package com.ejianc.business.change.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bedget.bean.*;
import com.ejianc.business.bedget.service.IConsdrawbudgetService;
import com.ejianc.business.bedget.service.IConsdrawbudgetdetailService;
import com.ejianc.business.bedget.service.ISubpackageService;
import com.ejianc.business.bedget.vo.SubpackageVO;
import com.ejianc.business.change.bean.ChangedesignestimateEntity;
import com.ejianc.business.change.bean.ChangesubpackageEntity;
import com.ejianc.business.change.bean.ChangesubpackagedetailEntity;
import com.ejianc.business.change.mapper.ChangesubpackageMapper;
import com.ejianc.business.change.service.IChangesubpackageService;
import com.ejianc.business.change.vo.ChangedesignestimateVO;
import com.ejianc.business.change.vo.ChangedesignestimatedetailVO;
import com.ejianc.business.change.vo.ChangesubpackageVO;
import com.ejianc.business.change.vo.ChangesubpackagedetailVO;
import com.ejianc.business.record.bean.RecorddesignestimateEntity;
import com.ejianc.business.record.bean.RecordsubpackageEntity;
import com.ejianc.business.record.service.IRecordsubpackageService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;


/**
 * 分包施工图预算变更
 *
 * @author generator
 */
@Service("changesubpackageService")
public class ChangesubpackageServiceImpl extends BaseServiceImpl<ChangesubpackageMapper, ChangesubpackageEntity> implements IChangesubpackageService {

    @Autowired
    private ISubpackageService subpackageService;
    @Autowired
    private IRecordsubpackageService recordsubpackageService;
    @Autowired
    private IConsdrawbudgetService consdrawbudgetService;
    @Autowired
    private IConsdrawbudgetdetailService consdrawbudgetdetailService;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public CommonResponse<ChangesubpackageVO> saveChange(ChangesubpackageVO saveOrUpdateVO) {
        //检验该单据是否存在
        boolean exitBill = false;
        if (saveOrUpdateVO.getId() != null) {
            ChangesubpackageEntity e = this.getById(saveOrUpdateVO);
            if (e != null) {
                exitBill = true;
            }
        }
        ChangesubpackageEntity entity = BeanMapper.map(saveOrUpdateVO, ChangesubpackageEntity.class);
        //检验是否存在未生效的变更单据，若存在，则不能变更
        QueryWrapper<ChangesubpackageEntity> queryWrapper = new QueryWrapper<ChangesubpackageEntity>();
        queryWrapper.eq("original_id", saveOrUpdateVO.getOriginalId());
        queryWrapper.eq("dr", 0);
        queryWrapper.in("bill_state", "[0,4]");
        if (saveOrUpdateVO.getId() != null) {
            queryWrapper.ne("id", saveOrUpdateVO.getId());
        }
        List<ChangesubpackageEntity> exit = this.list(queryWrapper);
        if (exit != null && exit.size() > 0) {
            throw new BusinessException("已存在未完成的变更单据，不能新增新的变更单据");
        }

        List<ConsdrawbudgetdetailEntity> drawList = new ArrayList<>();
        List<ChangesubpackagedetailEntity> subList = new ArrayList<>();
        //查询是否开启控制
        QueryWrapper<ConsdrawbudgetEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("dr", 0);
        wrapper.eq("project_id", entity.getProjectId());
        wrapper.in("bill_state", 1, 3);
        ConsdrawbudgetEntity control = consdrawbudgetService.getOne(wrapper);

        for (ChangesubpackagedetailEntity detail : entity.getSubpackagedetailEntities()) {
            //根据施工图预算行ID查该行的累计工程量,
            Long countId = detail.getConsdrawbudgetId();
            QueryWrapper<ConsdrawbudgetdetailEntity> countWrapper = new QueryWrapper<>();
            countWrapper.eq("mid", control.getId());
            countWrapper.eq("section",detail.getSection());
            countWrapper.eq("subitem_code",detail.getSubtitleCode());
            ConsdrawbudgetdetailEntity consdrawbudgetdetail = consdrawbudgetdetailService.getOne(countWrapper);

            if (consdrawbudgetdetail.getEngineeQuatity() != null) {
                drawList.add(consdrawbudgetdetail);
                subList.add(detail);
                //更新本单据子表的预计工程量
                detail.setSubpackageBudgetTotal(consdrawbudgetdetail.getEngineeQuatity());
            }
            //开启控制后进行判断
            if (control.getIsOpenControl() == 1) {
                if (consdrawbudgetdetail.getSubEngineeQuatity() == null) {
                    consdrawbudgetdetail.setSubEngineeQuatity(new BigDecimal(0));
                }
                if (consdrawbudgetdetail.getEngineeQuatity() != null) {
                    BigDecimal allowance = consdrawbudgetdetail.getEngineeQuatity().subtract(consdrawbudgetdetail.getSubEngineeQuatity());
                    if (allowance.compareTo(detail.getSubpackageQuantities()) == -1) {
                        throw new BusinessException("本次输入的工程量不允许超过'分包施工图预算量合计（施工图预算工程量）'");
                    }
                }
            }
        }

        //处理子表数据
        this.saveOrUpdate(entity, false);

        ChangesubpackageVO vo = BeanMapper.map(entity, ChangesubpackageVO.class);
        vo.setSubpackagedetailEntities(saveOrUpdateVO.getSubpackagedetailEntities());
        vo.setRecordsubpackageList(saveOrUpdateVO.getRecordsubpackageList());
        if (!exitBill) {
            //查询当前合同信息，将状态改为变更中
            SubpackageEntity subpackageEntity = subpackageService.selectById(vo.getOriginalId());
            subpackageEntity.setChangeState("2");//状态改为变更中
            subpackageEntity.setChangeId(vo.getId());
            subpackageService.saveOrUpdate(subpackageEntity, false);
        }

        for (ConsdrawbudgetdetailEntity draw : drawList) {
            for (ChangesubpackagedetailEntity subpackagedetail : subList) {
                if (draw.getId().equals(subpackagedetail.getConsdrawbudgetId()) && draw.getEngineeQuatity() != null) {
                    //更新累计分包工程量
                    if (draw.getSubEngineeQuatity() == null) {
                        draw.setSubEngineeQuatity(subpackagedetail.getSubpackageQuantities());
                    } else {
                        draw.setSubEngineeQuatity(draw.getSubEngineeQuatity().add(subpackagedetail.getSubpackageQuantities()));
                    }
                    consdrawbudgetdetailService.saveOrUpdate(draw);
                }
            }
        }
        logger.info("-------更新施工图预算表的累计分包工程量成功！！！-------");
        //构建树形结构
        List<ChangesubpackagedetailVO> changesubpackagedetailVOList = vo.getSubpackagedetailEntities();
        List<ChangesubpackagedetailVO> resChangedesignestimatedetailVOList = createTree(changesubpackagedetailVOList);
        vo.setSubpackagedetailEntities(resChangedesignestimatedetailVOList);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    @Override
    public CommonResponse<String> delete(List<ChangesubpackageVO> vos) {
        for (ChangesubpackageVO vo : vos) {
            ChangesubpackageEntity entity = this.getById(vo.getId());
            SubpackageEntity subpackageEntity = subpackageService.selectById(entity.getOriginalId());
            QueryWrapper<RecordsubpackageEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("dr", 0);
            queryWrapper.eq("original_id", subpackageEntity.getId());
            List<RecordsubpackageEntity> records = recordsubpackageService.list(queryWrapper);
            if (records != null && records.size() > 0) {
                subpackageEntity.setChangeState("3");//状态改为已变更
            } else {
                subpackageEntity.setChangeState("1");//状态改为未变更
            }
            subpackageEntity.setChangeId(null);
            subpackageService.saveOrUpdate(subpackageEntity, false);
        }
        this.removeByIds(vos.stream().map(ChangesubpackageVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    private List<ChangesubpackagedetailVO> createTree(List<ChangesubpackagedetailVO> list) {
        List<ChangesubpackagedetailVO> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();

        //循环list，放入listMap重
        Map<String, ChangesubpackagedetailVO> listMap = new HashMap<>();
        for (ChangesubpackagedetailVO item : list) {
            listMap.put(item.getTid().toString(), item);
        }

        for (int i = 0; i < list.size(); i++) {
            ChangesubpackagedetailVO item = list.get(i);
            String parentId = (item.getTpid() != null) ? item.getTpid().toString() : "";
            ChangesubpackagedetailVO parent = listMap.get(parentId);
            if (parent != null) {
                List<ChangesubpackagedetailVO> child = (List<ChangesubpackagedetailVO>) parent.getChildren();
                if (child != null) {
                    child.add(item);
                } else {
                    List<ChangesubpackagedetailVO> children = new ArrayList<ChangesubpackagedetailVO>();
                    children.add(item);
                    parent.setChildren(children);
                }
            } else {
                rootItems.add(item.getTid());
            }
        }

        for (String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }

}