/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bedget.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.bedget.bean.ConsdrawbudgetEntity;
import com.ejianc.business.bedget.bean.ConsdrawbudgetdetailEntity;
import com.ejianc.business.bedget.controller.SubpackageController;
import com.ejianc.business.bedget.service.IConsdrawbudgetService;
import com.ejianc.business.bedget.service.IConsdrawbudgetdetailService;
import com.ejianc.business.bedget.vo.ConsdrawbudgetVO;
import com.ejianc.business.bedget.vo.ConsdrawbudgetdetailVO;
import com.ejianc.business.bedget.vo.SubpackagedetailVO;
import com.ejianc.business.record.service.IRecordconsdrawbudgetService;
import com.ejianc.business.record.vo.RecordconsdrawbudgetVO;
import com.ejianc.business.utils.DateUtils;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.util.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"consdrawbudget"})
public class ConsdrawbudgetController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "budgetmanager-consdrawbudget";
    @Autowired
    private IConsdrawbudgetService service;
    @Autowired
    private IConsdrawbudgetdetailService consdrawbudgetdetailService;
    @Autowired
    private IRecordconsdrawbudgetService recordconsdrawbudgetService;
    @Autowired
    private SubpackageController subpackageController;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ConsdrawbudgetVO> saveOrUpdate(@RequestBody ConsdrawbudgetVO saveorUpdateVO) {
        List pro;
        ConsdrawbudgetEntity entity = (ConsdrawbudgetEntity)((Object)BeanMapper.map((Object)((Object)saveorUpdateVO), ConsdrawbudgetEntity.class));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"project_id", (Object)entity.getProjectId());
        queryWrapper.eq((Object)"dr", (Object)"0");
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() != 0L) {
            queryWrapper.ne((Object)"id", (Object)saveorUpdateVO.getId());
        }
        if ((pro = this.service.list((Wrapper)queryWrapper)).size() > 0) {
            throw new BusinessException("\u8be5\u9879\u76ee\u5df2\u7ecf\u521b\u5efa\u4e00\u4e2a\u65bd\u5de5\u56fe\u9884\u7b97\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u521b\u5efa!");
        }
        entity = this.checkBillCodeUniq(entity);
        entity.setChangeState("1");
        this.service.saveOrUpdate((Object)entity, false);
        ConsdrawbudgetVO vo = (ConsdrawbudgetVO)((Object)BeanMapper.map((Object)((Object)entity), ConsdrawbudgetVO.class));
        List<ConsdrawbudgetdetailVO> consdrawbudgetdetailVOList = vo.getConsdrawbudgetdetailEntities();
        vo.setConsdrawbudgetdetailEntities(this.handleChildren(consdrawbudgetdetailVOList));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ConsdrawbudgetEntity checkBillCodeUniq(ConsdrawbudgetEntity entity) {
        if (entity.getBillCode() == null || StringUtils.isEmpty((CharSequence)entity.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (!billCode.isSuccess()) throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            entity.setBillCode((String)billCode.getData());
            return entity;
        } else {
            List proBillCode;
            QueryWrapper queryWrapperBillCode = new QueryWrapper();
            queryWrapperBillCode.eq((Object)"bill_code", (Object)entity.getBillCode());
            queryWrapperBillCode.eq((Object)"dr", (Object)"0");
            if (entity.getId() != null && entity.getId() != 0L) {
                queryWrapperBillCode.ne((Object)"id", (Object)entity.getId());
            }
            if ((proBillCode = this.service.list((Wrapper)queryWrapperBillCode)).size() <= 0) return entity;
            throw new BusinessException("\u5355\u636e\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u5f55\u5165!");
        }
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ConsdrawbudgetVO> queryDetail(Long id) {
        ConsdrawbudgetEntity entity = (ConsdrawbudgetEntity)((Object)this.service.selectById(id));
        ConsdrawbudgetVO vo = (ConsdrawbudgetVO)((Object)BeanMapper.map((Object)((Object)entity), ConsdrawbudgetVO.class));
        List<ConsdrawbudgetdetailVO> consdrawbudgetdetailEntities = vo.getConsdrawbudgetdetailEntities();
        vo.setConsdrawbudgetdetailEntities(this.handleChildren(consdrawbudgetdetailEntities));
        if (!"1".equals(vo.getChangeState())) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"dr", (Object)0);
            queryWrapper.eq((Object)"consdrawbudget_id", (Object)vo.getId());
            List records = this.recordconsdrawbudgetService.list((Wrapper)queryWrapper);
            if (records != null && records.size() > 0) {
                vo.setRecordconsdrawbudgetVOS(BeanMapper.mapList((Iterable)records, RecordconsdrawbudgetVO.class));
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryProject"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> queryProject(Long id, Long projectId) {
        List entityList;
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.eq((Object)"project_id", (Object)projectId);
        if (id != null && id != 0L) {
            queryWrapper.ne((Object)"id", (Object)id);
        }
        if ((entityList = this.service.list((Wrapper)queryWrapper)) != null && entityList.size() > 0) {
            return CommonResponse.success((String)"\u6240\u9009\u9879\u76ee\u5df2\u7ecf\u5b58\u5728\u65bd\u5de5\u56fe\u9884\u7b97\uff0c\u4e0d\u80fd\u7ee7\u7eed\u521b\u5efa\uff01", (Object)"0");
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)"1");
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ConsdrawbudgetVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ConsdrawbudgetVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("bill_code");
        fuzzyFields.add("project_name");
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ConsdrawbudgetVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("bill_code");
        fuzzyFields.add("project_name");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        List consdrawbudgetVOList = BeanMapper.mapList((Iterable)list, ConsdrawbudgetVO.class);
        for (int i = 0; i < consdrawbudgetVOList.size(); ++i) {
            ConsdrawbudgetVO consdrawbudgetVO = (ConsdrawbudgetVO)((Object)consdrawbudgetVOList.get(i));
            consdrawbudgetVO.setSort(Long.parseLong(String.valueOf(i + 1)));
            if (consdrawbudgetVO.getCreateTime() != null) {
                consdrawbudgetVO.setCreateTimeShow(DateUtils.dateSimple2(consdrawbudgetVO.getCreateTime()));
            }
            String billStateStr = consdrawbudgetVO.getBillState().toString();
            String changeState = consdrawbudgetVO.getChangeState();
            Integer isOpenControl = consdrawbudgetVO.getIsOpenControl();
            String isOpenControlStr = "";
            if (billStateStr != null) {
                if ("0".equals(billStateStr)) {
                    billStateStr = "\u81ea\u7531\u6001";
                } else if ("1".equals(billStateStr)) {
                    billStateStr = "\u5df2\u63d0\u4ea4";
                } else if ("2".equals(billStateStr) || "5".equals(billStateStr)) {
                    billStateStr = "\u5ba1\u6279\u4e2d";
                } else if ("3".equals(billStateStr)) {
                    billStateStr = "\u5ba1\u6279\u901a\u8fc7";
                } else if ("4".equals(billStateStr)) {
                    billStateStr = "\u9a73\u56de";
                }
                consdrawbudgetVO.setBillStateStr(billStateStr);
            }
            if (changeState != null) {
                if ("1".equals(changeState)) {
                    changeState = "\u672a\u53d8\u66f4";
                } else if ("2".equals(changeState)) {
                    changeState = "\u53d8\u66f4\u4e2d";
                } else if ("3".equals(changeState)) {
                    changeState = "\u5df2\u53d8\u66f4";
                }
                consdrawbudgetVO.setChangeState(changeState);
            }
            if (isOpenControl == null) continue;
            isOpenControlStr = isOpenControl.toString();
            if ("0".equals(isOpenControlStr)) {
                isOpenControlStr = "\u5426";
            } else if ("1".equals(isOpenControlStr)) {
                isOpenControlStr = "\u662f";
            }
            consdrawbudgetVO.setIsOpenControlStr(isOpenControlStr);
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", consdrawbudgetVOList);
        ExcelExport.getInstance().export("Consdrawbudget-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refConsdrawbudgetData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ConsdrawbudgetVO>> refConsdrawbudgetData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ConsdrawbudgetVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/refConsdrawbudgetDataDetail"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<SubpackagedetailVO>> refConsdrawbudgetDataDetail(@RequestBody SubpackagedetailVO vo) {
        List<SubpackagedetailVO> recordsVo = new ArrayList<SubpackagedetailVO>();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.eq((Object)"project_id", (Object)vo.getProjectId());
        queryWrapper.in((Object)"bill_state", new Object[]{1, 3});
        ConsdrawbudgetEntity entity = (ConsdrawbudgetEntity)((Object)this.service.getOne((Wrapper)queryWrapper));
        if (entity == null) {
            throw new BusinessException("\u8be5\u9879\u76ee\u6ca1\u6709\u65bd\u5de5\u56fe\u9884\u7b97,\u8bf7\u9009\u62e9\u522b\u7684\u9879\u76ee");
        }
        QueryWrapper queryWrapper1 = new QueryWrapper();
        queryWrapper1.eq((Object)"dr", (Object)0);
        queryWrapper1.eq((Object)"mid", (Object)entity.getId());
        List<String> idList = vo.getIdList();
        if (idList != null && idList.size() > 0) {
            queryWrapper1.notIn((Object)"tid", idList);
        }
        List records = this.consdrawbudgetdetailService.list((Wrapper)queryWrapper1);
        for (ConsdrawbudgetdetailEntity entity1 : records) {
            SubpackagedetailVO subpackagedetailVO = new SubpackagedetailVO();
            subpackagedetailVO.setSort(entity1.getSort());
            subpackagedetailVO.setSection(entity1.getSection());
            subpackagedetailVO.setSubtitleCode(entity1.getSubitemCode());
            subpackagedetailVO.setSubtitleName(entity1.getSubitemName());
            subpackagedetailVO.setSubtitleFeature(entity1.getCharacterDescrip());
            subpackagedetailVO.setMeasuringUnit(entity1.getEstimateUnit());
            subpackagedetailVO.setTid(entity1.getTid());
            subpackagedetailVO.setTpid(entity1.getTpid());
            subpackagedetailVO.setId(IdWorker.getId());
            subpackagedetailVO.setConsdrawbudgetId(entity1.getId());
            subpackagedetailVO.setSubpackageBudgetTotal(entity1.getEngineeQuatity());
            recordsVo.add(subpackagedetailVO);
        }
        if (recordsVo.size() > 1) {
            recordsVo = SubpackageController.createTreeData(recordsVo);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", recordsVo);
    }

    public static List<ConsdrawbudgetdetailVO> createTreeData(List<ConsdrawbudgetdetailVO> list) {
        ArrayList<ConsdrawbudgetdetailVO> resp = new ArrayList<ConsdrawbudgetdetailVO>();
        ArrayList<String> rootItems = new ArrayList<String>();
        HashMap<String, ConsdrawbudgetdetailVO> listMap = new HashMap<String, ConsdrawbudgetdetailVO>();
        for (ConsdrawbudgetdetailVO item : list) {
            listMap.put(item.getTid().toString(), item);
        }
        for (int i = 0; i < list.size(); ++i) {
            ConsdrawbudgetdetailVO item;
            item = list.get(i);
            String parentId = item.getTpid() != null ? item.getTpid().toString() : "";
            ConsdrawbudgetdetailVO parent = (ConsdrawbudgetdetailVO)((Object)listMap.get(parentId));
            if (parent != null) {
                List<ConsdrawbudgetdetailVO> child = parent.getChildren();
                if (child != null) {
                    child.add(item);
                    continue;
                }
                ArrayList<ConsdrawbudgetdetailVO> children = new ArrayList<ConsdrawbudgetdetailVO>();
                children.add(item);
                parent.setChildren(children);
                continue;
            }
            rootItems.add(item.getTid());
        }
        for (String rootId : rootItems) {
            resp.add((ConsdrawbudgetdetailVO)((Object)listMap.get(rootId)));
        }
        return resp;
    }

    @RequestMapping(value={"/refreshData"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> refreshData(@RequestBody List<ConsdrawbudgetdetailVO> list, HttpServletResponse response) {
        String code;
        JSONObject json = new JSONObject();
        HashMap<String, ConsdrawbudgetdetailVO> map = new HashMap<String, ConsdrawbudgetdetailVO>();
        ConsdrawbudgetdetailVO add = list.get(list.size() - 1);
        add.setId(IdWorker.getId());
        add.setTid(String.valueOf(IdWorker.getId()));
        add.setRowState("edit");
        add.setInnercode(add.getSubitemCode() + "_" + add.getSection());
        if ("01".equals(add.getSubitemCode()) && add.getSubitemName().contains("\u88c5\u9970")) {
            add.setInnercode("a1_" + add.getSection());
        }
        if (add.getSubitemCode().length() >= 4 && ("0111".equals(code = add.getSubitemCode().substring(0, 4)) || "0112".equals(code) || "0113".equals(code) || "0114".equals(code) || "0115".equals(code))) {
            add.setInnercode("a1" + add.getSubitemCode().substring(2, add.getSubitemCode().length()) + "_" + add.getSection());
        }
        for (ConsdrawbudgetdetailVO vo : list) {
            map.put(vo.getInnercode(), vo);
            if (add.getId().equals(vo.getId()) || !add.getInnercode().equals(vo.getInnercode())) continue;
            throw new BusinessException("\u5b50\u76ee\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u586b\u5199");
        }
        for (ConsdrawbudgetdetailVO vo : list) {
            String innercode = vo.getInnercode();
            String[] innercodeSubArr = innercode.split("_");
            String innercodeSub = "";
            String sectionSuf = "";
            if (innercodeSubArr.length > 1) {
                innercodeSub = innercodeSubArr[0];
                sectionSuf = "_" + innercodeSubArr[1];
            }
            Long pid = null;
            if (innercodeSub.length() != 2) {
                String pcode;
                if (innercodeSub.length() == 4) {
                    pcode = innercodeSub.substring(0, 2) + sectionSuf;
                    pid = this.setPid(pcode, map);
                } else if (innercodeSub.length() == 6) {
                    pcode = innercodeSub.substring(0, 4) + sectionSuf;
                    pid = this.setPid(pcode, map);
                } else if (innercodeSub.length() > 6) {
                    pcode = innercodeSub.substring(0, 6) + sectionSuf;
                    pid = this.setPid(pcode, map);
                }
            }
            if (pid != null) {
                vo.setTpid(pid.toString());
                continue;
            }
            vo.setTpid("");
        }
        list = this.clearPData(add, list);
        json.put("dataSource", this.handleChildren(list));
        return CommonResponse.success((Object)json);
    }

    private List<ConsdrawbudgetdetailVO> clearPData(ConsdrawbudgetdetailVO handleVO, List<ConsdrawbudgetdetailVO> list) {
        if (list == null || list.size() == 0) {
            return null;
        }
        String pid = handleVO.getTpid();
        if (pid == null || TextUtils.isEmpty((CharSequence)pid)) {
            return list;
        }
        for (int i = 0; i < list.size(); ++i) {
            ConsdrawbudgetdetailVO vo = list.get(i);
            if (!pid.equals(vo.getTid())) continue;
            vo.setEngineeQuatity(null);
            vo.setUnitLaborCost(null);
            vo.setUnitMaterialCost(null);
            vo.setUnitMachineryCost(null);
            vo.setUnitBusinessManagerCost(null);
            vo.setUnitProfit(null);
            vo.setComprehensiveUnitPrice(null);
            if (vo.getTpid() == null || TextUtils.isEmpty((CharSequence)vo.getTpid())) continue;
            this.clearPData(vo, list);
            break;
        }
        return list;
    }

    private Long setPid(String pcode, Map<String, ConsdrawbudgetdetailVO> map) {
        if (map.get(pcode) != null) {
            return Long.valueOf(map.get(pcode).getTid());
        }
        String[] pcodeSubArr = pcode.split("_");
        String pcodeSub = "";
        String sectionSuf = "";
        if (pcodeSubArr.length > 1) {
            pcodeSub = pcodeSubArr[0];
            sectionSuf = "_" + pcodeSubArr[1];
        }
        if (pcodeSub.length() == 2) {
            return null;
        }
        if (pcodeSub.length() == 4) {
            String ppcode = pcodeSub.substring(0, 2);
            return this.setPid(ppcode + sectionSuf, map);
        }
        if (pcodeSub.length() == 6) {
            String ppcode = pcode.substring(0, 4);
            return this.setPid(ppcode + sectionSuf, map);
        }
        if (pcodeSub.length() > 6) {
            String ppcode = pcode.substring(0, 6);
            return this.setPid(ppcode + sectionSuf, map);
        }
        return null;
    }

    private List<ConsdrawbudgetdetailVO> handleChildren(List<ConsdrawbudgetdetailVO> voList) {
        Collections.sort(voList, new Comparator<ConsdrawbudgetdetailVO>(){

            @Override
            public int compare(ConsdrawbudgetdetailVO o1, ConsdrawbudgetdetailVO o2) {
                return (o1.getSubitemCode() + o1.getSection()).compareTo(o2.getSubitemCode() + o2.getSection());
            }
        });
        voList = ConsdrawbudgetController.createTreeData(voList);
        return voList;
    }
}

