/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bedget.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.bedget.bean.ConsdrawbudgettotalEntity;
import com.ejianc.business.bedget.bean.ConsdrawbudgettotaldetailEntity;
import com.ejianc.business.bedget.bean.ContrastanalysisEntity;
import com.ejianc.business.bedget.bean.ContrastanalysisdetailsEntity;
import com.ejianc.business.bedget.bean.DesignestimateEntity;
import com.ejianc.business.bedget.bean.DesignestimatedetailEntity;
import com.ejianc.business.bedget.bean.QuotasummaryEntity;
import com.ejianc.business.bedget.bean.QuotasummarydetailEntity;
import com.ejianc.business.bedget.service.IConsdrawbudgettotalService;
import com.ejianc.business.bedget.service.IConsdrawbudgettotaldetailService;
import com.ejianc.business.bedget.service.IContrastanalysisService;
import com.ejianc.business.bedget.service.IContrastanalysisdetailsService;
import com.ejianc.business.bedget.service.IDesignestimateService;
import com.ejianc.business.bedget.service.IDesignestimatedetailService;
import com.ejianc.business.bedget.service.IQuotasummaryService;
import com.ejianc.business.bedget.service.IQuotasummarydetailService;
import com.ejianc.business.bedget.vo.ContrastanalysisVO;
import com.ejianc.business.bedget.vo.ContrastanalysisdetailVO;
import com.ejianc.business.record.service.IRecordContrastanalysistService;
import com.ejianc.business.record.vo.RecordContrastanalysistVO;
import com.ejianc.business.utils.DateUtils;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"contrastanalysis"})
public class ContrastanalysisController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "budgetmanager-contrastanalysis";
    @Autowired
    private IContrastanalysisService service;
    @Autowired
    private IQuotasummaryService quotasummaryService;
    @Autowired
    private IContrastanalysisdetailsService contrastanalysisdetailsService;
    @Autowired
    private IDesignestimateService designestimateService;
    @Autowired
    private IConsdrawbudgettotalService consdrawbudgettotalService;
    @Autowired
    private IQuotasummarydetailService quotasummarydetailService;
    @Autowired
    private IDesignestimatedetailService designestimatedetailService;
    @Autowired
    private IConsdrawbudgettotaldetailService consdrawbudgettotaldetailService;
    @Autowired
    private IRecordContrastanalysistService recordContrastanalysistService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ContrastanalysisVO> saveOrUpdate(@RequestBody ContrastanalysisVO saveorUpdateVO) {
        List pro;
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"project_id", (Object)saveorUpdateVO.getProjectId());
        queryWrapper.eq((Object)"dr", (Object)"0");
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() != 0L) {
            queryWrapper.ne((Object)"id", (Object)saveorUpdateVO.getId());
        }
        if ((pro = this.service.list((Wrapper)queryWrapper)) != null && pro.size() > 0) {
            throw new BusinessException("\u4e00\u4e2a\u9879\u76ee\u53ea\u80fd\u6709\u4e00\u4e2a\u5bf9\u6bd4\u5206\u6790\u8868");
        }
        ContrastanalysisEntity entity = (ContrastanalysisEntity)((Object)BeanMapper.map((Object)((Object)saveorUpdateVO), ContrastanalysisEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setChangeState("1");
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        ContrastanalysisVO vo = (ContrastanalysisVO)((Object)BeanMapper.map((Object)((Object)entity), ContrastanalysisVO.class));
        vo.setContrastanalysisdetailEntities(ContrastanalysisController.createTreeData(vo.getContrastanalysisdetailEntities()));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ContrastanalysisVO> queryDetail(Long id) {
        ContrastanalysisEntity entity = (ContrastanalysisEntity)((Object)this.service.selectById(id));
        ContrastanalysisVO vo = (ContrastanalysisVO)((Object)BeanMapper.map((Object)((Object)entity), ContrastanalysisVO.class));
        vo.setContrastanalysisdetailEntities(ContrastanalysisController.createTreeData(vo.getContrastanalysisdetailEntities()));
        if (!"1".equals(vo.getChangeState())) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"dr", (Object)0);
            queryWrapper.eq((Object)"contrastanalysis_id", (Object)vo.getId());
            List records = this.recordContrastanalysistService.list((Wrapper)queryWrapper);
            if (records != null && records.size() > 0) {
                vo.setRecordContrastanalysistList(BeanMapper.mapList((Iterable)records, RecordContrastanalysistVO.class));
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ContrastanalysisVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ContrastanalysisVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("bill_code");
        fuzzyFields.add("project_name");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ContrastanalysisVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("bill_code");
        fuzzyFields.add("project_name");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        List contrastanalysisVOList = BeanMapper.mapList((Iterable)list, ContrastanalysisVO.class);
        for (int i = 0; i < contrastanalysisVOList.size(); ++i) {
            ContrastanalysisVO contrastanalysisVO = (ContrastanalysisVO)((Object)contrastanalysisVOList.get(i));
            contrastanalysisVO.setSort(Long.parseLong(String.valueOf(i + 1)));
            if (contrastanalysisVO.getCreateTime() != null) {
                contrastanalysisVO.setCreateTimeShow(DateUtils.dateSimple2(contrastanalysisVO.getCreateTime()));
            }
            String billStateStr = contrastanalysisVO.getBillState().toString();
            String changeState = contrastanalysisVO.getChangeState();
            if (billStateStr != null) {
                if ("0".equals(billStateStr)) {
                    billStateStr = "\u81ea\u7531\u6001";
                } else if ("1".equals(billStateStr)) {
                    billStateStr = "\u5df2\u63d0\u4ea4";
                } else if ("2".equals(billStateStr) || "5".equals(billStateStr)) {
                    billStateStr = "\u5ba1\u6279\u4e2d";
                } else if ("3".equals(billStateStr)) {
                    billStateStr = "\u5ba1\u6279\u901a\u8fc7";
                } else if ("4".equals(billStateStr)) {
                    billStateStr = "\u9a73\u56de";
                }
                contrastanalysisVO.setBillStateStr(billStateStr);
            }
            if (changeState == null) continue;
            if ("1".equals(changeState)) {
                changeState = "\u672a\u53d8\u66f4";
            } else if ("2".equals(changeState)) {
                changeState = "\u53d8\u66f4\u4e2d";
            } else if ("3".equals(changeState)) {
                changeState = "\u5df2\u53d8\u66f4";
            }
            contrastanalysisVO.setChangeState(changeState);
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", contrastanalysisVOList);
        ExcelExport.getInstance().export("Contrastanalysis-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refContrastanalysisData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ContrastanalysisVO>> refContrastanalysisData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ContrastanalysisVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryDetailList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<ContrastanalysisdetailVO>> queryDetailList(Long id, Long projectId) {
        List entityList;
        QueryWrapper queryWrapperProject = new QueryWrapper();
        queryWrapperProject.eq((Object)"project_id", (Object)projectId);
        queryWrapperProject.eq((Object)"dr", (Object)0);
        if (id != null && id != 0L) {
            queryWrapperProject.ne((Object)"id", (Object)id);
        }
        if ((entityList = this.service.list((Wrapper)queryWrapperProject)) != null && entityList.size() > 0) {
            throw new BusinessException("\u8be5\u9879\u76ee\u5df2\u7ecf\u521b\u5efa\u4e00\u4e2a\u5bf9\u6bd4\u5206\u6790\u8868\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u521b\u5efa\uff01");
        }
        ArrayList<ContrastanalysisdetailVO> vo = new ArrayList<ContrastanalysisdetailVO>();
        List contrastanalysisdetailsEntity = this.contrastanalysisdetailsService.list();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"project_id", (Object)projectId);
        queryWrapper.eq((Object)"dr", (Object)0);
        QuotasummaryEntity quotasummaryEntity = (QuotasummaryEntity)((Object)this.quotasummaryService.getOne((Wrapper)queryWrapper));
        QueryWrapper queryWrapper1 = new QueryWrapper();
        queryWrapper1.eq((Object)"project_id", (Object)projectId);
        queryWrapper1.eq((Object)"dr", (Object)0);
        DesignestimateEntity designestimateEntity = (DesignestimateEntity)((Object)this.designestimateService.getOne((Wrapper)queryWrapper1));
        QueryWrapper queryWrapper2 = new QueryWrapper();
        queryWrapper2.eq((Object)"project_id", (Object)projectId);
        queryWrapper2.eq((Object)"dr", (Object)0);
        ConsdrawbudgettotalEntity consdrawbudgettotalEntity = (ConsdrawbudgettotalEntity)((Object)this.consdrawbudgettotalService.getOne((Wrapper)queryWrapper2));
        for (ContrastanalysisdetailsEntity entity : contrastanalysisdetailsEntity) {
            int i;
            boolean isNullUnitCost;
            boolean isNullProjectCost;
            boolean isNullScale;
            ContrastanalysisdetailVO contrastanalysisdetailVO = new ContrastanalysisdetailVO();
            contrastanalysisdetailVO.setId(IdWorker.getId());
            contrastanalysisdetailVO.setSort(entity.getSort());
            contrastanalysisdetailVO.setCode(entity.getCode());
            contrastanalysisdetailVO.setName(entity.getName());
            contrastanalysisdetailVO.setTid(entity.getTid());
            contrastanalysisdetailVO.setTpid(entity.getTpid());
            String innateCode = entity.getCode();
            String innateName = entity.getName();
            if (quotasummaryEntity != null) {
                QueryWrapper queryWrapper3 = new QueryWrapper();
                queryWrapper3.eq((Object)"mid", (Object)quotasummaryEntity.getId());
                queryWrapper3.eq((Object)"sort", (Object)innateCode);
                if ("01".equals(innateCode)) {
                    if ("\u88c5\u9970\u5de5\u7a0b".equals(innateName)) {
                        queryWrapper3.like((Object)"unit_project_name", (Object)"\u88c5\u9970");
                    } else {
                        queryWrapper3.notLike((Object)"unit_project_name", (Object)"\u88c5\u9970");
                    }
                }
                queryWrapper3.eq((Object)"dr", (Object)0);
                List quotasummarydetailEntity = this.quotasummarydetailService.list((Wrapper)queryWrapper3);
                if (quotasummarydetailEntity != null && quotasummarydetailEntity.size() > 0) {
                    BigDecimal quotasummaryScale = new BigDecimal(0);
                    BigDecimal quotasummaryProjectCost = new BigDecimal(0);
                    BigDecimal quotasummarylUnitCost = new BigDecimal(0);
                    isNullScale = true;
                    isNullProjectCost = true;
                    isNullUnitCost = true;
                    for (i = 0; i < quotasummarydetailEntity.size(); ++i) {
                        BigDecimal quotasummaryDetailScale = ((QuotasummarydetailEntity)((Object)quotasummarydetailEntity.get(i))).getScale();
                        BigDecimal quotasummaryDetailProjectCost = ((QuotasummarydetailEntity)((Object)quotasummarydetailEntity.get(i))).getProjectCost();
                        if (quotasummaryDetailScale != null) {
                            quotasummaryScale = quotasummaryScale.add(quotasummaryDetailScale);
                            isNullScale = false;
                        }
                        if (quotasummaryDetailProjectCost == null) continue;
                        quotasummaryProjectCost = quotasummaryProjectCost.add(quotasummaryDetailProjectCost);
                        isNullProjectCost = false;
                    }
                    if (quotasummaryProjectCost != null && quotasummaryScale != null && quotasummaryScale.compareTo(BigDecimal.ZERO) != 0) {
                        quotasummarylUnitCost = quotasummaryProjectCost.divide(quotasummaryScale, 8, 4);
                        isNullUnitCost = false;
                    }
                    if (isNullScale) {
                        contrastanalysisdetailVO.setQuataDesignTotal(null);
                    } else {
                        contrastanalysisdetailVO.setQuataDesignTotal(quotasummaryScale);
                    }
                    if (isNullProjectCost) {
                        contrastanalysisdetailVO.setQuotaDesignBudgetTotal(null);
                    } else {
                        contrastanalysisdetailVO.setQuotaDesignBudgetTotal(quotasummaryProjectCost);
                    }
                    if (isNullUnitCost) {
                        contrastanalysisdetailVO.setQuotaDesignBudgetPrice(null);
                    } else {
                        contrastanalysisdetailVO.setQuotaDesignBudgetPrice(quotasummarylUnitCost);
                    }
                }
            }
            if (designestimateEntity != null) {
                QueryWrapper queryWrapper4 = new QueryWrapper();
                queryWrapper4.eq((Object)"mid", (Object)designestimateEntity.getId());
                queryWrapper4.eq((Object)"son_item_code", (Object)innateCode);
                if ("01".equals(innateCode)) {
                    if ("\u88c5\u9970\u5de5\u7a0b".equals(innateName)) {
                        queryWrapper4.like((Object)"son_item_name", (Object)"\u88c5\u9970");
                    } else {
                        queryWrapper4.notLike((Object)"son_item_name", (Object)"\u88c5\u9970");
                    }
                }
                queryWrapper4.eq((Object)"dr", (Object)0);
                List designestimatedetailEntity = this.designestimatedetailService.list((Wrapper)queryWrapper4);
                if (designestimatedetailEntity != null && designestimatedetailEntity.size() > 0) {
                    BigDecimal estimateScale = new BigDecimal(0);
                    BigDecimal estimateProjectCost = new BigDecimal(0);
                    BigDecimal estimatelUnitCost = new BigDecimal(0);
                    isNullScale = true;
                    isNullProjectCost = true;
                    isNullUnitCost = true;
                    for (i = 0; i < designestimatedetailEntity.size(); ++i) {
                        BigDecimal estimateDetailProjectScale = ((DesignestimatedetailEntity)((Object)designestimatedetailEntity.get(i))).getProjectScale();
                        BigDecimal estimateDetailProjectCost = ((DesignestimatedetailEntity)((Object)designestimatedetailEntity.get(i))).getProjectCost();
                        if (estimateDetailProjectScale != null) {
                            estimateScale = estimateScale.add(estimateDetailProjectScale);
                            isNullScale = false;
                        }
                        if (estimateDetailProjectCost == null) continue;
                        estimateProjectCost = estimateProjectCost.add(estimateDetailProjectCost);
                        isNullProjectCost = false;
                    }
                    if (estimateProjectCost != null && estimateScale != null && estimateScale.compareTo(BigDecimal.ZERO) != 0) {
                        estimatelUnitCost = estimateProjectCost.divide(estimateScale, 8, 4);
                        isNullUnitCost = false;
                    }
                    if (isNullScale) {
                        contrastanalysisdetailVO.setDesignBugetEstimate(null);
                    } else {
                        contrastanalysisdetailVO.setDesignBugetEstimate(estimateScale);
                    }
                    if (isNullProjectCost) {
                        contrastanalysisdetailVO.setDesignBugetEstimateTotal(null);
                    } else {
                        contrastanalysisdetailVO.setDesignBugetEstimateTotal(estimateProjectCost);
                    }
                    if (isNullUnitCost) {
                        contrastanalysisdetailVO.setDesignBugetEstimatePrice(null);
                    } else {
                        contrastanalysisdetailVO.setDesignBugetEstimatePrice(estimatelUnitCost);
                    }
                }
            }
            if (consdrawbudgettotalEntity != null) {
                QueryWrapper queryWrapper5 = new QueryWrapper();
                queryWrapper5.eq((Object)"mid", (Object)consdrawbudgettotalEntity.getId());
                queryWrapper5.eq((Object)"subitem_code", (Object)innateCode);
                if ("01".equals(innateCode)) {
                    if ("\u88c5\u9970\u5de5\u7a0b".equals(innateName)) {
                        queryWrapper5.like((Object)"project_unit_name", (Object)"\u88c5\u9970");
                    } else {
                        queryWrapper5.notLike((Object)"project_unit_name", (Object)"\u88c5\u9970");
                    }
                }
                queryWrapper5.eq((Object)"dr", (Object)0);
                List consdrawbudgettotaldetailEntity = this.consdrawbudgettotaldetailService.list((Wrapper)queryWrapper5);
                if (consdrawbudgettotaldetailEntity != null && consdrawbudgettotaldetailEntity.size() > 0) {
                    BigDecimal consdrawbudgettotalScale = new BigDecimal(0);
                    BigDecimal consdrawbudgettotalProjectCost = new BigDecimal(0);
                    BigDecimal consdrawbudgettotallUnitCost = new BigDecimal(0);
                    isNullScale = true;
                    isNullProjectCost = true;
                    isNullUnitCost = true;
                    for (i = 0; i < consdrawbudgettotaldetailEntity.size(); ++i) {
                        BigDecimal consdrawbudgettotalDetailProjectScale = ((ConsdrawbudgettotaldetailEntity)((Object)consdrawbudgettotaldetailEntity.get(i))).getProjectScale();
                        BigDecimal consdrawbudgettotalDetailProjectCost = ((ConsdrawbudgettotaldetailEntity)((Object)consdrawbudgettotaldetailEntity.get(i))).getProjectCost();
                        if (consdrawbudgettotalDetailProjectScale != null) {
                            consdrawbudgettotalScale = consdrawbudgettotalScale.add(consdrawbudgettotalDetailProjectScale);
                            isNullScale = false;
                        }
                        if (consdrawbudgettotalDetailProjectCost == null) continue;
                        consdrawbudgettotalProjectCost = consdrawbudgettotalProjectCost.add(consdrawbudgettotalDetailProjectCost);
                        isNullProjectCost = false;
                    }
                    if (consdrawbudgettotalProjectCost != null && consdrawbudgettotalScale != null && consdrawbudgettotalScale.compareTo(BigDecimal.ZERO) != 0) {
                        consdrawbudgettotallUnitCost = consdrawbudgettotalProjectCost.divide(consdrawbudgettotalScale, 8, 4);
                        isNullUnitCost = false;
                    }
                    if (isNullScale) {
                        contrastanalysisdetailVO.setConstructionBugetEstimate(null);
                    } else {
                        contrastanalysisdetailVO.setConstructionBugetEstimate(consdrawbudgettotalScale);
                    }
                    if (isNullProjectCost) {
                        contrastanalysisdetailVO.setConstructionBugetEstimateTotal(null);
                    } else {
                        contrastanalysisdetailVO.setConstructionBugetEstimateTotal(consdrawbudgettotalProjectCost);
                    }
                    if (isNullUnitCost) {
                        contrastanalysisdetailVO.setConstructionBugetEstimatePrice(null);
                    } else {
                        contrastanalysisdetailVO.setConstructionBugetEstimatePrice(consdrawbudgettotallUnitCost);
                    }
                    contrastanalysisdetailVO.setConstructionBugetEstimate(consdrawbudgettotalScale);
                    contrastanalysisdetailVO.setConstructionBugetEstimateTotal(consdrawbudgettotalProjectCost);
                    contrastanalysisdetailVO.setConstructionBugetEstimatePrice(consdrawbudgettotallUnitCost);
                }
            }
            contrastanalysisdetailVO.setRowState("add");
            vo.add(contrastanalysisdetailVO);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", ContrastanalysisController.createTreeData(vo));
    }

    public static List<ContrastanalysisdetailVO> createTreeData(List<ContrastanalysisdetailVO> list) {
        ArrayList<ContrastanalysisdetailVO> resp = new ArrayList<ContrastanalysisdetailVO>();
        ArrayList<String> rootItems = new ArrayList<String>();
        HashMap<String, ContrastanalysisdetailVO> listMap = new HashMap<String, ContrastanalysisdetailVO>();
        for (ContrastanalysisdetailVO item : list) {
            listMap.put(item.getTid().toString(), item);
        }
        for (int i = 0; i < list.size(); ++i) {
            ContrastanalysisdetailVO item;
            item = list.get(i);
            String parentId = item.getTpid() != null ? item.getTpid().toString() : "";
            ContrastanalysisdetailVO parent = (ContrastanalysisdetailVO)((Object)listMap.get(parentId));
            if (parent != null) {
                List<ContrastanalysisdetailVO> child = parent.getChildren();
                if (child != null) {
                    child.add(item);
                    continue;
                }
                ArrayList<ContrastanalysisdetailVO> children = new ArrayList<ContrastanalysisdetailVO>();
                children.add(item);
                parent.setChildren(children);
                continue;
            }
            rootItems.add(item.getTid());
        }
        for (String rootId : rootItems) {
            resp.add((ContrastanalysisdetailVO)((Object)listMap.get(rootId)));
        }
        return resp;
    }
}

