/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bedget.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.bedget.bean.SubpackagetotalEntity;
import com.ejianc.business.bedget.service.ISubpackageService;
import com.ejianc.business.bedget.service.ISubpackagedetailService;
import com.ejianc.business.bedget.service.ISubpackagetotalService;
import com.ejianc.business.bedget.vo.SubpackagetotalVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"subpackagetotal"})
public class SubpackagetotalController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "budgetmanager-subpackagetotal";
    @Autowired
    private ISubpackagetotalService service;
    @Autowired
    private ISubpackageService subpackageService;
    @Autowired
    private ISubpackagedetailService subpackagedetailService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SubpackagetotalVO> saveOrUpdate(@RequestBody SubpackagetotalVO saveorUpdateVO) {
        SubpackagetotalEntity entity = (SubpackagetotalEntity)((Object)BeanMapper.map((Object)((Object)saveorUpdateVO), SubpackagetotalEntity.class));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"project_id", (Object)entity.getProjectId());
        queryWrapper.eq((Object)"dr", (Object)"0");
        List pro = this.service.list((Wrapper)queryWrapper);
        if (pro.size() > 0) {
            throw new BusinessException("\u8be5\u9879\u76ee\u5df2\u7ecf\u521b\u5efa\u4e00\u4e2a\u5206\u5305\u65bd\u5de5\u56fe\u9884\u7b97\u6c47\u603b\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u521b\u5efa!");
        }
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        SubpackagetotalVO vo = (SubpackagetotalVO)((Object)BeanMapper.map((Object)((Object)entity), SubpackagetotalVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SubpackagetotalVO> queryDetail(Long id) {
        SubpackagetotalEntity entity = (SubpackagetotalEntity)((Object)this.service.selectById(id));
        SubpackagetotalVO vo = (SubpackagetotalVO)((Object)BeanMapper.map((Object)((Object)entity), SubpackagetotalVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SubpackagetotalVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SubpackagetotalVO>> queryList(@RequestBody QueryParam param) {
        return null;
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Subpackagetotal-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refSubpackagetotalData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SubpackagetotalVO>> refSubpackagetotalData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SubpackagetotalVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/saveSnapshotData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> saveSnapshotData() {
        return this.service.saveSnapshotData();
    }

    @RequestMapping(value={"/saveESData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> saveESData(String contract, String projectId) {
        if (projectId == null || StringUtils.isBlank((CharSequence)projectId)) {
            throw new BusinessException("\u8bf7\u9009\u62e9\u9879\u76ee");
        }
        if (contract == null || StringUtils.isBlank((CharSequence)contract)) {
            throw new BusinessException("\u8bf7\u9009\u62e9\u5408\u540c");
        }
        SimpleDateFormat format1 = new SimpleDateFormat("YYYY-MM-dd hh:mm:ss");
        String curDate = format1.format(new Date());
        return this.service.saveESData("\u52b3\u52a1\u5206\u5305\u9884\u7b97\u6c47\u603b\uff08\u624b\u52a8\uff09" + curDate, contract, projectId);
    }

    @RequestMapping(value={"/queryReportList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SubpackagetotalVO>> queryReportList(QueryParam param, String reportItem, String monthQuery, String contract, String projectId) throws ParseException {
        if (projectId == null || StringUtils.isBlank((CharSequence)projectId)) {
            throw new BusinessException("\u8bf7\u9009\u62e9\u9879\u76ee");
        }
        if (contract == null || StringUtils.isBlank((CharSequence)contract)) {
            throw new BusinessException("\u8bf7\u9009\u62e9\u5408\u540c");
        }
        if (monthQuery == null || StringUtils.isBlank((CharSequence)monthQuery)) {
            throw new BusinessException("\u8bf7\u9009\u62e9\u6708\u4efd");
        }
        if (reportItem == null || StringUtils.isBlank((CharSequence)reportItem)) {
            throw new BusinessException("\u8bf7\u9009\u62e9\u5feb\u7167\u7248\u672c");
        }
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("subtitleCode");
        fuzzyFields.add("subtitleName");
        fuzzyFields.add("subtitleFeature");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("section");
        return CommonResponse.success(this.service.queryEsByPage(param, reportItem, monthQuery, contract, projectId));
    }

    @RequestMapping(value={"/esExcelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse esExcelExport(HttpServletResponse response) throws ParseException {
        QueryParam param = new QueryParam();
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("subtitleCode");
        fuzzyFields.add("subtitleName");
        fuzzyFields.add("subtitleFeature");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("section");
        IPage<SubpackagetotalVO> page = this.service.queryEsByPage(param, null, null, null, null);
        ArrayList<SubpackagetotalVO> list = new ArrayList<SubpackagetotalVO>();
        for (int i = 0; i < page.getRecords().size(); ++i) {
            SubpackagetotalVO vo = (SubpackagetotalVO)((Object)page.getRecords().get(i));
            vo.setSort(String.valueOf(i + 1));
            list.add(vo);
        }
        HashMap<String, ArrayList<SubpackagetotalVO>> beans = new HashMap<String, ArrayList<SubpackagetotalVO>>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Subpackagetotal-export.xlsx", beans, response);
        return CommonResponse.success();
    }

    @RequestMapping(value={"/queryEsSnap"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse queryEsSnap(String snapShotTime, String contract, String projectId) {
        List<String> list = this.service.queryEsSnap(snapShotTime, contract, projectId);
        return CommonResponse.success(list);
    }

    @RequestMapping(value={"/excelExportSubpackagetotalFromPage"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportSubpackagetotalFromPage(@RequestBody List<SubpackagetotalVO> list, HttpServletResponse response) {
        ArrayList<SubpackagetotalVO> concatList = new ArrayList<SubpackagetotalVO>();
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                SubpackagetotalVO subpackagedetailVO = list.get(i);
                subpackagedetailVO.setSort(String.valueOf(i + 1));
                concatList.add(subpackagedetailVO);
            }
        }
        List<SubpackagetotalVO> allList = this.handleList(list, concatList);
        for (int i = 0; i < allList.size(); ++i) {
            allList.get(i).setId(Long.valueOf(i + 1));
        }
        HashMap<String, List<SubpackagetotalVO>> beans = new HashMap<String, List<SubpackagetotalVO>>();
        beans.put("records", allList);
        ExcelExport.getInstance().export("Subpackagetotal-export.xlsx", beans, response);
    }

    private List<SubpackagetotalVO> handleList(List<SubpackagetotalVO> list, List<SubpackagetotalVO> concatList) {
        if (list == null || list.size() == 0) {
            return concatList;
        }
        for (int i = 0; i < list.size(); ++i) {
            SubpackagetotalVO subpackagedetailVO = list.get(i);
            List<SubpackagetotalVO> children = subpackagedetailVO.getChildren();
            if (children == null || children.size() <= 0) continue;
            concatList.addAll(children);
            this.handleList(children, concatList);
        }
        return concatList;
    }

    @RequestMapping(value={"/pastData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SubpackagetotalVO> pastData(Long projectId, Date deadline) {
        Date deadlineRes = deadline;
        if (deadline == null) {
            deadlineRes = new Date(System.currentTimeMillis());
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5f80\u671f\u5ba1\u6279\u901a\u8fc7\u7684\u7d2f\u8ba1\u6570\u636e\u6210\u529f\uff01", (Object)((Object)this.getPastTotalData(projectId, deadlineRes)));
    }

    @RequestMapping(value={"/selectEsList"}, method={RequestMethod.GET})
    @ResponseBody
    public IPage<SubpackagetotalVO> selectEsList(QueryParam param, String contract, String projectId) {
        if (contract == null || StringUtils.isBlank((CharSequence)contract)) {
            throw new BusinessException("\u8bf7\u9009\u62e9\u5408\u540c");
        }
        if (projectId == null || StringUtils.isBlank((CharSequence)projectId)) {
            throw new BusinessException("\u8bf7\u9009\u62e9\u9879\u76ee");
        }
        IPage<SubpackagetotalVO> subpackagetotalVOIPage = this.service.selectEsList(param, contract, projectId);
        return subpackagetotalVOIPage;
    }

    private SubpackagetotalVO getPastTotalData(Long projectId, Date deadlineRes) {
        return new SubpackagetotalVO();
    }
}

