/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bedget.excel;

import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bedget.service.IConsdrawbudgetdetailService;
import com.ejianc.business.bedget.vo.ConsdrawbudgetVO;
import com.ejianc.business.bedget.vo.ConsdrawbudgetdetailVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.util.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"consdrawbudgetExport"})
public class ExeclConsdrawbudgetController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IConsdrawbudgetdetailService consdrawbudgetdetailService;

    @RequestMapping(value={"/downloadConsdrawbudget"})
    @ResponseBody
    public void downloadConsdrawbudget(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"consdrawbudgetdetail-import.xlsx", (String)"\u65bd\u5de5\u56fe\u9884\u7b97\u6e05\u5355\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImportConsdrawbudget"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportConsdrawbudget(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<ConsdrawbudgetdetailVO> successList = new ArrayList<ConsdrawbudgetdetailVO>();
        ArrayList<ConsdrawbudgetdetailVO> errorList = new ArrayList<ConsdrawbudgetdetailVO>();
        HashMap<String, ConsdrawbudgetdetailVO> map = new HashMap<String, ConsdrawbudgetdetailVO>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            for (int i = 2; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                StringBuilder errorsMsgBuilder = new StringBuilder();
                String subitemCode = (String)datas.get(0);
                String section = (String)datas.get(1);
                String subitemName = (String)datas.get(2);
                String engineeQuatity = (String)datas.get(5);
                String unitLaborCost = (String)datas.get(6);
                String unitmaterialCost = (String)datas.get(7);
                String unitMachineryCost = (String)datas.get(8);
                String unitBusinessManagerCost = (String)datas.get(9);
                String unitProfit = (String)datas.get(10);
                String comprehensiveUnitPrice = (String)datas.get(11);
                String totalLaborCost = (String)datas.get(12);
                String totalMaterialCost = (String)datas.get(13);
                String totalMachineryCost = (String)datas.get(14);
                String totalBusinessManagerCost = (String)datas.get(15);
                String totalProfit = (String)datas.get(16);
                String sumTotalPrice = (String)datas.get(17);
                String socialSecurity = (String)datas.get(18);
                String housing = (String)datas.get(19);
                String reserved1 = (String)datas.get(20);
                String reserved2 = (String)datas.get(21);
                String reserved3 = (String)datas.get(22);
                String tax = (String)datas.get(23);
                String provisionalEstimate = (String)datas.get(24);
                ConsdrawbudgetdetailVO consdrawbudgetdetailVO = new ConsdrawbudgetdetailVO();
                consdrawbudgetdetailVO.setId(IdWorker.getId());
                consdrawbudgetdetailVO.setTid(String.valueOf(IdWorker.getId()));
                consdrawbudgetdetailVO.setSubitemCode(StringUtils.isNotBlank((CharSequence)subitemCode) ? subitemCode : null);
                consdrawbudgetdetailVO.setSection(StringUtils.isNotBlank((CharSequence)section) ? section : null);
                consdrawbudgetdetailVO.setSubitemName(StringUtils.isNotBlank((CharSequence)subitemName) ? subitemName : null);
                consdrawbudgetdetailVO.setCharacterDescrip(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(3))) ? (String)datas.get(3) : null);
                consdrawbudgetdetailVO.setEstimateUnit(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(4))) ? (String)datas.get(4) : null);
                if (subitemCode == null || TextUtils.isEmpty((CharSequence)subitemCode)) {
                    consdrawbudgetdetailVO.setErrorMsg("\u5b50\u76ee\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorsMsgBuilder.append("\u5b50\u76ee\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (section == null || TextUtils.isEmpty((CharSequence)section)) {
                    consdrawbudgetdetailVO.setErrorMsg("\u533a\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorsMsgBuilder.append("\u533a\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (subitemName == null || TextUtils.isEmpty((CharSequence)subitemName)) {
                    consdrawbudgetdetailVO.setErrorMsg("\u5b50\u76ee\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorsMsgBuilder.append("\u5b50\u76ee\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (subitemCode != null) {
                    String code;
                    consdrawbudgetdetailVO.setInnercode(subitemCode + "_" + section);
                    if ("01".equals(subitemCode) && subitemName != null && subitemName.contains("\u88c5\u9970")) {
                        consdrawbudgetdetailVO.setInnercode("a1_" + consdrawbudgetdetailVO.getSection());
                    }
                    if (subitemCode.length() >= 4 && ("0111".equals(code = subitemCode.substring(0, 4)) || "0112".equals(code) || "0113".equals(code) || "0114".equals(code) || "0115".equals(code))) {
                        consdrawbudgetdetailVO.setInnercode("a1" + subitemCode.substring(2, subitemCode.length()) + "_" + section);
                    }
                    if (subitemCode == null || subitemCode.length() != 2 && subitemCode.length() != 4 && subitemCode.length() != 6 && subitemCode.length() < 9) {
                        consdrawbudgetdetailVO.setErrorMsg("\u5b50\u76ee\u7f16\u7801\u5fc5\u987b\u7b26\u5408\uff1a2\u4f4d\u30014\u4f4d\u30016\u4f4d\u30019\u4f4d\u62169\u4f4d\u4ee5\u4e0a\u4e2d\u4efb\u610f\u4e00\u89c4\u5219");
                        errorsMsgBuilder.append("\u5b50\u76ee\u7f16\u7801\u5fc5\u987b\u7b26\u5408\uff1a2\u4f4d\u30014\u4f4d\u30016\u4f4d\u30019\u4f4d\u62169\u4f4d\u4ee5\u4e0a\u4e2d\u4efb\u610f\u4e00\u89c4\u5219\uff01");
                    }
                    consdrawbudgetdetailVO.setSubitemCode(subitemCode);
                    ConsdrawbudgetdetailVO mapVO = (ConsdrawbudgetdetailVO)((Object)map.get(consdrawbudgetdetailVO.getInnercode()));
                    if (mapVO == null) {
                        map.put(consdrawbudgetdetailVO.getInnercode(), consdrawbudgetdetailVO);
                    } else {
                        consdrawbudgetdetailVO.setErrorMsg("\u5b50\u76ee\u7f16\u7801\u5df2\u5b58\u5728\uff01");
                        errorsMsgBuilder.append("\u5b50\u76ee\u7f16\u7801\u5df2\u5b58\u5728\uff01");
                    }
                    consdrawbudgetdetailVO.setSubitemCode(subitemCode);
                }
                if (!TextUtils.isEmpty((CharSequence)engineeQuatity) && !NumberUtil.isNumber((String)engineeQuatity)) {
                    consdrawbudgetdetailVO.setErrorMsg("\u5de5\u7a0b\u91cf\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    errorsMsgBuilder.append("\u5de5\u7a0b\u91cf\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                } else {
                    consdrawbudgetdetailVO.setEngineeQuatity(StringUtils.isNotBlank((CharSequence)engineeQuatity) ? new BigDecimal(engineeQuatity) : null);
                }
                if (!TextUtils.isEmpty((CharSequence)unitLaborCost) && !NumberUtil.isNumber((String)unitLaborCost)) {
                    consdrawbudgetdetailVO.setErrorMsg("\u4eba\u5de5\u8d39\uff08\u5355\u4ef7\uff09\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    errorsMsgBuilder.append("\u4eba\u5de5\u8d39\uff08\u5355\u4ef7\uff09\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                } else {
                    consdrawbudgetdetailVO.setUnitLaborCost(StringUtils.isNotBlank((CharSequence)unitLaborCost) ? new BigDecimal(unitLaborCost) : null);
                }
                if (!TextUtils.isEmpty((CharSequence)unitmaterialCost) && !NumberUtil.isNumber((String)unitmaterialCost)) {
                    consdrawbudgetdetailVO.setErrorMsg("\u6750\u6599\u8d39\uff08\u5355\u4ef7\uff09\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    errorsMsgBuilder.append("\u6750\u6599\u8d39\uff08\u5355\u4ef7\uff09\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                } else {
                    consdrawbudgetdetailVO.setUnitMaterialCost(StringUtils.isNotBlank((CharSequence)unitmaterialCost) ? new BigDecimal(unitmaterialCost) : null);
                }
                if (!TextUtils.isEmpty((CharSequence)unitMachineryCost) && !NumberUtil.isNumber((String)unitMachineryCost)) {
                    consdrawbudgetdetailVO.setErrorMsg("\u673a\u68b0\u8d39\uff08\u5355\u4ef7\uff09\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    errorsMsgBuilder.append("\u673a\u68b0\u8d39\uff08\u5355\u4ef7\uff09\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                } else {
                    consdrawbudgetdetailVO.setUnitMachineryCost(StringUtils.isNotBlank((CharSequence)unitMachineryCost) ? new BigDecimal(unitMachineryCost) : null);
                }
                if (!TextUtils.isEmpty((CharSequence)unitBusinessManagerCost) && !NumberUtil.isNumber((String)unitBusinessManagerCost)) {
                    consdrawbudgetdetailVO.setErrorMsg("\u4f01\u4e1a\u7ba1\u7406\u8d39\uff08\u5355\u4ef7\uff09\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    errorsMsgBuilder.append("\u4f01\u4e1a\u7ba1\u7406\u8d39\uff08\u5355\u4ef7\uff09\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                } else {
                    consdrawbudgetdetailVO.setUnitBusinessManagerCost(StringUtils.isNotBlank((CharSequence)unitBusinessManagerCost) ? new BigDecimal(unitBusinessManagerCost) : null);
                }
                if (!TextUtils.isEmpty((CharSequence)unitProfit) && !NumberUtil.isNumber((String)unitProfit)) {
                    consdrawbudgetdetailVO.setErrorMsg("\u5229\u6da6\uff08\u5355\u4ef7\uff09\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    errorsMsgBuilder.append("\u5229\u6da6\uff08\u5355\u4ef7\uff09\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                } else {
                    consdrawbudgetdetailVO.setUnitProfit(StringUtils.isNotBlank((CharSequence)unitProfit) ? new BigDecimal(unitProfit) : null);
                }
                if (!TextUtils.isEmpty((CharSequence)comprehensiveUnitPrice) && !NumberUtil.isNumber((String)comprehensiveUnitPrice)) {
                    consdrawbudgetdetailVO.setErrorMsg("\u7efc\u5408\u5355\u4ef7\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    errorsMsgBuilder.append("\u7efc\u5408\u5355\u4ef7\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                } else {
                    BigDecimal comprehensiveUnitPriceB = new BigDecimal(0);
                    if (unitLaborCost != null && NumberUtil.isNumber((String)unitLaborCost)) {
                        comprehensiveUnitPriceB = comprehensiveUnitPriceB.add(new BigDecimal(unitLaborCost));
                    } else {
                        unitLaborCost = null;
                    }
                    if (unitmaterialCost != null && NumberUtil.isNumber((String)unitmaterialCost)) {
                        comprehensiveUnitPriceB = comprehensiveUnitPriceB.add(new BigDecimal(unitmaterialCost));
                    } else {
                        unitmaterialCost = null;
                    }
                    if (unitMachineryCost != null && NumberUtil.isNumber((String)unitMachineryCost)) {
                        comprehensiveUnitPriceB = comprehensiveUnitPriceB.add(new BigDecimal(unitMachineryCost));
                    } else {
                        unitMachineryCost = null;
                    }
                    if (unitBusinessManagerCost != null && NumberUtil.isNumber((String)unitBusinessManagerCost)) {
                        comprehensiveUnitPriceB = comprehensiveUnitPriceB.add(new BigDecimal(unitBusinessManagerCost));
                    } else {
                        unitBusinessManagerCost = null;
                    }
                    if (unitProfit != null && NumberUtil.isNumber((String)unitProfit)) {
                        comprehensiveUnitPriceB = comprehensiveUnitPriceB.add(new BigDecimal(unitProfit));
                    } else {
                        unitProfit = null;
                    }
                    if (unitLaborCost == null && unitmaterialCost == null && unitMachineryCost == null && unitBusinessManagerCost == null && unitProfit == null) {
                        comprehensiveUnitPriceB = null;
                    }
                    consdrawbudgetdetailVO.setComprehensiveUnitPrice(StringUtils.isNotBlank((CharSequence)comprehensiveUnitPrice) ? new BigDecimal(comprehensiveUnitPrice) : comprehensiveUnitPriceB);
                }
                if (!TextUtils.isEmpty((CharSequence)totalLaborCost) && !NumberUtil.isNumber((String)totalLaborCost)) {
                    consdrawbudgetdetailVO.setErrorMsg("\u4eba\u5de5\u8d39\uff08\u5408\u4ef7\uff09\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    errorsMsgBuilder.append("\u4eba\u5de5\u8d39\uff08\u5408\u4ef7\uff09\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                } else {
                    BigDecimal totalLaborCostB = new BigDecimal(0);
                    totalLaborCostB = engineeQuatity != null && NumberUtil.isNumber((String)engineeQuatity) && unitLaborCost != null && NumberUtil.isNumber((String)unitLaborCost) ? new BigDecimal(engineeQuatity).multiply(new BigDecimal(unitmaterialCost)) : null;
                    consdrawbudgetdetailVO.setTotalLaborCost(StringUtils.isNotBlank((CharSequence)totalLaborCost) ? new BigDecimal(totalLaborCost) : totalLaborCostB);
                }
                if (!TextUtils.isEmpty((CharSequence)totalMaterialCost) && !NumberUtil.isNumber((String)totalMaterialCost)) {
                    consdrawbudgetdetailVO.setErrorMsg("\u6750\u6599\u8d39\uff08\u5408\u4ef7\uff09\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    errorsMsgBuilder.append("\u6750\u6599\u8d39\uff08\u5408\u4ef7\uff09\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                } else {
                    BigDecimal totalMaterialCostB = new BigDecimal(0);
                    totalMaterialCostB = engineeQuatity != null && NumberUtil.isNumber((String)engineeQuatity) && unitmaterialCost != null && NumberUtil.isNumber((String)unitmaterialCost) ? new BigDecimal(engineeQuatity).multiply(new BigDecimal(unitLaborCost)) : null;
                    consdrawbudgetdetailVO.setTotalMaterialCost(StringUtils.isNotBlank((CharSequence)totalMaterialCost) ? new BigDecimal(totalMaterialCost) : totalMaterialCostB);
                }
                if (!TextUtils.isEmpty((CharSequence)totalMachineryCost) && !NumberUtil.isNumber((String)totalMachineryCost)) {
                    consdrawbudgetdetailVO.setErrorMsg("\u673a\u68b0\u8d39\uff08\u5408\u4ef7\uff09\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    errorsMsgBuilder.append("\u673a\u68b0\u8d39\uff08\u5408\u4ef7\uff09\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                } else {
                    BigDecimal totalMachineryCostB = new BigDecimal(0);
                    totalMachineryCostB = engineeQuatity != null && NumberUtil.isNumber((String)engineeQuatity) && unitMachineryCost != null && NumberUtil.isNumber((String)unitMachineryCost) ? new BigDecimal(engineeQuatity).multiply(new BigDecimal(unitMachineryCost)) : null;
                    consdrawbudgetdetailVO.setTotalMachineryCost(StringUtils.isNotBlank((CharSequence)totalMachineryCost) ? new BigDecimal(totalMachineryCost) : totalMachineryCostB);
                }
                if (!TextUtils.isEmpty((CharSequence)totalBusinessManagerCost) && !NumberUtil.isNumber((String)totalBusinessManagerCost)) {
                    consdrawbudgetdetailVO.setErrorMsg("\u4f01\u4e1a\u7ba1\u7406\u8d39\uff08\u5408\u4ef7\uff09\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    errorsMsgBuilder.append("\u4f01\u4e1a\u7ba1\u7406\u8d39\uff08\u5408\u4ef7\uff09\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                } else {
                    BigDecimal totalBusinessManagerCostB = new BigDecimal(0);
                    totalBusinessManagerCostB = engineeQuatity != null && NumberUtil.isNumber((String)engineeQuatity) && unitBusinessManagerCost != null && NumberUtil.isNumber((String)unitBusinessManagerCost) ? new BigDecimal(engineeQuatity).multiply(new BigDecimal(unitBusinessManagerCost)) : null;
                    consdrawbudgetdetailVO.setTotalBusinessManagerCost(StringUtils.isNotBlank((CharSequence)totalBusinessManagerCost) ? new BigDecimal(totalBusinessManagerCost) : totalBusinessManagerCostB);
                }
                if (!TextUtils.isEmpty((CharSequence)totalProfit) && !NumberUtil.isNumber((String)totalProfit)) {
                    consdrawbudgetdetailVO.setErrorMsg("\u5229\u6da6\uff08\u5408\u4ef7\uff09\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    errorsMsgBuilder.append("\u5229\u6da6\uff08\u5408\u4ef7\uff09\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                } else {
                    BigDecimal totalProfitB = new BigDecimal(0);
                    totalProfitB = engineeQuatity != null && NumberUtil.isNumber((String)engineeQuatity) && unitBusinessManagerCost != null && NumberUtil.isNumber((String)unitBusinessManagerCost) ? new BigDecimal(engineeQuatity).multiply(new BigDecimal(unitProfit)) : null;
                    consdrawbudgetdetailVO.setTotalProfit(StringUtils.isNotBlank((CharSequence)totalProfit) ? new BigDecimal(totalProfit) : totalProfitB);
                }
                if (!TextUtils.isEmpty((CharSequence)sumTotalPrice) && !NumberUtil.isNumber((String)sumTotalPrice)) {
                    consdrawbudgetdetailVO.setErrorMsg("\u5408\u4ef7\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    errorsMsgBuilder.append("\u5408\u4ef7\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                } else {
                    BigDecimal sumTotalPriceB = new BigDecimal(0);
                    if (totalLaborCost != null && NumberUtil.isNumber((String)totalLaborCost)) {
                        sumTotalPriceB = sumTotalPriceB.add(new BigDecimal(totalLaborCost));
                    } else {
                        totalLaborCost = null;
                    }
                    if (totalMaterialCost != null && NumberUtil.isNumber((String)totalMaterialCost)) {
                        sumTotalPriceB = sumTotalPriceB.add(new BigDecimal(totalMaterialCost));
                    } else {
                        totalMaterialCost = null;
                    }
                    if (totalMachineryCost != null && NumberUtil.isNumber((String)totalMachineryCost)) {
                        sumTotalPriceB = sumTotalPriceB.add(new BigDecimal(totalMachineryCost));
                    } else {
                        totalMachineryCost = null;
                    }
                    if (totalBusinessManagerCost != null && NumberUtil.isNumber((String)totalBusinessManagerCost)) {
                        sumTotalPriceB = sumTotalPriceB.add(new BigDecimal(totalBusinessManagerCost));
                    } else {
                        totalBusinessManagerCost = null;
                    }
                    if (totalProfit != null && NumberUtil.isNumber((String)totalProfit)) {
                        sumTotalPriceB = sumTotalPriceB.add(new BigDecimal(totalProfit));
                    } else {
                        totalProfit = null;
                    }
                    if (totalLaborCost == null && totalMaterialCost == null && totalMachineryCost == null && totalBusinessManagerCost == null && totalProfit == null) {
                        sumTotalPriceB = null;
                    }
                    consdrawbudgetdetailVO.setSumTotalPrice(StringUtils.isNotBlank((CharSequence)sumTotalPrice) ? new BigDecimal(sumTotalPrice) : sumTotalPriceB);
                }
                if (!TextUtils.isEmpty((CharSequence)socialSecurity) && !NumberUtil.isNumber((String)socialSecurity)) {
                    consdrawbudgetdetailVO.setErrorMsg("\u793e\u4fdd\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    errorsMsgBuilder.append("\u793e\u4fdd\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                } else {
                    consdrawbudgetdetailVO.setSocialSecurity(StringUtils.isNotBlank((CharSequence)socialSecurity) ? new BigDecimal(socialSecurity) : null);
                }
                if (!TextUtils.isEmpty((CharSequence)housing) && !NumberUtil.isNumber((String)housing)) {
                    consdrawbudgetdetailVO.setErrorMsg("\u4f4f\u623f\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    errorsMsgBuilder.append("\u4f4f\u623f\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                } else {
                    consdrawbudgetdetailVO.setHousing(StringUtils.isNotBlank((CharSequence)housing) ? new BigDecimal(housing) : null);
                }
                if (!TextUtils.isEmpty((CharSequence)reserved1) && !NumberUtil.isNumber((String)reserved1)) {
                    consdrawbudgetdetailVO.setErrorMsg("\u9884\u75591\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    errorsMsgBuilder.append("\u9884\u75591\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                } else {
                    consdrawbudgetdetailVO.setReserved1(StringUtils.isNotBlank((CharSequence)reserved1) ? new BigDecimal(reserved1) : null);
                }
                if (!TextUtils.isEmpty((CharSequence)reserved2) && !NumberUtil.isNumber((String)reserved2)) {
                    consdrawbudgetdetailVO.setErrorMsg("\u9884\u75592\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    errorsMsgBuilder.append("\u9884\u75592\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                } else {
                    consdrawbudgetdetailVO.setReserved2(StringUtils.isNotBlank((CharSequence)reserved2) ? new BigDecimal(reserved2) : null);
                }
                if (!TextUtils.isEmpty((CharSequence)reserved3) && !NumberUtil.isNumber((String)reserved3)) {
                    consdrawbudgetdetailVO.setErrorMsg("\u9884\u75593\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    errorsMsgBuilder.append("\u9884\u75593\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                } else {
                    consdrawbudgetdetailVO.setReserved3(StringUtils.isNotBlank((CharSequence)reserved3) ? new BigDecimal(reserved3) : null);
                }
                if (!TextUtils.isEmpty((CharSequence)tax) && !NumberUtil.isNumber((String)tax)) {
                    consdrawbudgetdetailVO.setErrorMsg("\u7a0e\u91d1\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    errorsMsgBuilder.append("\u7a0e\u91d1\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                } else {
                    consdrawbudgetdetailVO.setTax(StringUtils.isNotBlank((CharSequence)tax) ? new BigDecimal(tax) : null);
                }
                if (!TextUtils.isEmpty((CharSequence)provisionalEstimate) && !NumberUtil.isNumber((String)provisionalEstimate)) {
                    consdrawbudgetdetailVO.setErrorMsg("\u6682\u4f30\u4ef7\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    errorsMsgBuilder.append("\u6682\u4f30\u4ef7\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                } else {
                    consdrawbudgetdetailVO.setProvisionalEstimate(StringUtils.isNotBlank((CharSequence)provisionalEstimate) ? new BigDecimal(provisionalEstimate) : null);
                }
                if (errorsMsgBuilder.length() > 0) {
                    errorList.add(consdrawbudgetdetailVO);
                    continue;
                }
                successList.add(consdrawbudgetdetailVO);
            }
        }
        Collections.sort(successList, new Comparator<ConsdrawbudgetdetailVO>(){

            @Override
            public int compare(ConsdrawbudgetdetailVO o1, ConsdrawbudgetdetailVO o2) {
                return (o1.getSubitemCode() + o1.getSection()).compareTo(o2.getSubitemCode() + o2.getSection());
            }
        });
        List<ConsdrawbudgetdetailVO> resList = this.setTidAndTpid(successList, map);
        resList = ExeclConsdrawbudgetController.createTreeData(resList);
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", resList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        ConsdrawbudgetVO resVo = new ConsdrawbudgetVO();
        json.put("total", (Object)this.getTotalAmount(resList, resVo));
        return CommonResponse.success((Object)json);
    }

    private List<ConsdrawbudgetdetailVO> setTidAndTpid(List<ConsdrawbudgetdetailVO> vos, Map<String, ConsdrawbudgetdetailVO> map) {
        if (vos == null) {
            return null;
        }
        for (int i = 0; i < vos.size(); ++i) {
            ConsdrawbudgetdetailVO consdrawbudgetdetailVO = vos.get(i);
            String innercode = consdrawbudgetdetailVO.getInnercode();
            String[] innercodeSubArr = innercode.split("_");
            String innercodeSub = "";
            String sectionSuf = "";
            if (innercodeSubArr.length > 1) {
                innercodeSub = innercodeSubArr[0];
                sectionSuf = "_" + innercodeSubArr[1];
            }
            Long pid = null;
            if (innercodeSub.length() != 2) {
                String pcode;
                if (innercodeSub.length() == 4) {
                    pcode = innercodeSub.substring(0, 2) + sectionSuf;
                    pid = this.setPid(pcode, map);
                } else if (innercodeSub.length() == 6) {
                    pcode = innercodeSub.substring(0, 4) + sectionSuf;
                    pid = this.setPid(pcode, map);
                } else if (innercodeSub.length() > 6) {
                    pcode = innercodeSub.substring(0, 6) + sectionSuf;
                    pid = this.setPid(pcode, map);
                }
            }
            if (pid != null) {
                consdrawbudgetdetailVO.setTpid(pid.toString());
                continue;
            }
            consdrawbudgetdetailVO.setTpid("");
        }
        return vos;
    }

    public static List<ConsdrawbudgetdetailVO> createTreeData(List<ConsdrawbudgetdetailVO> list) {
        ArrayList<ConsdrawbudgetdetailVO> resp = new ArrayList<ConsdrawbudgetdetailVO>();
        ArrayList<String> rootItems = new ArrayList<String>();
        HashMap<String, ConsdrawbudgetdetailVO> listMap = new HashMap<String, ConsdrawbudgetdetailVO>();
        for (ConsdrawbudgetdetailVO item : list) {
            listMap.put(item.getTid().toString(), item);
        }
        for (int i = 0; i < list.size(); ++i) {
            ConsdrawbudgetdetailVO item;
            item = list.get(i);
            String parentId = item.getTpid() != null ? item.getTpid().toString() : "";
            ConsdrawbudgetdetailVO parent = (ConsdrawbudgetdetailVO)((Object)listMap.get(parentId));
            if (parent != null) {
                List<ConsdrawbudgetdetailVO> child = parent.getChildren();
                if (child != null) {
                    child.add(item);
                    continue;
                }
                ArrayList<ConsdrawbudgetdetailVO> children = new ArrayList<ConsdrawbudgetdetailVO>();
                children.add(item);
                parent.setChildren(children);
                continue;
            }
            rootItems.add(item.getTid());
        }
        for (String rootId : rootItems) {
            resp.add((ConsdrawbudgetdetailVO)((Object)listMap.get(rootId)));
        }
        return resp;
    }

    private ConsdrawbudgetVO getTotalAmount(List<ConsdrawbudgetdetailVO> vos, ConsdrawbudgetVO resVo) {
        BigDecimal conDrawBudgetTotal = new BigDecimal(0);
        BigDecimal feesTotal = new BigDecimal(0);
        BigDecimal taxTotal = new BigDecimal(0);
        BigDecimal provisionalEstimateTotal = new BigDecimal(0);
        for (ConsdrawbudgetdetailVO vo : vos) {
            if (vo.getSumTotalPrice() != null) {
                conDrawBudgetTotal = conDrawBudgetTotal.add(vo.getSumTotalPrice());
            }
            if (vo.getTax() != null) {
                taxTotal = taxTotal.add(vo.getTax());
            }
            if (vo.getSocialSecurity() != null) {
                feesTotal = feesTotal.add(vo.getSocialSecurity());
            }
            if (vo.getHousing() != null) {
                feesTotal = feesTotal.add(vo.getHousing());
            }
            if (vo.getReserved1() != null) {
                feesTotal = feesTotal.add(vo.getReserved1());
            }
            if (vo.getReserved2() != null) {
                feesTotal = feesTotal.add(vo.getReserved2());
            }
            if (vo.getReserved3() != null) {
                feesTotal = feesTotal.add(vo.getReserved3());
            }
            if (vo.getProvisionalEstimate() == null) continue;
            provisionalEstimateTotal = provisionalEstimateTotal.add(vo.getProvisionalEstimate());
        }
        resVo.setConDrawBudgetTotal(conDrawBudgetTotal);
        resVo.setProvisionalEstimateTotal(provisionalEstimateTotal);
        resVo.setFeesTotal(feesTotal);
        resVo.setTaxTotal(taxTotal);
        return resVo;
    }

    private Long setPid(String pcode, Map<String, ConsdrawbudgetdetailVO> map) {
        if (map.get(pcode) != null) {
            return Long.valueOf(map.get(pcode).getTid());
        }
        String[] pcodeSubArr = pcode.split("_");
        String pcodeSub = "";
        String sectionSuf = "";
        if (pcodeSubArr.length > 1) {
            pcodeSub = pcodeSubArr[0];
            sectionSuf = "_" + pcodeSubArr[1];
        }
        if (pcodeSub.length() == 2) {
            return null;
        }
        if (pcodeSub.length() == 4) {
            String ppcode = pcodeSub.substring(0, 2);
            return this.setPid(ppcode + sectionSuf, map);
        }
        if (pcodeSub.length() == 6) {
            String ppcode = pcode.substring(0, 4);
            return this.setPid(ppcode + sectionSuf, map);
        }
        if (pcodeSub.length() > 6) {
            String ppcode = pcode.substring(0, 6);
            return this.setPid(ppcode + sectionSuf, map);
        }
        return null;
    }

    @RequestMapping(value={"/excelExportConsdrawbudgetFromDatabase"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportConsdrawbudgetFromDatabase(@RequestBody ConsdrawbudgetVO consdrawbudgetVO, HttpServletResponse response) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"mid", (Object)consdrawbudgetVO.getId());
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.orderByAsc((Object)"subitem_code");
        queryWrapper.orderByAsc((Object)"section");
        List list = this.consdrawbudgetdetailService.list((Wrapper)queryWrapper);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("consdrawbudgetdetail-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/excelExportConsdrawbudgetFromPage"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportConsdrawbudgetFromPage(@RequestBody List<ConsdrawbudgetdetailVO> list, HttpServletResponse response) {
        ArrayList<ConsdrawbudgetdetailVO> concatList = new ArrayList<ConsdrawbudgetdetailVO>();
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                ConsdrawbudgetdetailVO consdrawbudgetdetailVO = list.get(i);
                concatList.add(consdrawbudgetdetailVO);
            }
        }
        List<ConsdrawbudgetdetailVO> allList = this.handleList(list, concatList);
        HashMap<String, List<ConsdrawbudgetdetailVO>> beans = new HashMap<String, List<ConsdrawbudgetdetailVO>>();
        beans.put("records", allList);
        ExcelExport.getInstance().export("consdrawbudgetdetail-export.xlsx", beans, response);
    }

    private List<ConsdrawbudgetdetailVO> handleList(List<ConsdrawbudgetdetailVO> list, List<ConsdrawbudgetdetailVO> concatList) {
        if (list == null || list.size() == 0) {
            return concatList;
        }
        for (int i = 0; i < list.size(); ++i) {
            ConsdrawbudgetdetailVO consdrawbudgetdetailVO = list.get(i);
            List<ConsdrawbudgetdetailVO> children = consdrawbudgetdetailVO.getChildren();
            if (children == null || children.size() <= 0) continue;
            concatList.addAll(children);
            this.handleList(children, concatList);
        }
        return concatList;
    }
}

