/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bedget.service.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.bedget.bean.SubpackageEntity;
import com.ejianc.business.bedget.bean.SubpackagedetailEntity;
import com.ejianc.business.bedget.bean.SubpackagetotalEntity;
import com.ejianc.business.bedget.mapper.SubpackagetotalMapper;
import com.ejianc.business.bedget.service.ISubpackageService;
import com.ejianc.business.bedget.service.ISubpackagedetailService;
import com.ejianc.business.bedget.service.ISubpackagetotalService;
import com.ejianc.business.bedget.vo.SubpackagedetailVO;
import com.ejianc.business.bedget.vo.SubpackagetotalVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MatchPhraseQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="subpackagetotalService")
public class SubpackagetotalServiceImpl
extends BaseServiceImpl<SubpackagetotalMapper, SubpackagetotalEntity>
implements ISubpackagetotalService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISubpackagetotalService service;
    @Autowired
    private RestHighLevelClient client;
    @Autowired
    private ISubpackageService subpackageService;
    @Autowired
    private ISubpackagedetailService subpackagedetailService;
    private static final String ESSignStatistic = "ejc-budgetmanage-subpackagetotal";

    @Override
    public CommonResponse<String> saveSnapshotData() {
        String curDate = this.getLastMonth();
        new Thread(() -> {
            try {
                this.service.saveESData("\u52b3\u52a1\u5206\u5305\u9884\u7b97\u6c47\u603b\u62a5\u8868" + curDate, null, null);
            }
            catch (Exception e) {
                this.logger.error("\u52b3\u52a1\u5206\u5305\u9884\u7b97\u6c47\u603b\u62a5\u8868\u6570\u636e\u5f02\u5e38\uff0c", (Throwable)e);
            }
        }).start();
        return CommonResponse.success((String)"\u4fdd\u5b58\u5feb\u7167\u6210\u529f");
    }

    @Override
    public CommonResponse<String> saveESData(String reportName, String contract, String projectId) {
        BulkRequest bulkRequest = new BulkRequest();
        SimpleDateFormat format1 = new SimpleDateFormat("YYYY-MM-dd hh:mm:ss");
        String curDate = format1.format(new Date());
        if (reportName == null || StringUtils.isBlank((CharSequence)reportName)) {
            reportName = "\u5206\u5305\u65bd\u5de5\u56fe\u9884\u7b97\u6c47\u603b(\u624b\u52a8)";
        }
        String versionId = reportName + curDate;
        QueryWrapper queryParam = new QueryWrapper();
        queryParam.eq((Object)"contract", (Object)contract);
        queryParam.eq((Object)"project_id", (Object)projectId);
        queryParam.eq((Object)"dr", (Object)0);
        List list = this.subpackageService.list((Wrapper)queryParam);
        for (SubpackageEntity entity : list) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"dr", (Object)0);
            wrapper.eq((Object)"mid", (Object)entity.getId());
            List subpackagedetailEntityList = this.subpackagedetailService.list((Wrapper)wrapper);
            for (SubpackagedetailEntity subpackagedetailEntity : subpackagedetailEntityList) {
                try {
                    SubpackagetotalVO vo = (SubpackagetotalVO)((Object)BeanMapper.map((Object)((Object)entity), SubpackagetotalVO.class));
                    Map dataMap = (Map)BeanMapper.map((Object)((Object)vo), Map.class);
                    dataMap.put("reportId", subpackagedetailEntity.getId().toString());
                    dataMap.put("snapShotTime", curDate);
                    dataMap.put("snapShotVersion", versionId);
                    dataMap.put("projectId", entity.getProjectId());
                    dataMap.put("contract", entity.getContract());
                    dataMap.put("subtitleCode", subpackagedetailEntity.getSubtitleCode());
                    dataMap.put("subtitleName", subpackagedetailEntity.getSubtitleName());
                    dataMap.put("subtitleFeature", subpackagedetailEntity.getSubtitleFeature());
                    dataMap.put("artificialTotal", subpackagedetailEntity.getArtificialTotal());
                    dataMap.put("materialsTotal", subpackagedetailEntity.getMaterialsTotal());
                    dataMap.put("mechanicalTotal", subpackagedetailEntity.getMechanicalTotal());
                    dataMap.put("enterpriseManageTotal", subpackagedetailEntity.getEnterpriseManageTotal());
                    dataMap.put("profitsTotal", subpackagedetailEntity.getProfitsTotal());
                    dataMap.put("feesTotal", subpackagedetailEntity.getFeesTotal());
                    dataMap.put("taxTotal", subpackagedetailEntity.getTaxTotal());
                    dataMap.put("comprehensiveTotal", subpackagedetailEntity.getComprehensiveTotal());
                    dataMap.put("excludingTaxTotal", subpackagedetailEntity.getExcludingTaxTotal());
                    dataMap.put("includingTaxTotal", subpackagedetailEntity.getIncludingTaxTotal());
                    dataMap.put("tid", subpackagedetailEntity.getTid());
                    dataMap.put("tpid", subpackagedetailEntity.getTpid());
                    IndexRequest indexRequest = new IndexRequest(ESSignStatistic);
                    indexRequest.source(dataMap, XContentType.JSON);
                    bulkRequest.add(indexRequest);
                }
                catch (Exception e) {
                    this.logger.error("\u751f\u6210\u52b3\u52a1\u5206\u5305\u9884\u7b97\u6c47\u603b\u6570\u636e\u5f02\u5e38\uff0c", (Throwable)e);
                    throw new BusinessException("\u751f\u6210\u52b3\u52a1\u5206\u5305\u9884\u7b97\u6c47\u603b\u6570\u636e\u5f02\u5e38");
                }
            }
        }
        try {
            bulkRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            this.client.bulk(bulkRequest, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            this.logger.info("\u751f\u6210ES\u6570\u636e\u5931\u8d25:---->" + e.getMessage());
            throw new BusinessException("\u751f\u6210ES\u6570\u636e\u5931\u8d25:---->" + e.getMessage());
        }
        this.logger.info("***********\u751f\u6210\u52b3\u52a1\u5206\u5305\u9884\u7b97\u6c47\u603b---\u6267\u884c\u5b8c\u6210 *********** ");
        return CommonResponse.success((String)"\u751f\u6210\u52b3\u52a1\u5206\u5305\u9884\u7b97\u6c47\u603b\u6210\u529f");
    }

    @Override
    public IPage<SubpackagetotalVO> queryEsByPage(QueryParam param, String reportItem, String monthQuery, String contract, String projectId) {
        Date d = new Date(monthQuery);
        String dateFormat = String.valueOf(d.getYear() + 45 + (d.getMonth() + 1) + 45 + d.getDate() + 32 + d.getHours() + 58 + d.getMinutes() + 58 + d.getSeconds());
        SearchRequest searchRequest = new SearchRequest(new String[]{ESSignStatistic});
        searchRequest.searchType(SearchType.DEFAULT);
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolBuilder = QueryBuilders.boolQuery();
        Map parameterMap = param.getParams();
        ArrayList<MatchPhraseQueryBuilder> listQuery = new ArrayList<MatchPhraseQueryBuilder>();
        ArrayList<MatchPhraseQueryBuilder> mustQuery = new ArrayList<MatchPhraseQueryBuilder>();
        if (StringUtils.isNotEmpty((CharSequence)contract) && contract != null) {
            mustQuery.add(QueryBuilders.matchPhraseQuery((String)"contract", (Object)contract));
        }
        if (StringUtils.isNotEmpty((CharSequence)projectId) && projectId != null) {
            mustQuery.add(QueryBuilders.matchPhraseQuery((String)"projectId", (Object)projectId));
        }
        if (StringUtils.isNotEmpty((CharSequence)dateFormat) && dateFormat != null) {
            listQuery.add(QueryBuilders.matchPhraseQuery((String)"createTime", (Object)dateFormat));
        }
        if (StringUtils.isNotEmpty((CharSequence)reportItem) && reportItem != null) {
            mustQuery.add(QueryBuilders.matchPhraseQuery((String)"snapShotVersion", (Object)reportItem));
        }
        if (parameterMap.size() > 0 && parameterMap != null) {
            for (String key : parameterMap.keySet()) {
                listQuery.add(QueryBuilders.matchPhraseQuery((String)key, (Object)((Parameter)param.getParams().get(key)).getValue()));
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getSearchText()) && param.getSearchText() != null) {
            for (String field : param.getFuzzyFields()) {
                listQuery.add(QueryBuilders.matchPhraseQuery((String)field, (Object)param.getSearchText()));
            }
        }
        Integer pageIndex = param.getPageIndex();
        Integer pageSize = param.getPageSize();
        sourceBuilder.from(pageIndex <= 0 ? 0 : (pageIndex - 1) * pageSize);
        sourceBuilder.size(pageSize.intValue());
        sourceBuilder.trackTotalHits(true);
        sourceBuilder.timeout(new TimeValue(60L, TimeUnit.SECONDS));
        boolBuilder.should().addAll(listQuery);
        boolBuilder.must().addAll(mustQuery);
        sourceBuilder.query((QueryBuilder)boolBuilder);
        searchRequest.source(sourceBuilder);
        ArrayList<SubpackagetotalVO> list = new ArrayList<SubpackagetotalVO>();
        try {
            SearchResponse searchResponse = this.client.search(searchRequest, RequestOptions.DEFAULT);
            SearchHits hits = searchResponse.getHits();
            Integer idCount = 1;
            SearchHit[] searchHits = hits.getHits();
            Page voPage = new Page();
            if (hits.getTotalHits().value <= 0L) {
                voPage.setTotal(0L);
                voPage.setCurrent((long)pageIndex.intValue());
                voPage.setSize((long)pageSize.intValue());
                voPage.setRecords(null);
                return voPage;
            }
            for (SearchHit hit : searchHits) {
                Integer n = idCount;
                Integer n2 = idCount = Integer.valueOf(idCount + 1);
                JSONObject json = new JSONObject(hit.getSourceAsMap());
                SubpackagetotalVO vo = (SubpackagetotalVO)((Object)JSONObject.toJavaObject((JSON)json, SubpackagetotalVO.class));
                vo.setId((long)idCount);
                if (vo.getSnapShotTime() != null) {
                    vo.setSnapShotTime((Date)DateUtil.date((Date)vo.getSnapShotTime()));
                }
                list.add(vo);
            }
            List<SubpackagetotalVO> resList = SubpackagetotalServiceImpl.createTreeData(list);
            voPage.setTotal(hits.getTotalHits().value);
            voPage.setSize((long)pageSize.intValue());
            voPage.setCurrent((long)pageIndex.intValue());
            voPage.setRecords(resList);
            return voPage;
        }
        catch (IOException e) {
            throw new RuntimeException("ES\u67e5\u8be2\u5f02\u5e38" + e);
        }
    }

    @Override
    public List<String> queryEsSnap(String snapShotTime, String contract, String projectId) {
        SearchRequest searchRequest = new SearchRequest(new String[]{ESSignStatistic});
        searchRequest.searchType(SearchType.DEFAULT);
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolBuilder = QueryBuilders.boolQuery();
        ArrayList<MatchPhraseQueryBuilder> listQuery = new ArrayList<MatchPhraseQueryBuilder>();
        ArrayList<MatchPhraseQueryBuilder> mustQuery = new ArrayList<MatchPhraseQueryBuilder>();
        if (StringUtils.isNotEmpty((CharSequence)contract) && contract != null) {
            mustQuery.add(QueryBuilders.matchPhraseQuery((String)"contract", (Object)contract));
        }
        if (StringUtils.isNotEmpty((CharSequence)projectId) && projectId != null) {
            mustQuery.add(QueryBuilders.matchPhraseQuery((String)"projectId", (Object)projectId));
        }
        if (StringUtils.isNotEmpty((CharSequence)snapShotTime) && snapShotTime != null) {
            listQuery.add(QueryBuilders.matchPhraseQuery((String)"createTime", (Object)snapShotTime));
        }
        boolBuilder.should().addAll(listQuery);
        boolBuilder.must().addAll(mustQuery);
        sourceBuilder.query((QueryBuilder)boolBuilder);
        searchRequest.source(sourceBuilder);
        ArrayList<String> list = new ArrayList<String>();
        try {
            SearchHit[] searchHits;
            SearchResponse searchResponse = this.client.search(searchRequest, RequestOptions.DEFAULT);
            SearchHits hits = searchResponse.getHits();
            for (SearchHit hit : searchHits = hits.getHits()) {
                Map sourceAsMap = hit.getSourceAsMap();
                JSONObject json = new JSONObject(sourceAsMap);
                SubpackagetotalVO vo = (SubpackagetotalVO)((Object)JSONObject.toJavaObject((JSON)json, SubpackagetotalVO.class));
                TreeSet<String> set = new TreeSet<String>();
                set.add(vo.getSnapShotVersion());
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
                Date createTime = vo.getCreateTime();
                String dataDate = format.format(createTime);
                if (!dataDate.equals(snapShotTime)) {
                    list = null;
                    continue;
                }
                list.addAll(set);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("ES\u67e5\u8be2\u5931\u8d25" + e);
        }
        return list;
    }

    @Override
    public IPage<SubpackagetotalVO> selectEsList(QueryParam param, String contract, String projectId) {
        ArrayList<SubpackagetotalVO> vo = new ArrayList<SubpackagetotalVO>();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"contract", (Object)contract);
        queryWrapper.eq((Object)"project_id", (Object)projectId);
        queryWrapper.eq((Object)"dr", (Object)0);
        List records = this.subpackageService.list((Wrapper)queryWrapper);
        for (SubpackageEntity entity : records) {
            QueryWrapper queryWrapper1 = new QueryWrapper();
            queryWrapper1.eq((Object)"dr", (Object)0);
            queryWrapper1.eq((Object)"mid", (Object)entity.getId());
            List records1 = this.subpackagedetailService.list((Wrapper)queryWrapper1);
            for (SubpackagedetailEntity entity1 : records1) {
                SubpackagetotalVO subpackagetotalVO = new SubpackagetotalVO();
                subpackagetotalVO.setId(IdWorker.getId());
                subpackagetotalVO.setSubtitleCode(entity1.getSubtitleCode());
                subpackagetotalVO.setSubtitleName(entity1.getSubtitleName());
                subpackagetotalVO.setSubtitleFeature(entity1.getSubtitleFeature());
                subpackagetotalVO.setArtificialTotal(entity1.getArtificialTotal());
                subpackagetotalVO.setMaterialsTotal(entity1.getMaterialsTotal());
                subpackagetotalVO.setMechanicalTotal(entity1.getMechanicalTotal());
                subpackagetotalVO.setEnterpriseManageTotal(entity1.getEnterpriseManageTotal());
                subpackagetotalVO.setProfitsTotal(entity1.getProfitsTotal());
                subpackagetotalVO.setFeesTotal(entity1.getFeesTotal());
                subpackagetotalVO.setTaxTotal(entity1.getTaxTotal());
                subpackagetotalVO.setComprehensiveTotal(entity1.getComprehensiveTotal());
                subpackagetotalVO.setExcludingTaxTotal(entity1.getExcludingTaxTotal());
                subpackagetotalVO.setIncludingTaxTotal(entity1.getIncludingTaxTotal());
                subpackagetotalVO.setTid(String.valueOf(entity1.getTid()));
                subpackagetotalVO.setTpid(entity1.getTpid());
                if (subpackagetotalVO.getChildren() != null && subpackagetotalVO.getChildren().size() == 0) {
                    subpackagetotalVO.setChildren(null);
                }
                vo.add(subpackagetotalVO);
            }
        }
        List<SubpackagetotalVO> treeData = SubpackagetotalServiceImpl.createTreeData(vo);
        Page pages = new Page();
        pages.setCurrent((long)param.getPageIndex());
        pages.setSize((long)param.getPageSize());
        pages.setTotal((long)treeData.size());
        pages.setRecords(treeData);
        return pages;
    }

    public static List<SubpackagetotalVO> createTreeData(List<SubpackagetotalVO> list) {
        ArrayList<SubpackagetotalVO> resp = new ArrayList<SubpackagetotalVO>();
        ArrayList<String> rootItems = new ArrayList<String>();
        HashMap<String, SubpackagetotalVO> listMap = new HashMap<String, SubpackagetotalVO>();
        for (SubpackagetotalVO item : list) {
            listMap.put(item.getTid().toString(), item);
        }
        for (int i = 0; i < list.size(); ++i) {
            SubpackagetotalVO item;
            item = list.get(i);
            String parentId = item.getTpid() != null ? item.getTpid().toString() : "";
            SubpackagetotalVO parent = (SubpackagetotalVO)((Object)listMap.get(parentId));
            if (parent != null) {
                List<SubpackagetotalVO> child = parent.getChildren();
                if (child != null) {
                    child.add(item);
                    continue;
                }
                ArrayList<SubpackagetotalVO> children = new ArrayList<SubpackagetotalVO>();
                children.add(item);
                parent.setChildren(children);
                continue;
            }
            rootItems.add(item.getTid());
        }
        for (String rootId : rootItems) {
            resp.add((SubpackagetotalVO)((Object)listMap.get(rootId)));
        }
        return resp;
    }

    private Long setPid(String pcode, Map<String, SubpackagedetailVO> map) {
        if (map.get(pcode) != null) {
            return Long.valueOf(map.get(pcode).getTid());
        }
        if (pcode.length() == 2) {
            return null;
        }
        if (pcode.length() == 4) {
            String ppcode = pcode.substring(0, 2);
            return this.setPid(ppcode, map);
        }
        if (pcode.length() == 6) {
            String ppcode = pcode.substring(0, 4);
            return this.setPid(ppcode, map);
        }
        if (pcode.length() > 6) {
            String ppcode = pcode.substring(0, 6);
            return this.setPid(ppcode, map);
        }
        return null;
    }

    public String getLastMonth() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(2, calendar.get(2) - 1);
        date = calendar.getTime();
        String accDate = format.format(date);
        return accDate;
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }
}

