/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bedget.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.bedget.bean.DesignestimateEntity;
import com.ejianc.business.bedget.bean.EstimatesummaryEntity;
import com.ejianc.business.bedget.service.IDesignestimateService;
import com.ejianc.business.bedget.service.IDesignestimatedetailService;
import com.ejianc.business.bedget.service.IEstimatesummaryService;
import com.ejianc.business.bedget.vo.EstimatesummaryVO;
import com.ejianc.business.bedget.vo.EstimatesummarydetailVO;
import com.ejianc.business.record.service.IRecordestimatesummaryService;
import com.ejianc.business.record.vo.RecordestimatesummaryVO;
import com.ejianc.business.utils.DateUtils;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"estimatesummary"})
public class EstimatesummaryController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "budgetmanage-budgetestimatesummary";
    @Autowired
    private IEstimatesummaryService service;
    @Autowired
    private IDesignestimateService designestimateService;
    @Autowired
    private IDesignestimatedetailService designestimatedetailService;
    @Autowired
    private IRecordestimatesummaryService recordestimatesummaryService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<EstimatesummaryVO> saveOrUpdate(@RequestBody EstimatesummaryVO saveorUpdateVO) {
        List pro;
        EstimatesummaryEntity entity = (EstimatesummaryEntity)((Object)BeanMapper.map((Object)((Object)saveorUpdateVO), EstimatesummaryEntity.class));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"project_id", (Object)entity.getProjectId());
        queryWrapper.eq((Object)"dr", (Object)"0");
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() != 0L) {
            queryWrapper.ne((Object)"id", (Object)saveorUpdateVO.getId());
        }
        if ((pro = this.service.list((Wrapper)queryWrapper)).size() > 0) {
            throw new BusinessException("\u8be5\u9879\u76ee\u5df2\u7ecf\u521b\u5efa\u4e00\u4e2a\u8bbe\u8ba1\u6982\u7b97\u6c47\u603b\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u521b\u5efa!");
        }
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setChangeState("1");
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        EstimatesummaryVO vo = (EstimatesummaryVO)((Object)BeanMapper.map((Object)((Object)entity), EstimatesummaryVO.class));
        List<EstimatesummarydetailVO> estimatesummarydetailVOList = vo.getEstimatesummarydetailEntities();
        vo.setEstimatesummarydetailEntities(this.handleChildren(estimatesummarydetailVOList));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<EstimatesummaryVO> queryDetail(Long id) {
        EstimatesummaryEntity entity = (EstimatesummaryEntity)((Object)this.service.selectById(id));
        EstimatesummaryVO vo = (EstimatesummaryVO)((Object)BeanMapper.map((Object)((Object)entity), EstimatesummaryVO.class));
        List<EstimatesummarydetailVO> estimatesummarydetailVOList = vo.getEstimatesummarydetailEntities();
        vo.setEstimatesummarydetailEntities(this.handleChildren(estimatesummarydetailVOList));
        if (!"1".equals(vo.getChangeState())) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"dr", (Object)0);
            queryWrapper.eq((Object)"budgetestimatesummary_id", (Object)vo.getId());
            List records = this.recordestimatesummaryService.list((Wrapper)queryWrapper);
            if (records != null && records.size() > 0) {
                vo.setRecordestimatesummaryVOList(BeanMapper.mapList((Iterable)records, RecordestimatesummaryVO.class));
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<EstimatesummaryVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<EstimatesummaryVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("bill_code");
        fuzzyFields.add("project_name");
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), EstimatesummaryVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("bill_code");
        fuzzyFields.add("project_name");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        List estimatesummaryVOList = BeanMapper.mapList((Iterable)list, EstimatesummaryVO.class);
        for (int i = 0; i < estimatesummaryVOList.size(); ++i) {
            EstimatesummaryVO estimatesummaryVO = (EstimatesummaryVO)((Object)estimatesummaryVOList.get(i));
            estimatesummaryVO.setSort(String.valueOf(i + 1));
            if (estimatesummaryVO.getCreateTime() != null) {
                estimatesummaryVO.setCreateTimeShow(DateUtils.dateSimple2(estimatesummaryVO.getCreateTime()));
            }
            String billStateStr = estimatesummaryVO.getBillState().toString();
            String changeState = estimatesummaryVO.getChangeState();
            if (billStateStr != null) {
                if ("0".equals(billStateStr)) {
                    billStateStr = "\u81ea\u7531\u6001";
                } else if ("1".equals(billStateStr)) {
                    billStateStr = "\u5df2\u63d0\u4ea4";
                } else if ("2".equals(billStateStr) || "5".equals(billStateStr)) {
                    billStateStr = "\u5ba1\u6279\u4e2d";
                } else if ("3".equals(billStateStr)) {
                    billStateStr = "\u5ba1\u6279\u901a\u8fc7";
                } else if ("4".equals(billStateStr)) {
                    billStateStr = "\u9a73\u56de";
                }
                estimatesummaryVO.setBillStateStr(billStateStr);
            }
            if (changeState == null) continue;
            if ("1".equals(changeState)) {
                changeState = "\u672a\u53d8\u66f4";
            } else if ("2".equals(changeState)) {
                changeState = "\u53d8\u66f4\u4e2d";
            } else if ("3".equals(changeState)) {
                changeState = "\u5df2\u53d8\u66f4";
            }
            estimatesummaryVO.setChangeState(changeState);
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", estimatesummaryVOList);
        ExcelExport.getInstance().export("Estimatesummary-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refEstimatesummaryData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<EstimatesummaryVO>> refEstimatesummaryData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), EstimatesummaryVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryDetailList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<EstimatesummarydetailVO>> queryDetailList(Long id, Long projectId) {
        List entityList;
        ArrayList<EstimatesummarydetailVO> voList = new ArrayList<EstimatesummarydetailVO>();
        QueryWrapper queryWrapperProject = new QueryWrapper();
        queryWrapperProject.eq((Object)"project_id", (Object)projectId);
        queryWrapperProject.eq((Object)"dr", (Object)0);
        if (id != null && id != 0L) {
            queryWrapperProject.ne((Object)"id", (Object)id);
        }
        if ((entityList = this.service.list((Wrapper)queryWrapperProject)) != null && entityList.size() > 0) {
            throw new BusinessException("\u8be5\u9879\u76ee\u5df2\u7ecf\u521b\u5efa\u4e00\u4e2a\u8bbe\u8ba1\u6982\u7b97\u6c47\u603b\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u521b\u5efa");
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"project_id", (Object)projectId);
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.in((Object)"bill_state", new Object[]{1, 3});
        DesignestimateEntity entity = (DesignestimateEntity)((Object)this.designestimateService.getOne((Wrapper)queryWrapper));
        if (entity == null) {
            throw new BusinessException("\u60a8\u9009\u62e9\u7684\u9879\u76ee\u6ca1\u6709\u8bbe\u8ba1\u6982\u7b97,\u8bf7\u9009\u62e9\u522b\u7684\u9879\u76ee");
        }
        return CommonResponse.success(this.handleChildren(voList));
    }

    private List<EstimatesummarydetailVO> handleChildren(List<EstimatesummarydetailVO> voList) {
        Collections.sort(voList, new Comparator<EstimatesummarydetailVO>(){

            @Override
            public int compare(EstimatesummarydetailVO o1, EstimatesummarydetailVO o2) {
                return o1.getInventoryCode().compareTo(o2.getInventoryCode());
            }
        });
        voList = EstimatesummaryController.createTreeData(voList);
        return voList;
    }

    public static List<EstimatesummarydetailVO> createTreeData(List<EstimatesummarydetailVO> list) {
        ArrayList<EstimatesummarydetailVO> resp = new ArrayList<EstimatesummarydetailVO>();
        ArrayList<String> rootItems = new ArrayList<String>();
        HashMap<String, EstimatesummarydetailVO> listMap = new HashMap<String, EstimatesummarydetailVO>();
        for (EstimatesummarydetailVO item : list) {
            listMap.put(item.getTid().toString(), item);
        }
        for (int i = 0; i < list.size(); ++i) {
            EstimatesummarydetailVO item;
            item = list.get(i);
            String parentId = item.getTpid() != null ? item.getTpid().toString() : "";
            EstimatesummarydetailVO parent = (EstimatesummarydetailVO)((Object)listMap.get(parentId));
            if (parent != null) {
                List<EstimatesummarydetailVO> child = parent.getChildren();
                if (child != null) {
                    child.add(item);
                    continue;
                }
                ArrayList<EstimatesummarydetailVO> children = new ArrayList<EstimatesummarydetailVO>();
                children.add(item);
                parent.setChildren(children);
                continue;
            }
            rootItems.add(item.getTid());
        }
        for (String rootId : rootItems) {
            resp.add((EstimatesummarydetailVO)((Object)listMap.get(rootId)));
        }
        return resp;
    }
}

