/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bedget.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bedget.bean.SubpackageEntity;
import com.ejianc.business.bedget.service.ISubpackageService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="subpackage")
public class SubpackageBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private ISubpackageService subpackageService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"id", (Object)billId);
        SubpackageEntity subpackageEntity = (SubpackageEntity)((Object)this.subpackageService.getOne((Wrapper)wrapper));
        Long projectId = subpackageEntity.getProjectId();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.eq((Object)"project_id", (Object)projectId);
        queryWrapper.eq((Object)"bill_state", (Object)0);
        List entityList = this.subpackageService.list((Wrapper)queryWrapper);
        if (CollectionUtil.isNotEmpty((Collection)entityList)) {
            throw new BusinessException("\u8be5\u9879\u76ee\u4e0b\u5df2\u5b58\u5728\u81ea\u7531\u6001\u7684\u5355\u636e\uff0c\u4e0d\u80fd\u64a4\u56de");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse resp = this.billTypeApi.checkQuote(billTypeCode, billId);
        if (!resp.isSuccess()) {
            this.logger.info("\u5206\u5305\u65bd\u5de5\u56fe\u9884\u7b97\u5355\u636e\u3010billId-{}\u3011,\u3010billTypeCode-{}\u3011\u6267\u884c\u64a4\u56de\u64cd\u4f5c\u6821\u9a8c\u7ed3\u675f\uff0c\u672a\u901a\u8fc7\u6821\u9a8c\uff0c\u539f\u56e0\uff1a{}", new Object[]{billId, billTypeCode, resp.getMsg()});
            return CommonResponse.error((String)resp.getMsg());
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"id", (Object)billId);
        SubpackageEntity subpackageEntity = (SubpackageEntity)((Object)this.subpackageService.getOne((Wrapper)wrapper));
        Long projectId = subpackageEntity.getProjectId();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.eq((Object)"project_id", (Object)projectId);
        queryWrapper.eq((Object)"bill_state", (Object)0);
        List entityList = this.subpackageService.list((Wrapper)queryWrapper);
        if (CollectionUtil.isNotEmpty((Collection)entityList)) {
            throw new BusinessException("\u8be5\u9879\u76ee\u4e0b\u5df2\u5b58\u5728\u81ea\u7531\u6001\u7684\u5355\u636e\uff0c\u4e0d\u80fd\u64a4\u56de");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

