/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bedget.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.bedget.bean.QuotadesignEntity;
import com.ejianc.business.bedget.bean.QuotadesigndetailEntity;
import com.ejianc.business.bedget.bean.QuotasummaryEntity;
import com.ejianc.business.bedget.service.IQuotadesignService;
import com.ejianc.business.bedget.service.IQuotadesigndetailService;
import com.ejianc.business.bedget.service.IQuotasummaryService;
import com.ejianc.business.bedget.vo.QuotasummaryVO;
import com.ejianc.business.bedget.vo.QuotasummarydetailVO;
import com.ejianc.business.record.service.IRecordquotasummaryService;
import com.ejianc.business.record.vo.RecordquotasummaryVO;
import com.ejianc.business.utils.DateUtils;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"quotasummary"})
public class QuotasummaryController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private SessionManager sessionManager;
    private static final String BILL_CODE = "budgetmanage-quotasummary";
    @Autowired
    private IQuotasummaryService service;
    @Autowired
    private IQuotadesignService quotadesignService;
    @Autowired
    private IQuotadesigndetailService quotadesigndetailService;
    @Autowired
    private IRecordquotasummaryService recordquotasummaryService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<QuotasummaryVO> saveOrUpdate(@RequestBody QuotasummaryVO saveorUpdateVO) {
        List pro;
        QuotasummaryEntity entity = (QuotasummaryEntity)((Object)BeanMapper.map((Object)((Object)saveorUpdateVO), QuotasummaryEntity.class));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"project_id", (Object)entity.getProjectId());
        queryWrapper.eq((Object)"dr", (Object)"0");
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() != 0L) {
            queryWrapper.ne((Object)"id", (Object)saveorUpdateVO.getId());
        }
        if ((pro = this.service.list((Wrapper)queryWrapper)).size() > 0) {
            throw new BusinessException("\u8be5\u9879\u76ee\u5df2\u7ecf\u521b\u5efa\u4e00\u4e2a\u9650\u989d\u8bbe\u8ba1\u6c47\u603b\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u521b\u5efa!");
        }
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setChangeState("1");
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        QuotasummaryVO vo = (QuotasummaryVO)((Object)BeanMapper.map((Object)((Object)entity), QuotasummaryVO.class));
        List<QuotasummarydetailVO> quotadesigndetailVO = vo.getQuotasummarydetailEntities();
        List<QuotasummarydetailVO> resQuotadesigndetailVO = QuotasummaryController.createTreeData(quotadesigndetailVO);
        vo.setQuotasummarydetailEntities(resQuotadesigndetailVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<QuotasummaryVO> queryDetail(Long id) {
        QuotasummaryEntity entity = (QuotasummaryEntity)((Object)this.service.selectById(id));
        QuotasummaryVO vo = (QuotasummaryVO)((Object)BeanMapper.map((Object)((Object)entity), QuotasummaryVO.class));
        List<QuotasummarydetailVO> quotadesigndetailVO = vo.getQuotasummarydetailEntities();
        List<QuotasummarydetailVO> resQuotadesigndetailVO = QuotasummaryController.createTreeData(quotadesigndetailVO);
        vo.setQuotasummarydetailEntities(resQuotadesigndetailVO);
        if (!"1".equals(vo.getChangeState())) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"dr", (Object)0);
            queryWrapper.eq((Object)"quotasummary_id", (Object)vo.getId());
            List records = this.recordquotasummaryService.list((Wrapper)queryWrapper);
            if (records != null && records.size() > 0) {
                vo.setRecordquotasummaryList(BeanMapper.mapList((Iterable)records, RecordquotasummaryVO.class));
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    public static List<QuotasummarydetailVO> createTreeData(List<QuotasummarydetailVO> list) {
        ArrayList<QuotasummarydetailVO> resp = new ArrayList<QuotasummarydetailVO>();
        ArrayList<String> rootItems = new ArrayList<String>();
        HashMap<String, QuotasummarydetailVO> listMap = new HashMap<String, QuotasummarydetailVO>();
        for (QuotasummarydetailVO item : list) {
            listMap.put(item.getTid().toString(), item);
        }
        for (int i = 0; i < list.size(); ++i) {
            QuotasummarydetailVO item;
            item = list.get(i);
            String parentId = item.getTpid() != null ? item.getTpid().toString() : "";
            QuotasummarydetailVO parent = (QuotasummarydetailVO)((Object)listMap.get(parentId));
            if (parent != null) {
                List<QuotasummarydetailVO> child = parent.getChildren();
                if (child != null) {
                    child.add(item);
                    continue;
                }
                ArrayList<QuotasummarydetailVO> children = new ArrayList<QuotasummarydetailVO>();
                children.add(item);
                parent.setChildren(children);
                continue;
            }
            rootItems.add(item.getTid());
        }
        for (String rootId : rootItems) {
            resp.add((QuotasummarydetailVO)((Object)listMap.get(rootId)));
        }
        return resp;
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<QuotasummaryVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<QuotasummaryVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("bill_code");
        fuzzyFields.add("project_name");
        fuzzyFields.add("operator_name");
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), QuotasummaryVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("bill_code");
        fuzzyFields.add("project_name");
        fuzzyFields.add("operator_name");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        List QuotasummaryVOList = BeanMapper.mapList((Iterable)list, QuotasummaryVO.class);
        for (int i = 0; i < QuotasummaryVOList.size(); ++i) {
            QuotasummaryVO quotasummaryVO = (QuotasummaryVO)((Object)QuotasummaryVOList.get(i));
            quotasummaryVO.setSort(String.valueOf(i + 1));
            if (quotasummaryVO.getCreateTime() != null) {
                quotasummaryVO.setCreateTimeShow(DateUtils.dateSimple2(quotasummaryVO.getCreateTime()));
            }
            String billStateStr = quotasummaryVO.getBillState().toString();
            String changeState = quotasummaryVO.getChangeState();
            if (billStateStr != null) {
                if ("0".equals(billStateStr)) {
                    billStateStr = "\u81ea\u7531\u6001";
                } else if ("1".equals(billStateStr)) {
                    billStateStr = "\u5df2\u63d0\u4ea4";
                } else if ("2".equals(billStateStr) || "5".equals(billStateStr)) {
                    billStateStr = "\u5ba1\u6279\u4e2d";
                } else if ("3".equals(billStateStr)) {
                    billStateStr = "\u5ba1\u6279\u901a\u8fc7";
                } else if ("4".equals(billStateStr)) {
                    billStateStr = "\u9a73\u56de";
                }
                quotasummaryVO.setBillStateStr(billStateStr);
            }
            if (changeState == null) continue;
            if ("1".equals(changeState)) {
                changeState = "\u672a\u53d8\u66f4";
            } else if ("2".equals(changeState)) {
                changeState = "\u53d8\u66f4\u4e2d";
            } else if ("3".equals(changeState)) {
                changeState = "\u5df2\u53d8\u66f4";
            }
            quotasummaryVO.setChangeState(changeState);
        }
        beans.put("records", QuotasummaryVOList);
        ExcelExport.getInstance().export("Quotasummary-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refQuotasummaryData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<QuotasummaryVO>> refQuotasummaryData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), QuotasummaryVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryDetailList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<QuotasummarydetailVO>> queryDetailList(Long id, Long projectId) {
        List entityList;
        QueryWrapper queryWrapperProject = new QueryWrapper();
        queryWrapperProject.eq((Object)"project_id", (Object)projectId);
        queryWrapperProject.eq((Object)"dr", (Object)0);
        if (id != null && id != 0L) {
            queryWrapperProject.ne((Object)"id", (Object)id);
        }
        if ((entityList = this.service.list((Wrapper)queryWrapperProject)) != null && entityList.size() > 0) {
            throw new BusinessException("\u8be5\u9879\u76ee\u5df2\u7ecf\u521b\u5efa\u4e00\u4e2a\u9650\u989d\u8bbe\u8ba1\u6c47\u603b\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u521b\u5efa\uff01");
        }
        ArrayList<QuotasummarydetailVO> vo = new ArrayList<QuotasummarydetailVO>();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"project_id", (Object)projectId);
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.in((Object)"bill_state", new Object[]{1, 3});
        QuotadesignEntity entity = (QuotadesignEntity)((Object)this.quotadesignService.getOne((Wrapper)queryWrapper));
        if (entity == null) {
            throw new BusinessException("\u60a8\u9009\u62e9\u7684\u9879\u76ee\u6ca1\u6709\u9650\u989d\u8bbe\u8ba1,\u8bf7\u9009\u62e9\u522b\u7684\u9879\u76ee");
        }
        QueryWrapper queryWrapper1 = new QueryWrapper();
        queryWrapper1.eq((Object)"mid", (Object)entity.getId());
        queryWrapper1.eq((Object)"dr", (Object)0);
        queryWrapper1.eq((Object)"tpid", (Object)"");
        List list = this.quotadesigndetailService.list((Wrapper)queryWrapper1);
        if (list == null) {
            throw new BusinessException("\u60a8\u9009\u62e9\u7684\u9879\u76ee\u6ca1\u6709\u9650\u989d\u8bbe\u8ba1\u6e05\u5355,\u8bf7\u9009\u62e9\u522b\u7684\u9879\u76ee");
        }
        BigDecimal zero = new BigDecimal("0.00");
        for (QuotadesigndetailEntity quotadesigndetailEntity : list) {
            QuotasummarydetailVO quotasummarydetailVO = new QuotasummarydetailVO();
            quotasummarydetailVO.setId(IdWorker.getId());
            quotasummarydetailVO.setSort(String.valueOf(quotadesigndetailEntity.getSonItemCode()));
            quotasummarydetailVO.setUnitProjectName(quotadesigndetailEntity.getSonItemName());
            quotasummarydetailVO.setLaborCost(quotadesigndetailEntity.getShutLabor());
            quotasummarydetailVO.setMaterialCost(quotadesigndetailEntity.getShutMaterial());
            quotasummarydetailVO.setMechanicalCost(quotadesigndetailEntity.getShutMechanical());
            quotasummarydetailVO.setManagementCost(quotadesigndetailEntity.getShutManagement());
            quotasummarydetailVO.setProfit(quotadesigndetailEntity.getShutProfit());
            quotasummarydetailVO.setPartialItemTotal(quotadesigndetailEntity.getShutPrice());
            quotasummarydetailVO.setFees(quotadesigndetailEntity.getClubInsurance() == null ? zero : quotadesigndetailEntity.getClubInsurance().add(quotadesigndetailEntity.getHousing() == null ? zero : quotadesigndetailEntity.getHousing()).add(quotadesigndetailEntity.getReserved1() == null ? zero : quotadesigndetailEntity.getReserved1()).add(quotadesigndetailEntity.getReserved2() == null ? zero : quotadesigndetailEntity.getReserved2()).add(quotadesigndetailEntity.getReserved3() == null ? zero : quotadesigndetailEntity.getReserved3()));
            quotasummarydetailVO.setTax(quotadesigndetailEntity.getTax());
            quotasummarydetailVO.setProjectCost(quotadesigndetailEntity.getShutPrice() == null ? zero : quotadesigndetailEntity.getShutPrice().add(quotadesigndetailEntity.getTax() == null ? zero : quotadesigndetailEntity.getTax()).add(quotasummarydetailVO.getFees() == null ? zero : quotasummarydetailVO.getFees()));
            quotasummarydetailVO.setTid(quotadesigndetailEntity.getTid());
            quotasummarydetailVO.setTpid(quotadesigndetailEntity.getTpid());
            quotasummarydetailVO.setRowState("add");
            QueryWrapper queryWrapper2 = new QueryWrapper();
            queryWrapper2.eq((Object)"mid", (Object)entity.getId());
            queryWrapper2.eq((Object)"dr", (Object)0);
            queryWrapper2.eq((Object)"tpid", (Object)quotadesigndetailEntity.getTid());
            List list1 = this.quotadesigndetailService.list((Wrapper)queryWrapper2);
            if (list1 != null) {
                ArrayList<QuotasummarydetailVO> quotasummarydetailVOS = new ArrayList<QuotasummarydetailVO>();
                for (QuotadesigndetailEntity quotadesigndetailEntity1 : list1) {
                    QuotasummarydetailVO quotasummarydetailVO1 = new QuotasummarydetailVO();
                    quotasummarydetailVO1.setId(IdWorker.getId());
                    quotasummarydetailVO1.setSort(quotadesigndetailEntity1.getSonItemCode());
                    quotasummarydetailVO1.setUnitProjectName(quotadesigndetailEntity1.getSonItemName());
                    quotasummarydetailVO1.setLaborCost(quotadesigndetailEntity1.getShutLabor());
                    quotasummarydetailVO1.setMaterialCost(quotadesigndetailEntity1.getShutMaterial());
                    quotasummarydetailVO1.setMechanicalCost(quotadesigndetailEntity1.getShutMechanical());
                    quotasummarydetailVO1.setManagementCost(quotadesigndetailEntity1.getShutManagement());
                    quotasummarydetailVO1.setProfit(quotadesigndetailEntity1.getShutProfit());
                    quotasummarydetailVO1.setPartialItemTotal(quotadesigndetailEntity1.getShutPrice());
                    quotasummarydetailVO1.setFees(quotadesigndetailEntity1.getClubInsurance() == null ? zero : quotadesigndetailEntity1.getClubInsurance().add(quotadesigndetailEntity1.getHousing() == null ? zero : quotadesigndetailEntity1.getHousing()).add(quotadesigndetailEntity1.getReserved1() == null ? zero : quotadesigndetailEntity1.getReserved1()).add(quotadesigndetailEntity1.getReserved2() == null ? zero : quotadesigndetailEntity1.getReserved2()).add(quotadesigndetailEntity1.getReserved3() == null ? zero : quotadesigndetailEntity1.getReserved3()));
                    quotasummarydetailVO1.setTax(quotadesigndetailEntity1.getTax());
                    quotasummarydetailVO1.setProjectCost(quotadesigndetailEntity1.getShutPrice() == null ? zero : quotadesigndetailEntity1.getShutPrice().add(quotadesigndetailEntity1.getTax() == null ? zero : quotadesigndetailEntity1.getTax()).add(quotasummarydetailVO1.getFees() == null ? zero : quotasummarydetailVO1.getFees()));
                    quotasummarydetailVO1.setTid(quotadesigndetailEntity1.getTid());
                    quotasummarydetailVO1.setTpid(quotadesigndetailEntity1.getTpid());
                    quotasummarydetailVO1.setRowState("add");
                    quotasummarydetailVOS.add(quotasummarydetailVO1);
                    quotasummarydetailVO.setChildren(quotasummarydetailVOS);
                }
            }
            vo.add(quotasummarydetailVO);
        }
        return CommonResponse.success(vo);
    }
}

