/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bedget.excel;

import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bedget.service.IContrastanalysisdetailService;
import com.ejianc.business.bedget.service.IContrastanalysisdetailsService;
import com.ejianc.business.bedget.vo.ContrastanalysisVO;
import com.ejianc.business.bedget.vo.ContrastanalysisdetailVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.util.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"contrastanalysisExport"})
public class ExeclContrastanalysisController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IContrastanalysisdetailService ContrastanalysisdetailService;
    @Autowired
    private IContrastanalysisdetailsService contrastanalysisdetailsService;

    @RequestMapping(value={"/downloadContrastanalysis"})
    @ResponseBody
    public void downloadContrastanalysis(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"contrastanalysisdetail-import.xlsx", (String)"\u65bd\u5de5\u56fe\u9884\u7b97\u6e05\u5355\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImportContrastanalysis"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportContrastanalysis(HttpServletRequest request, HttpServletResponse response, String detailVos) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<ContrastanalysisdetailVO> successList = new ArrayList<ContrastanalysisdetailVO>();
        ArrayList<ContrastanalysisdetailVO> errorList = new ArrayList<ContrastanalysisdetailVO>();
        HashMap<String, ContrastanalysisdetailVO> map = new HashMap<String, ContrastanalysisdetailVO>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            int i;
            List<ContrastanalysisdetailVO> grabVos = JSONArray.parseArray((String)detailVos, ContrastanalysisdetailVO.class);
            ArrayList<ContrastanalysisdetailVO> concatList = new ArrayList<ContrastanalysisdetailVO>();
            if (grabVos != null && grabVos.size() > 0) {
                for (int i2 = 0; i2 < grabVos.size(); ++i2) {
                    ContrastanalysisdetailVO contrastanalysisdetailVO = grabVos.get(i2);
                    concatList.add(contrastanalysisdetailVO);
                }
            }
            grabVos = this.handleList(grabVos, concatList);
            HashMap<String, ContrastanalysisdetailVO> grabMap = new HashMap<String, ContrastanalysisdetailVO>();
            for (i = 0; i < grabVos.size(); ++i) {
                ContrastanalysisdetailVO grabVo = grabVos.get(i);
                String grapSort = grabVo.getSort();
                String grapCode = grabVo.getCode();
                String grapName = grabVo.getName();
                String grapKey = grapSort + grapCode + grapName;
                grabMap.put(grapKey, grabVo);
            }
            for (i = 2; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                StringBuilder errorsMsgBuilder = new StringBuilder();
                int proIndex = i - 2;
                String sort = (String)datas.get(0);
                String code = (String)datas.get(1);
                String name = (String)datas.get(2);
                String biddingStage = (String)datas.get(3);
                String quataDesignTotal = (String)datas.get(4);
                String designBugetEstimate = (String)datas.get(5);
                String constructionBugetEstimate = (String)datas.get(6);
                String tenderListTotal = (String)datas.get(7);
                String tenderListPrice = (String)datas.get(8);
                String quotaDesignBudgetTotal = (String)datas.get(9);
                String quotaDesignBudgetPrice = (String)datas.get(10);
                String designBugetEstimateTotal = (String)datas.get(11);
                String designBugetEstimatePrice = (String)datas.get(12);
                String constructionBugetEstimateTotal = (String)datas.get(13);
                String constructionBugetEstimatePrice = (String)datas.get(14);
                String memo = (String)datas.get(15);
                ContrastanalysisdetailVO contrastanalysisdetailVO = new ContrastanalysisdetailVO();
                contrastanalysisdetailVO.setId(IdWorker.getId());
                contrastanalysisdetailVO.setSort(sort);
                contrastanalysisdetailVO.setTid(String.valueOf(IdWorker.getId()));
                contrastanalysisdetailVO.setCode(code);
                contrastanalysisdetailVO.setName(StringUtils.isNotBlank((CharSequence)name) ? name : null);
                contrastanalysisdetailVO.setMemo(StringUtils.isNotBlank((CharSequence)memo) ? memo : null);
                if (biddingStage == null || TextUtils.isEmpty((CharSequence)biddingStage)) {
                    contrastanalysisdetailVO.setErrorMsg("\u6295\u6807\u9636\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorsMsgBuilder.append("\u6295\u6807\u9636\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (tenderListTotal == null || TextUtils.isEmpty((CharSequence)tenderListTotal)) {
                    contrastanalysisdetailVO.setErrorMsg("\u6295\u6807\u6e05\u5355\u5408\u4ef7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorsMsgBuilder.append("\u6295\u6807\u6e05\u5355\u5408\u4ef7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (code != null) {
                    String subCode;
                    contrastanalysisdetailVO.setInnercode(code);
                    if ("01".equals(code) && name != null && name.contains("\u88c5\u9970")) {
                        contrastanalysisdetailVO.setInnercode("a1");
                    }
                    if (code.length() >= 4 && ("0111".equals(subCode = code.substring(0, 4)) || "0112".equals(subCode) || "0113".equals(subCode) || "0114".equals(subCode) || "0115".equals(subCode))) {
                        contrastanalysisdetailVO.setInnercode("a1" + code.substring(2, code.length()));
                    }
                    if (code == null || code.length() != 2 && code.length() != 4 && code.length() != 6 && code.length() < 9) {
                        contrastanalysisdetailVO.setErrorMsg("\u6e05\u5355\u7f16\u7801\u4e0d\u7b26\u5408\u89c4\u5b9a\u683c\u5f0f");
                        errorsMsgBuilder.append("\u6e05\u5355\u7f16\u7801\u4e0d\u7b26\u5408\u89c4\u5b9a\u683c\u5f0f\uff01");
                    }
                    contrastanalysisdetailVO.setCode(code);
                    ContrastanalysisdetailVO mapVO = (ContrastanalysisdetailVO)((Object)map.get(contrastanalysisdetailVO.getInnercode()));
                    if (mapVO == null) {
                        map.put(contrastanalysisdetailVO.getInnercode(), contrastanalysisdetailVO);
                    } else {
                        contrastanalysisdetailVO.setErrorMsg("\u6e05\u5355\u7f16\u7801\u5df2\u5b58\u5728\uff01");
                        errorsMsgBuilder.append("\u6e05\u5355\u7f16\u7801\u5df2\u5b58\u5728\uff01");
                    }
                    contrastanalysisdetailVO.setCode(code);
                    String innercode = contrastanalysisdetailVO.getInnercode();
                    Long pid = null;
                    if (innercode.length() != 2) {
                        String pcode;
                        if (innercode.length() == 4) {
                            pcode = innercode.substring(0, 2);
                            pid = this.setPid(pcode, map);
                        } else if (innercode.length() == 6) {
                            pcode = innercode.substring(0, 4);
                            pid = this.setPid(pcode, map);
                        } else if (innercode.length() > 6) {
                            pcode = innercode.substring(0, 6);
                            pid = this.setPid(pcode, map);
                        }
                    }
                    if (pid != null) {
                        contrastanalysisdetailVO.setTpid(pid.toString());
                    } else {
                        contrastanalysisdetailVO.setTpid("");
                    }
                }
                if (!TextUtils.isEmpty((CharSequence)biddingStage) && !NumberUtil.isNumber((String)biddingStage)) {
                    contrastanalysisdetailVO.setErrorMsg("\u6295\u6807\u9636\u6bb5\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    errorsMsgBuilder.append("\u6295\u6807\u9636\u6bb5\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                } else {
                    contrastanalysisdetailVO.setBiddingStage(StringUtils.isNotBlank((CharSequence)biddingStage) ? new BigDecimal(biddingStage) : null);
                }
                if (!TextUtils.isEmpty((CharSequence)tenderListTotal) && !NumberUtil.isNumber((String)tenderListTotal)) {
                    contrastanalysisdetailVO.setErrorMsg("\u6295\u6807\u6e05\u5355\u5408\u4ef7\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    errorsMsgBuilder.append("\u6295\u6807\u6e05\u5355\u5408\u4ef7\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                } else {
                    contrastanalysisdetailVO.setTenderListTotal(StringUtils.isNotBlank((CharSequence)tenderListTotal) ? new BigDecimal(tenderListTotal) : null);
                }
                if (!TextUtils.isEmpty((CharSequence)tenderListPrice) && !NumberUtil.isNumber((String)tenderListPrice)) {
                    contrastanalysisdetailVO.setErrorMsg("\u6295\u6807\u6e05\u5355\u5355\u4f4d\u9020\u4ef7\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    errorsMsgBuilder.append("\u6295\u6807\u6e05\u5355\u5355\u4f4d\u9020\u4ef7\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                } else {
                    contrastanalysisdetailVO.setTenderListPrice(StringUtils.isNotBlank((CharSequence)tenderListPrice) ? new BigDecimal(tenderListPrice) : null);
                }
                String currentKey = sort + code + name;
                if (proIndex < grabVos.size()) {
                    if (grabMap.get(currentKey) == null) {
                        contrastanalysisdetailVO.setErrorMsg("\u5e8f\u53f7\u3001\u6e05\u5355\u7f16\u7801\u3001\u5de5\u7a0b\u540d\u79f0\u6216\u8d39\u7528\u540d\u79f0\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\uff01");
                        errorsMsgBuilder.append("\u5e8f\u53f7\u3001\u6e05\u5355\u7f16\u7801\u3001\u5de5\u7a0b\u540d\u79f0\u6216\u8d39\u7528\u540d\u79f0\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\uff01");
                    } else {
                        ContrastanalysisdetailVO grabVo = (ContrastanalysisdetailVO)((Object)grabMap.get(currentKey));
                        BigDecimal grabQuataDesignTotal = grabVo.getQuataDesignTotal();
                        BigDecimal grabDesignBugetEstimate = grabVo.getDesignBugetEstimate();
                        BigDecimal grabConstructionBugetEstimate = grabVo.getConstructionBugetEstimate();
                        BigDecimal grabQuotaDesignBudgetTotal = grabVo.getQuotaDesignBudgetTotal();
                        BigDecimal grabQuotaDesignBudgetPrice = grabVo.getQuotaDesignBudgetPrice();
                        BigDecimal grabDesignBugetEstimateTotal = grabVo.getDesignBugetEstimateTotal();
                        BigDecimal grabDesignBugetEstimatePrice = grabVo.getDesignBugetEstimatePrice();
                        BigDecimal grabConstructionBugetEstimateTotal = grabVo.getConstructionBugetEstimateTotal();
                        BigDecimal grabConstructionBugetEstimatePrice = grabVo.getConstructionBugetEstimatePrice();
                        contrastanalysisdetailVO.setQuataDesignTotal(grabQuataDesignTotal);
                        contrastanalysisdetailVO.setDesignBugetEstimate(grabDesignBugetEstimate);
                        contrastanalysisdetailVO.setConstructionBugetEstimate(grabConstructionBugetEstimate);
                        contrastanalysisdetailVO.setQuotaDesignBudgetTotal(grabQuotaDesignBudgetTotal);
                        contrastanalysisdetailVO.setQuotaDesignBudgetPrice(grabQuotaDesignBudgetPrice);
                        contrastanalysisdetailVO.setDesignBugetEstimateTotal(grabDesignBugetEstimateTotal);
                        contrastanalysisdetailVO.setDesignBugetEstimatePrice(grabDesignBugetEstimatePrice);
                        contrastanalysisdetailVO.setDesignBugetEstimateTotal(grabDesignBugetEstimateTotal);
                        contrastanalysisdetailVO.setConstructionBugetEstimateTotal(grabConstructionBugetEstimateTotal);
                        contrastanalysisdetailVO.setConstructionBugetEstimatePrice(grabConstructionBugetEstimatePrice);
                    }
                } else {
                    contrastanalysisdetailVO.setErrorMsg("\u4e0d\u5141\u8bb8\u65b0\u589e\u884c\uff01");
                    errorsMsgBuilder.append("\u4e0d\u5141\u8bb8\u65b0\u589e\u884c\uff01");
                }
                if (errorsMsgBuilder.length() > 0) {
                    errorList.add(contrastanalysisdetailVO);
                    continue;
                }
                successList.add(contrastanalysisdetailVO);
            }
        }
        List<ContrastanalysisdetailVO> resList = ExeclContrastanalysisController.createTreeData(successList);
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", resList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        ContrastanalysisVO resVo = new ContrastanalysisVO();
        json.put("total", (Object)this.getTotalAmount(resList, resVo));
        return CommonResponse.success((Object)json);
    }

    @RequestMapping(value={"/excelExportContrastanalysisFromDatabase"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportContrastanalysisFromDatabase(@RequestBody ContrastanalysisVO ContrastanalysisVO2, HttpServletResponse response) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"mid", (Object)ContrastanalysisVO2.getId());
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.orderByAsc((Object)"sort");
        List list = this.ContrastanalysisdetailService.list((Wrapper)queryWrapper);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("contrastanalysisdetail-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/excelExportContrastanalysisFromPage"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportContrastanalysisFromPage(@RequestBody List<ContrastanalysisdetailVO> list, HttpServletResponse response) {
        ArrayList<ContrastanalysisdetailVO> concatList = new ArrayList<ContrastanalysisdetailVO>();
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                ContrastanalysisdetailVO contrastanalysisdetailVO = list.get(i);
                concatList.add(contrastanalysisdetailVO);
            }
        }
        List<ContrastanalysisdetailVO> allList = this.handleList(list, concatList);
        HashMap<String, List<ContrastanalysisdetailVO>> beans = new HashMap<String, List<ContrastanalysisdetailVO>>();
        beans.put("records", allList);
        ExcelExport.getInstance().export("contrastanalysisdetail-export.xlsx", beans, response);
    }

    private List<ContrastanalysisdetailVO> handleList(List<ContrastanalysisdetailVO> list, List<ContrastanalysisdetailVO> concatList) {
        if (list == null || list.size() == 0) {
            return concatList;
        }
        for (int i = 0; i < list.size(); ++i) {
            ContrastanalysisdetailVO contrastanalysisdetailVO = list.get(i);
            List<ContrastanalysisdetailVO> children = contrastanalysisdetailVO.getChildren();
            if (children == null || children.size() <= 0) continue;
            concatList.addAll(children);
            this.handleList(children, concatList);
        }
        Collections.sort(concatList, new Comparator<ContrastanalysisdetailVO>(){

            @Override
            public int compare(ContrastanalysisdetailVO o1, ContrastanalysisdetailVO o2) {
                return o1.getSort().compareTo(o2.getSort());
            }
        });
        return concatList;
    }

    private Long setPid(String pcode, Map<String, ContrastanalysisdetailVO> map) {
        if (map.get(pcode) != null) {
            return Long.valueOf(map.get(pcode).getTid());
        }
        if (pcode.length() == 2) {
            return null;
        }
        if (pcode.length() == 4) {
            String ppcode = pcode.substring(0, 2);
            return this.setPid(ppcode, map);
        }
        if (pcode.length() == 6) {
            String ppcode = pcode.substring(0, 4);
            return this.setPid(ppcode, map);
        }
        if (pcode.length() > 6) {
            String ppcode = pcode.substring(0, 6);
            return this.setPid(ppcode, map);
        }
        return null;
    }

    public static List<ContrastanalysisdetailVO> createTreeData(List<ContrastanalysisdetailVO> list) {
        ArrayList<ContrastanalysisdetailVO> resp = new ArrayList<ContrastanalysisdetailVO>();
        ArrayList<String> rootItems = new ArrayList<String>();
        HashMap<String, ContrastanalysisdetailVO> listMap = new HashMap<String, ContrastanalysisdetailVO>();
        for (ContrastanalysisdetailVO item : list) {
            listMap.put(item.getTid().toString(), item);
        }
        for (int i = 0; i < list.size(); ++i) {
            ContrastanalysisdetailVO item;
            item = list.get(i);
            String parentId = item.getTpid() != null ? item.getTpid().toString() : "";
            ContrastanalysisdetailVO parent = (ContrastanalysisdetailVO)((Object)listMap.get(parentId));
            if (parent != null) {
                List<ContrastanalysisdetailVO> child = parent.getChildren();
                if (child != null) {
                    child.add(item);
                    continue;
                }
                ArrayList<ContrastanalysisdetailVO> children = new ArrayList<ContrastanalysisdetailVO>();
                children.add(item);
                parent.setChildren(children);
                continue;
            }
            rootItems.add(item.getTid());
        }
        for (String rootId : rootItems) {
            resp.add((ContrastanalysisdetailVO)((Object)listMap.get(rootId)));
        }
        return resp;
    }

    private ContrastanalysisVO getTotalAmount(List<ContrastanalysisdetailVO> vos, ContrastanalysisVO resVo) {
        BigDecimal tenderTotal = new BigDecimal(0);
        BigDecimal quotaTotal = new BigDecimal(0);
        BigDecimal budgetEstimateTotal = new BigDecimal(0);
        BigDecimal constructionTotal = new BigDecimal(0);
        for (ContrastanalysisdetailVO vo : vos) {
            if (vo.getTenderListTotal() != null) {
                tenderTotal = tenderTotal.add(vo.getTenderListTotal());
            }
            if (vo.getQuotaDesignBudgetTotal() != null) {
                quotaTotal = quotaTotal.add(vo.getQuotaDesignBudgetTotal());
            }
            if (vo.getDesignBugetEstimateTotal() != null) {
                budgetEstimateTotal = budgetEstimateTotal.add(vo.getDesignBugetEstimateTotal());
            }
            if (vo.getConstructionBugetEstimateTotal() == null) continue;
            constructionTotal = constructionTotal.add(vo.getConstructionBugetEstimateTotal());
        }
        resVo.setTenderTotal(tenderTotal);
        resVo.setQuotaTotal(quotaTotal);
        resVo.setBudgetEstimateTotal(budgetEstimateTotal);
        resVo.setConstructionTotal(constructionTotal);
        return resVo;
    }
}

