package com.ejianc.business.bedget.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
/**
 * 施工图预算书
 *
 * @author generator
 *
 */
 @TableName("ejc_budgetmanage_draw")
public class DrawEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_code")
    private String orgCode; // 组织编码
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 所属组织
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 所属组织编码
    @TableField(value="parent_org_name")
    private String parentOrgName; // 所属组织名称
    @TableField(value="project_id")
    private Long projectId; // 项目
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="contract_id")
    private Long contractId; // 合同
    @TableField(value="contract_code")
    private String contractCode; // 合同编码
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="budget_name")
    private String budgetName; // 预算书名称
    @TableField(value="tax_rate")
    private BigDecimal taxRate; // 税率
    @TableField(value="budget_mny")
    private BigDecimal budgetMny; // 金额
    @TableField(value="before_budget_mny")
    private BigDecimal beforeBudgetMny; // 变更前金额
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="dept_id")
    private Long deptId; // 经办部门
    @TableField(value="dept_name")
    private String deptName; // 经办部门名称
    @TableField(value="sub_mny")
    private BigDecimal subMny; // 分部分项金额
    @TableField(value="before_sub_mny")
    private BigDecimal beforeSubMny; // 变更前分部分项金额
    @TableField(value="price_measure_mny")
    private BigDecimal priceMeasureMny; // 单价措施项金额
    @TableField(value="before_price_measure_mny")
    private BigDecimal beforePriceMeasureMny; // 变更前单价措施项金额
    @TableField(value="total_measure_mny")
    private BigDecimal totalMeasureMny; // 总价措施项金额
    @TableField(value="before_total_measure_mny")
    private BigDecimal beforeTotalMeasureMny; // 变更前总价措施项金额
    @TableField(value="other_mny")
    private BigDecimal otherMny; // 其它项金额
    @TableField(value="before_other_mny")
    private BigDecimal beforeOtherMny; // 变更前其它项金额
    @TableField(value="estimate_mny")
    private BigDecimal estimateMny; // 暂估金额
    @TableField(value="before_estimate_mny")
    private BigDecimal beforeEstimateMny; // 变更前暂估金额
    @TableField(value="fee_mny")
    private BigDecimal feeMny; // 规费金额
    @TableField(value="before_fee_mny")
    private BigDecimal beforeFeeMny; // 变更前规费金额
    @TableField(value="taxes_mny")
    private BigDecimal taxesMny; // 税金金额
    @TableField(value="before_taxes_mny")
    private BigDecimal beforeTaxesMny; // 变更前税金金额
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="latest_flag")
    private Boolean latestFlag; // 是否最新版本
    @TableField(value="enable_state")
    private Boolean enableState; // 是否生效
    @TableField(value="draw_version")
    private Integer drawVersion; // 施工图预算版本号
    @TableField(value="last_draw_id")
    private Long lastDrawId; // 上一版本主键
    @TableField(value="change_id")
    private Long changeId; // 变更单主键
    @TableField(value="change_state")
    private Integer changeState; // 变更状态(0-未变更1-变更中2-已变更)
    @TableField(value="before_draw_version")
    private Integer beforeDrawVersion; // 历史版本号
    @TableField(value="memo")
    private String memo; // 编制说明
    @TableField(value="change_reason")
    private String changeReason; // 变更原因
    @TableField(value="enabled_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date enabledTime; // 生效时间

    @TableField(exist=false)
    @SubEntity(serviceName="drawFeeService", pidName = "drawId")
    private List<DrawFeeEntity> feeList = new ArrayList<>(); // 施工图预算书费用项子表
    @TableField(exist=false)
    @SubEntity(serviceName="drawOtherService", pidName = "drawId")
    private List<DrawOtherEntity> otherList = new ArrayList<>(); // 施工图预算书其他项子表
    @TableField(exist=false)
    @SubEntity(serviceName="drawPriceService", pidName = "drawId")
    private List<DrawPriceEntity> priceList = new ArrayList<>(); // 施工图预算书单价措施项子表
    @TableField(exist=false)
    @SubEntity(serviceName="drawTotalService", pidName = "drawId")
    private List<DrawTotalEntity> totalList = new ArrayList<>(); // 施工图预算书总价措施项子表
    @TableField(exist=false)
    @SubEntity(serviceName="drawSubService", pidName = "drawId")
    private List<DrawSubEntity> subList = new ArrayList<>(); // 施工图预算书分部分项子表


    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getBudgetName() {
        return budgetName;
    }

    public void setBudgetName(String budgetName) {
        this.budgetName = budgetName;
    }
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    public BigDecimal getBudgetMny() {
        return budgetMny;
    }

    public void setBudgetMny(BigDecimal budgetMny) {
        this.budgetMny = budgetMny;
    }
    public BigDecimal getBeforeBudgetMny() {
        return beforeBudgetMny;
    }

    public void setBeforeBudgetMny(BigDecimal beforeBudgetMny) {
        this.beforeBudgetMny = beforeBudgetMny;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDeptId() {
        return deptId;
    }

    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }
    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }
    public BigDecimal getSubMny() {
        return subMny;
    }

    public void setSubMny(BigDecimal subMny) {
        this.subMny = subMny;
    }
    public BigDecimal getBeforeSubMny() {
        return beforeSubMny;
    }

    public void setBeforeSubMny(BigDecimal beforeSubMny) {
        this.beforeSubMny = beforeSubMny;
    }
    public BigDecimal getPriceMeasureMny() {
        return priceMeasureMny;
    }

    public void setPriceMeasureMny(BigDecimal priceMeasureMny) {
        this.priceMeasureMny = priceMeasureMny;
    }
    public BigDecimal getBeforePriceMeasureMny() {
        return beforePriceMeasureMny;
    }

    public void setBeforePriceMeasureMny(BigDecimal beforePriceMeasureMny) {
        this.beforePriceMeasureMny = beforePriceMeasureMny;
    }
    public BigDecimal getTotalMeasureMny() {
        return totalMeasureMny;
    }

    public void setTotalMeasureMny(BigDecimal totalMeasureMny) {
        this.totalMeasureMny = totalMeasureMny;
    }
    public BigDecimal getBeforeTotalMeasureMny() {
        return beforeTotalMeasureMny;
    }

    public void setBeforeTotalMeasureMny(BigDecimal beforeTotalMeasureMny) {
        this.beforeTotalMeasureMny = beforeTotalMeasureMny;
    }
    public BigDecimal getOtherMny() {
        return otherMny;
    }

    public void setOtherMny(BigDecimal otherMny) {
        this.otherMny = otherMny;
    }
    public BigDecimal getBeforeOtherMny() {
        return beforeOtherMny;
    }

    public void setBeforeOtherMny(BigDecimal beforeOtherMny) {
        this.beforeOtherMny = beforeOtherMny;
    }
    public BigDecimal getEstimateMny() {
        return estimateMny;
    }

    public void setEstimateMny(BigDecimal estimateMny) {
        this.estimateMny = estimateMny;
    }
    public BigDecimal getBeforeEstimateMny() {
        return beforeEstimateMny;
    }

    public void setBeforeEstimateMny(BigDecimal beforeEstimateMny) {
        this.beforeEstimateMny = beforeEstimateMny;
    }
    public BigDecimal getFeeMny() {
        return feeMny;
    }

    public void setFeeMny(BigDecimal feeMny) {
        this.feeMny = feeMny;
    }
    public BigDecimal getBeforeFeeMny() {
        return beforeFeeMny;
    }

    public void setBeforeFeeMny(BigDecimal beforeFeeMny) {
        this.beforeFeeMny = beforeFeeMny;
    }
    public BigDecimal getTaxesMny() {
        return taxesMny;
    }

    public void setTaxesMny(BigDecimal taxesMny) {
        this.taxesMny = taxesMny;
    }
    public BigDecimal getBeforeTaxesMny() {
        return beforeTaxesMny;
    }

    public void setBeforeTaxesMny(BigDecimal beforeTaxesMny) {
        this.beforeTaxesMny = beforeTaxesMny;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Boolean getLatestFlag() {
        return latestFlag;
    }

    public void setLatestFlag(Boolean latestFlag) {
        this.latestFlag = latestFlag;
    }
    public Boolean getEnableState() {
        return enableState;
    }

    public void setEnableState(Boolean enableState) {
        this.enableState = enableState;
    }
    public Integer getDrawVersion() {
        return drawVersion;
    }

    public void setDrawVersion(Integer drawVersion) {
        this.drawVersion = drawVersion;
    }
    public Long getLastDrawId() {
        return lastDrawId;
    }

    public void setLastDrawId(Long lastDrawId) {
        this.lastDrawId = lastDrawId;
    }
    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    public Integer getChangeState() {
        return changeState;
    }

    public void setChangeState(Integer changeState) {
        this.changeState = changeState;
    }
    public Integer getBeforeDrawVersion() {
        return beforeDrawVersion;
    }

    public void setBeforeDrawVersion(Integer beforeDrawVersion) {
        this.beforeDrawVersion = beforeDrawVersion;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getChangeReason() {
        return changeReason;
    }

    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }

    public Date getEnabledTime() {
        return enabledTime;
    }

    public void setEnabledTime(Date enabledTime) {
        this.enabledTime = enabledTime;
    }

    public List<DrawFeeEntity> getFeeList() {
        return feeList;
    }

    public void setFeeList(List<DrawFeeEntity> feeList) {
        this.feeList = feeList;
    }

    public List<DrawOtherEntity> getOtherList() {
        return otherList;
    }

    public void setOtherList(List<DrawOtherEntity> otherList) {
        this.otherList = otherList;
    }

    public List<DrawPriceEntity> getPriceList() {
        return priceList;
    }

    public void setPriceList(List<DrawPriceEntity> priceList) {
        this.priceList = priceList;
    }

    public List<DrawTotalEntity> getTotalList() {
        return totalList;
    }

    public void setTotalList(List<DrawTotalEntity> totalList) {
        this.totalList = totalList;
    }

    public List<DrawSubEntity> getSubList() {
        return subList;
    }

    public void setSubList(List<DrawSubEntity> subList) {
        this.subList = subList;
    }
}
