package com.ejianc.business.bedget.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 付款登记
 * 
 * @author generator
 * 
 */
 @TableName("ejc_budgetmanage_payment")
public class PaymentEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="org_id")
    private Long orgId; // 所属组织id
    @TableField(value="org_name")
    private String orgName; // 所属组织名称
    @TableField(value="project_department_id")
    private Long projectDepartmentId; // 项目部id
    @TableField(value="register_date")
    private Date registerDate; // 登记日期
    @TableField(value="settlement_amount_total")
    private BigDecimal settlementAmountTotal; // 累计结算金额
    @TableField(value="accounts_payable_total")
    private BigDecimal accountsPayableTotal; // 累计应付金额
    @TableField(value="interim_payment_money")
    private BigDecimal interimPaymentMoney; // 本期进度款金额
    @TableField(value="bill_state")
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    @TableField(value="employee_id")
    private Long employeeId; // 经办人id
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="advance_payment_money")
    private BigDecimal advancePaymentMoney; // 本期预付款金额
    @TableField(value="have_paid_total")
    private BigDecimal havePaidTotal; // 累计已支付金额
    @TableField(value="in_advance_payment_money")
    private BigDecimal inAdvancePaymentMoney; // 其中累计预付款金额
    @TableField(value="payment_ratio_total")
    private BigDecimal paymentRatioTotal; // 累计支付比例
    @TableField(value="debt_money_total")
    private BigDecimal debtMoneyTotal; // 累计欠款金额
    @TableField(exist=false)
    private String billStateName;

    @TableField(exist=false)
    @SubEntity(serviceName="paymentDetailService", pidName = "paymentId")
    private List<PaymentDetailEntity> paymentDetailList = new ArrayList<>(); // 付款登记子表



    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }
    public Date getRegisterDate() {
        return registerDate;
    }

    public void setRegisterDate(Date registerDate) {
        this.registerDate = registerDate;
    }
    public BigDecimal getSettlementAmountTotal() {
        return settlementAmountTotal;
    }

    public void setSettlementAmountTotal(BigDecimal settlementAmountTotal) {
        this.settlementAmountTotal = settlementAmountTotal;
    }
    public BigDecimal getAccountsPayableTotal() {
        return accountsPayableTotal;
    }

    public void setAccountsPayableTotal(BigDecimal accountsPayableTotal) {
        this.accountsPayableTotal = accountsPayableTotal;
    }
    public BigDecimal getInterimPaymentMoney() {
        return interimPaymentMoney;
    }

    public void setInterimPaymentMoney(BigDecimal interimPaymentMoney) {
        this.interimPaymentMoney = interimPaymentMoney;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public BigDecimal getAdvancePaymentMoney() {
        return advancePaymentMoney;
    }

    public void setAdvancePaymentMoney(BigDecimal advancePaymentMoney) {
        this.advancePaymentMoney = advancePaymentMoney;
    }
    public BigDecimal getHavePaidTotal() {
        return havePaidTotal;
    }

    public void setHavePaidTotal(BigDecimal havePaidTotal) {
        this.havePaidTotal = havePaidTotal;
    }
    public BigDecimal getInAdvancePaymentMoney() {
        return inAdvancePaymentMoney;
    }

    public void setInAdvancePaymentMoney(BigDecimal inAdvancePaymentMoney) {
        this.inAdvancePaymentMoney = inAdvancePaymentMoney;
    }
    public BigDecimal getPaymentRatioTotal() {
        return paymentRatioTotal;
    }

    public void setPaymentRatioTotal(BigDecimal paymentRatioTotal) {
        this.paymentRatioTotal = paymentRatioTotal;
    }
    public BigDecimal getDebtMoneyTotal() {
        return debtMoneyTotal;
    }

    public void setDebtMoneyTotal(BigDecimal debtMoneyTotal) {
        this.debtMoneyTotal = debtMoneyTotal;
    }

    public List<PaymentDetailEntity> getPaymentDetailList() {
        return paymentDetailList;
    }

    public void setPaymentDetailList(List<PaymentDetailEntity> paymentDetailList) {
        this.paymentDetailList = paymentDetailList;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }
}
