package com.ejianc.business.bedget.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.bedget.bean.ConsdrawbudgetEntity;
import com.ejianc.business.bedget.bean.ConsdrawbudgetdetailEntity;
import com.ejianc.business.bedget.service.IConsdrawbudgetService;
import com.ejianc.business.bedget.service.IConsdrawbudgetdetailService;
import com.ejianc.business.bedget.vo.ConsdrawbudgetVO;
import com.ejianc.business.bedget.vo.ConsdrawbudgetdetailVO;
import com.ejianc.business.bedget.vo.SubpackagedetailVO;
import com.ejianc.business.record.bean.RecordconsdrawbudgetEntity;
import com.ejianc.business.record.service.IRecordconsdrawbudgetService;
import com.ejianc.business.record.vo.RecordconsdrawbudgetVO;
import com.ejianc.business.utils.BigDecimalUtils;
import com.ejianc.business.utils.DateUtils;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 施工图预算
 *
 * @author generator
 */
@Controller
@RequestMapping("consdrawbudget")
public class ConsdrawbudgetController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private SessionManager sessionManager;

    private static final String BILL_CODE = "budgetmanager-consdrawbudget";//此处需要根据实际修改

    @Autowired
    private IConsdrawbudgetService service;
    @Autowired
    private IConsdrawbudgetdetailService consdrawbudgetdetailService;
    @Autowired
    private IRecordconsdrawbudgetService recordconsdrawbudgetService;
    @Autowired
    private SubpackageController subpackageController;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ConsdrawbudgetVO> saveOrUpdate(@RequestBody ConsdrawbudgetVO saveorUpdateVO) {
        ConsdrawbudgetEntity entity = BeanMapper.map(saveorUpdateVO, ConsdrawbudgetEntity.class);
        QueryWrapper<ConsdrawbudgetEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("project_id", entity.getProjectId());
        queryWrapper.eq("dr", "0");
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() != 0) {
            queryWrapper.ne("id", saveorUpdateVO.getId());
        }
        List<ConsdrawbudgetEntity> pro = service.list(queryWrapper);
        if (pro.size() > 0) {
            throw new BusinessException("该项目已经创建一个施工图预算，不允许重复创建!");
        }

        //单据编码唯一性校验
        entity = checkBillCodeUniq(entity);

        entity.setChangeState("1");//未变更
        //计算表头合计字段
        BigDecimal total = BigDecimalUtils.ofNullable(entity.getFeesTotal())
                .add(BigDecimalUtils.ofNullable(entity.getTaxTotal()))
                .add(BigDecimalUtils.ofNullable(entity.getProvisionalEstimateTotal()));
        entity.setTotal(total);
        service.saveOrUpdate(entity, false);
        ConsdrawbudgetVO vo = BeanMapper.map(entity, ConsdrawbudgetVO.class);

        //构建树形结构
        List<ConsdrawbudgetdetailVO> consdrawbudgetdetailVOList = vo.getConsdrawbudgetdetailEntities();
        vo.setConsdrawbudgetdetailEntities(handleChildren(consdrawbudgetdetailVOList));
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * 单据编码唯一性校验
     *
     * @param entity
     */
    private ConsdrawbudgetEntity checkBillCodeUniq(ConsdrawbudgetEntity entity) {
        if (entity.getBillCode() == null || StringUtils.isEmpty(entity.getBillCode())) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        } else {
            //单据编码唯一性
            QueryWrapper<ConsdrawbudgetEntity> queryWrapperBillCode = new QueryWrapper<>();
            queryWrapperBillCode.eq("bill_code", entity.getBillCode());
            queryWrapperBillCode.eq("dr", "0");
            if(entity.getId() != null && entity.getId() != 0){
                queryWrapperBillCode.ne("id", entity.getId());
            }
            List<ConsdrawbudgetEntity> proBillCode = service.list(queryWrapperBillCode);

            if (proBillCode.size() > 0) {
                throw new BusinessException("单据编码已存在，请重新录入!");
            }
        }
        return entity;
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ConsdrawbudgetVO> queryDetail(Long id) {
        ConsdrawbudgetEntity entity = service.selectById(id);
        ConsdrawbudgetVO vo = BeanMapper.map(entity, ConsdrawbudgetVO.class);

        //构建树
        List<ConsdrawbudgetdetailVO> consdrawbudgetdetailEntities = vo.getConsdrawbudgetdetailEntities();
        vo.setConsdrawbudgetdetailEntities(handleChildren(consdrawbudgetdetailEntities));

        //当前单据变更过则显示变更记录
        if (!"1".equals(vo.getChangeState())) {
            QueryWrapper<RecordconsdrawbudgetEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("dr", 0);
            queryWrapper.eq("consdrawbudget_id", vo.getId());
            List<RecordconsdrawbudgetEntity> records = recordconsdrawbudgetService.list(queryWrapper);
            if (records != null && records.size() > 0) {
                vo.setRecordconsdrawbudgetVOS(BeanMapper.mapList(records, RecordconsdrawbudgetVO.class));
            }
        }

        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @param id
     * @param projectId
     * @Description queryDetail 查询该项目是否已有限额设计指标分析单据
     */
    @RequestMapping(value = "/queryProject", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> queryProject(Long id, Long projectId) {
        QueryWrapper<ConsdrawbudgetEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("dr", 0);
        queryWrapper.eq("project_id", projectId);
        if (id != null && id != 0) {
            queryWrapper.ne("id", id);
        }
        List<ConsdrawbudgetEntity> entityList = service.list(queryWrapper);

        if (entityList != null && entityList.size() > 0) {
            return CommonResponse.success("所选项目已经存在施工图预算，不能继续创建！", "0");
        }

        return CommonResponse.success("查询成功！", "1");
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ConsdrawbudgetVO> vos) {
        service.removeByIds(vos.stream().map(ConsdrawbudgetVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ConsdrawbudgetVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("bill_code");
        fuzzyFields.add("project_name");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<ConsdrawbudgetEntity> page = service.queryPage(param, false);
        IPage<ConsdrawbudgetVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ConsdrawbudgetVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }



    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("bill_code");
        fuzzyFields.add("project_name");
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ConsdrawbudgetEntity> list = service.queryList(param);
        //todo:字段翻译等等
        List<ConsdrawbudgetVO> consdrawbudgetVOList = BeanMapper.mapList(list, ConsdrawbudgetVO.class);
        for (int i = 0; i < consdrawbudgetVOList.size(); i++) {
            ConsdrawbudgetVO consdrawbudgetVO = consdrawbudgetVOList.get(i);
            consdrawbudgetVO.setSort(Long.parseLong(String.valueOf(i + 1)));
            if (consdrawbudgetVO.getCreateTime() != null) {
                consdrawbudgetVO.setCreateTimeShow(DateUtils.dateSimple2(consdrawbudgetVO.getCreateTime()));
            }
            String billStateStr = consdrawbudgetVO.getBillState().toString();
            String changeState = consdrawbudgetVO.getChangeState();
            Integer isOpenControl = consdrawbudgetVO.getIsOpenControl();
            String isOpenControlStr = "";
            if (billStateStr != null) {
                if ("0".equals(billStateStr)) {//自由态
                    billStateStr = "自由态";
                } else if ("1".equals(billStateStr)) {//已提交
                    billStateStr = "已提交";
                } else if ("2".equals(billStateStr) || "5".equals(billStateStr)) {//审批中
                    billStateStr = "审批中";
                } else if ("3".equals(billStateStr)) {//审批通过
                    billStateStr = "审批通过";
                } else if ("4".equals(billStateStr)) {//驳回
                    billStateStr = "驳回";
                }

                consdrawbudgetVO.setBillStateStr(billStateStr);
            }

            if (changeState != null) {
                if ("1".equals(changeState)) {//1:未变更
                    changeState = "未变更";
                } else if ("2".equals(changeState)) {//2:变更中
                    changeState = "变更中";
                } else if ("3".equals(changeState)) {//3:已变更
                    changeState = "已变更";
                }

                consdrawbudgetVO.setChangeState(changeState);
            }

            if (isOpenControl != null) {
                isOpenControlStr = isOpenControl.toString();
                if ("0".equals(isOpenControlStr)) {//0：否
                    isOpenControlStr = "否";
                } else if ("1".equals(isOpenControlStr)) {//1：是
                    isOpenControlStr = "是";
                }
                consdrawbudgetVO.setIsOpenControlStr(isOpenControlStr);
            }
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", consdrawbudgetVOList);
        ExcelExport.getInstance().export("Consdrawbudget-export.xlsx", beans, response);
    }

    /**
     * @param
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refConsdrawbudgetData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ConsdrawbudgetVO>> refConsdrawbudgetData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                         String condition,
                                                                         String searchObject,
                                                                         String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ConsdrawbudgetEntity> page = service.queryPage(param, false);
        IPage<ConsdrawbudgetVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ConsdrawbudgetVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * @param
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refConsdrawbudgetDataDetail", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<SubpackagedetailVO>> refConsdrawbudgetDataDetail(@RequestBody SubpackagedetailVO vo) {
        List<SubpackagedetailVO> recordsVo = new ArrayList<>();
        QueryWrapper<ConsdrawbudgetEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("dr", 0);
        queryWrapper.eq("project_id", vo.getProjectId());
        queryWrapper.in("bill_state", 1, 3);

        ConsdrawbudgetEntity entity = service.getOne(queryWrapper);
        if (entity == null) {
            throw new BusinessException("该项目没有施工图预算,请选择别的项目");
        } else {
            QueryWrapper<ConsdrawbudgetdetailEntity> queryWrapper1 = new QueryWrapper<>();
            queryWrapper1.eq("dr", 0);
            queryWrapper1.eq("mid", entity.getId());
            List<String> idList = vo.getIdList();
            if (idList!=null && idList.size() > 0) {
                queryWrapper1.notIn("tid", idList);
            }
            List<ConsdrawbudgetdetailEntity> records = consdrawbudgetdetailService.list(queryWrapper1);
            for (ConsdrawbudgetdetailEntity entity1 : records) {
                SubpackagedetailVO subpackagedetailVO = new SubpackagedetailVO();
                subpackagedetailVO.setSort(entity1.getSort());
                subpackagedetailVO.setSection(entity1.getSection());
                subpackagedetailVO.setSubtitleCode(entity1.getSubitemCode());
                subpackagedetailVO.setSubtitleName(entity1.getSubitemName());
                subpackagedetailVO.setSubtitleFeature(entity1.getCharacterDescrip());
                subpackagedetailVO.setMeasuringUnit(entity1.getEstimateUnit());
                subpackagedetailVO.setTid(entity1.getTid());
                subpackagedetailVO.setTpid(entity1.getTpid());
                subpackagedetailVO.setId(IdWorker.getId());
                subpackagedetailVO.setConsdrawbudgetId(entity1.getId());
                subpackagedetailVO.setSubpackageBudgetTotal(entity1.getEngineeQuatity());
                recordsVo.add(subpackagedetailVO);
            }
            if (recordsVo.size() > 1) {
                //构建树
                recordsVo = subpackageController.createTreeData(recordsVo);
            }
        }
        return CommonResponse.success("查询参照数据成功！", recordsVo);
    }

    public static List<ConsdrawbudgetdetailVO> createTreeData(List<ConsdrawbudgetdetailVO> list) {
        List<ConsdrawbudgetdetailVO> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();

        //循环list，放入listMap重
        Map<String, ConsdrawbudgetdetailVO> listMap = new HashMap<>();
        for (ConsdrawbudgetdetailVO item : list) {
            listMap.put(item.getTid().toString(), item);
        }

        for (int i = 0; i < list.size(); i++) {
            ConsdrawbudgetdetailVO item = list.get(i);
            String parentId = (item.getTpid() != null) ? item.getTpid().toString() : "";
            ConsdrawbudgetdetailVO parent = listMap.get(parentId);
            if (parent != null) {
                List<ConsdrawbudgetdetailVO> child = (List<ConsdrawbudgetdetailVO>) parent.getChildren();
                if (child != null) {
                    child.add(item);
                } else {
                    List<ConsdrawbudgetdetailVO> children = new ArrayList<ConsdrawbudgetdetailVO>();
                    children.add(item);
                    parent.setChildren(children);
                }
            } else {
                rootItems.add(item.getTid());
            }
        }

        for (String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }

    /**
     * 页面新增后重新构建树
     *
     * @param
     * @return
     */
    @RequestMapping(value = "/refreshData", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> refreshData(@RequestBody List<ConsdrawbudgetdetailVO> list, HttpServletResponse response) {
        JSONObject json = new JSONObject();
        Map<String, ConsdrawbudgetdetailVO> map = new HashMap<>();
        ConsdrawbudgetdetailVO add = list.get(list.size() - 1);
        add.setId(IdWorker.getId());
        add.setTid(String.valueOf(IdWorker.getId()));
        add.setRowState("edit");
        add.setInnercode(add.getSubitemCode() + "_" + add.getSection());//子目编码、区段、确定唯一性
        if ("01".equals(add.getSubitemCode()) && add.getSubitemName().contains("装饰")) {
            add.setInnercode("a1" + "_" + add.getSection());
        }
        //判断是否是装饰工程的子节点编码
        if (add.getSubitemCode().length() >= 4) {
            //0111、0112、0113、0114、0115这五个节点都是装饰工程下的
            String code = add.getSubitemCode().substring(0, 4);
            if ("0111".equals(code) || "0112".equals(code) || "0113".equals(code) || "0114".equals(code) || "0115".equals(code)) {
//	    		若是的话，将内码改为a1xx
                add.setInnercode("a1" + add.getSubitemCode().substring(2, add.getSubitemCode().length()) + "_" + add.getSection());
            }
        }
        for (ConsdrawbudgetdetailVO vo : list) {
            map.put(vo.getInnercode(), vo);
            if (!add.getId().equals(vo.getId()) && add.getInnercode().equals(vo.getInnercode())) {
                throw new BusinessException("子目编码已存在，请重新填写");
            }
        }
        //设置父级id
        for (ConsdrawbudgetdetailVO vo : list) {
            String innercode = vo.getInnercode();
            String[] innercodeSubArr = innercode.split("_");
            String innercodeSub = "";
            String sectionSuf = "";
            if (innercodeSubArr.length > 1) {
                innercodeSub = innercodeSubArr[0];
                sectionSuf = "_" + innercodeSubArr[1];
            }

            Long pid = null;
            if (innercodeSub.length() == 2) {
                //最上级
            } else if (innercodeSub.length() == 4) {
                String pcode = innercodeSub.substring(0, 2) + sectionSuf;
                //有父节点
                pid = this.setPid(pcode, map);

            } else if (innercodeSub.length() == 6) {
                String pcode = innercodeSub.substring(0, 4) + sectionSuf;
                //有父节点
                pid = this.setPid(pcode, map);
            } else if (innercodeSub.length() > 6) {
                String pcode = innercodeSub.substring(0, 6) + sectionSuf;
                //有父节点
                pid = this.setPid(pcode, map);
            }

            if (pid != null) {
                vo.setTpid(pid.toString());
            } else {
                vo.setTpid("");
            }
        }

        //排序、构建树
        list = handleChildren(list);

        //统计父级的合计数值
        getChildrenUnitTotalAmount(list);

        json.put("dataSource", list);

        return CommonResponse.success(json);
    }

    /**
     * 统计父级的合计数值
     * @param vos
     * @return
     */
    private ConsdrawbudgetdetailVO getChildrenUnitTotalAmount(List<ConsdrawbudgetdetailVO> vos){
        ConsdrawbudgetdetailVO detail = new ConsdrawbudgetdetailVO();
        detail.setTotalLaborCost(new BigDecimal(0));//人工费(综合)
        detail.setTotalMaterialCost(new BigDecimal(0));//材料费(综合)
        detail.setTotalMachineryCost(new BigDecimal(0));//机械费(综合)
        detail.setTotalBusinessManagerCost(new BigDecimal(0));//企业管理费(综合)
        detail.setTotalProfit(new BigDecimal(0));//利润(综合)
        detail.setSumTotalPrice(new BigDecimal(0));//合价(元)
        detail.setSocialSecurity(new BigDecimal(0));//社保
        detail.setHousing(new BigDecimal(0));//住房
        detail.setReserved1(new BigDecimal(0));//预留1
        detail.setReserved2(new BigDecimal(0));//预留2
        detail.setReserved3(new BigDecimal(0));//预留3
        detail.setTax(new BigDecimal(0));//税金
        detail.setProvisionalEstimate(new BigDecimal(0));//暂估价

        BigDecimal totalLaborCost = detail.getTotalLaborCost();
        BigDecimal totalMaterialCost = detail.getTotalMaterialCost();
        BigDecimal totalMachineryCost = detail.getTotalMachineryCost();
        BigDecimal totalBusinessManagerCost = detail.getTotalBusinessManagerCost();
        BigDecimal totalProfit = detail.getTotalProfit();
        BigDecimal sumTotalPrice = detail.getSumTotalPrice();
        BigDecimal socialSecurity = detail.getSocialSecurity();
        BigDecimal housing = detail.getHousing();
        BigDecimal reserved1 = detail.getReserved1();
        BigDecimal reserved2 = detail.getReserved2();
        BigDecimal reserved3 = detail.getReserved3();
        BigDecimal tax = detail.getTax();
        BigDecimal provisionalEstimate = detail.getProvisionalEstimate();

        for(ConsdrawbudgetdetailVO vo: vos){
            if(vo.getChildren()!=null&&vo.getChildren().size()>0){
                //有孩子节点----清空工程量和综合单价--金额字段
                vo.setEngineeQuatity(null);// 工程量
                vo.setUnitLaborCost(null);// 人工费
                vo.setUnitMaterialCost(null);
                vo.setUnitMachineryCost(null);
                vo.setUnitBusinessManagerCost(null);
                vo.setUnitProfit(null);
                vo.setComprehensiveUnitPrice(null);

                //获取孩子节点的总计数据
                ConsdrawbudgetdetailVO childrenUnitTotalAmount = this.getChildrenUnitTotalAmount(vo.getChildren());
                vo.setTotalLaborCost(childrenUnitTotalAmount.getTotalLaborCost());
                vo.setTotalMaterialCost(childrenUnitTotalAmount.getTotalMaterialCost());
                vo.setTotalMachineryCost(childrenUnitTotalAmount.getTotalMachineryCost());
                vo.setTotalBusinessManagerCost(childrenUnitTotalAmount.getTotalBusinessManagerCost());
                vo.setTotalProfit(childrenUnitTotalAmount.getTotalProfit());
                vo.setSumTotalPrice(childrenUnitTotalAmount.getSumTotalPrice());
                vo.setSocialSecurity(childrenUnitTotalAmount.getSocialSecurity());
                vo.setHousing(childrenUnitTotalAmount.getHousing());
                vo.setReserved1(childrenUnitTotalAmount.getReserved1());
                vo.setReserved2(childrenUnitTotalAmount.getReserved2());
                vo.setReserved3(childrenUnitTotalAmount.getReserved3());
                vo.setTax(childrenUnitTotalAmount.getTax());
                vo.setProvisionalEstimate(childrenUnitTotalAmount.getProvisionalEstimate());

                totalLaborCost = totalLaborCost.add(childrenUnitTotalAmount.getTotalLaborCost());
                totalMaterialCost = totalMaterialCost.add(childrenUnitTotalAmount.getTotalMaterialCost());
                totalMachineryCost = totalMachineryCost.add(childrenUnitTotalAmount.getTotalMachineryCost());
                totalBusinessManagerCost = totalBusinessManagerCost.add(childrenUnitTotalAmount.getTotalBusinessManagerCost());
                totalProfit = totalProfit.add(childrenUnitTotalAmount.getTotalProfit());
                sumTotalPrice = sumTotalPrice.add(childrenUnitTotalAmount.getSumTotalPrice());
                socialSecurity = socialSecurity.add(childrenUnitTotalAmount.getSocialSecurity());
                housing = housing.add(childrenUnitTotalAmount.getHousing());
                reserved1 = reserved1.add(childrenUnitTotalAmount.getReserved1());
                reserved2 = reserved2.add(childrenUnitTotalAmount.getReserved2());
                reserved3 = reserved3.add(childrenUnitTotalAmount.getReserved3());
                tax = tax.add(childrenUnitTotalAmount.getTax());
                provisionalEstimate = provisionalEstimate.add(childrenUnitTotalAmount.getProvisionalEstimate());
            }else{
                if(vo.getTotalLaborCost()!=null){
                    totalLaborCost = totalLaborCost.add(vo.getTotalLaborCost());
                }

                if(vo.getTotalMaterialCost()!=null){
                    totalMaterialCost = totalMaterialCost.add(vo.getTotalMaterialCost());
                }

                if(vo.getTotalMachineryCost()!=null){
                    totalMachineryCost = totalMachineryCost.add(vo.getTotalMachineryCost());
                }

                if(vo.getTotalBusinessManagerCost()!=null){
                    totalBusinessManagerCost = totalBusinessManagerCost.add(vo.getTotalBusinessManagerCost());
                }

                if(vo.getTotalProfit()!=null){
                    totalProfit = totalProfit.add(vo.getTotalProfit());
                }

                if(vo.getSumTotalPrice()!=null){
                    sumTotalPrice = sumTotalPrice.add(vo.getSumTotalPrice());
                }

                if(vo.getSocialSecurity()!=null){
                    socialSecurity = socialSecurity.add(vo.getSocialSecurity());
                }

                if(vo.getHousing()!=null){
                    housing = housing.add(vo.getHousing());
                }

                if(vo.getReserved1()!=null){
                    reserved1 = reserved1.add(vo.getReserved1());
                }

                if(vo.getReserved2()!=null){
                    reserved2 = reserved2.add(vo.getReserved2());
                }

                if(vo.getReserved3()!=null){
                    reserved3 = reserved3.add(vo.getReserved3());
                }

                if(vo.getTax()!=null){
                    tax = tax.add(vo.getTax());
                }

                if(vo.getProvisionalEstimate()!=null){
                    provisionalEstimate = provisionalEstimate.add(vo.getProvisionalEstimate());
                }
            }

            detail.setTotalLaborCost(totalLaborCost);
            detail.setTotalMaterialCost(totalMaterialCost);
            detail.setTotalMachineryCost(totalMachineryCost);
            detail.setTotalBusinessManagerCost(totalBusinessManagerCost);
            detail.setTotalProfit(totalProfit);
            detail.setSumTotalPrice(sumTotalPrice);
            detail.setSocialSecurity(socialSecurity);
            detail.setHousing(housing);
            detail.setReserved1(reserved1);
            detail.setReserved2(reserved2);
            detail.setReserved3(reserved3);
            detail.setTax(tax);
            detail.setProvisionalEstimate(provisionalEstimate);
        }
        return detail;
    }

    //子目编码规则定死------分别是2位/4位/6位/6为以上
    private Long setPid(String pcode, Map<String, ConsdrawbudgetdetailVO> map) {
        if (map.get(pcode) != null) {
            return Long.valueOf(map.get(pcode).getTid());
        } else {
            //父级没有找到，则继续往上找
            String[] pcodeSubArr = pcode.split("_");
            String pcodeSub = "";
            String sectionSuf = "";//"_" + 区段
            if (pcodeSubArr.length > 1) {
                pcodeSub = pcodeSubArr[0];
                sectionSuf = "_" + pcodeSubArr[1];
            }
            if (pcodeSub.length() == 2) {
                //最上级
                return null;
            } else if (pcodeSub.length() == 4) {
                String ppcode = pcodeSub.substring(0, 2);
                return this.setPid(ppcode + sectionSuf, map);
            } else if (pcodeSub.length() == 6) {
                String ppcode = pcode.substring(0, 4);
                return this.setPid(ppcode + sectionSuf, map);
            } else if (pcodeSub.length() > 6) {
                String ppcode = pcode.substring(0, 6);
                return this.setPid(ppcode + sectionSuf, map);
            } else {
                return null;
            }
        }
    }

    /**
     * 对子表做排序、构建树等处理
     *
     * @param voList
     */
    private List<ConsdrawbudgetdetailVO> handleChildren(List<ConsdrawbudgetdetailVO> voList) {
        //按子目编码排序
        Collections.sort(voList, new Comparator<ConsdrawbudgetdetailVO>() {
            @Override
            public int compare(ConsdrawbudgetdetailVO o1, ConsdrawbudgetdetailVO o2) {
                return (o1.getSubitemCode() + o1.getSection()).compareTo(o2.getSubitemCode() + o2.getSection());
            }
        });

        //构建树
        voList = createTreeData(voList);

        return voList;
    }
}
