package com.ejianc.business.bedget.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.bedget.bean.MaterialanalysisEntity;
import com.ejianc.business.bedget.bean.MaterialanalysisdetailEntity;
import com.ejianc.business.bedget.bean.MaterialrequirementsEntity;
import com.ejianc.business.bedget.bean.MaterialrequirementsdetailEntity;
import com.ejianc.business.bedget.service.IMaterialanalysisService;
import com.ejianc.business.bedget.service.IMaterialrequirementsService;
import com.ejianc.business.bedget.service.IMaterialrequirementsdetailService;
import com.ejianc.business.bedget.vo.MaterialanalysisVO;
import com.ejianc.business.record.bean.RecordmaterialanalysisEntity;
import com.ejianc.business.record.service.IRecordmaterialanalysisService;
import com.ejianc.business.record.vo.RecordmaterialanalysisVO;
import com.ejianc.business.utils.DateUtils;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 施工图预算材料分析
 *
 * @author generator
 */
@Controller
@RequestMapping("materialanalysis")
public class MaterialanalysisController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IMaterialrequirementsService materialrequirementsService;//需求总计划service


    private static final String BILL_CODE = "budgetmanager-materialanalysis";//此处需要根据实际修改

    @Autowired
    private IMaterialanalysisService service;
    @Autowired
    private IMaterialrequirementsdetailService materialrequirementsdetailService;//需求总计划明细service

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<MaterialanalysisVO> saveOrUpdate(@RequestBody MaterialanalysisVO saveorUpdateVO) {
        /**
         * 获取当前单据项目id
         * 查询项目对于物资需求总计划
         */

        MaterialanalysisEntity entity = BeanMapper.map(saveorUpdateVO, MaterialanalysisEntity.class);
        HashMap<String, BigDecimal> fbMap = new HashMap<>();
        HashMap<String, BigDecimal> xqMap = new HashMap<>();
        //获取主表项目
        Long projectId = entity.getProjectId();
        //查找该项目的物资需求总计划
        QueryWrapper<MaterialrequirementsEntity> queryWrapper1 = new QueryWrapper<>();
        queryWrapper1.eq("project_id", projectId);
        queryWrapper1.eq("dr", "0");
        queryWrapper1.in("bill_state", "1", "3");
        List<MaterialrequirementsEntity> materialrequirementsEntityList = materialrequirementsService.list(queryWrapper1);
        if (materialrequirementsEntityList.size() > 0) {
            MaterialrequirementsEntity materialrequirementsEntity = materialrequirementsEntityList.get(0);
            //主表id
            Long mid = materialrequirementsEntity.getId();
            QueryWrapper<MaterialrequirementsdetailEntity> queryWrappers = new QueryWrapper<>();
            queryWrappers.eq("dr", "0");
            queryWrappers.eq("mid", mid);
            List<MaterialrequirementsdetailEntity> materialrequirementsdetailEntityList = materialrequirementsdetailService.list(queryWrappers);
            //物资需求总计划明细
            for (MaterialrequirementsdetailEntity materialrequirementsdetailEntity : materialrequirementsdetailEntityList) {
                String s = materialrequirementsdetailEntity.getBillCode() + materialrequirementsdetailEntity.getName() + materialrequirementsdetailEntity.getSpec() + materialrequirementsdetailEntity.getMeasuringUnit();
                BigDecimal sl = materialrequirementsdetailEntity.getTotal();
                xqMap.put(s, sl);
            }
            List<MaterialanalysisdetailEntity> subpackagematerialanalysisdetailEntitiesList = entity.getMaterialanalysisdetailEntities();
            //遍历子表数据
            for (MaterialanalysisdetailEntity subpackagematerialanalysisdetailEntity : subpackagematerialanalysisdetailEntitiesList) {
                String rowState = subpackagematerialanalysisdetailEntity.getRowState();
                if (!"del".equals(rowState)) {
                    //获取编码，名称 ，规格，单位拼接
                    String s = subpackagematerialanalysisdetailEntity.getMaterialsCode() + subpackagematerialanalysisdetailEntity.getMaterialsName() + subpackagematerialanalysisdetailEntity.getSpec() + subpackagematerialanalysisdetailEntity.getMeasuringUnit();
                    BigDecimal sl = subpackagematerialanalysisdetailEntity.getSubtotal();
                    fbMap.put(s, sl);
                }
            }
            for (String s : fbMap.keySet()) {
                BigDecimal bigDecimal = xqMap.get(s);
                if (bigDecimal==null){
                    throw new BusinessException(s+"需求总计划数量不足，请检查！当前可用数量：0");
                } else {
                    BigDecimal bigDecimal1 = fbMap.get(s);
                    if (bigDecimal.compareTo(bigDecimal1)==-1){
                        throw new BusinessException(s+"需求总计划数量不足，请检查！当前可用数量："+bigDecimal.setScale(2, BigDecimal.ROUND_HALF_UP));
                    }
                }
            }
        }
        QueryWrapper<MaterialanalysisEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("project_id", entity.getProjectId());
        queryWrapper.eq("dr", "0");
        if (entity.getId() != null && entity.getId() != 0) {
            queryWrapper.ne("id", entity.getId());
        }
        List<MaterialanalysisEntity> pro = service.list(queryWrapper);
        if (pro.size() > 0) {
            throw new BusinessException("该项目已经创建一个施工图预算材料分析，不允许重复创建!");
        }
        if (entity.getId() == null || entity.getId() == 0) {
            entity.setChangeState("1");//未变更
        }
        //获取当前entity的单据编号
        String billCode_now = entity.getBillCode();
        //如果当前单据编号为空，则生成单据编号，否则直接写入
        if (billCode_now == null || "".equals(billCode_now)) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        } else {
            //查询当前单据编号是否存在
            QueryWrapper<MaterialanalysisEntity> queryWrapper11 = new QueryWrapper<>();
            queryWrapper11.eq("bill_code", entity.getBillCode());
            queryWrapper11.eq("dr", "0");
            if (entity.getId() != null && entity.getId() != 0) {
                queryWrapper11.ne("id", entity.getId());
            }
            List<MaterialanalysisEntity> subpackagematerialanalysisEntityList = service.list(queryWrapper11);
            if (subpackagematerialanalysisEntityList.size() > 0) {
                throw new BusinessException("当前单据编号已存在，请检查！");
            }
        }
        service.saveOrUpdate(entity, false);
        MaterialanalysisVO vo = BeanMapper.map(entity, MaterialanalysisVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    @Autowired
    private IRecordmaterialanalysisService recordmaterialanalysisService;

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MaterialanalysisVO> queryDetail(Long id) {
        MaterialanalysisEntity entity = service.selectById(id);
        MaterialanalysisVO vo = BeanMapper.map(entity, MaterialanalysisVO.class);
        if (!"1".equals(vo.getChangeState())) {
            QueryWrapper<RecordmaterialanalysisEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("dr", 0);
            queryWrapper.eq("original_id", vo.getId());
            List<RecordmaterialanalysisEntity> records = recordmaterialanalysisService.list(queryWrapper);
            if (records != null && records.size() > 0) {
                vo.setRecordmaterialanalysisVOS(BeanMapper.mapList(records, RecordmaterialanalysisVO.class));
            }
        }
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MaterialanalysisVO> vos) {
        service.removeByIds(vos.stream().map(MaterialanalysisVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<MaterialanalysisVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        /** 租户隔离 */
        //param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        IPage<MaterialanalysisEntity> page = service.queryPage(param, false);
        IPage<MaterialanalysisVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), MaterialanalysisVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }



    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }



    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        List<MaterialanalysisEntity> list = service.queryList(param);
        //todo:字段翻译等等
        List<MaterialanalysisVO> quotadesignVOList = BeanMapper.mapList(list, MaterialanalysisVO.class);
        for (int i = 0; i < quotadesignVOList.size(); i++) {
            MaterialanalysisVO quotadesignVO = quotadesignVOList.get(i);
            quotadesignVO.setSort(String.valueOf(i+1));
            if (quotadesignVO.getCreateTime()!=null){
                quotadesignVO.setCreateTimeShow(DateUtils.dateSimple2(quotadesignVO.getCreateTime()));
            }
            String billStateStr = quotadesignVO.getBillState().toString();
            String changeState = quotadesignVO.getChangeState();
            if (billStateStr != null){
                if("0".equals(billStateStr)){//自由态
                    billStateStr = "自由态";
                }else if("1".equals(billStateStr)){//已提交
                    billStateStr = "已提交";
                }else if("2".equals(billStateStr) || "5".equals(billStateStr)){//审批中
                    billStateStr = "审批中";
                }else if("3".equals(billStateStr)){//审批通过
                    billStateStr = "审批通过";
                }else if("4".equals(billStateStr)){//驳回
                    billStateStr = "驳回";
                }

                quotadesignVO.setBillStateStr(billStateStr);
            }

            if (changeState != null){
                if("1".equals(changeState)){//1:未变更
                    changeState = "未变更";
                }else if("2".equals(changeState)){//2:变更中
                    changeState = "变更中";
                }else if("3".equals(changeState)){//3:已变更
                    changeState = "已变更";
                }

                quotadesignVO.setChangeState(changeState);
            }
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", quotadesignVOList);
        ExcelExport.getInstance().export("Materialanalysis-export.xlsx", beans, response);
    }

    /**
     * @param param
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refMaterialanalysisData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<MaterialanalysisVO>> refMaterialanalysisData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                             String condition,
                                                                             String searchObject,
                                                                             String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        //param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<MaterialanalysisEntity> page = service.queryPage(param, false);
        IPage<MaterialanalysisVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), MaterialanalysisVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * @param id
     * @param projectId
     * @Description queryDetail 查询该项目是否已有物资需求总计划单据
     */
    @RequestMapping(value = "/queryProject", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> queryProject(Long projectId, Long id) {
        QueryWrapper<MaterialrequirementsEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("dr", 0);
        queryWrapper.eq("project_id", projectId);
        queryWrapper.in("bill_state", "1", "3");
        List<MaterialrequirementsEntity> entityList = materialrequirementsService.list(queryWrapper);

        if (entityList == null || entityList.size() == 0) {
            return CommonResponse.success("该项目未创建需求总计划，请选择其他项目!", "0");
        }
        //查询当前项目是否已创建单据
        QueryWrapper<MaterialanalysisEntity> queryWrapper1 = new QueryWrapper<>();
        queryWrapper1.eq("dr", 0);
        queryWrapper1.eq("project_id", projectId);
        if (id != null && id != 0) {
            queryWrapper1.ne("id", id);
        }
        List<MaterialanalysisEntity> entityList1 = service.list(queryWrapper1);
        if (entityList1 != null && entityList1.size() > 0) {
            return CommonResponse.success("该项目已经创建一个施工图预算材料分析，请选择其他项目!", "0");
        }

        return CommonResponse.success("查询成功！", "1");
    }
}
