package com.ejianc.business.bedget.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.bedget.bean.QuotadesignEntity;
import com.ejianc.business.bedget.bean.QuotadesigndetailEntity;
import com.ejianc.business.bedget.bean.QuotasummaryEntity;
import com.ejianc.business.bedget.service.IQuotadesignService;
import com.ejianc.business.bedget.service.IQuotadesigndetailService;
import com.ejianc.business.bedget.service.IQuotasummaryService;
import com.ejianc.business.bedget.vo.QuotasummaryVO;
import com.ejianc.business.bedget.vo.QuotasummarydetailVO;
import com.ejianc.business.record.bean.RecordquotasummaryEntity;
import com.ejianc.business.record.service.IRecordquotasummaryService;
import com.ejianc.business.record.vo.RecordquotasummaryVO;
import com.ejianc.business.utils.DateUtils;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 限额设计汇总
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("quotasummary")
public class QuotasummaryController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private SessionManager sessionManager;

    private static final String BILL_CODE = "budgetmanage-quotasummary";//此处需要根据实际修改

    @Autowired
    private IQuotasummaryService service;
    @Autowired
    private IQuotadesignService quotadesignService;
    @Autowired
    private IQuotadesigndetailService quotadesigndetailService;
    @Autowired
    private IRecordquotasummaryService recordquotasummaryService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<QuotasummaryVO> saveOrUpdate(@RequestBody QuotasummaryVO saveorUpdateVO) {
    	QuotasummaryEntity entity = BeanMapper.map(saveorUpdateVO, QuotasummaryEntity.class);
        QueryWrapper<QuotasummaryEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("project_id", entity.getProjectId());
        queryWrapper.eq("dr", "0");
        if(saveorUpdateVO.getId() != null && saveorUpdateVO.getId() != 0){
            queryWrapper.ne("id", saveorUpdateVO.getId());
        }
        List<QuotasummaryEntity> pro = service.list(queryWrapper);
        if(pro.size() > 0){
            throw new BusinessException("该项目已经创建一个限额设计汇总，不允许重复创建!");
        }

    	if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setChangeState("1");//未变更
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	QuotasummaryVO vo = BeanMapper.map(entity, QuotasummaryVO.class);

        //构建树形结构
        List<QuotasummarydetailVO> quotadesigndetailVO = vo.getQuotasummarydetailEntities();
        List<QuotasummarydetailVO> resQuotadesigndetailVO = createTreeData(quotadesigndetailVO);
        vo.setQuotasummarydetailEntities(resQuotadesigndetailVO);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<QuotasummaryVO> queryDetail(Long id) {
    	QuotasummaryEntity entity = service.selectById(id);
    	QuotasummaryVO vo = BeanMapper.map(entity, QuotasummaryVO.class);

        //构建树形结构
        List<QuotasummarydetailVO> quotadesigndetailVO = vo.getQuotasummarydetailEntities();
        List<QuotasummarydetailVO> resQuotadesigndetailVO = createTreeData(quotadesigndetailVO);
        vo.setQuotasummarydetailEntities(resQuotadesigndetailVO);

        //当前单据变更过则显示变更记录
        if(!"1".equals(vo.getChangeState())){
            QueryWrapper<RecordquotasummaryEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("dr", 0);
            queryWrapper.eq("quotasummary_id", vo.getId());
            List<RecordquotasummaryEntity> records = recordquotasummaryService.list(queryWrapper);
            if(records!=null&&records.size()>0){
                vo.setRecordquotasummaryList(BeanMapper.mapList(records, RecordquotasummaryVO.class));
            }
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    public static List<QuotasummarydetailVO> createTreeData(List<QuotasummarydetailVO> list) {
        List<QuotasummarydetailVO> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();

        //循环list，放入listMap重
        Map<String, QuotasummarydetailVO> listMap = new HashMap<>();
        for(QuotasummarydetailVO item:list) {
            listMap.put(item.getTid().toString(), item);
        }

        for(int i =0; i<list.size(); i++) {
            QuotasummarydetailVO item = list.get(i);
            String parentId = (item.getTpid() != null) ? item.getTpid().toString():"";
            QuotasummarydetailVO parent = listMap.get(parentId);
            if(parent != null) {
                List<QuotasummarydetailVO> child = (List<QuotasummarydetailVO>) parent.getChildren();
                if(child != null) {
                    child.add(item);
                }else{
                    List<QuotasummarydetailVO> children = new ArrayList<>();
                    children.add(item);
                    parent.setChildren(children);
                }
            } else {
                rootItems.add(item.getTid());
            }
        }

        for(String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<QuotasummaryVO> vos) {
        service.removeByIds(vos.stream().map(QuotasummaryVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<QuotasummaryVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("bill_code");
        fuzzyFields.add("project_name");
        fuzzyFields.add("operator_name");
        /** 租户隔离 */
        //param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        IPage<QuotasummaryEntity> page = service.queryPage(param,false);
        IPage<QuotasummaryVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), QuotasummaryVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }



    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }




    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("bill_code");
        fuzzyFields.add("project_name");
        fuzzyFields.add("operator_name");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        List<QuotasummaryEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        //时间转换
        List<QuotasummaryVO> QuotasummaryVOList = BeanMapper.mapList(list, QuotasummaryVO.class);
        for (int i = 0; i < QuotasummaryVOList.size(); i++) {
            QuotasummaryVO quotasummaryVO = QuotasummaryVOList.get(i);
            quotasummaryVO.setSort(String.valueOf(i+1));
            if (quotasummaryVO.getCreateTime()!=null){
                quotasummaryVO.setCreateTimeShow(DateUtils.dateSimple2(quotasummaryVO.getCreateTime()));
            }
            String billStateStr = quotasummaryVO.getBillState().toString();
            String changeState = quotasummaryVO.getChangeState();
            if (billStateStr != null){
                if("0".equals(billStateStr)){//自由态
                    billStateStr = "自由态";
                }else if("1".equals(billStateStr)){//已提交
                    billStateStr = "已提交";
                }else if("2".equals(billStateStr) || "5".equals(billStateStr)){//审批中
                    billStateStr = "审批中";
                }else if("3".equals(billStateStr)){//审批通过
                    billStateStr = "审批通过";
                }else if("4".equals(billStateStr)){//驳回
                    billStateStr = "驳回";
                }

                quotasummaryVO.setBillStateStr(billStateStr);
            }

            if (changeState != null){
                if("1".equals(changeState)){//1:未变更
                    changeState = "未变更";
                }else if("2".equals(changeState)){//2:变更中
                    changeState = "变更中";
                }else if("3".equals(changeState)){//3:已变更
                    changeState = "已变更";
                }

                quotasummaryVO.setChangeState(changeState);
            }
        }
        beans.put("records", QuotasummaryVOList);
        ExcelExport.getInstance().export("Quotasummary-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refQuotasummaryData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<QuotasummaryVO>> refQuotasummaryData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        //param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<QuotasummaryEntity> page = service.queryPage(param,false);
        IPage<QuotasummaryVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), QuotasummaryVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * @Description queryDetail 查询详情
     * @param projectId
     */
    @RequestMapping(value = "/queryDetailList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<QuotasummarydetailVO>> queryDetailList(Long id, Long projectId) {
        //校验项目唯一性
        QueryWrapper<QuotasummaryEntity> queryWrapperProject = new QueryWrapper<>();
        queryWrapperProject.eq("project_id", projectId);
        queryWrapperProject.eq("dr", 0);
        if (id != null && id != 0) {
            queryWrapperProject.ne("id", id);
        }
        List<QuotasummaryEntity> entityList = service.list(queryWrapperProject);
        if (entityList != null && entityList.size() > 0) {
            throw new BusinessException("该项目已经创建一个限额设计汇总，不允许重复创建！");
        }

        List<QuotasummarydetailVO> vo = new ArrayList<>();
        //根据项目id查询限额设计表数据
        QueryWrapper<QuotadesignEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("project_id",projectId);
        queryWrapper.eq("dr", 0);
        queryWrapper.in("bill_state", 1, 3);
        QuotadesignEntity entity = quotadesignService.getOne(queryWrapper);
        if(entity == null){
            throw  new BusinessException("您选择的项目没有限额设计,请选择别的项目");
        }else{
            //根据主表id和tpid为空 查询子表第一层数据
            QueryWrapper<QuotadesigndetailEntity> queryWrapper1 = new QueryWrapper<>();
            queryWrapper1.eq("mid",entity.getId());
            queryWrapper1.eq("dr", 0);
            queryWrapper1.eq("tpid", "");
            List<QuotadesigndetailEntity> list = quotadesigndetailService.list(queryWrapper1);
            if(list == null){
                throw  new BusinessException("您选择的项目没有限额设计清单,请选择别的项目");
            }else{
                BigDecimal zero = new BigDecimal("0.00");
                for(QuotadesigndetailEntity quotadesigndetailEntity : list){
                    //循环将第一层数据的值赋值给清单
                    QuotasummarydetailVO quotasummarydetailVO = new QuotasummarydetailVO();
                    quotasummarydetailVO.setId(IdWorker.getId());
                    quotasummarydetailVO.setSort(String.valueOf(quotadesigndetailEntity.getSonItemCode()));
                    quotasummarydetailVO.setUnitProjectName(quotadesigndetailEntity.getSonItemName());

                    quotasummarydetailVO.setLaborCost(quotadesigndetailEntity.getShutLabor());
                    quotasummarydetailVO.setMaterialCost(quotadesigndetailEntity.getShutMaterial());
                    quotasummarydetailVO.setMechanicalCost(quotadesigndetailEntity.getShutMechanical());
                    quotasummarydetailVO.setManagementCost(quotadesigndetailEntity.getShutManagement());
                    quotasummarydetailVO.setProfit(quotadesigndetailEntity.getShutProfit());
                    quotasummarydetailVO.setPartialItemTotal(quotadesigndetailEntity.getShutPrice());

                    quotasummarydetailVO.setFees(quotadesigndetailEntity.getClubInsurance()==null?zero:quotadesigndetailEntity.getClubInsurance().add(quotadesigndetailEntity.getHousing()==null?zero:quotadesigndetailEntity.getHousing())
                            .add(quotadesigndetailEntity.getReserved1()==null?zero:quotadesigndetailEntity.getReserved1()).add(quotadesigndetailEntity.getReserved2()==null?zero:quotadesigndetailEntity.getReserved2())
                            .add(quotadesigndetailEntity.getReserved3()==null?zero:quotadesigndetailEntity.getReserved3()));

                    quotasummarydetailVO.setTax(quotadesigndetailEntity.getTax());

                    //项目造价
                    quotasummarydetailVO.setProjectCost(quotadesigndetailEntity.getShutPrice()==null?zero:quotadesigndetailEntity.getShutPrice().add(quotadesigndetailEntity.getTax()==null?zero:quotadesigndetailEntity.getTax())
                            .add(quotasummarydetailVO.getFees()==null?zero:quotasummarydetailVO.getFees()));

                    quotasummarydetailVO.setTid(quotadesigndetailEntity.getTid());
                    quotasummarydetailVO.setTpid(quotadesigndetailEntity.getTpid());
                    quotasummarydetailVO.setRowState("add");
                    //根据主表id和第一层数据的父id查询第二层数据
                    QueryWrapper<QuotadesigndetailEntity> queryWrapper2 = new QueryWrapper<>();
                    queryWrapper2.eq("mid",entity.getId());
                    queryWrapper2.eq("dr", 0);
                    queryWrapper2.eq("tpid", quotadesigndetailEntity.getTid());
                    List<QuotadesigndetailEntity> list1 = quotadesigndetailService.list(queryWrapper2);
                    if(list1 != null){
                        List<QuotasummarydetailVO> quotasummarydetailVOS = new ArrayList<>();
                        for(QuotadesigndetailEntity  quotadesigndetailEntity1: list1){
                            QuotasummarydetailVO quotasummarydetailVO1 = new QuotasummarydetailVO();
                            quotasummarydetailVO1.setId(IdWorker.getId());
                            quotasummarydetailVO1.setSort(quotadesigndetailEntity1.getSonItemCode());
                            quotasummarydetailVO1.setUnitProjectName(quotadesigndetailEntity1.getSonItemName());
                            quotasummarydetailVO1.setLaborCost(quotadesigndetailEntity1.getShutLabor());
                            quotasummarydetailVO1.setMaterialCost(quotadesigndetailEntity1.getShutMaterial());
                            quotasummarydetailVO1.setMechanicalCost(quotadesigndetailEntity1.getShutMechanical());
                            quotasummarydetailVO1.setManagementCost(quotadesigndetailEntity1.getShutManagement());
                            quotasummarydetailVO1.setProfit(quotadesigndetailEntity1.getShutProfit());
                            quotasummarydetailVO1.setPartialItemTotal(quotadesigndetailEntity1.getShutPrice());

                            quotasummarydetailVO1.setFees(quotadesigndetailEntity1.getClubInsurance()==null?zero:quotadesigndetailEntity1.getClubInsurance().add(quotadesigndetailEntity1.getHousing()==null?zero:quotadesigndetailEntity1.getHousing())
                                    .add(quotadesigndetailEntity1.getReserved1()==null?zero:quotadesigndetailEntity1.getReserved1()).add(quotadesigndetailEntity1.getReserved2()==null?zero:quotadesigndetailEntity1.getReserved2())
                                    .add(quotadesigndetailEntity1.getReserved3()==null?zero:quotadesigndetailEntity1.getReserved3()));

                            quotasummarydetailVO1.setTax(quotadesigndetailEntity1.getTax());

                            //项目造价
                            quotasummarydetailVO1.setProjectCost(quotadesigndetailEntity1.getShutPrice()==null?zero:quotadesigndetailEntity1.getShutPrice().add(quotadesigndetailEntity1.getTax()==null?zero:quotadesigndetailEntity1.getTax())
                                    .add(quotasummarydetailVO1.getFees()==null?zero:quotasummarydetailVO1.getFees()));

                            quotasummarydetailVO1.setTid(quotadesigndetailEntity1.getTid());
                            quotasummarydetailVO1.setTpid(quotadesigndetailEntity1.getTpid());
                            quotasummarydetailVO1.setRowState("add");
                            quotasummarydetailVOS.add(quotasummarydetailVO1);
                            //将第二层数据添加到第一层数据下
                            quotasummarydetailVO.setChildren(quotasummarydetailVOS);
                        }
                    }
                    vo.add(quotasummarydetailVO);
                }
            }
        }
        return CommonResponse.success(vo);

    }
}
