package com.ejianc.business.bedget.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.bedget.bean.SubpackagetotalEntity;
import com.ejianc.business.bedget.service.ISubpackageService;
import com.ejianc.business.bedget.service.ISubpackagedetailService;
import com.ejianc.business.bedget.service.ISubpackagetotalService;
import com.ejianc.business.bedget.vo.SubpackagetotalVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 分包施工图预算汇总
 *
 * @author generator
 */
@Controller
@RequestMapping("subpackagetotal")
public class SubpackagetotalController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private SessionManager sessionManager;


    private static final String BILL_CODE = "budgetmanager-subpackagetotal";//此处需要根据实际修改

    @Autowired
    private ISubpackagetotalService service;
    @Autowired
    private ISubpackageService subpackageService;
    @Autowired
    private ISubpackagedetailService subpackagedetailService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SubpackagetotalVO> saveOrUpdate(@RequestBody SubpackagetotalVO saveorUpdateVO) {
        SubpackagetotalEntity entity = BeanMapper.map(saveorUpdateVO, SubpackagetotalEntity.class);
        QueryWrapper<SubpackagetotalEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("project_id", entity.getProjectId());
        queryWrapper.eq("dr", "0");
        List<SubpackagetotalEntity> pro = service.list(queryWrapper);
        if (pro.size() > 0) {
            throw new BusinessException("该项目已经创建一个分包施工图预算汇总，不允许重复创建!");
        }
        if (entity.getId() == null || entity.getId() == 0) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                //entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        service.saveOrUpdate(entity, false);
        SubpackagetotalVO vo = BeanMapper.map(entity, SubpackagetotalVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SubpackagetotalVO> queryDetail(Long id) {
        SubpackagetotalEntity entity = service.selectById(id);
        SubpackagetotalVO vo = BeanMapper.map(entity, SubpackagetotalVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SubpackagetotalVO> vos) {
        service.removeByIds(vos.stream().map(SubpackagetotalVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SubpackagetotalVO>> queryList(@RequestBody QueryParam param) {
       // CommonResponse.success("查询列表数据成功！", pageData);
        return null;
    }



    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }




    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        List<SubpackagetotalEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Subpackagetotal-export.xlsx", beans, response);
    }

    /**
     * @param
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refSubpackagetotalData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SubpackagetotalVO>> refSubpackagetotalData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                           String condition,
                                                                           String searchObject,
                                                                           String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        //param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<SubpackagetotalEntity> page = service.queryPage(param, false);
        IPage<SubpackagetotalVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SubpackagetotalVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }


    /**
     * @param
     * @Description 自动任务执行--每月1号00：00：00执行，保存当前数据快照
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/saveSnapshotData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> saveSnapshotData() {
        return service.saveSnapshotData();
    }

    /**
     * @Description saveOrUpdate 手动保存当前的数据到es
     */
    @RequestMapping(value = "/saveESData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> saveESData(String contract,String projectId) {
        if(projectId == null || StringUtils.isBlank(projectId)){
            throw new BusinessException("请选择项目");
        }
        if(contract == null || StringUtils.isBlank(contract)){
            throw new BusinessException("请选择合同");
        }
        SimpleDateFormat format1 = new SimpleDateFormat("YYYY-MM-dd hh:mm:ss");
        String curDate = format1.format(new Date());
        return service.saveESData("劳务分包预算汇总（手动）" + curDate, contract, projectId);
    }

    @RequestMapping(value = "/queryReportList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SubpackagetotalVO>> queryReportList(QueryParam param,String reportItem,
                                                                    String monthQuery,String contract,String projectId) throws ParseException {

        if(projectId == null || StringUtils.isBlank(projectId)){
            throw new BusinessException("请选择项目");
        }
        if(contract == null || StringUtils.isBlank(contract)){
            throw new BusinessException("请选择合同");
        }
        if(monthQuery == null || StringUtils.isBlank(monthQuery)){
            throw new BusinessException("请选择月份");
        }
        if(reportItem == null || StringUtils.isBlank(reportItem)){
            throw new BusinessException("请选择快照版本");
        }
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("subtitleCode");
        fuzzyFields.add("subtitleName");
        fuzzyFields.add("subtitleFeature");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("section");
        /** 租户隔离 */
        //param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        return CommonResponse.success(service.queryEsByPage(param, reportItem,
                 monthQuery, contract, projectId));

    }


    /**
     * @param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/esExcelExport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse esExcelExport(HttpServletResponse response) throws ParseException {
        /** 模糊搜索配置字段示例 */
       /* List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);*/
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        /*param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));*/
        QueryParam param = new QueryParam();
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("subtitleCode");
        fuzzyFields.add("subtitleName");
        fuzzyFields.add("subtitleFeature");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("section");
        IPage<SubpackagetotalVO> page = service.queryEsByPage(param,null,null,null,null);
        //todo:字段翻译等等
        List<SubpackagetotalVO> list = new ArrayList<>();
        for (int i = 0; i < page.getRecords().size(); i++) {
            SubpackagetotalVO vo = page.getRecords().get(i);
            vo.setSort(String.valueOf(i + 1));
            list.add(vo);
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Subpackagetotal-export.xlsx", beans, response);
        return CommonResponse.success();
    }

    /**
     * 查询所有的ES快照版本
     */
    @RequestMapping(value = "/queryEsSnap", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse queryEsSnap(String snapShotTime,String contract,String projectId) {
        List<String> list = service.queryEsSnap(snapShotTime, contract, projectId);
        return CommonResponse.success(list);
    }

    @RequestMapping(value = "/excelExportSubpackagetotalFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportSubpackagetotalFromPage(@RequestBody List<SubpackagetotalVO> list, HttpServletResponse response){
        List<SubpackagetotalVO> concatList = new ArrayList<>();
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); i++) {
                SubpackagetotalVO subpackagedetailVO = list.get(i);
                subpackagedetailVO.setSort(String.valueOf(i + 1));
                concatList.add(subpackagedetailVO);
            }
        }

        //children拍平
        List<SubpackagetotalVO> allList = handleList(list, concatList);
        for (int i = 0; i < allList.size(); i++) {
            allList.get(i).setId(Long.valueOf(i+1));
        }

        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", allList);
        ExcelExport.getInstance().export("Subpackagetotal-export.xlsx", beans, response);
    }

   private List<SubpackagetotalVO> handleList(List<SubpackagetotalVO> list, List<SubpackagetotalVO> concatList) {
        if (list == null || list.size() == 0) {
            return concatList;
        }

        for (int i = 0; i < list.size(); i++) {
            SubpackagetotalVO subpackagedetailVO = list.get(i);
            List<SubpackagetotalVO> children = subpackagedetailVO.getChildren();
            if (children != null && children.size() > 0) {
                concatList.addAll(children);
                handleList(children, concatList);
            }
        }

        return concatList;
    }


    /**
     * @param projectId
     * @Description 查询往期
     */
    @RequestMapping(value = "/pastData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SubpackagetotalVO> pastData(Long projectId, Date deadline) {
        Date deadlineRes = deadline;

        if (deadline == null) {
            deadlineRes = new Date(System.currentTimeMillis());
        }

        return CommonResponse.success("查询往期审批通过的累计数据成功！", getPastTotalData(projectId, deadlineRes));
    }

    @RequestMapping(value = "/selectEsList", method = RequestMethod.GET)
    @ResponseBody
    public IPage<SubpackagetotalVO> selectEsList(QueryParam param,String contract,String projectId) {
        if(contract == null || StringUtils.isBlank(contract)){
            throw new BusinessException("请选择合同");
        }
        if(projectId == null || StringUtils.isBlank(projectId)){
            throw new BusinessException("请选择项目");
        }
        IPage<SubpackagetotalVO> subpackagetotalVOIPage = service.selectEsList(param,contract,projectId);
        return subpackagetotalVOIPage;
    }

    private SubpackagetotalVO getPastTotalData(Long projectId, Date deadlineRes) {
        return new SubpackagetotalVO();
    }


}
