package com.ejianc.business.bedget.controller.api;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bedget.bean.SubpackageEntity;
import com.ejianc.business.bedget.bean.SubpackagedetailEntity;
import com.ejianc.business.bedget.service.ISubpackageService;
import com.ejianc.business.bedget.service.ISubpackagedetailService;
import com.ejianc.foundation.budgetmanage.vo.SubpackageVO;
import com.ejianc.foundation.budgetmanage.vo.SubpackagedetailVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;
import java.util.List;

/**
 * 分包施工图预算
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("api/subpackage")
public class SubpackageApiController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ISubpackageService service;
    @Autowired
    private ISubpackagedetailService detailService;

    /**
     * @Description 根据合同id查询详情
     * @param
     * @Return void
     */
    @RequestMapping(value = "/queryByContractId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SubpackageVO> queryByContractId(@RequestParam(value = "contractId") Long contractId) {
        QueryWrapper<SubpackageEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("contract", contractId);
        queryWrapper.in("bill_state", 1, 3);
        queryWrapper.eq("dr", 0);
        queryWrapper.orderByDesc("create_time");
        List<SubpackageEntity> list = service.list(queryWrapper);
        SubpackageVO result = new SubpackageVO();
        if(list != null && list.size() > 0){
            result = BeanMapper.map(list.get(0), SubpackageVO.class);

            //查询单据子表
            QueryWrapper<SubpackagedetailEntity> queryWrapperDetailList = new QueryWrapper<>();
            queryWrapperDetailList.eq("mid", result.getId());
            queryWrapperDetailList.eq("dr", "0");
            List<SubpackagedetailEntity> detailList = detailService.list(queryWrapperDetailList);

            List<SubpackagedetailVO> resDetailList = BeanMapper.mapList(detailList, SubpackagedetailVO.class);
            result.setSubpackagedetailEntities(resDetailList);
        }
        return CommonResponse.success("查询数据成功！",result);
    }
}
