package com.ejianc.business.bedget.excel;

import com.ejianc.business.bedget.vo.ConsdrawbudgetContrastdetailVO;
import com.ejianc.framework.core.util.ExcelExport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;

/**
 * 施工图预算变更对比导出
 */
@Controller
@RequestMapping("consdrawbudgetcontrastExport")
public class ExeclConsdrawbudgetcontrastController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    /**
     * excel导出页面数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportData", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportData(@RequestBody List<ConsdrawbudgetContrastdetailVO> list, HttpServletResponse response) {
        Map<String, Object> beans = new HashMap<String, Object>();
        List<ConsdrawbudgetContrastdetailVO> records = new ArrayList<>();

        for(ConsdrawbudgetContrastdetailVO vo : list){
            records.add(vo);
            if(vo.getChildren()!=null&&vo.getChildren().size()>0){
                this.splitList(vo.getChildren(),records);
            }
        }

        beans.put("records", records);
        ExcelExport.getInstance().export("consdrawbudgetcontrastdetail-export.xlsx", beans, response);
    }

    /**
     * 导出遍历加上所有子表
     * @param list
     * @param records
     */
    private void splitList(List<ConsdrawbudgetContrastdetailVO> list,List<ConsdrawbudgetContrastdetailVO> records) {
        for(ConsdrawbudgetContrastdetailVO vo : list){
            records.add(vo);
            if(vo.getChildren()!=null&&vo.getChildren().size()>0){
                this.splitList(vo.getChildren(),records);
            }
        }
    }
}
