package com.ejianc.business.bedget.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.ejianc.business.bedget.vo.PaymentDetailVO;
import com.ejianc.business.bedget.vo.PaymentVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.support.idworker.util.IdWorker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.bedget.mapper.PaymentMapper;
import com.ejianc.business.bedget.bean.PaymentEntity;
import com.ejianc.business.bedget.service.IPaymentService;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 付款登记
 * 
 * @author generator
 * 
 */
@Service("paymentService")
public class PaymentServiceImpl extends BaseServiceImpl<PaymentMapper, PaymentEntity> implements IPaymentService{

    @Autowired
    private PaymentMapper paymentMapper;
    @Override
    public PaymentVO queryDetailList(Long projectId) {
        //根据项目查询所有合同信息
        List<PaymentDetailVO> queryOutcontractList = queryOutcontractList(projectId);
        //是否最终结算
        for(PaymentDetailVO paymentDetailVO : queryOutcontractList){
            paymentDetailVO.setId(IdWorker.getId());
            if("劳务分包".equals(paymentDetailVO.getSubcontractType()) || "专业分包".equals(paymentDetailVO.getSubcontractType())){
                paymentDetailVO.setIsComplete(querySettlementBookList(paymentDetailVO.getProjectId(),paymentDetailVO.getContractId()));
                paymentDetailVO.setTaxCurrentTotal(querySubcontractingvolume(paymentDetailVO.getProjectId(),paymentDetailVO.getContractId()));
                paymentDetailVO.setTotalMoneyTax(querySettlementBookListAmount(paymentDetailVO.getProjectId(),paymentDetailVO.getContractId()));
            }else if("物资采购".equals(paymentDetailVO.getSubcontractType()) ){
                paymentDetailVO.setIsComplete(queryPurchaseSettlementList(paymentDetailVO.getProjectId(),paymentDetailVO.getContractId()));
                System.out.println(queryPurchasesettlement(paymentDetailVO.getProjectId(),paymentDetailVO.getContractId())+"==============");
                paymentDetailVO.setTaxCurrentTotal(queryPurchasesettlement(paymentDetailVO.getProjectId(),paymentDetailVO.getContractId()));
                paymentDetailVO.setTotalMoneyTax(queryPurchaseSettlementListAmount(paymentDetailVO.getProjectId(),paymentDetailVO.getContractId()));
            }else if("机械租赁".equals(paymentDetailVO.getSubcontractType()) ){
                paymentDetailVO.setIsComplete(queryMachinerySettlementList(paymentDetailVO.getProjectId(),paymentDetailVO.getContractId()));
                paymentDetailVO.setTaxCurrentTotal(queryMechanicallease(paymentDetailVO.getProjectId(),paymentDetailVO.getContractId()));
                paymentDetailVO.setTotalMoneyTax(queryMachinerySettlementListAmount(paymentDetailVO.getProjectId(),paymentDetailVO.getContractId()));
            }else if("周转材租赁".equals(paymentDetailVO.getSubcontractType()) ){
                paymentDetailVO.setIsComplete(queryLeaseSettLementList(paymentDetailVO.getProjectId(),paymentDetailVO.getContractId()));
                paymentDetailVO.setTaxCurrentTotal(queryRevolvinglease(paymentDetailVO.getProjectId(),paymentDetailVO.getContractId()));
                paymentDetailVO.setTotalMoneyTax(queryLeaseSettLementListAmount(paymentDetailVO.getProjectId(),paymentDetailVO.getContractId()));
            }else if("设计勘察".equals(paymentDetailVO.getSubcontractType()) ){
                paymentDetailVO.setIsComplete(queryDesignSettlementList(paymentDetailVO.getProjectId(),paymentDetailVO.getContractId()));
                paymentDetailVO.setTaxCurrentTotal(queryDesignsubcontractnode(paymentDetailVO.getProjectId(),paymentDetailVO.getContractId()));
                paymentDetailVO.setTotalMoneyTax(queryDesignSettlementListAmount(paymentDetailVO.getProjectId(),paymentDetailVO.getContractId()));
            }else  if("咨询服务".equals(paymentDetailVO.getSubcontractType()) || "其它合同".equals(paymentDetailVO.getSubcontractType())){
                paymentDetailVO.setIsComplete(queryConsultotherfinalList(paymentDetailVO.getProjectId(),paymentDetailVO.getContractId()));
                paymentDetailVO.setTaxCurrentTotal(queryConsultother(paymentDetailVO.getProjectId(),paymentDetailVO.getContractId()));
                paymentDetailVO.setTotalMoneyTax(queryConsultotherfinalListAmount(paymentDetailVO.getProjectId(),paymentDetailVO.getContractId()));
            }

            paymentDetailVO.setSettlementMoneyTotal(ComputeUtil.safeAdd(paymentDetailVO.getTaxCurrentTotal(), paymentDetailVO.getTotalMoneyTax()));
        }
        //查询历史数据
        List<PaymentDetailVO> paymentDetailVOList = queryDetailVOList(projectId);
        //更新历史数据中的合同数据
        for(PaymentDetailVO paymentDetailVO : paymentDetailVOList){
            paymentDetailVO.setId(IdWorker.getId());
            if("劳务分包".equals(paymentDetailVO.getSubcontractType()) || "专业分包".equals(paymentDetailVO.getSubcontractType())){
                paymentDetailVO.setIsComplete(querySettlementBookList(projectId,paymentDetailVO.getContractId()));
                paymentDetailVO.setTaxCurrentTotal(querySubcontractingvolume(projectId,paymentDetailVO.getContractId()));
                paymentDetailVO.setTotalMoneyTax(querySettlementBookListAmount(projectId,paymentDetailVO.getContractId()));
            }else if("物资采购".equals(paymentDetailVO.getSubcontractType()) ){
                paymentDetailVO.setIsComplete(queryPurchaseSettlementList(projectId,paymentDetailVO.getContractId()));
                System.out.println(queryPurchasesettlement(projectId,paymentDetailVO.getContractId())+"==============");
                paymentDetailVO.setTaxCurrentTotal(queryPurchasesettlement(projectId,paymentDetailVO.getContractId()));
                paymentDetailVO.setTotalMoneyTax(queryPurchaseSettlementListAmount(projectId,paymentDetailVO.getContractId()));
            }else if("机械租赁".equals(paymentDetailVO.getSubcontractType()) ){
                paymentDetailVO.setIsComplete(queryMachinerySettlementList(projectId,paymentDetailVO.getContractId()));
                paymentDetailVO.setTaxCurrentTotal(queryMechanicallease(projectId,paymentDetailVO.getContractId()));
                paymentDetailVO.setTotalMoneyTax(queryMachinerySettlementListAmount(projectId,paymentDetailVO.getContractId()));
            }else if("周转材租赁".equals(paymentDetailVO.getSubcontractType()) ){
                paymentDetailVO.setIsComplete(queryLeaseSettLementList(projectId,paymentDetailVO.getContractId()));
                paymentDetailVO.setTaxCurrentTotal(queryRevolvinglease(projectId,paymentDetailVO.getContractId()));
                paymentDetailVO.setTotalMoneyTax(queryLeaseSettLementListAmount(projectId,paymentDetailVO.getContractId()));
            }else if("设计勘察".equals(paymentDetailVO.getSubcontractType()) ){
                paymentDetailVO.setIsComplete(queryDesignSettlementList(projectId,paymentDetailVO.getContractId()));
                paymentDetailVO.setTaxCurrentTotal(queryDesignsubcontractnode(projectId,paymentDetailVO.getContractId()));
                paymentDetailVO.setTotalMoneyTax(queryDesignSettlementListAmount(projectId,paymentDetailVO.getContractId()));
            }else  if("咨询服务".equals(paymentDetailVO.getSubcontractType()) || "其它合同".equals(paymentDetailVO.getSubcontractType())){
                paymentDetailVO.setIsComplete(queryConsultotherfinalList(projectId,paymentDetailVO.getContractId()));
                paymentDetailVO.setTaxCurrentTotal(queryConsultother(projectId,paymentDetailVO.getContractId()));
                paymentDetailVO.setTotalMoneyTax(queryConsultotherfinalListAmount(projectId,paymentDetailVO.getContractId()));
            }

            paymentDetailVO.setSettlementMoneyTotal(ComputeUtil.safeAdd(paymentDetailVO.getTaxCurrentTotal(), paymentDetailVO.getTotalMoneyTax()));
        }
        if(CollectionUtil.isNotEmpty(paymentDetailVOList)){
            for(PaymentDetailVO paymentDetailVO : paymentDetailVOList){
                paymentDetailVO.setId(IdWorker.getId());
            }
            Map<Long,PaymentDetailVO> maps = paymentDetailVOList.stream().collect(Collectors.toMap(x->x.getContractId(), Function.identity(),(k1, k2) ->k2));
            Long k;
            for(PaymentDetailVO vo : queryOutcontractList){
                k = vo.getContractId();
                if (!maps.containsKey(k)){
                    paymentDetailVOList.add(vo);
                }
            }
            //累计支付比例汇总
            BigDecimal paymentCopeWithRatio = new BigDecimal("0");
            //累计付款金额（含本期) 预付账款
            BigDecimal paymentAdvanceMoney = new BigDecimal("0");
            //累计已支付金额
            BigDecimal havePaidTotal  = new BigDecimal("0");
            // 累计欠款金额 合计
            BigDecimal debtMoneyTotal  = new BigDecimal("0");
            for(PaymentDetailVO vo : paymentDetailVOList){
                vo.setPaymentAdvanceMoney(ComputeUtil.safeAdd(vo.getPaymentAdvanceMoney(),vo.getCurrentAdvanceMoney()));
                vo.setPaymentScheduleMoney(ComputeUtil.safeAdd(vo.getPaymentScheduleMoney(),vo.getCurrentScheduleMoney()));
                vo.setPaymentMoneyTotal(ComputeUtil.safeAdd(vo.getPaymentAdvanceMoney(),vo.getPaymentScheduleMoney()));
                vo.setPaymentCopeWithRatio(ComputeUtil.safeDiv(vo.getPaymentMoneyTotal(),vo.getSettlementMoneyTotal()));

                //  累计欠款金额预付账款
                vo.setDebtAdvanceMoney(ComputeUtil.safeSub(vo.getAdvanceTotal(),vo.getPaymentAdvanceMoney()));
                // 累计欠款金额 进度账款 scheduleTotal - paymentScheduleMoney
                vo.setDebtScheduleMoney(ComputeUtil.safeSub(vo.getScheduleTotal(),vo.getPaymentScheduleMoney()));
                // 累计欠款金额 合计
                vo.setDebtMoneyTotal(ComputeUtil.safeAdd(vo.getDebtAdvanceMoney(),vo.getDebtScheduleMoney()));
                paymentCopeWithRatio = ComputeUtil.safeAdd(paymentCopeWithRatio,vo.getPaymentCopeWithRatio());
                paymentAdvanceMoney=  ComputeUtil.safeAdd(paymentAdvanceMoney,vo.getPaymentAdvanceMoney());
                havePaidTotal = ComputeUtil.safeAdd(havePaidTotal,vo.getPaymentMoneyTotal());
                debtMoneyTotal = ComputeUtil.safeAdd(debtMoneyTotal,vo.getDebtMoneyTotal());
            }
            //查询表头
            PaymentEntity paymentEntity = selectById(paymentDetailVOList.get(0).getPaymentId());
            paymentEntity.setPaymentRatioTotal(paymentCopeWithRatio);
            paymentEntity.setInAdvancePaymentMoney(paymentAdvanceMoney);
            paymentEntity.setHavePaidTotal(havePaidTotal);
            paymentEntity.setDebtMoneyTotal(debtMoneyTotal);
            PaymentVO paymentVO = BeanMapper.map(paymentEntity, PaymentVO.class);
            paymentVO.setPaymentDetailList(paymentDetailVOList);

            return paymentVO;
        }else{
            PaymentVO paymentVO = new PaymentVO();
            paymentVO.setPaymentDetailList(queryOutcontractList);
            return paymentVO;
        }
    }

    @Override
    public List<PaymentDetailVO> queryOutcontractList(Long projectId) {
        return paymentMapper.queryOutcontractList(projectId);
    }

    @Override
    public String querySettlementBookList(Long projectId,Long contractId) {
        List<PaymentDetailVO> paymentDetailVOS = paymentMapper.querySettlementBookList(projectId,contractId);
        if (CollectionUtil.isNotEmpty(paymentDetailVOS)) {
            return "是";
        }else{
            return "否";
        }
    }

    @Override
    public String queryPurchaseSettlementList(Long projectId, Long contractId) {
        List<PaymentDetailVO> paymentDetailVOS = paymentMapper.queryPurchaseSettlementList(projectId,contractId);
        if (CollectionUtil.isNotEmpty(paymentDetailVOS)) {
            return "是";
        }else{
            return "否";
        }
    }

    @Override
    public String queryLeaseSettLementList(Long projectId, Long contractId) {
        List<PaymentDetailVO> paymentDetailVOS = paymentMapper.queryLeaseSettLementList(projectId,contractId);
        if (CollectionUtil.isNotEmpty(paymentDetailVOS)) {
            return "是";
        }else{
            return "否";
        }
    }

    @Override
    public String queryMachinerySettlementList(Long projectId, Long contractId) {
        List<PaymentDetailVO> paymentDetailVOS = paymentMapper.queryMachinerySettlementList(projectId,contractId);
        if (CollectionUtil.isNotEmpty(paymentDetailVOS)) {
            return "是";
        }else{
            return "否";
        }
    }

    @Override
    public String queryDesignSettlementList(Long projectId, Long contractId) {
        List<PaymentDetailVO> paymentDetailVOS = paymentMapper.queryDesignSettlementList(projectId,contractId);
        if (CollectionUtil.isNotEmpty(paymentDetailVOS)) {
            return "是";
        }else{
            return "否";
        }
    }

    @Override
    public String queryConsultotherfinalList(Long projectId, Long contractId) {
        List<PaymentDetailVO> paymentDetailVOS = paymentMapper.queryConsultotherfinalList(projectId,contractId);
        if (CollectionUtil.isNotEmpty(paymentDetailVOS)) {
            return "是";
        }else{
            return "否";
        }
    }

    @Override
    public BigDecimal querySubcontractingvolume(Long projectId, Long contractId) {
        List<PaymentDetailVO> paymentDetailVOS = paymentMapper.querySubcontractingvolume(projectId,contractId);
        if (CollectionUtil.isNotEmpty(paymentDetailVOS)) {
            return paymentDetailVOS.get(0).getTotalMoneyTax();
        }else{
            return new BigDecimal("0");
        }
    }

    @Override
    public BigDecimal queryPurchasesettlement(Long projectId, Long contractId) {
        List<PaymentDetailVO> paymentDetailVOS = paymentMapper.queryPurchasesettlement(projectId,contractId);
        if (CollectionUtil.isNotEmpty(paymentDetailVOS)) {
            return paymentDetailVOS.get(0).getTotalMoneyTax();
        }else{
            return new BigDecimal("0");
        }
    }

    @Override
    public BigDecimal queryRevolvinglease(Long projectId, Long contractId) {
        List<PaymentDetailVO> paymentDetailVOS = paymentMapper.queryRevolvinglease(projectId,contractId);
        if (CollectionUtil.isNotEmpty(paymentDetailVOS)) {
            return paymentDetailVOS.get(0).getTotalMoneyTax();
        }else{
            return new BigDecimal("0");
        }
    }

    @Override
    public BigDecimal queryMechanicallease(Long projectId, Long contractId) {
        List<PaymentDetailVO> paymentDetailVOS = paymentMapper.queryMechanicallease(projectId,contractId);
        if (CollectionUtil.isNotEmpty(paymentDetailVOS)) {
            return paymentDetailVOS.get(0).getTotalMoneyTax();
        }else{
            return new BigDecimal("0");
        }
    }

    @Override
    public BigDecimal queryDesignsubcontractnode(Long projectId, Long contractId) {
        List<PaymentDetailVO> paymentDetailVOS = paymentMapper.queryDesignsubcontractnode(projectId,contractId);
        if (CollectionUtil.isNotEmpty(paymentDetailVOS)) {
            return paymentDetailVOS.get(0).getTotalMoneyTax();
        }else{
            return new BigDecimal("0");
        }
    }

    @Override
    public BigDecimal queryConsultother(Long projectId, Long contractId) {
        List<PaymentDetailVO> paymentDetailVOS = paymentMapper.queryConsultother(projectId,contractId);
        if (CollectionUtil.isNotEmpty(paymentDetailVOS)) {
            return paymentDetailVOS.get(0).getTotalMoneyTax();
        }else{
            return new BigDecimal("0");
        }
    }

    @Override
    public BigDecimal querySettlementBookListAmount(Long projectId, Long contractId) {
        List<PaymentDetailVO> paymentDetailVOS = paymentMapper.querySettlementBookListAmount(projectId,contractId);
        if (CollectionUtil.isNotEmpty(paymentDetailVOS)) {
            return paymentDetailVOS.get(0).getTotalMoneyTax();
        }else{
            return new BigDecimal("0");
        }
    }

    @Override
    public BigDecimal queryPurchaseSettlementListAmount(Long projectId, Long contractId) {
        List<PaymentDetailVO> paymentDetailVOS = paymentMapper.queryPurchaseSettlementListAmount(projectId,contractId);
        if (CollectionUtil.isNotEmpty(paymentDetailVOS)) {
            return paymentDetailVOS.get(0).getTotalMoneyTax();
        }else{
            return new BigDecimal("0");
        }
    }

    @Override
    public BigDecimal queryLeaseSettLementListAmount(Long projectId, Long contractId) {
        List<PaymentDetailVO> paymentDetailVOS = paymentMapper.queryLeaseSettLementListAmount(projectId,contractId);
        if (CollectionUtil.isNotEmpty(paymentDetailVOS)) {
            return paymentDetailVOS.get(0).getTotalMoneyTax();
        }else{
            return new BigDecimal("0");
        }
    }

    @Override
    public BigDecimal queryMachinerySettlementListAmount(Long projectId, Long contractId) {
        List<PaymentDetailVO> paymentDetailVOS = paymentMapper.queryMachinerySettlementListAmount(projectId,contractId);

        if (CollectionUtil.isNotEmpty(paymentDetailVOS)) {
            return paymentDetailVOS.get(0).getTotalMoneyTax();
        }else{
            return new BigDecimal("0");
        }
    }

    @Override
    public BigDecimal queryDesignSettlementListAmount(Long projectId, Long contractId) {
        List<PaymentDetailVO> paymentDetailVOS = paymentMapper.queryDesignSettlementListAmount(projectId,contractId);
        if (CollectionUtil.isNotEmpty(paymentDetailVOS)) {
            return paymentDetailVOS.get(0).getTotalMoneyTax();
        }else{
            return new BigDecimal("0");
        }
    }

    @Override
    public BigDecimal queryConsultotherfinalListAmount(Long projectId, Long contractId) {
        List<PaymentDetailVO> paymentDetailVOS = paymentMapper.queryConsultotherfinalListAmount(projectId,contractId);
        if (CollectionUtil.isNotEmpty(paymentDetailVOS)) {
            return paymentDetailVOS.get(0).getTotalMoneyTax();
        }else{
            return new BigDecimal("0");
        }
    }

    @Override
    public List<PaymentDetailVO> queryDetailVOList(Long projectId) {
        return paymentMapper.queryDetailVOList(projectId);
    }


}
