package com.ejianc.business.bedget.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bedget.bean.SubpackageEntity;
import com.ejianc.business.bedget.service.ISubpackageService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import org.apache.lucene.index.DocIDMerger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.List;

@Service("subpackage")
public class SubpackageBpmServiceImpl implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private ISubpackageService subpackageService;

    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    ;

    /**
     * 提交完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 有审批流的撤回前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        QueryWrapper<SubpackageEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("id", billId);
        SubpackageEntity subpackageEntity = subpackageService.getOne(wrapper);
        Long projectId = subpackageEntity.getProjectId();
        QueryWrapper<SubpackageEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("dr", 0);
        queryWrapper.eq("project_id", projectId);
        queryWrapper.eq("bill_state", 0);
        List<SubpackageEntity> entityList = subpackageService.list(queryWrapper);
        if (CollectionUtil.isNotEmpty(entityList)) {
            throw new BusinessException("该项目下已存在自由态的单据，不能撤回");
        }

        return CommonResponse.success();
    }

    ;

    /**
     * 有审批流的撤回后回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 审批节点审批中时节点审批前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    ;

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {

        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
        if (!resp.isSuccess()) {
            logger.info("分包施工图预算单据【billId-{}】,【billTypeCode-{}】执行撤回操作校验结束，未通过校验，原因：{}", billId, billTypeCode, resp.getMsg());
            return CommonResponse.error(resp.getMsg());
        }

        QueryWrapper<SubpackageEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("id", billId);
        SubpackageEntity subpackageEntity = subpackageService.getOne(wrapper);
        Long projectId = subpackageEntity.getProjectId();
        QueryWrapper<SubpackageEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("dr", 0);
        queryWrapper.eq("project_id", projectId);
        queryWrapper.eq("bill_state", 0);
        List<SubpackageEntity> entityList = subpackageService.list(queryWrapper);
        if (CollectionUtil.isNotEmpty(entityList)) {
            throw new BusinessException("该项目下已存在自由态的单据，不能撤回");
        }
        return CommonResponse.success();
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

}
