package com.ejianc.business.bedget.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.bedget.bean.SubpackageEntity;
import com.ejianc.business.bedget.bean.SubpackagedetailEntity;
import com.ejianc.business.bedget.bean.SubpackagetotalEntity;
import com.ejianc.business.bedget.mapper.SubpackagetotalMapper;
import com.ejianc.business.bedget.service.ISubpackageService;
import com.ejianc.business.bedget.service.ISubpackagedetailService;
import com.ejianc.business.bedget.service.ISubpackagetotalService;
import com.ejianc.business.bedget.vo.SubpackagedetailVO;
import com.ejianc.business.bedget.vo.SubpackagetotalVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.TimeUnit;

/**
 * 分包施工图预算汇总
 * 
 * @author generator
 * 
 */
@Service("subpackagetotalService")
public class SubpackagetotalServiceImpl extends BaseServiceImpl<SubpackagetotalMapper, SubpackagetotalEntity> implements ISubpackagetotalService{

    //日志
    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private ISubpackagetotalService service;

    @Autowired
    private RestHighLevelClient client;

    @Autowired
    private ISubpackageService subpackageService;

    @Autowired
    private ISubpackagedetailService subpackagedetailService;


    private final static String ESSignStatistic = "ejc-budgetmanage-subpackagetotal";

    @Override
    public CommonResponse<String> saveSnapshotData() {
        String curDate = this.getLastMonth();
        //劳务分包汇总统计
        new Thread(() -> {
            try {
                service.saveESData("劳务分包预算汇总报表" + curDate,null,null);
            } catch (Exception e) {
                logger.error("劳务分包预算汇总报表数据异常，", e);
            }
        }).start();

        return CommonResponse.success("保存快照成功");
    }

    @Override
    public CommonResponse<String> saveESData(String reportName,String contract,String projectId) {
        //构建es请求
        BulkRequest bulkRequest = new BulkRequest();

        SimpleDateFormat format1 = new SimpleDateFormat("YYYY-MM-dd hh:mm:ss");
        String curDate = format1.format(new Date());
        //获取当前mysql数据
        QueryWrapper queryParam = new QueryWrapper<>();
        queryParam.eq("contract",contract);
        queryParam.eq("project_id",projectId);
        queryParam.eq("dr",0);
        List<SubpackageEntity> list = subpackageService.list(queryParam);
        for (SubpackageEntity entity : list) {
            QueryWrapper<SubpackagedetailEntity> wrapper = new QueryWrapper<>();
            wrapper.eq("dr",0);
            wrapper.eq("mid",entity.getId());
            List<SubpackagedetailEntity> subpackagedetailEntityList = subpackagedetailService.list(wrapper);
            for (SubpackagedetailEntity subpackagedetailEntity : subpackagedetailEntityList) {
                try {
                    SubpackagetotalVO vo = BeanMapper.map(entity, SubpackagetotalVO.class);
                    Map<String, Object> dataMap = BeanMapper.map(vo, Map.class);
                    dataMap.put("reportId", subpackagedetailEntity.getId().toString());
                    dataMap.put("snapShotTime", curDate);
                    dataMap.put("snapShotVersion", reportName);
                    dataMap.put("projectId",entity.getProjectId());
                    dataMap.put("contract",entity.getContract());
                    dataMap.put("subtitleCode",subpackagedetailEntity.getSubtitleCode());
                    dataMap.put("subtitleName",subpackagedetailEntity.getSubtitleName());
                    dataMap.put("subtitleFeature",subpackagedetailEntity.getSubtitleFeature());
                    dataMap.put("artificialTotal",subpackagedetailEntity.getArtificialTotal());
                    dataMap.put("materialsTotal",subpackagedetailEntity.getMaterialsTotal());
                    dataMap.put("mechanicalTotal",subpackagedetailEntity.getMechanicalTotal());
                    dataMap.put("enterpriseManageTotal",subpackagedetailEntity.getEnterpriseManageTotal());
                    dataMap.put("profitsTotal",subpackagedetailEntity.getProfitsTotal());
                    dataMap.put("feesTotal",subpackagedetailEntity.getFeesTotal());
                    dataMap.put("taxTotal",subpackagedetailEntity.getTaxTotal());
                    dataMap.put("comprehensiveTotal",subpackagedetailEntity.getComprehensiveTotal());
                    dataMap.put("excludingTaxTotal",subpackagedetailEntity.getExcludingTaxTotal());
                    dataMap.put("includingTaxTotal",subpackagedetailEntity.getIncludingTaxTotal());
                    dataMap.put("tid",subpackagedetailEntity.getTid());
                    dataMap.put("tpid",subpackagedetailEntity.getTpid());
                    IndexRequest indexRequest = new IndexRequest(ESSignStatistic);
                    indexRequest.source(dataMap, XContentType.JSON);
                    bulkRequest.add(indexRequest);
                } catch (Exception e) {
                    logger.error("生成劳务分包预算汇总数据异常，", e);
                    throw new BusinessException("生成劳务分包预算汇总数据异常");
                }
            }
        }

        try {
            bulkRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            client.bulk(bulkRequest, RequestOptions.DEFAULT);
        } catch (IOException e) {
            logger.info("生成ES数据失败:---->" + e.getMessage());
            throw new BusinessException("生成ES数据失败:---->" + e.getMessage());
        }

        logger.info("***********生成劳务分包预算汇总---执行完成 *********** ");
        return CommonResponse.success("生成劳务分包预算汇总成功");
    }

    @Override
    public IPage<SubpackagetotalVO> queryEsByPage(QueryParam param,String reportItem,
                                                  String monthQuery,String contract,String projectId) {

        Date d = new Date(monthQuery);
        String  dateFormat = String.valueOf(d.getYear() + '-' + (d.getMonth() + 1) + '-' + d.getDate() + ' ' + d.getHours() + ':' + d.getMinutes() + ':' + d.getSeconds());


        // 搜索请求对象
        SearchRequest searchRequest = new SearchRequest(ESSignStatistic);
        // 指定类型
        searchRequest.searchType(SearchType.DEFAULT);

        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolBuilder = QueryBuilders.boolQuery();
        Map<String, Parameter> parameterMap = param.getParams();
        List<QueryBuilder> listQuery = new ArrayList<>();
        List<QueryBuilder> mustQuery = new ArrayList<>();
        if(StringUtils.isNotEmpty(contract) && contract != null){
            mustQuery.add(QueryBuilders.matchPhraseQuery("contract",contract));
        }
        if(StringUtils.isNotEmpty(projectId) && projectId != null){
            mustQuery.add(QueryBuilders.matchPhraseQuery("projectId",projectId));
        }
        if(StringUtils.isNotEmpty(dateFormat) && dateFormat != null){
            listQuery.add(QueryBuilders.matchPhraseQuery("createTime",dateFormat));
        }
        if(StringUtils.isNotEmpty(reportItem) && reportItem != null){
            mustQuery.add(QueryBuilders.matchPhraseQuery("snapShotVersion",reportItem));
        }
        if (parameterMap.size() > 0 && parameterMap != null) {
            for (String key : parameterMap.keySet()) {
                    listQuery.add(QueryBuilders.matchPhraseQuery(key,param.getParams().get(key).getValue()));
               // boolBuilder.should(QueryBuilders.termQuery(key,param.getParams().get(key).getValue()));
            }
        }
        if(StringUtils.isNotEmpty(param.getSearchText()) && param.getSearchText() != null){
            for (String field : param.getFuzzyFields()) {
                listQuery.add(QueryBuilders.matchPhraseQuery(field,param.getSearchText()));
            }
        }
        //分页配置
        Integer pageIndex = param.getPageIndex();
        Integer pageSize = param.getPageSize();
        sourceBuilder.from(pageIndex <= 0 ? 0 : (pageIndex-1)*pageSize);
        sourceBuilder.size(pageSize);
        sourceBuilder.trackTotalHits(true);
        sourceBuilder.timeout(new TimeValue(60, TimeUnit.SECONDS)); //设置超时时间

        //搜索源配置
        boolBuilder.should().addAll(listQuery);
        boolBuilder.must().addAll(mustQuery);
        sourceBuilder.query(boolBuilder);
        searchRequest.source(sourceBuilder);

        ArrayList<SubpackagetotalVO> list = new ArrayList<>();
        try {
            //调用检索
            SearchResponse searchResponse = client.search(searchRequest, RequestOptions.DEFAULT);
            // 搜索结果
            SearchHits hits = searchResponse.getHits();
            Integer idCount = 1;
            // 得到匹配度高的文档
            SearchHit[] searchHits = hits.getHits();
            Page<SubpackagetotalVO> voPage = new Page<>();
            if ( hits.getTotalHits().value <= 0) {
                voPage.setTotal(0);
                voPage.setCurrent(pageIndex);
                voPage.setSize(pageSize);
                voPage.setRecords(null);
                return voPage;
            }

            //响应数据
            for (SearchHit hit : searchHits) {
                idCount++;
                JSONObject json = new JSONObject(hit.getSourceAsMap());
                SubpackagetotalVO vo = JSONObject.toJavaObject(json, SubpackagetotalVO.class);
                vo.setId(Long.valueOf(idCount));
                if (vo.getSnapShotTime() != null) {
                    vo.setSnapShotTime(DateUtil.date(vo.getSnapShotTime()));
                }
                list.add(vo);

            }
            //构建树
            List<SubpackagetotalVO> resList = createTreeData(list);
            for (SubpackagetotalVO subpackagetotalVO : resList) {
                if(CollectionUtil.isNotEmpty(subpackagetotalVO.getChildren().get(0).getChildren())){
                    subpackagetotalVO.getChildren().get(0).setChildren(null);
                }
            }
            voPage.setTotal(hits.getTotalHits().value);
            voPage.setSize(pageSize);
            voPage.setCurrent(pageIndex);
            voPage.setRecords(resList);
            return voPage;
        } catch (IOException e) {
            throw new RuntimeException("ES查询异常" + e);
        }
    }

    @Override
    public List<String> queryEsSnap(String snapShotTime,String contract,String projectId) {

        // 搜索请求对象
        SearchRequest searchRequest = new SearchRequest(ESSignStatistic);
        // 指定类型
        searchRequest.searchType(SearchType.DEFAULT);

        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolBuilder = QueryBuilders.boolQuery();
        List<QueryBuilder> listQuery = new ArrayList<>();
        List<QueryBuilder> mustQuery = new ArrayList<>();
        if(StringUtils.isNotEmpty(contract) && contract != null){
            mustQuery.add(QueryBuilders.matchPhraseQuery("contract",contract));
        }
        if(StringUtils.isNotEmpty(projectId) && projectId != null){
            mustQuery.add(QueryBuilders.matchPhraseQuery("projectId",projectId));
        }
        if(StringUtils.isNotEmpty(snapShotTime) && snapShotTime != null){
            listQuery.add(QueryBuilders.matchPhraseQuery("createTime",snapShotTime));
        }
        //搜索源配置
        boolBuilder.should().addAll(listQuery);
        boolBuilder.must().addAll(mustQuery);
        sourceBuilder.query(boolBuilder);
        searchRequest.source(sourceBuilder);

        ArrayList<String> list = new ArrayList<>();
        try {
           SearchResponse  searchResponse = client.search(searchRequest, RequestOptions.DEFAULT);
            SearchHits hits = searchResponse.getHits();
            SearchHit[] searchHits = hits.getHits();
            for (SearchHit hit : searchHits) {
                // 源文档内容
                Map<String, Object> sourceAsMap = hit.getSourceAsMap();
                JSONObject json = new JSONObject(sourceAsMap);
                SubpackagetotalVO vo = JSONObject.toJavaObject(json, SubpackagetotalVO.class);
                //list.add(hit.getId());
                TreeSet<String> set = new TreeSet<>();
                set.add(vo.getSnapShotVersion());
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
                Date createTime = vo.getCreateTime();
                String dataDate = format.format(createTime);
                if(!dataDate.equals(snapShotTime)){
                    list = null;
                }else{
                    list.addAll(set);
                }
            }
        } catch (IOException e) {
            throw new RuntimeException("ES查询失败" + e);
        }
        // 搜索结果
        return list;
    }

    @Override
    public IPage<SubpackagetotalVO> selectEsList(QueryParam param,String contract,String projectId) {
        List<SubpackagetotalVO> vo = new ArrayList<>();
        QueryWrapper<SubpackageEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("contract",contract);
        queryWrapper.eq("project_id",projectId);
        queryWrapper.eq("dr", 0);
        List<SubpackageEntity> records = subpackageService.list(queryWrapper);
        for (SubpackageEntity entity : records) {
            QueryWrapper<SubpackagedetailEntity> queryWrapper1 = new QueryWrapper<>();
            queryWrapper1.eq("dr", 0);
            queryWrapper1.eq("mid", entity.getId());
            List<SubpackagedetailEntity> records1 = subpackagedetailService.list(queryWrapper1);
            for (SubpackagedetailEntity entity1 : records1) {
                SubpackagetotalVO subpackagetotalVO = new SubpackagetotalVO();
                subpackagetotalVO.setId(IdWorker.getId());
                subpackagetotalVO.setSubtitleCode(entity1.getSubtitleCode());
                subpackagetotalVO.setSubtitleName(entity1.getSubtitleName());
                subpackagetotalVO.setSubtitleFeature(entity1.getSubtitleFeature());
                subpackagetotalVO.setArtificialTotal(entity1.getArtificialTotal());
                subpackagetotalVO.setMaterialsTotal(entity1.getMaterialsTotal());
                subpackagetotalVO.setMechanicalTotal(entity1.getMechanicalTotal());
                subpackagetotalVO.setEnterpriseManageTotal(entity1.getEnterpriseManageTotal());
                subpackagetotalVO.setProfitsTotal(entity1.getProfitsTotal());
                subpackagetotalVO.setFeesTotal(entity1.getFeesTotal());
                subpackagetotalVO.setTaxTotal(entity1.getTaxTotal());
                subpackagetotalVO.setComprehensiveTotal(entity1.getComprehensiveTotal());
                subpackagetotalVO.setExcludingTaxTotal(entity1.getExcludingTaxTotal());
                subpackagetotalVO.setIncludingTaxTotal(entity1.getIncludingTaxTotal());
                subpackagetotalVO.setTid(String.valueOf(entity1.getTid()));
                subpackagetotalVO.setTpid(entity1.getTpid());
                if(subpackagetotalVO.getChildren()!=null && subpackagetotalVO.getChildren().size() == 0){
                    subpackagetotalVO.setChildren(null);
                }
                vo.add(subpackagetotalVO);
            }
        }
        List<SubpackagetotalVO> treeData = createTreeData(vo);
        for (SubpackagetotalVO subpackagetotalVO : treeData) {
            List<SubpackagetotalVO> list = subpackagetotalVO.getChildren();
            if (list != null && list.size() > 0){
                SubpackagetotalVO subpackagetotalVO1 = list.get(0);
                subpackagetotalVO1.setChildren(null);
            }

        }
        Page<SubpackagetotalVO> pages = new Page<>();
        pages.setCurrent(param.getPageIndex());
        pages.setSize(param.getPageSize());
        pages.setTotal(treeData.size());
        pages.setRecords(treeData);
        return pages;
    }
    /**
     * 构建树
     *
     * @param list
     * @return
     */
    public static List<SubpackagetotalVO> createTreeData(List<SubpackagetotalVO> list) {
        List<SubpackagetotalVO> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();

        //循环list，放入listMap重
        Map<String, SubpackagetotalVO> listMap = new HashMap<>();
        for (SubpackagetotalVO item : list) {
            listMap.put(item.getTid().toString(), item);
        }

        for (int i = 0; i < list.size(); i++) {
            SubpackagetotalVO item = list.get(i);
            String parentId = (item.getTpid() != null) ? item.getTpid().toString() : "";
            SubpackagetotalVO parent = listMap.get(parentId);
            if (parent != null) {
                List<SubpackagetotalVO> child = (List<SubpackagetotalVO>) parent.getChildren();
                if (child != null) {
                    child.add(item);
                } else{
                    List<SubpackagetotalVO> children = new ArrayList<SubpackagetotalVO>();
                    children.add(item);
                    parent.setChildren(children);
                }
            } else {
                rootItems.add(item.getTid());
            }
        }

        for (String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }

    //子目编码规则定死------分别是2位/4位/6位/6为以上
    private Long setPid(String pcode, Map<String, SubpackagedetailVO> map) {
        if (map.get(pcode) != null) {
            return Long.valueOf(map.get(pcode).getTid());
        } else {
            //父级没有找到，则继续往上找
            if (pcode.length() == 2) {
                //最上级
                return null;
            } else if (pcode.length() == 4) {
                String ppcode = pcode.substring(0, 2);
                return this.setPid(ppcode, map);
            } else if (pcode.length() == 6) {
                String ppcode = pcode.substring(0, 4);
                return this.setPid(ppcode, map);
            } else if (pcode.length() > 6) {
                String ppcode = pcode.substring(0, 6);
                return this.setPid(ppcode, map);
            } else {
                return null;
            }
        }
    }

    //获取上一个月字符串
    public String getLastMonth() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date); // 设置为当前时间
        calendar.set(Calendar.MONTH, calendar.get(Calendar.MONTH) - 1); // 设置为上一个月
        date = calendar.getTime();
        String accDate = format.format(date);
        return accDate;
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }
}
