package com.ejianc.business.bedget.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 施工图预算书
 *
 * @author generator
 *
 */
public class DrawVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String billCode; // 单据编号
    private Long orgId; // 组织
    private String orgCode; // 组织编码
    private String orgName; // 组织名称
    private Long parentOrgId; // 所属组织
    private String parentOrgCode; // 所属组织编码
    private String parentOrgName; // 所属组织名称
    private Long projectId; // 项目
    private String projectCode; // 项目编码
    private String projectName; // 项目名称
    private Long contractId; // 合同
    private String contractCode; // 合同编码
    private String contractName; // 合同名称
    private String budgetName; // 预算书名称
    private BigDecimal taxRate; // 税率
    private BigDecimal budgetMny; // 金额
    private BigDecimal beforeBudgetMny; // 变更前金额
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private Long deptId; // 经办部门
    private String deptName; // 经办部门名称
    private BigDecimal subMny; // 分部分项金额
    private BigDecimal beforeSubMny; // 变更前分部分项金额
    private BigDecimal priceMeasureMny; // 单价措施项金额
    private BigDecimal beforePriceMeasureMny; // 变更前单价措施项金额
    private BigDecimal totalMeasureMny; // 总价措施项金额
    private BigDecimal beforeTotalMeasureMny; // 变更前总价措施项金额
    private BigDecimal otherMny; // 其它项金额
    private BigDecimal beforeOtherMny; // 变更前其它项金额
    private BigDecimal estimateMny; // 暂估金额
    private BigDecimal beforeEstimateMny; // 变更前暂估金额
    private BigDecimal feeMny; // 规费金额
    private BigDecimal beforeFeeMny; // 变更前规费金额
    private BigDecimal taxesMny; // 税金金额
    private BigDecimal beforeTaxesMny; // 变更前税金金额
    private Integer billState; // 单据状态
    private Boolean latestFlag; // 是否最新版本
    private Boolean enableState; // 是否生效
    private Integer drawVersion; // 施工图预算版本号
    private Long lastDrawId; // 上一版本主键
    private Long changeId; // 变更单主键
    private Integer changeState; // 变更状态(0-未变更1-变更中2-已变更)
    private Integer beforeDrawVersion; // 历史版本号
    private String memo; // 编制说明
    private String changeReason; // 变更原因
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date enabledTime; // 生效时间

    private java.lang.String billStateName; // 单据状态名称
    private String changeStateName; // 变更状态名称(0-未变更1-变更中2-已变更)

    private List<DrawFeeVO> feeList = new ArrayList<>(); // 施工图预算书费用项子表
    private List<DrawOtherVO> otherList = new ArrayList<>(); // 施工图预算书其他项子表
    private List<DrawPriceVO> priceList = new ArrayList<>(); // 施工图预算书单价措施项子表
    private List<DrawTotalVO> totalList = new ArrayList<>(); // 施工图预算书总价措施项子表
    private List<DrawSubVO> subList = new ArrayList<>(); // 施工图预算书分部分项子表

    private List<DrawVO> changeList = new ArrayList<>();//变更历史

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }
    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    @ReferSerialTransfer(referCode="ejc-zjkj-project")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    @ReferSerialTransfer(referCode="ejc-zjkj-incontract")
    public Long getContractId() {
        return contractId;
    }
    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getBudgetName() {
        return budgetName;
    }

    public void setBudgetName(String budgetName) {
        this.budgetName = budgetName;
    }
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    public BigDecimal getBudgetMny() {
        return budgetMny;
    }

    public void setBudgetMny(BigDecimal budgetMny) {
        this.budgetMny = budgetMny;
    }
    public BigDecimal getBeforeBudgetMny() {
        return beforeBudgetMny;
    }

    public void setBeforeBudgetMny(BigDecimal beforeBudgetMny) {
        this.beforeBudgetMny = beforeBudgetMny;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    @ReferSerialTransfer(referCode = "idm-dept")
    public Long getDeptId() {
        return deptId;
    }

    @ReferDeserialTransfer
    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }
    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }
    public BigDecimal getSubMny() {
        return subMny;
    }

    public void setSubMny(BigDecimal subMny) {
        this.subMny = subMny;
    }
    public BigDecimal getBeforeSubMny() {
        return beforeSubMny;
    }

    public void setBeforeSubMny(BigDecimal beforeSubMny) {
        this.beforeSubMny = beforeSubMny;
    }
    public BigDecimal getPriceMeasureMny() {
        return priceMeasureMny;
    }

    public void setPriceMeasureMny(BigDecimal priceMeasureMny) {
        this.priceMeasureMny = priceMeasureMny;
    }
    public BigDecimal getBeforePriceMeasureMny() {
        return beforePriceMeasureMny;
    }

    public void setBeforePriceMeasureMny(BigDecimal beforePriceMeasureMny) {
        this.beforePriceMeasureMny = beforePriceMeasureMny;
    }
    public BigDecimal getTotalMeasureMny() {
        return totalMeasureMny;
    }

    public void setTotalMeasureMny(BigDecimal totalMeasureMny) {
        this.totalMeasureMny = totalMeasureMny;
    }
    public BigDecimal getBeforeTotalMeasureMny() {
        return beforeTotalMeasureMny;
    }

    public void setBeforeTotalMeasureMny(BigDecimal beforeTotalMeasureMny) {
        this.beforeTotalMeasureMny = beforeTotalMeasureMny;
    }
    public BigDecimal getOtherMny() {
        return otherMny;
    }

    public void setOtherMny(BigDecimal otherMny) {
        this.otherMny = otherMny;
    }
    public BigDecimal getBeforeOtherMny() {
        return beforeOtherMny;
    }

    public void setBeforeOtherMny(BigDecimal beforeOtherMny) {
        this.beforeOtherMny = beforeOtherMny;
    }
    public BigDecimal getEstimateMny() {
        return estimateMny;
    }

    public void setEstimateMny(BigDecimal estimateMny) {
        this.estimateMny = estimateMny;
    }
    public BigDecimal getBeforeEstimateMny() {
        return beforeEstimateMny;
    }

    public void setBeforeEstimateMny(BigDecimal beforeEstimateMny) {
        this.beforeEstimateMny = beforeEstimateMny;
    }
    public BigDecimal getFeeMny() {
        return feeMny;
    }

    public void setFeeMny(BigDecimal feeMny) {
        this.feeMny = feeMny;
    }
    public BigDecimal getBeforeFeeMny() {
        return beforeFeeMny;
    }

    public void setBeforeFeeMny(BigDecimal beforeFeeMny) {
        this.beforeFeeMny = beforeFeeMny;
    }
    public BigDecimal getTaxesMny() {
        return taxesMny;
    }

    public void setTaxesMny(BigDecimal taxesMny) {
        this.taxesMny = taxesMny;
    }
    public BigDecimal getBeforeTaxesMny() {
        return beforeTaxesMny;
    }

    public void setBeforeTaxesMny(BigDecimal beforeTaxesMny) {
        this.beforeTaxesMny = beforeTaxesMny;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Boolean getLatestFlag() {
        return latestFlag;
    }

    public void setLatestFlag(Boolean latestFlag) {
        this.latestFlag = latestFlag;
    }
    public Boolean getEnableState() {
        return enableState;
    }

    public void setEnableState(Boolean enableState) {
        this.enableState = enableState;
    }
    public Integer getDrawVersion() {
        return drawVersion;
    }

    public void setDrawVersion(Integer drawVersion) {
        this.drawVersion = drawVersion;
    }
    public Long getLastDrawId() {
        return lastDrawId;
    }

    public void setLastDrawId(Long lastDrawId) {
        this.lastDrawId = lastDrawId;
    }
    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    public Integer getChangeState() {
        return changeState;
    }

    public void setChangeState(Integer changeState) {
        this.changeState = changeState;
    }
    public Integer getBeforeDrawVersion() {
        return beforeDrawVersion;
    }

    public void setBeforeDrawVersion(Integer beforeDrawVersion) {
        this.beforeDrawVersion = beforeDrawVersion;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getChangeReason() {
        return changeReason;
    }

    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }

    public Date getEnabledTime() {
        return enabledTime;
    }

    public void setEnabledTime(Date enabledTime) {
        this.enabledTime = enabledTime;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getChangeStateName() {
        return changeStateName;
    }

    public void setChangeStateName(String changeStateName) {
        this.changeStateName = changeStateName;
    }

    public List<DrawFeeVO> getFeeList() {
        return feeList;
    }

    public void setFeeList(List<DrawFeeVO> feeList) {
        this.feeList = feeList;
    }

    public List<DrawOtherVO> getOtherList() {
        return otherList;
    }

    public void setOtherList(List<DrawOtherVO> otherList) {
        this.otherList = otherList;
    }

    public List<DrawPriceVO> getPriceList() {
        return priceList;
    }

    public void setPriceList(List<DrawPriceVO> priceList) {
        this.priceList = priceList;
    }

    public List<DrawTotalVO> getTotalList() {
        return totalList;
    }

    public void setTotalList(List<DrawTotalVO> totalList) {
        this.totalList = totalList;
    }

    public List<DrawSubVO> getSubList() {
        return subList;
    }

    public void setSubList(List<DrawSubVO> subList) {
        this.subList = subList;
    }

    public List<DrawVO> getChangeList() {
        return changeList;
    }

    public void setChangeList(List<DrawVO> changeList) {
        this.changeList = changeList;
    }
}
