package com.ejianc.business.change.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bedget.bean.QuotadesignEntity;
import com.ejianc.business.bedget.bean.QuotadesigndetailEntity;
import com.ejianc.business.bedget.bean.QuotasummaryEntity;
import com.ejianc.business.bedget.bean.QuotasummarydetailEntity;
import com.ejianc.business.bedget.service.IQuotadesignService;
import com.ejianc.business.bedget.service.IQuotadesigndetailService;
import com.ejianc.business.bedget.service.IQuotasummaryService;
import com.ejianc.business.bedget.vo.QuotasummarydetailVO;
import com.ejianc.business.change.bean.ChangequotasummaryEntity;
import com.ejianc.business.change.service.IChangequotasummaryService;
import com.ejianc.business.change.vo.ChangequotadesigndetailVO;
import com.ejianc.business.change.vo.ChangequotasummaryVO;
import com.ejianc.business.change.vo.ChangequotasummarydetaillVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;



/**
 * 限额设计汇总变更
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("changequotasummary")
public class ChangequotasummaryController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "change-budgetmanage-quotasummary";//此处需要根据实际修改

    @Autowired
    private IChangequotasummaryService service;
    @Autowired
    private IQuotasummaryService quotasummaryService;

    @Autowired
    private IQuotadesignService quotadesignService;

    @Autowired
    private IQuotadesigndetailService quotadesigndetailService;

    /**
     * 初始化更详情页面
     *
     * @param
     * @return
     */
//    @GetMapping(value = "queryDetailByQuotasummaryId")
//    @ResponseBody
//    public CommonResponse<ChangequotasummaryVO> queryDetailByOriginalId(@RequestParam(value = "quotasummaryId") Long quotasummaryId) {
//        QuotasummaryEntity quotasummaryVO = quotasummaryService.selectById(quotasummaryId);
//        ChangequotasummaryVO changeVO = BeanMapper.map(quotasummaryVO, ChangequotasummaryVO.class);
//        Long id = IdWorker.getId();
//        changeVO.setOriginalId(quotasummaryId);
//        changeVO.setBillState(null);
//        changeVO.setCreateTime(null);
//        changeVO.setCreateUserCode(null);
//        changeVO.setTenantId(null);
//        changeVO.setUpdateTime(null);
//        changeVO.setUpdateUserCode(null);
//        changeVO.setId(id);
//
//        //子表
//        List<QuotasummarydetailEntity> quotasummarydetailList = quotasummaryVO.getQuotasummarydetailEntities();
//        if(quotasummarydetailList!=null&&quotasummarydetailList.size()>0){
//            List<ChangequotasummarydetaillVO> changequotasummarydetaillVos = new ArrayList<>();
//            for(QuotasummarydetailEntity entity : quotasummarydetailList){
//                ChangequotasummarydetaillVO vo = BeanMapper.map(entity, ChangequotasummarydetaillVO.class);
//                vo.setMid(id);
//                vo.setOriginalId(entity.getId());
//                vo.setCreateTime(null);
//                vo.setCreateUserCode(null);
//                vo.setTenantId(null);
//                vo.setUpdateTime(null);
//                vo.setUpdateUserCode(null);
//                vo.setRowState("edit");
//                vo.setId(IdWorker.getId());
//                changequotasummarydetaillVos.add(vo);
//            }
//
//            //构建树形结构
//            List<ChangequotasummarydetaillVO> resChangequotasummarydetaillVos = createTreeData(changequotasummarydetaillVos);
//            changeVO.setQuotasummarydetailEntities(resChangequotasummarydetaillVos);
//        }
//
//        return CommonResponse.success("查询详情成功！", changeVO);
//
//    }

    /**
     * 初始化更详情页面
     *
     * @param
     * @return
     */
    @GetMapping(value = "queryDetailByQuotasummaryId")
    @ResponseBody
    public CommonResponse<ChangequotasummaryVO> queryDetailByOriginalId(@RequestParam(value = "quotasummaryId") Long quotasummaryId) {
        QuotasummaryEntity quotasummaryVO = quotasummaryService.selectById(quotasummaryId);
        ChangequotasummaryVO changeVO = BeanMapper.map(quotasummaryVO, ChangequotasummaryVO.class);
        if(quotasummaryVO != null){
            //变更单主表基础信息
            Long id = IdWorker.getId();
            changeVO.setOriginalId(quotasummaryId);
            changeVO.setBillState(null);
            changeVO.setCreateTime(null);
            changeVO.setCreateUserCode(null);
            changeVO.setTenantId(null);
            changeVO.setUpdateTime(null);
            changeVO.setUpdateUserCode(null);
            changeVO.setId(id);

            Long projectId = quotasummaryVO.getProjectId();
            List<ChangequotasummarydetaillVO> quotasummarydetailVOList = new ArrayList<>();
            //根据项目id查询限额设计表数据
            QueryWrapper<QuotadesignEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("project_id",projectId);
            queryWrapper.eq("dr", 0);
            queryWrapper.in("bill_state", 1, 3);
            QuotadesignEntity entity = quotadesignService.getOne(queryWrapper);

            //根据主表id和tpid为空 查询子表第一层数据
            QueryWrapper<QuotadesigndetailEntity> queryWrapper1 = new QueryWrapper<>();
            queryWrapper1.eq("mid",entity.getId());
            queryWrapper1.eq("dr", 0);
            queryWrapper1.eq("tpid", "");
            List<QuotadesigndetailEntity> list = quotadesigndetailService.list(queryWrapper1);

            BigDecimal zero = new BigDecimal("0.00");
            for(QuotadesigndetailEntity quotadesigndetailEntity : list){
                //循环将第一层数据的值赋值给清单
                ChangequotasummarydetaillVO quotasummarydetailVO = new ChangequotasummarydetaillVO();
                quotasummarydetailVO.setId(IdWorker.getId());
                quotasummarydetailVO.setSort(String.valueOf(quotadesigndetailEntity.getSonItemCode()));
                quotasummarydetailVO.setUnitProjectName(quotadesigndetailEntity.getSonItemName());

                quotasummarydetailVO.setLaborCost(quotadesigndetailEntity.getShutLabor());
                quotasummarydetailVO.setMaterialCost(quotadesigndetailEntity.getShutMaterial());
                quotasummarydetailVO.setMechanicalCost(quotadesigndetailEntity.getShutMechanical());
                quotasummarydetailVO.setManagementCost(quotadesigndetailEntity.getShutManagement());
                quotasummarydetailVO.setProfit(quotadesigndetailEntity.getShutProfit());
                quotasummarydetailVO.setPartialItemTotal(quotadesigndetailEntity.getShutPrice());

                quotasummarydetailVO.setFees(quotadesigndetailEntity.getClubInsurance()==null?zero:quotadesigndetailEntity.getClubInsurance().add(quotadesigndetailEntity.getHousing()==null?zero:quotadesigndetailEntity.getHousing())
                        .add(quotadesigndetailEntity.getReserved1()==null?zero:quotadesigndetailEntity.getReserved1()).add(quotadesigndetailEntity.getReserved2()==null?zero:quotadesigndetailEntity.getReserved2())
                        .add(quotadesigndetailEntity.getReserved3()==null?zero:quotadesigndetailEntity.getReserved3()));

                quotasummarydetailVO.setTax(quotadesigndetailEntity.getTax());

                //项目造价
                quotasummarydetailVO.setProjectCost(quotadesigndetailEntity.getShutPrice()==null?zero:quotadesigndetailEntity.getShutPrice().add(quotadesigndetailEntity.getTax()==null?zero:quotadesigndetailEntity.getTax())
                        .add(quotasummarydetailVO.getFees()==null?zero:quotasummarydetailVO.getFees()));

                quotasummarydetailVO.setTid(quotadesigndetailEntity.getTid());
                quotasummarydetailVO.setTpid(quotadesigndetailEntity.getTpid());
                quotasummarydetailVO.setRowState("add");
                //根据主表id和第一层数据的父id查询第二层数据
                QueryWrapper<QuotadesigndetailEntity> queryWrapper2 = new QueryWrapper<>();
                queryWrapper2.eq("mid",entity.getId());
                queryWrapper2.eq("dr", 0);
                queryWrapper2.eq("tpid", quotadesigndetailEntity.getTid());
                List<QuotadesigndetailEntity> list1 = quotadesigndetailService.list(queryWrapper2);
                if(list1 != null){
                    for(QuotadesigndetailEntity  quotadesigndetailEntity1: list1){
                        List<ChangequotasummarydetaillVO> quotasummarydetailVOS = new ArrayList<>();
                        ChangequotasummarydetaillVO quotasummarydetailVO1 = new ChangequotasummarydetaillVO();
                        quotasummarydetailVO1.setId(IdWorker.getId());
                        quotasummarydetailVO1.setSort(quotadesigndetailEntity1.getSonItemCode());
                        quotasummarydetailVO1.setUnitProjectName(quotadesigndetailEntity1.getSonItemName());
                        quotasummarydetailVO1.setLaborCost(quotadesigndetailEntity1.getShutLabor());
                        quotasummarydetailVO1.setMaterialCost(quotadesigndetailEntity1.getShutMaterial());
                        quotasummarydetailVO1.setMechanicalCost(quotadesigndetailEntity1.getShutMechanical());
                        quotasummarydetailVO1.setManagementCost(quotadesigndetailEntity1.getShutManagement());
                        quotasummarydetailVO1.setProfit(quotadesigndetailEntity1.getShutProfit());
                        quotasummarydetailVO1.setPartialItemTotal(quotadesigndetailEntity1.getShutPrice());

                        quotasummarydetailVO1.setFees(quotadesigndetailEntity1.getClubInsurance()==null?zero:quotadesigndetailEntity1.getClubInsurance().add(quotadesigndetailEntity1.getHousing()==null?zero:quotadesigndetailEntity1.getHousing())
                                .add(quotadesigndetailEntity1.getReserved1()==null?zero:quotadesigndetailEntity1.getReserved1()).add(quotadesigndetailEntity1.getReserved2()==null?zero:quotadesigndetailEntity1.getReserved2())
                                .add(quotadesigndetailEntity1.getReserved3()==null?zero:quotadesigndetailEntity1.getReserved3()));

                        quotasummarydetailVO1.setTax(quotadesigndetailEntity1.getTax());

                        //项目造价
                        quotasummarydetailVO1.setProjectCost(quotadesigndetailEntity1.getShutPrice()==null?zero:quotadesigndetailEntity1.getShutPrice().add(quotadesigndetailEntity1.getTax()==null?zero:quotadesigndetailEntity1.getTax())
                                .add(quotasummarydetailVO1.getFees()==null?zero:quotasummarydetailVO1.getFees()));

                        quotasummarydetailVO1.setTid(quotadesigndetailEntity1.getTid());
                        quotasummarydetailVO1.setTpid(quotadesigndetailEntity1.getTpid());
                        quotasummarydetailVO1.setRowState("add");
                        quotasummarydetailVOS.add(quotasummarydetailVO1);
                        //将第二层数据添加到第一层数据下
                        quotasummarydetailVO.setChildren(quotasummarydetailVOS);
                    }
                }
                quotasummarydetailVOList.add(quotasummarydetailVO);
            }

            changeVO.setQuotasummarydetailEntities(quotasummarydetailVOList);
        }

        return CommonResponse.success("查询详情成功！", changeVO);
    }

    public static List<ChangequotasummarydetaillVO> createTreeData(List<ChangequotasummarydetaillVO> list) {
        List<ChangequotasummarydetaillVO> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();

        //循环list，放入listMap重
        Map<String, ChangequotasummarydetaillVO> listMap = new HashMap<>();
        for(ChangequotasummarydetaillVO item:list) {
            listMap.put(item.getTid().toString(), item);
        }

        for(int i =0; i<list.size(); i++) {
            ChangequotasummarydetaillVO item = list.get(i);
            String parentId = (item.getTpid() != null) ? item.getTpid().toString():"";
            ChangequotasummarydetaillVO parent = listMap.get(parentId);
            if(parent != null) {
                List<ChangequotasummarydetaillVO> child = (List<ChangequotasummarydetaillVO>) parent.getChildren();
                if(child != null) {
                    child.add(item);
                }else{
                    List<ChangequotasummarydetaillVO> children = new ArrayList<ChangequotasummarydetaillVO>();
                    children.add(item);
                    parent.setChildren(children);
                }
            } else {
                rootItems.add(item.getTid());
            }
        }

        for(String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveChange", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ChangequotasummaryVO> saveOrUpdate(@RequestBody ChangequotasummaryVO saveOrUpdateVO) {
        return service.saveChange(saveOrUpdateVO);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ChangequotasummaryVO> queryDetail(Long id) {
    	ChangequotasummaryEntity entity = service.selectById(id);
    	ChangequotasummaryVO vo = BeanMapper.map(entity, ChangequotasummaryVO.class);

        //构建树形结构
        List<ChangequotasummarydetaillVO> resChangequotasummarydetaillVos = createTreeData(vo.getQuotasummarydetailEntities());
        vo.setQuotasummarydetailEntities(resChangequotasummarydetaillVos);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ChangequotasummaryVO> vos) {
        return service.delete(vos);
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ChangequotasummaryVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        //param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<ChangequotasummaryEntity> page = service.queryPage(param,false);
        IPage<ChangequotasummaryVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ChangequotasummaryVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ChangequotasummaryEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Changequotasummary-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refChangequotasummaryData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ChangequotasummaryVO>> refChangequotasummaryData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        //param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ChangequotasummaryEntity> page = service.queryPage(param,false);
        IPage<ChangequotasummaryVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ChangequotasummaryVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
