package com.ejianc.business.change.excel;

import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bedget.bean.ContrastanalysisdetailEntity;
import com.ejianc.business.bedget.bean.ContrastanalysisdetailsEntity;
import com.ejianc.business.bedget.service.IContrastanalysisdetailService;
import com.ejianc.business.bedget.service.IContrastanalysisdetailsService;
import com.ejianc.business.bedget.vo.ContrastanalysisVO;
import com.ejianc.business.bedget.vo.ContrastanalysisdetailVO;
import com.ejianc.business.change.bean.ChangeContrastanalysisdetailEntity;
import com.ejianc.business.change.service.IChangeContrastanalysisdetailService;
import com.ejianc.business.change.vo.ChangeContrastanalysisdetailVO;
import com.ejianc.business.change.vo.ChangeContrastanalysistVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.util.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 对比分析清单导入导出
 */
@Controller
@RequestMapping("changeContrastanalysisExport")
public class ExeclChangeContrastanalysisController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IContrastanalysisdetailService ContrastanalysisdetailService;
    @Autowired
    private IChangeContrastanalysisdetailService changeContrastanalysisdetailService;

    @Autowired
    private IContrastanalysisdetailsService contrastanalysisdetailsService;

    /**
     * 导入模板下载
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadContrastanalysis")
    @ResponseBody
    public void downloadContrastanalysis(HttpServletRequest request, HttpServletResponse response){
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "contrastanalysisdetail-import.xlsx", "施工图预算清单模板");
    }

    /**
     * excel导入
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelImportContrastanalysis", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportContrastanalysis(HttpServletRequest request, HttpServletResponse response, String detailVos) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<ChangeContrastanalysisdetailVO> successList = new ArrayList<>();
        List<ChangeContrastanalysisdetailVO> errorList = new ArrayList<>();
        Map<String, ChangeContrastanalysisdetailVO> map = new HashMap<>();
        DateFormat sdf=new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if(isFailed) {
            return CommonResponse.error("文件格式不合法");
        }else{
            List<List<String>> result = ExcelReader.readExcel(mf);
            if(result != null && result.size() > 0) {
                //前端传的抓取施工图预算数据
                List<ChangeContrastanalysisdetailVO> grabVos = JSONArray.parseArray(detailVos, ChangeContrastanalysisdetailVO.class);
                List<ChangeContrastanalysisdetailVO> concatList = new ArrayList<>();
                if (grabVos != null && grabVos.size() > 0) {
                    for (int i = 0; i < grabVos.size(); i++) {
                        ChangeContrastanalysisdetailVO contrastanalysisdetailVO = grabVos.get(i);
                        concatList.add(contrastanalysisdetailVO);
                    }
                }
                grabVos = handleList(grabVos, concatList);//拍平
                Map<String, ChangeContrastanalysisdetailVO> grabMap = new HashMap<>();
                for (int i = 0; i < grabVos.size(); i++) {
                    ChangeContrastanalysisdetailVO grabVo = grabVos.get(i);
                    String grapSort = grabVo.getSort();
                    String grapCode = grabVo.getCode();
                    String grapName = grabVo.getName();
                    String grapKey = grapSort + grapCode + grapName;
                    grabMap.put(grapKey, grabVo);
                }

                //查询固定表格的数据
//                List<ContrastanalysisdetailsEntity> contrastanalysisdetailsList = contrastanalysisdetailsService.list();

                for(int i=2;i<result.size();i++) {
                    List<String> datas = result.get(i);
                    StringBuilder errorsMsgBuilder = new StringBuilder();

                    int proIndex = i - 2;

                    String sort = datas.get(0);
                    String code = datas.get(1);
                    String name = datas.get(2);
                    String biddingStage = datas.get(3);
                    String quataDesignTotal = datas.get(4);
                    String designBugetEstimate = datas.get(5);
                    String constructionBugetEstimate = datas.get(6);
                    String tenderListTotal = datas.get(7);
                    String tenderListPrice = datas.get(8);
                    String quotaDesignBudgetTotal = datas.get(9);
                    String quotaDesignBudgetPrice = datas.get(10);
                    String designBugetEstimateTotal = datas.get(11);
                    String designBugetEstimatePrice = datas.get(12);
                    String constructionBugetEstimateTotal = datas.get(13);
                    String constructionBugetEstimatePrice = datas.get(14);
                    String memo = datas.get(15);

                    ChangeContrastanalysisdetailVO contrastanalysisdetailVO = new ChangeContrastanalysisdetailVO();
                    contrastanalysisdetailVO.setId(IdWorker.getId());//id
                    contrastanalysisdetailVO.setSort(sort); // 序号
                    contrastanalysisdetailVO.setTid(String.valueOf(IdWorker.getId()));//tid
                    contrastanalysisdetailVO.setCode(code);//清单编码
                    contrastanalysisdetailVO.setName(StringUtils.isNotBlank(name)? name:null); // 工程名称或费用名称
                    contrastanalysisdetailVO.setMemo(StringUtils.isNotBlank(memo)? memo:null); // 备注

                    //必填项校验
//                    if (sort == null || TextUtils.isEmpty(sort)) {
//                        contrastanalysisdetailVO.setErrorMsg("序号不能为空！");
//                        errorsMsgBuilder.append("序号不能为空！");
//                    }
//                    if (code == null || TextUtils.isEmpty(code)) {
//                        contrastanalysisdetailVO.setErrorMsg("清单编码不能为空！");
//                        errorsMsgBuilder.append("清单编码不能为空！");
//                    }
//                    if (name == null || TextUtils.isEmpty(name)) {
//                        contrastanalysisdetailVO.setErrorMsg("工程名称或费用名称不能为空！");
//                        errorsMsgBuilder.append("工程名称或费用名称不能为空！");
//                    }
                    if (biddingStage == null || TextUtils.isEmpty(biddingStage)) {
                        contrastanalysisdetailVO.setErrorMsg("投标阶段不能为空！");
                        errorsMsgBuilder.append("投标阶段不能为空！");
                    }
                    if (tenderListTotal == null || TextUtils.isEmpty(tenderListTotal)) {
                        contrastanalysisdetailVO.setErrorMsg("投标清单合价不能为空！");
                        errorsMsgBuilder.append("投标清单合价不能为空！");
                    }

                    if(code != null){
                        contrastanalysisdetailVO.setInnercode(code);//清单编码确定唯一性
                        if ("01".equals(code) && name != null && name.contains("装饰")) {
                            contrastanalysisdetailVO.setInnercode("a1");
                        }
                        //判断是否是装饰工程的子节点编码
                        if (code.length() >= 4) {
                            //0111、0112、0113、0114、0115这五个节点都是装饰工程下的
                            String subCode = code.substring(0, 4);
                            if ("0111".equals(subCode) || "0112".equals(subCode) || "0113".equals(subCode) || "0114".equals(subCode) || "0115".equals(subCode)) {
                                //若是的话，将内码改为a1xx
                                contrastanalysisdetailVO.setInnercode("a1" + code.substring(2, code.length()));
                            }
                        }
                        //1、校验编码是否符合规则--2、4、6、9、9以上
                        if (code == null || !(code.length() == 2 || code.length() == 4 || code.length() == 6 || code.length() >= 9)) {
                            contrastanalysisdetailVO.setErrorMsg("清单编码不符合规定格式");
                            errorsMsgBuilder.append("清单编码不符合规定格式！");
                        }
                        contrastanalysisdetailVO.setCode(code);

                        //重复性校验
                        ChangeContrastanalysisdetailVO mapVO = map.get(contrastanalysisdetailVO.getInnercode());
                        if(mapVO == null){
                            map.put(contrastanalysisdetailVO.getInnercode(), contrastanalysisdetailVO);
                        }else {
                            contrastanalysisdetailVO.setErrorMsg("清单编码已存在！");
                            errorsMsgBuilder.append("清单编码已存在！");
                        }
                        contrastanalysisdetailVO.setCode(code);

                        //设置父级id
                        String innercode = contrastanalysisdetailVO.getInnercode();

                        Long pid = null;
                        if (innercode.length() == 2) {
                            //最上级
                        } else if (innercode.length() == 4) {
                            String pcode = innercode.substring(0, 2);
                            //有父节点
                            pid = this.setPid(pcode, map);
                        } else if (innercode.length() == 6) {
                            String pcode = innercode.substring(0, 4);
                            //有父节点
                            pid = this.setPid(pcode, map);
                        } else if (innercode.length() > 6) {
                            String pcode = innercode.substring(0, 6);
                            //有父节点
                            pid = this.setPid(pcode, map);
                        }

                        if (pid != null) {
                            contrastanalysisdetailVO.setTpid(pid.toString());
                        } else {
                            contrastanalysisdetailVO.setTpid("");
                        }
                    }

                    //格式校验
                    if(!TextUtils.isEmpty(biddingStage) && !NumberUtil.isNumber(biddingStage)){
                        contrastanalysisdetailVO.setErrorMsg("投标阶段格式不正确！");
                        errorsMsgBuilder.append("投标阶段格式不正确！");
                    }else {
                        contrastanalysisdetailVO.setBiddingStage(StringUtils.isNotBlank(biddingStage) ? new BigDecimal(biddingStage) : null); // 投标阶段
                    }

//                    if(!TextUtils.isEmpty(quataDesignTotal) && !NumberUtil.isNumber(quataDesignTotal)){
//                        contrastanalysisdetailVO.setErrorMsg("限额设计阶段格式不正确！");
//                        errorsMsgBuilder.append("限额设计阶段格式不正确！");
//                    }else {
//                        contrastanalysisdetailVO.setQuataDesignTotal(StringUtils.isNotBlank(quataDesignTotal) ? new BigDecimal(quataDesignTotal) : null); // 限额设计阶段
//                    }
//
//                    if(!TextUtils.isEmpty(designBugetEstimate) && !NumberUtil.isNumber(designBugetEstimate)){
//                        contrastanalysisdetailVO.setErrorMsg("设计概算阶段格式不正确！");
//                        errorsMsgBuilder.append("设计概算阶段格式不正确！");
//                    }else {
//                        contrastanalysisdetailVO.setDesignBugetEstimate(StringUtils.isNotBlank(designBugetEstimate) ? new BigDecimal(designBugetEstimate) : null); // 设计概算阶段
//                    }
//
//                    if(!TextUtils.isEmpty(constructionBugetEstimate) && !NumberUtil.isNumber(constructionBugetEstimate)){
//                        contrastanalysisdetailVO.setErrorMsg("施工图预算阶段格式不正确！");
//                        errorsMsgBuilder.append("施工图预算阶段格式不正确！");
//                    }else {
//                        contrastanalysisdetailVO.setConstructionBugetEstimate(StringUtils.isNotBlank(constructionBugetEstimate) ? new BigDecimal(constructionBugetEstimate) : null); // 施工图预算阶段
//                    }

                    if(!TextUtils.isEmpty(tenderListTotal) && !NumberUtil.isNumber(tenderListTotal)){
                        contrastanalysisdetailVO.setErrorMsg("投标清单合价格式不正确！");
                        errorsMsgBuilder.append("投标清单合价格式不正确！");
                    }else {
                        contrastanalysisdetailVO.setTenderListTotal(StringUtils.isNotBlank(tenderListTotal) ? new BigDecimal(tenderListTotal) : null); // 投标清单合价
                    }

                    if(!TextUtils.isEmpty(tenderListPrice) && !NumberUtil.isNumber(tenderListPrice)){
                        contrastanalysisdetailVO.setErrorMsg("投标清单单位造价格式不正确！");
                        errorsMsgBuilder.append("投标清单单位造价格式不正确！");
                    }else {
                        contrastanalysisdetailVO.setTenderListPrice(StringUtils.isNotBlank(tenderListPrice) ? new BigDecimal(tenderListPrice) : null); // 投标清单单价
                    }

//                    if(!TextUtils.isEmpty(quotaDesignBudgetTotal) && !NumberUtil.isNumber(quotaDesignBudgetTotal)){
//                        contrastanalysisdetailVO.setErrorMsg("限额设计预算合价格式不正确！");
//                        errorsMsgBuilder.append("限额设计预算合价格式不正确！");
//                    }else {
//                        contrastanalysisdetailVO.setQuotaDesignBudgetTotal(StringUtils.isNotBlank(quotaDesignBudgetTotal) ? new BigDecimal(quotaDesignBudgetTotal) : null); // 限额设计预算合价
//                    }
//
//                    if(!TextUtils.isEmpty(quotaDesignBudgetPrice) && !NumberUtil.isNumber(quotaDesignBudgetPrice)){
//                        contrastanalysisdetailVO.setErrorMsg("限额设计预算单位造价格式不正确！");
//                        errorsMsgBuilder.append("限额设计预算单位造价格式不正确！");
//                    }else {
//                        contrastanalysisdetailVO.setQuotaDesignBudgetPrice(StringUtils.isNotBlank(quotaDesignBudgetPrice) ? new BigDecimal(quotaDesignBudgetPrice) : null); // 限额设计预算单价
//                    }
//
//                    if(!TextUtils.isEmpty(designBugetEstimateTotal) && !NumberUtil.isNumber(designBugetEstimateTotal)){
//                        contrastanalysisdetailVO.setErrorMsg("设计概算合价格式不正确！");
//                        errorsMsgBuilder.append("设计概算合价格式不正确！");
//                    }else {
//                        contrastanalysisdetailVO.setDesignBugetEstimateTotal(StringUtils.isNotBlank(designBugetEstimateTotal) ? new BigDecimal(designBugetEstimateTotal) : null); // 设计概算合价
//                    }
//
//                    if(!TextUtils.isEmpty(designBugetEstimatePrice) && !NumberUtil.isNumber(designBugetEstimatePrice)){
//                        contrastanalysisdetailVO.setErrorMsg("设计概算单位造价格式不正确！");
//                        errorsMsgBuilder.append("设计概算单位造价格式不正确！");
//                    }else {
//                        contrastanalysisdetailVO.setDesignBugetEstimatePrice(StringUtils.isNotBlank(designBugetEstimatePrice) ? new BigDecimal(designBugetEstimatePrice) : null); // 设计概算单价
//                    }
//
//                    if(!TextUtils.isEmpty(constructionBugetEstimateTotal) && !NumberUtil.isNumber(constructionBugetEstimateTotal)){
//                        contrastanalysisdetailVO.setErrorMsg("施工图预算合价格式不正确！");
//                        errorsMsgBuilder.append("施工图预算合价格式不正确！");
//                    }else {
//                        contrastanalysisdetailVO.setConstructionBugetEstimateTotal(StringUtils.isNotBlank(constructionBugetEstimateTotal) ? new BigDecimal(constructionBugetEstimateTotal) : null); // 施工图预算合价
//                    }
//
//                    if(!TextUtils.isEmpty(constructionBugetEstimatePrice) && !NumberUtil.isNumber(constructionBugetEstimatePrice)){
//                        contrastanalysisdetailVO.setErrorMsg("施工图预算单位造价格式不正确！");
//                        errorsMsgBuilder.append("施工图预算单位造价格式不正确！");
//                    }else {
//                        contrastanalysisdetailVO.setConstructionBugetEstimatePrice(StringUtils.isNotBlank(constructionBugetEstimatePrice) ? new BigDecimal(constructionBugetEstimatePrice) : null); // 施工图预算单价
//                    }

                    //校验固定列
                    String currentKey = sort + code + name;
                    if(proIndex < grabVos.size()){
                        if(grabMap.get(currentKey) == null){
                            contrastanalysisdetailVO.setErrorMsg("序号、清单编码、工程名称或费用名称，不允许修改！");
                            errorsMsgBuilder.append("序号、清单编码、工程名称或费用名称，不允许修改！");
                        }else {
                            ChangeContrastanalysisdetailVO grabVo = grabMap.get(currentKey);
                            BigDecimal grabQuataDesignTotal = grabVo.getQuataDesignTotal();//限额设计阶段
                            BigDecimal grabDesignBugetEstimate = grabVo.getDesignBugetEstimate();//设计概算阶段
                            BigDecimal grabConstructionBugetEstimate = grabVo.getConstructionBugetEstimate();//施工图预算阶段
                            BigDecimal grabQuotaDesignBudgetTotal = grabVo.getQuotaDesignBudgetTotal();//限额设计预算合价
                            BigDecimal grabQuotaDesignBudgetPrice = grabVo.getQuotaDesignBudgetPrice();//限额设计预算单价
                            BigDecimal grabDesignBugetEstimateTotal = grabVo.getDesignBugetEstimateTotal();//设计概算合价
                            BigDecimal grabDesignBugetEstimatePrice = grabVo.getDesignBugetEstimatePrice();//设计概算单价
                            BigDecimal grabConstructionBugetEstimateTotal = grabVo.getConstructionBugetEstimateTotal();//施工图预算合价
                            BigDecimal grabConstructionBugetEstimatePrice = grabVo.getConstructionBugetEstimatePrice();//施工图预算单价

                            //抓取的数据，以系统为准
                            contrastanalysisdetailVO.setQuataDesignTotal(grabQuataDesignTotal);
                            contrastanalysisdetailVO.setDesignBugetEstimate(grabDesignBugetEstimate);
                            contrastanalysisdetailVO.setConstructionBugetEstimate(grabConstructionBugetEstimate);
                            contrastanalysisdetailVO.setQuotaDesignBudgetTotal(grabQuotaDesignBudgetTotal);
                            contrastanalysisdetailVO.setQuotaDesignBudgetPrice(grabQuotaDesignBudgetPrice);
                            contrastanalysisdetailVO.setDesignBugetEstimateTotal(grabDesignBugetEstimateTotal);
                            contrastanalysisdetailVO.setDesignBugetEstimatePrice(grabDesignBugetEstimatePrice);
                            contrastanalysisdetailVO.setDesignBugetEstimateTotal(grabDesignBugetEstimateTotal);
                            contrastanalysisdetailVO.setConstructionBugetEstimateTotal(grabConstructionBugetEstimateTotal);
                            contrastanalysisdetailVO.setConstructionBugetEstimatePrice(grabConstructionBugetEstimatePrice);
                        }
                    }else {
                        contrastanalysisdetailVO.setErrorMsg("不允许新增行！");
                        errorsMsgBuilder.append("不允许新增行！");
                    }

                    if(errorsMsgBuilder.length() > 0){
                        errorList.add(contrastanalysisdetailVO);
                    }else {
                        successList.add(contrastanalysisdetailVO);
                    }
                }
            }
        }

        //构建树
        List<ChangeContrastanalysisdetailVO> resList = createTreeData(successList);

        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());

        ChangeContrastanalysistVO resVo = new ChangeContrastanalysistVO();
        json.put("total", getTotalAmount(resList, resVo));

        return CommonResponse.success(json);
    }

    /**
     * 构建树
     *
     * @param list
     * @return
     */
    public static List<ChangeContrastanalysisdetailVO> createTreeData(List<ChangeContrastanalysisdetailVO> list) {
        List<ChangeContrastanalysisdetailVO> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();

        //循环list，放入listMap重
        Map<String, ChangeContrastanalysisdetailVO> listMap = new HashMap<>();
        for (ChangeContrastanalysisdetailVO item : list) {
            listMap.put(item.getTid().toString(), item);
        }

        for (int i = 0; i < list.size(); i++) {
            ChangeContrastanalysisdetailVO item = list.get(i);
            String parentId = (item.getTpid() != null) ? item.getTpid().toString() : "";
            ChangeContrastanalysisdetailVO parent = listMap.get(parentId);
            if (parent != null) {
                List<ChangeContrastanalysisdetailVO> child = (List<ChangeContrastanalysisdetailVO>) parent.getChildren();
                if (child != null) {
                    child.add(item);
                } else {
                    List<ChangeContrastanalysisdetailVO> children = new ArrayList<ChangeContrastanalysisdetailVO>();
                    children.add(item);
                    parent.setChildren(children);
                }
            } else {
                rootItems.add(item.getTid());
            }
        }

        for (String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }

    private ChangeContrastanalysistVO getTotalAmount(List<ChangeContrastanalysisdetailVO> vos, ChangeContrastanalysistVO resVo) {
        BigDecimal tenderTotal = new BigDecimal(0);//投标阶段合计
        BigDecimal quotaTotal = new BigDecimal(0);//限额设计阶段合计
        BigDecimal budgetEstimateTotal = new BigDecimal(0);//设计概算阶段合计
        BigDecimal constructionTotal = new BigDecimal(0);//施工图预算阶段合计

        for (ChangeContrastanalysisdetailVO vo : vos) {
            if (vo.getTenderListTotal() != null) {
                tenderTotal = tenderTotal.add(vo.getTenderListTotal());
            }
            if (vo.getQuotaDesignBudgetTotal() != null) {
                quotaTotal = quotaTotal.add(vo.getQuotaDesignBudgetTotal());
            }
            if (vo.getDesignBugetEstimateTotal() != null) {
                budgetEstimateTotal = budgetEstimateTotal.add(vo.getDesignBugetEstimateTotal());
            }
            if (vo.getConstructionBugetEstimateTotal() != null) {
                constructionTotal = constructionTotal.add(vo.getConstructionBugetEstimateTotal());
            }
        }

        resVo.setTenderTotal(tenderTotal);
        resVo.setQuotaTotal(quotaTotal);
        resVo.setBudgetEstimateTotal(budgetEstimateTotal);
        resVo.setConstructionTotal(constructionTotal);
        return resVo;
    }

    //清单编码规则定死------分别是2位/4位/6位/6为以上
    private Long setPid(String pcode, Map<String, ChangeContrastanalysisdetailVO> map) {
        if (map.get(pcode) != null) {
            return Long.valueOf(map.get(pcode).getTid());
        } else {
            //父级没有找到，则继续往上找
            if (pcode.length() == 2) {
                //最上级
                return null;
            } else if (pcode.length() == 4) {
                String ppcode = pcode.substring(0, 2);
                return this.setPid(ppcode, map);
            } else if (pcode.length() == 6) {
                String ppcode = pcode.substring(0, 4);
                return this.setPid(ppcode, map);
            } else if (pcode.length() > 6) {
                String ppcode = pcode.substring(0, 6);
                return this.setPid(ppcode, map);
            } else {
                return null;
            }
        }
    }

    /**
     * excel导出数据库数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportContrastanalysisFromDatabase", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportContrastanalysisFromDatabase(@RequestBody ChangeContrastanalysisdetailVO changeContrastanalysisdetailVO, HttpServletResponse response) {
        QueryWrapper<ChangeContrastanalysisdetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("mid", changeContrastanalysisdetailVO.getMid());
        queryWrapper.eq("dr", 0);
        queryWrapper.orderByAsc("sort");
        List<ChangeContrastanalysisdetailEntity> list = changeContrastanalysisdetailService.list(queryWrapper);
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("contrastanalysisdetail-export.xlsx", beans, response);
    }

    /**
     * excel导出页面数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportContrastanalysisFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportContrastanalysisFromPage(@RequestBody List<ChangeContrastanalysisdetailVO> list, HttpServletResponse response) {
        List<ChangeContrastanalysisdetailVO> concatList = new ArrayList<>();
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); i++) {
                ChangeContrastanalysisdetailVO contrastanalysisdetailVO = list.get(i);
                concatList.add(contrastanalysisdetailVO);
            }
        }

        //children拍平
        List<ChangeContrastanalysisdetailVO> allList = handleList(list, concatList);
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", allList);
        ExcelExport.getInstance().export("contrastanalysisdetail-export.xlsx", beans, response);
    }

    /**
     * 导出页面数据处理children
     *
     * @param list
     */
    private List<ChangeContrastanalysisdetailVO> handleList(List<ChangeContrastanalysisdetailVO> list, List<ChangeContrastanalysisdetailVO> concatList) {
        if (list == null || list.size() == 0) {
            return concatList;
        }

        for (int i = 0; i < list.size(); i++) {
            ChangeContrastanalysisdetailVO contrastanalysisdetailVO = list.get(i);
            List<ChangeContrastanalysisdetailVO> children = contrastanalysisdetailVO.getChildren();
            if (children != null && children.size() > 0) {
                concatList.addAll(children);
                handleList(children, concatList);
            }
        }

        //按子目编码排序
        Collections.sort(concatList, new Comparator<ChangeContrastanalysisdetailVO>() {
            @Override
            public int compare(ChangeContrastanalysisdetailVO o1, ChangeContrastanalysisdetailVO o2) {
                return o1.getSort().compareTo(o2.getSort());
            }
        });

        return concatList;
    }
}
