package com.ejianc.business.change.excel;

import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bedget.vo.DesignestimateVO;
import com.ejianc.business.bedget.vo.DesignestimatedetailVO;
import com.ejianc.business.change.bean.ChangedesignestimatedetailEntity;
import com.ejianc.business.change.service.IChangedesignestimatedetailService;
import com.ejianc.business.change.vo.ChangedesignestimateVO;
import com.ejianc.business.change.vo.ChangedesignestimatedetailVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.util.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 设计概算清单导入导出
 */
@Controller
@RequestMapping("changeDesignestimateExport")
public class ExeclChangeDesignestimateController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IChangedesignestimatedetailService changedesignestimatedetailService;

    /**
     * 导入模板下载
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloaddesignestimate")
    @ResponseBody
    public void downloaddesignestimate(HttpServletRequest request, HttpServletResponse response){
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "designestimatedetail-import.xlsx", "施工图预算材料分析清单模板");
    }

    /**
     * excel导入
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelImportdesignestimate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportdesignestimate(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<ChangedesignestimatedetailVO> successList = new ArrayList<>();
        List<ChangedesignestimatedetailVO> errorList = new ArrayList<>();
        Map<String, ChangedesignestimatedetailVO> map = new HashMap<>();
        DateFormat sdf=new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if(isFailed) {
            return CommonResponse.error("文件格式不合法");
        }else{
            List<List<String>> result = ExcelReader.readExcel(mf);
            if(result != null && result.size() > 0) {
                for(int i=2;i<result.size();i++) {
                    List<String> datas = result.get(i);
                    StringBuilder errorsMsgBuilder = new StringBuilder();

                    String sonItemCode = datas.get(0);
                    String sonItemName = datas.get(1);
                    String projectCost = datas.get(2);
                    String costPercent = datas.get(3);
                    String projectScale = datas.get(4);
                    String unitCost = datas.get(5);
                    String budgeTotal = datas.get(6);
                    String laborCost = datas.get(7);
                    String materialCost = datas.get(8);
                    String machineryCost = datas.get(9);
                    String businessManagerCost = datas.get(10);
                    String profit = datas.get(11);
                    String measureItemsTotal = datas.get(12);
                    String safeCivilizedConstructionCost = datas.get(13);
                    String transportConsumeCost = datas.get(14);
                    String scatteredExpenseseTotal = datas.get(15);
                    String feesTotal = datas.get(16);
                    String taxTotal = datas.get(17);
                    ChangedesignestimatedetailVO changedesignestimatedetailVO = new ChangedesignestimatedetailVO();
                    changedesignestimatedetailVO.setId(IdWorker.getId());//id

                    changedesignestimatedetailVO.setTid(String.valueOf(IdWorker.getId()));//tid
                    changedesignestimatedetailVO.setSonItemCode(StringUtils.isNotBlank(sonItemCode)? sonItemCode:null); // 编码
                    changedesignestimatedetailVO.setSonItemName(StringUtils.isNotBlank(sonItemName)?sonItemName:null); // 名称

                    //必填项校验
                    if(StringUtils.isEmpty(sonItemCode)) {
                        changedesignestimatedetailVO.setErrorMsg("编号不能为空！");
                        errorsMsgBuilder.append("编号不能为空！");
                    }
                    if(StringUtils.isEmpty(sonItemName)) {
                        changedesignestimatedetailVO.setErrorMsg("名称不能为空！");
                        errorsMsgBuilder.append("名称不能为空！");
                    }

                    String innercode = changedesignestimatedetailVO.getSonItemCode();
                    if(innercode != null){
                        changedesignestimatedetailVO.setInnercode(innercode);
                        if("01".equals(changedesignestimatedetailVO.getSonItemCode())&&changedesignestimatedetailVO.getSonItemName().contains("装饰")){
                            innercode = "a1";
                        }
                        //判断是否是装饰工程的子节点编码
                        if (changedesignestimatedetailVO.getSonItemCode() != null && changedesignestimatedetailVO.getSonItemCode().length() >= 4) {
                            //0111、0112、0113、0114、0115这五个节点都是装饰工程下的
                            String code = changedesignestimatedetailVO.getSonItemCode().substring(0, 4);
                            if ("0111".equals(code) || "0112".equals(code) || "0113".equals(code) || "0114".equals(code) || "0115".equals(code)) {
                                //若是的话，将内码改为a1xx
                                innercode = "a1" + changedesignestimatedetailVO.getSonItemCode().substring(2, changedesignestimatedetailVO.getSonItemCode().length());
                            }
                        }
                        changedesignestimatedetailVO.setInnercode(innercode);

                        //1、校验编码是否符合规则--2、4、6、9、9以上
                        if (sonItemCode == null || !(sonItemCode.length() == 2 || sonItemCode.length() == 4 || sonItemCode.length() == 6)) {
                            changedesignestimatedetailVO.setErrorMsg("子目编码必须符合：2位、4位、6位中任意一规则！");
                            errorsMsgBuilder.append("子目编码必须符合：2位、4位、6位中任意一规则！");
                        }

                        //重复性校验
                        ChangedesignestimatedetailVO mapVO = map.get(changedesignestimatedetailVO.getInnercode());
                        if(mapVO == null){
                            map.put(changedesignestimatedetailVO.getInnercode(), changedesignestimatedetailVO);
                        }else {
                            changedesignestimatedetailVO.setErrorMsg("子目编码已存在！");
                            errorsMsgBuilder.append("子目编码已存在！");
                        }
                    }

                    //格式校验
                    if(!TextUtils.isEmpty(projectCost) && !NumberUtil.isNumber(projectCost)){
                        changedesignestimatedetailVO.setErrorMsg("项目造价格式不正确！");
                        errorsMsgBuilder.append("项目造价格式不正确！");
                    }else {
                        changedesignestimatedetailVO.setProjectCost(StringUtils.isNotBlank(projectCost) ? new BigDecimal(projectCost) : null);
                    }

                    if(!TextUtils.isEmpty(costPercent) && !NumberUtil.isNumber(costPercent)){
                        changedesignestimatedetailVO.setErrorMsg("占造价百分比格式不正确！");
                        errorsMsgBuilder.append("占造价百分比格式不正确！");
                    }else {
                        changedesignestimatedetailVO.setCostPercent(StringUtils.isNotBlank(costPercent) ? new BigDecimal(costPercent) : null);
                    }


                    if(!TextUtils.isEmpty(projectScale) && !NumberUtil.isNumber(projectScale)){
                        changedesignestimatedetailVO.setErrorMsg("工程规模格式不正确！");
                        errorsMsgBuilder.append("工程规模格式不正确！");
                    }else {
                        changedesignestimatedetailVO.setProjectScale(StringUtils.isNotBlank(projectScale)?new BigDecimal(projectScale):null); // 工程规模(m²或m)
                    }

                    if(!TextUtils.isEmpty(unitCost) && !NumberUtil.isNumber(unitCost)){
                        changedesignestimatedetailVO.setErrorMsg("单位造价格式不正确！");
                        errorsMsgBuilder.append("单位造价格式不正确！");
                    }else {
                        changedesignestimatedetailVO.setUnitCost(StringUtils.isNotBlank(unitCost)?new BigDecimal(unitCost):null); // 单位造价(元/m²或元/m)
                    }

                    if(!TextUtils.isEmpty(budgeTotal) && !NumberUtil.isNumber(budgeTotal)){
                        changedesignestimatedetailVO.setErrorMsg("预算合计格式不正确！");
                        errorsMsgBuilder.append("预算合计格式不正确！");
                    }else {
                        changedesignestimatedetailVO.setBudgeTotal(StringUtils.isNotBlank(datas.get(6))?new BigDecimal(datas.get(6)):null); // 预算合计
                    }

                    if(!TextUtils.isEmpty(laborCost) && !NumberUtil.isNumber(laborCost)){
                        changedesignestimatedetailVO.setErrorMsg("人工费格式不正确！");
                        errorsMsgBuilder.append("人工费格式不正确！");
                    }else {
                        changedesignestimatedetailVO.setLaborCost(StringUtils.isNotBlank(laborCost)?new BigDecimal(laborCost):null); // 人工费
                    }

                    if(!TextUtils.isEmpty(materialCost) && !NumberUtil.isNumber(materialCost)){
                        changedesignestimatedetailVO.setErrorMsg("材料费格式不正确！");
                        errorsMsgBuilder.append("材料费格式不正确！");
                    }else {
                        changedesignestimatedetailVO.setMaterialCost(StringUtils.isNotBlank(materialCost) ? new BigDecimal(materialCost) : null); // 材料费
                    }

                    if(!TextUtils.isEmpty(machineryCost) && !NumberUtil.isNumber(machineryCost)){
                        changedesignestimatedetailVO.setErrorMsg("机械费格式不正确！");
                        errorsMsgBuilder.append("机械费格式不正确！");
                    }else {
                        changedesignestimatedetailVO.setMachineryCost(StringUtils.isNotBlank(datas.get(10))?new BigDecimal(datas.get(10)):null); // 机械费
                    }

                    if(!TextUtils.isEmpty(businessManagerCost) && !NumberUtil.isNumber(businessManagerCost)){
                        changedesignestimatedetailVO.setErrorMsg("企业管理费格式不正确！");
                        errorsMsgBuilder.append("企业管理费格式不正确！");
                    }else {
                        changedesignestimatedetailVO.setBusinessManagerCost(StringUtils.isNotBlank(businessManagerCost)?new BigDecimal(businessManagerCost):null); // 企业管理费
                    }

                    if(!TextUtils.isEmpty(profit) && !NumberUtil.isNumber(profit)){
                        changedesignestimatedetailVO.setErrorMsg("利润格式不正确！");
                        errorsMsgBuilder.append("利润格式不正确！");
                    }else {
                        changedesignestimatedetailVO.setProfit(StringUtils.isNotBlank(profit)?new BigDecimal(profit):null); // 利润
                    }

                    if(!TextUtils.isEmpty(measureItemsTotal) && !NumberUtil.isNumber(measureItemsTotal)){
                        changedesignestimatedetailVO.setErrorMsg("措施项目合计格式不正确！");
                        errorsMsgBuilder.append("措施项目合计格式不正确！");
                    }else {
                        changedesignestimatedetailVO.setMeasureItemsTotal(StringUtils.isNotBlank(measureItemsTotal)?new BigDecimal(measureItemsTotal):null); // 措施项目合计
                    }

                    if(!TextUtils.isEmpty(safeCivilizedConstructionCost) && !NumberUtil.isNumber(safeCivilizedConstructionCost)){
                        changedesignestimatedetailVO.setErrorMsg("安全文明施工费格式不正确！");
                        errorsMsgBuilder.append("安全文明施工费格式不正确！");
                    }else {
                        changedesignestimatedetailVO.setSafeCivilizedConstructionCost(StringUtils.isNotBlank(safeCivilizedConstructionCost)?new BigDecimal(safeCivilizedConstructionCost):null); // 安全文明施工费
                    }

                    if(!TextUtils.isEmpty(transportConsumeCost) && !NumberUtil.isNumber(transportConsumeCost)){
                        changedesignestimatedetailVO.setErrorMsg("其中:施工垃圾场外运输和消纳费格式不正确！");
                        errorsMsgBuilder.append("其中:施工垃圾场外运输和消纳费格式不正确！");
                    }else {
                        changedesignestimatedetailVO.setTransportConsumeCost(StringUtils.isNotBlank(transportConsumeCost)?new BigDecimal(transportConsumeCost):null); // 其中:施工垃圾场外运输和消纳费
                    }

                    if(!TextUtils.isEmpty(scatteredExpenseseTotal) && !NumberUtil.isNumber(scatteredExpenseseTotal)){
                        changedesignestimatedetailVO.setErrorMsg("零星工程费格式不正确！");
                        errorsMsgBuilder.append("零星工程费格式不正确！");
                    }else {
                        changedesignestimatedetailVO.setScatteredExpenseseTotal(StringUtils.isNotBlank(scatteredExpenseseTotal)?new BigDecimal(scatteredExpenseseTotal):null); //零星工程费
                    }

                    if(!TextUtils.isEmpty(feesTotal) && !NumberUtil.isNumber(feesTotal)){
                        changedesignestimatedetailVO.setErrorMsg("规费合计格式不正确！");
                        errorsMsgBuilder.append("规费合计格式不正确！");
                    }else {
                        changedesignestimatedetailVO.setFeesTotal(StringUtils.isNotBlank(feesTotal)?new BigDecimal(feesTotal):null); // 规费合计
                    }

                    if(!TextUtils.isEmpty(taxTotal) && !NumberUtil.isNumber(taxTotal)){
                        changedesignestimatedetailVO.setErrorMsg("税金格式不正确！");
                        errorsMsgBuilder.append("税金格式不正确！");
                    }else {
                        changedesignestimatedetailVO.setTaxTotal(StringUtils.isNotBlank(taxTotal)?new BigDecimal(taxTotal):null); //税金
                    }

                    if(errorsMsgBuilder.length() > 0){
                        errorList.add(changedesignestimatedetailVO);
                    }else {
                        successList.add(changedesignestimatedetailVO);
                    }
                }
            }
        }

        //按子目编码排序
        Collections.sort(successList, new Comparator<ChangedesignestimatedetailVO>() {
            @Override
            public int compare(ChangedesignestimatedetailVO o1, ChangedesignestimatedetailVO o2) {
                return o1.getSonItemCode().compareTo(o2.getSonItemCode());
            }
        });

        //设置tid和tpid
        List<ChangedesignestimatedetailVO> resList = setTidAndTpid(successList, map);

        //构建树
        resList = createTreeData(resList);

        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", resList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());

        ChangedesignestimateVO resVo = new ChangedesignestimateVO();
        json.put("total", getTotalAmount(resList, resVo));

        return CommonResponse.success(json);
    }

    //子目编码规则定死------分别是2位/4位/6位/6为以上
    private Long setPid(String pcode, Map<String, ChangedesignestimatedetailVO> map) {
        if (map.get(pcode) != null) {
            return Long.valueOf(map.get(pcode).getTid());
        } else {
            //父级没有找到，则继续往上找
            if (pcode.length() == 2) {
                //最上级
                return null;
            } else if (pcode.length() == 4) {
                String ppcode = pcode.substring(0, 2);
                return this.setPid(ppcode, map);
            } else if (pcode.length() == 6) {
                String ppcode = pcode.substring(0, 4);
                return this.setPid(ppcode, map);
            } else if (pcode.length() > 6) {
                String ppcode = pcode.substring(0, 6);
                return this.setPid(ppcode, map);
            } else {
                return null;
            }
        }
    }

    /**
     * 设置tid和tpid
     *
     * @param vos
     * @param map
     * @return
     */
    private List<ChangedesignestimatedetailVO> setTidAndTpid(List<ChangedesignestimatedetailVO> vos, Map<String, ChangedesignestimatedetailVO> map) {
        if(vos == null){
            return null;
        }

        for (int i = 0; i < vos.size(); i++) {
            ChangedesignestimatedetailVO designestimatedetailVO = vos.get(i);
            //设置父级id
            String innercode = designestimatedetailVO.getInnercode();

            Long pid = null;
            if (innercode.length() == 2) {
                //最上级
            } else if (innercode.length() == 4) {
                String pcode = innercode.substring(0, 2);
                //有父节点
                pid = this.setPid(pcode, map);
            } else if (innercode.length() == 6) {
                String pcode = innercode.substring(0, 4);
                //有父节点
                pid = this.setPid(pcode, map);
            } else if (innercode.length() > 6) {
                String pcode = innercode.substring(0, 6);
                //有父节点
                pid = this.setPid(pcode, map);
            }

            if (pid != null) {
                designestimatedetailVO.setTpid(pid.toString());
            } else {
                designestimatedetailVO.setTpid("");
            }
        }

        return vos;
    }

    /**
     * 构建树
     *
     * @param list
     * @return
     */
    public static List<ChangedesignestimatedetailVO> createTreeData(List<ChangedesignestimatedetailVO> list) {
        List<ChangedesignestimatedetailVO> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();

        //循环list，放入listMap重
        Map<String, ChangedesignestimatedetailVO> listMap = new HashMap<>();
        for (ChangedesignestimatedetailVO item : list) {
            listMap.put(item.getTid().toString(), item);
        }

        for (int i = 0; i < list.size(); i++) {
            ChangedesignestimatedetailVO item = list.get(i);
            String parentId = (item.getTpid() != null) ? item.getTpid().toString() : "";
            ChangedesignestimatedetailVO parent = listMap.get(parentId);
            if (parent != null) {
                List<ChangedesignestimatedetailVO> child = (List<ChangedesignestimatedetailVO>) parent.getChildren();
                if (child != null) {
                    child.add(item);
                } else {
                    List<ChangedesignestimatedetailVO> children = new ArrayList<ChangedesignestimatedetailVO>();
                    children.add(item);
                    parent.setChildren(children);
                }
            } else {
                rootItems.add(item.getTid());
            }
        }

        for (String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }

    private ChangedesignestimateVO getTotalAmount(List<ChangedesignestimatedetailVO> vos, ChangedesignestimateVO resVo) {
        BigDecimal designEstimateTotal = new BigDecimal(0);//设计概算合计
        BigDecimal budgeTotal = new BigDecimal(0);//预算书合计
        BigDecimal measureItemsTotal = new BigDecimal(0);//措施项目合计
        BigDecimal scatteredExpenseseTotal = new BigDecimal(0);//零星费用合计
        BigDecimal feesTotal = new BigDecimal(0);//规费合计
        BigDecimal taxTotal = new BigDecimal(0);//税金合计

        for (ChangedesignestimatedetailVO vo : vos) {
            if (vo.getProjectCost() != null) {//项目造价
                designEstimateTotal = designEstimateTotal.add(vo.getProjectCost());
            }
            if (vo.getBudgeTotal() != null) {
                budgeTotal = budgeTotal.add(vo.getBudgeTotal());
            }
            if (vo.getMeasureItemsTotal() != null) {
                measureItemsTotal = measureItemsTotal.add(vo.getMeasureItemsTotal());
            }
            if (vo.getScatteredExpenseseTotal() != null) {
                scatteredExpenseseTotal = scatteredExpenseseTotal.add(vo.getScatteredExpenseseTotal());
            }

            if (vo.getTaxTotal() != null) {
                taxTotal = taxTotal.add(vo.getTaxTotal());
            }

            //规费合计
            if (vo.getFeesTotal() != null) {
                feesTotal = feesTotal.add(vo.getFeesTotal());
            }
        }

        resVo.setDesignEstimateTotal(designEstimateTotal);
        resVo.setBudgeTotal(budgeTotal);
        resVo.setMeasureItemsTotal(measureItemsTotal);
        resVo.setScatteredExpenseseTotal(scatteredExpenseseTotal);
        resVo.setFeesTotal(feesTotal);
        resVo.setTaxTotal(taxTotal);
        return resVo;
    }

    /**
     * excel导出数据库数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportdesignestimateFromDatabase", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportdesignestimateFromDatabase(@RequestBody ChangedesignestimateVO materialanalysisVO, HttpServletResponse response) {
        QueryWrapper<ChangedesignestimatedetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("mid", materialanalysisVO.getId());
        queryWrapper.eq("dr", 0);
        queryWrapper.orderByAsc("son_item_code");
        List<ChangedesignestimatedetailEntity> list = changedesignestimatedetailService.list(queryWrapper);

        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("designestimatedetail-export.xlsx", beans, response);
    }

    /**
     * excel导出页面数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportdesignestimateFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportdesignestimateFromPage(@RequestBody List<ChangedesignestimatedetailVO> list, HttpServletResponse response) {
        List<ChangedesignestimatedetailVO> concatList = new ArrayList<>();
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); i++) {
                ChangedesignestimatedetailVO changedesignestimatedetailVO = list.get(i);
                concatList.add(changedesignestimatedetailVO);
            }
        }

        //children拍平
        List<ChangedesignestimatedetailVO> allList = handleList(list, concatList);
        //按序号排序
        Collections.sort(allList, new Comparator<ChangedesignestimatedetailVO>() {
            @Override
            public int compare(ChangedesignestimatedetailVO o1, ChangedesignestimatedetailVO o2) {
                return o1.getSonItemCode().compareTo(o2.getSonItemCode());
            }
        });

        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("designestimatedetail-export.xlsx", beans, response);
    }

    /**
     * 导出页面数据处理children
     *
     * @param list
     */
    private List<ChangedesignestimatedetailVO> handleList(List<ChangedesignestimatedetailVO> list, List<ChangedesignestimatedetailVO> concatList) {
        if (list == null || list.size() == 0) {
            return concatList;
        }

        for (int i = 0; i < list.size(); i++) {
            ChangedesignestimatedetailVO changedesignestimatedetailVO = list.get(i);
            List<ChangedesignestimatedetailVO> children = changedesignestimatedetailVO.getChildren();
            if (children != null && children.size() > 0) {
                concatList.addAll(children);
                handleList(children, concatList);
            }
        }

        return concatList;
    }

}
