package com.ejianc.business.change.excel;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bedget.bean.QuotadesigndetailEntity;
import com.ejianc.business.bedget.service.IQuotadesigndetailService;
import com.ejianc.business.bedget.vo.QuotadesignVO;
import com.ejianc.business.bedget.vo.QuotadesigndetailVO;
import com.ejianc.business.change.bean.ChangequotadesigndetailEntity;
import com.ejianc.business.change.service.IChangequotadesigndetailService;
import com.ejianc.business.change.vo.ChangequotadesignVO;
import com.ejianc.business.change.vo.ChangequotadesigndetailVO;
import com.ejianc.business.utils.StringFormatUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.util.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 限额设计清单导入导出
 */
@Controller
@RequestMapping("changeQuotadesignExport")
public class ExeclChangeQuotadesignController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    private IChangequotadesigndetailService changequotadesigndetailService;


    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadQuotadesign")
    @ResponseBody
    public void downloadConsdrawbudget(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "quotadesigndetail-import.xlsx", "限额设计清单模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelImportQuotadesign", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportConsdrawbudget(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<ChangequotadesigndetailVO> successList = new ArrayList<>();
        List<ChangequotadesigndetailVO> errorList = new ArrayList<>();
        DateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        Map<String, ChangequotadesigndetailVO> map = new HashMap<>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                for (int i = 2; i < result.size(); i++) {
                    List<String> datas = result.get(i);

                    String sonItemCode = datas.get(0);
                    String engineering = datas.get(4);
                    String labor = datas.get(5);
                    String material = datas.get(6);
                    String mechanical = datas.get(7);
                    String management = datas.get(8);
                    String profit = datas.get(9);
                    String unitPrice = datas.get(10);
                    String shutLabor = datas.get(11);
                    String shutMaterial = datas.get(12);
                    String shutMechanical = datas.get(13);
                    String shutManagement = datas.get(14);
                    String shutProfit = datas.get(15);
                    String shutPrice = datas.get(16);
                    String clubInsurance = datas.get(17);
                    String housing = datas.get(18);
                    String reserved1 = datas.get(19);
                    String reserved2 = datas.get(20);
                    String reserved3 = datas.get(21);
                    String tax = datas.get(22);
                    String estimation = datas.get(23);
                    ChangequotadesigndetailVO changequotadesigndetailVO = new ChangequotadesigndetailVO();
                    changequotadesigndetailVO.setId(IdWorker.getId());//id
                    changequotadesigndetailVO.setTid(String.valueOf(IdWorker.getId()));//tid
                    changequotadesigndetailVO.setSonItemCode(StringUtils.isNotBlank(sonItemCode) ? sonItemCode : null); // 子目编码
                    changequotadesigndetailVO.setSonItemName(StringUtils.isNotBlank(datas.get(1)) ? datas.get(1) : null); // 子目名称
                    changequotadesigndetailVO.setSonItemDescribe(StringUtils.isNotBlank(datas.get(2)) ? datas.get(2) : null); // 子目特征描述
                    changequotadesigndetailVO.setMeasuringUnit(StringUtils.isNotBlank(datas.get(3)) ? datas.get(3) : null); // 计量单位

                    //必填项校验
                    if (changequotadesigndetailVO.getSonItemCode() == null || TextUtils.isEmpty(changequotadesigndetailVO.getSonItemCode())) {
                        changequotadesigndetailVO.setErrorMsg("子目编码不能为空！");
                        errorList.add(changequotadesigndetailVO);
                        continue;
                    }
                    if (changequotadesigndetailVO.getSonItemName() == null || TextUtils.isEmpty(changequotadesigndetailVO.getSonItemName())) {
                        changequotadesigndetailVO.setErrorMsg("子目名称不能为空！");
                        errorList.add(changequotadesigndetailVO);
                        continue;
                    }

                    String innercode = changequotadesigndetailVO.getSonItemCode();
                    changequotadesigndetailVO.setInnercode(innercode);
                    if("01".equals(changequotadesigndetailVO.getSonItemCode())&&changequotadesigndetailVO.getSonItemName().contains("装饰")){
                        innercode = "a1";
                    }
                    //判断是否是装饰工程的子节点编码
                    if (changequotadesigndetailVO.getSonItemCode().length() >= 4) {
                        //0111、0112、0113、0114、0115这五个节点都是装饰工程下的
                        String code = changequotadesigndetailVO.getSonItemCode().substring(0, 4);
                        if ("0111".equals(code) || "0112".equals(code) || "0113".equals(code) || "0114".equals(code) || "0115".equals(code)) {
                            //若是的话，将内码改为a1xx
                            innercode = "a1" + changequotadesigndetailVO.getSonItemCode().substring(2, changequotadesigndetailVO.getSonItemCode().length());
                        }
                    }
                    changequotadesigndetailVO.setInnercode(innercode);

                    Long pid = null;
                    if (innercode.length() == 2) {
                        //最上级
                    } else if (innercode.length() == 4) {
                        String pcode = innercode.substring(0, 2);
                        //有父节点
                        pid = this.setPid(pcode, map);

                    } else if (innercode.length() == 6) {
                        String pcode = innercode.substring(0, 4);
                        //有父节点
                        pid = this.setPid(pcode, map);
                    } else if (innercode.length() > 6) {
                        String pcode = innercode.substring(0, 6);
                        //有父节点
                        pid = this.setPid(pcode, map);
                    }

                    if (pid != null) {
                        changequotadesigndetailVO.setTpid(pid.toString());
                    } else {
                        changequotadesigndetailVO.setTpid("");
                    }

                    //1、校验编码是否符合规则--2、4、6、9、9以上
                    if (sonItemCode == null || !(sonItemCode.length() == 2 || sonItemCode.length() == 4 || sonItemCode.length() == 6 || sonItemCode.length() >= 9)) {
                        changequotadesigndetailVO.setErrorMsg("子目编码必须符合：2位、4位、6位、9位或9位以上中任意一规则");
                        errorList.add(changequotadesigndetailVO);
                        continue;
                    }

                    //重复性校验
                    ChangequotadesigndetailVO mapVO = map.get(changequotadesigndetailVO.getInnercode());
                    if(mapVO == null){
                        map.put(changequotadesigndetailVO.getInnercode(), changequotadesigndetailVO);
                    }else {
                        changequotadesigndetailVO.setErrorMsg("子目编码已存在");
                        errorList.add(changequotadesigndetailVO);
                        continue;
                    }

                    //格式校验
                    if(!TextUtils.isEmpty(engineering) && !StringFormatUtil.validateNumber(engineering)){
                        changequotadesigndetailVO.setErrorMsg("工程量格式不正确！");
                        errorList.add(changequotadesigndetailVO);
                        continue;
                    }else {
                        changequotadesigndetailVO.setEngineering(StringUtils.isNotBlank(engineering) ? new BigDecimal(engineering) : null); // 工程量
                    }

                    if(!TextUtils.isEmpty(labor) && !StringFormatUtil.validateNumber(labor)){
                        changequotadesigndetailVO.setErrorMsg("人工费（单价）格式不正确！");
                        errorList.add(changequotadesigndetailVO);
                        continue;
                    }else {
                        changequotadesigndetailVO.setLabor(StringUtils.isNotBlank(labor) ? new BigDecimal(labor) : null); // 人工费(单价)
                    }

                    if(!TextUtils.isEmpty(material) && !StringFormatUtil.validateNumber(material)){
                        changequotadesigndetailVO.setErrorMsg("材料费（单价）格式不正确！");
                        errorList.add(changequotadesigndetailVO);
                        continue;
                    }else {
                        changequotadesigndetailVO.setMaterial(StringUtils.isNotBlank(material) ? new BigDecimal(material) : null); // 材料费(单价)
                    }

                    if(!TextUtils.isEmpty(mechanical) && !StringFormatUtil.validateNumber(mechanical)){
                        changequotadesigndetailVO.setErrorMsg("机械费（单价）格式不正确！");
                        errorList.add(changequotadesigndetailVO);
                        continue;
                    }else {
                        changequotadesigndetailVO.setMechanical(StringUtils.isNotBlank(mechanical) ? new BigDecimal(mechanical) : null); // 机械费(单价)
                    }

                    if(!TextUtils.isEmpty(management) && !StringFormatUtil.validateNumber(management)){
                        changequotadesigndetailVO.setErrorMsg("企业管理费（单价）格式不正确！");
                        errorList.add(changequotadesigndetailVO);
                        continue;
                    }else {
                        changequotadesigndetailVO.setManagement(StringUtils.isNotBlank(management) ? new BigDecimal(management) : null); // 企业管理费(单价)
                    }

                    if(!TextUtils.isEmpty(profit) && !StringFormatUtil.validateNumber(profit)){
                        changequotadesigndetailVO.setErrorMsg("利润（单价）格式不正确！");
                        errorList.add(changequotadesigndetailVO);
                        continue;
                    }else {
                        changequotadesigndetailVO.setProfit(StringUtils.isNotBlank(profit) ? new BigDecimal(profit) : null); // 利润(单价)
                    }

                    if(StringUtils.isNotBlank(unitPrice)){
                        if(!StringFormatUtil.validateNumber(unitPrice)){
                            changequotadesigndetailVO.setErrorMsg("综合单价格式不正确！");
                            errorList.add(changequotadesigndetailVO);
                            continue;
                        }else {
                            changequotadesigndetailVO.setUnitPrice(new BigDecimal(unitPrice));
                        }
                    }else {//为空，则系统计算
                        BigDecimal unitPriceB = new BigDecimal(0);
                        BigDecimal laborB = changequotadesigndetailVO.getLabor();
                        BigDecimal materialB = changequotadesigndetailVO.getMaterial();
                        BigDecimal mechanicalB = changequotadesigndetailVO.getMechanical();
                        BigDecimal managementB = changequotadesigndetailVO.getManagement();
                        BigDecimal profitB = changequotadesigndetailVO.getProfit();

                        if(laborB != null){
                            unitPriceB = unitPriceB.add(laborB);
                        }
                        if(materialB != null){
                            unitPriceB = unitPriceB.add(materialB);
                        }
                        if(mechanicalB != null){
                            unitPriceB = unitPriceB.add(mechanicalB);
                        }
                        if(managementB != null){
                            unitPriceB = unitPriceB.add(managementB);
                        }
                        if(profitB != null){
                            unitPriceB = unitPriceB.add(profitB);
                        }
                        changequotadesigndetailVO.setUnitPrice(unitPriceB);
                    }

                    if(StringUtils.isNotBlank(shutLabor)){
                        if(!StringFormatUtil.validateNumber(shutLabor)){
                            changequotadesigndetailVO.setErrorMsg("人工费（合价）格式不正确！");
                            errorList.add(changequotadesigndetailVO);
                            continue;
                        }else {
                            changequotadesigndetailVO.setShutLabor(new BigDecimal(shutLabor));
                        }
                    }else {
                        BigDecimal shutLaborB = new BigDecimal(0);
                        BigDecimal engineeringB = changequotadesigndetailVO.getEngineering();
                        BigDecimal laborB = changequotadesigndetailVO.getLabor();
                        if(engineeringB != null && laborB != null){
                            shutLaborB = engineeringB.multiply(laborB);
                            changequotadesigndetailVO.setShutLabor(shutLaborB);
                        }
                    }

                    if(StringUtils.isNotBlank(shutMaterial)){
                        if(!StringFormatUtil.validateNumber(shutMaterial)){
                            changequotadesigndetailVO.setErrorMsg("材料费（合价）格式不正确！");
                            errorList.add(changequotadesigndetailVO);
                            continue;
                        }else {
                            changequotadesigndetailVO.setShutMaterial(new BigDecimal(shutMaterial));
                        }
                    }else {
                        BigDecimal shutMaterialB = new BigDecimal(0);
                        BigDecimal engineeringB = changequotadesigndetailVO.getEngineering();
                        BigDecimal materialB = changequotadesigndetailVO.getMaterial();
                        if(engineeringB != null && materialB != null){
                            shutMaterialB = engineeringB.multiply(materialB);
                            changequotadesigndetailVO.setShutMaterial(shutMaterialB);
                        }
                    }

                    if(StringUtils.isNotBlank(shutMechanical)){
                        if(!StringFormatUtil.validateNumber(shutMechanical)){
                            changequotadesigndetailVO.setErrorMsg("机械费（合价）格式不正确！");
                            errorList.add(changequotadesigndetailVO);
                            continue;
                        }else {
                            changequotadesigndetailVO.setShutMechanical(new BigDecimal(shutMechanical));
                        }
                    }else {
                        BigDecimal shutMechanicalB = new BigDecimal(0);
                        BigDecimal engineeringB = changequotadesigndetailVO.getEngineering();
                        BigDecimal mechanicalB = changequotadesigndetailVO.getMechanical();
                        if(engineeringB != null && mechanicalB != null){
                            shutMechanicalB = engineeringB.multiply(mechanicalB);
                            changequotadesigndetailVO.setShutMechanical(shutMechanicalB);
                        }
                    }

                    if(StringUtils.isNotBlank(shutManagement)){
                        if(!StringFormatUtil.validateNumber(shutManagement)){
                            changequotadesigndetailVO.setErrorMsg("企业管理费（合价）格式不正确！");
                            errorList.add(changequotadesigndetailVO);
                            continue;
                        }else {
                            changequotadesigndetailVO.setShutManagement(new BigDecimal(shutManagement));
                        }
                    }else {
                        BigDecimal shutManagementB = new BigDecimal(0);
                        BigDecimal engineeringB = changequotadesigndetailVO.getEngineering();
                        BigDecimal managementB = changequotadesigndetailVO.getManagement();
                        if(engineeringB != null && managementB != null){
                            shutManagementB = engineeringB.multiply(managementB);
                            changequotadesigndetailVO.setShutManagement(shutManagementB);
                        }
                    }

                    if(StringUtils.isNotBlank(shutProfit)){
                        if(!StringFormatUtil.validateNumber(shutProfit)){
                            changequotadesigndetailVO.setErrorMsg("利润（合价）格式不正确！");
                            errorList.add(changequotadesigndetailVO);
                            continue;
                        }else {
                            changequotadesigndetailVO.setShutProfit(new BigDecimal(shutProfit));
                        }
                    }else {
                        BigDecimal shutProfitB = new BigDecimal(0);
                        BigDecimal engineeringB = changequotadesigndetailVO.getEngineering();
                        BigDecimal profitB = changequotadesigndetailVO.getProfit();
                        if(engineeringB != null && profitB != null){
                            shutProfitB = engineeringB.multiply(profitB);
                            changequotadesigndetailVO.setShutProfit(shutProfitB);
                        }
                    }

                    if(StringUtils.isNotBlank(shutPrice)){
                        if(!StringFormatUtil.validateNumber(shutPrice)){
                            changequotadesigndetailVO.setErrorMsg("合价格式不正确！");
                            errorList.add(changequotadesigndetailVO);
                            continue;
                        }else {
                            changequotadesigndetailVO.setShutPrice(new BigDecimal(shutPrice));
                        }
                    }else {//为空，则系统计算
                        BigDecimal shutPriceB = new BigDecimal(0);
                        BigDecimal shutLaborB = changequotadesigndetailVO.getShutLabor();
                        BigDecimal shutMaterialB = changequotadesigndetailVO.getShutMaterial();
                        BigDecimal shutMechanicalB = changequotadesigndetailVO.getShutMechanical();
                        BigDecimal shutManagementB = changequotadesigndetailVO.getShutManagement();
                        BigDecimal shutProfitB = changequotadesigndetailVO.getShutProfit();

                        if(shutLaborB != null){
                            shutPriceB = shutPriceB.add(shutLaborB);
                        }
                        if(shutMaterialB != null){
                            shutPriceB = shutPriceB.add(shutMaterialB);
                        }
                        if(shutMechanicalB != null){
                            shutPriceB = shutPriceB.add(shutMechanicalB);
                        }
                        if(shutManagementB != null){
                            shutPriceB = shutPriceB.add(shutManagementB);
                        }
                        if(shutProfitB != null){
                            shutPriceB = shutPriceB.add(shutProfitB);
                        }

                        changequotadesigndetailVO.setShutPrice(shutPriceB);
                    }

                    if(!TextUtils.isEmpty(clubInsurance) && !StringFormatUtil.validateNumber(clubInsurance)){
                        changequotadesigndetailVO.setErrorMsg("社保格式不正确！");
                        errorList.add(changequotadesigndetailVO);
                        continue;
                    }else {
                        changequotadesigndetailVO.setClubInsurance(StringUtils.isNotBlank(clubInsurance) ? new BigDecimal(clubInsurance) : null); // 社保
                    }

                    if(!TextUtils.isEmpty(housing) && !StringFormatUtil.validateNumber(housing)){
                        changequotadesigndetailVO.setErrorMsg("住房格式不正确！");
                        errorList.add(changequotadesigndetailVO);
                        continue;
                    }else {
                        changequotadesigndetailVO.setHousing(StringUtils.isNotBlank(housing) ? new BigDecimal(housing) : null); // 住房
                    }

                    if(!TextUtils.isEmpty(reserved1) && !StringFormatUtil.validateNumber(reserved1)){
                        changequotadesigndetailVO.setErrorMsg("预留1格式不正确！");
                        errorList.add(changequotadesigndetailVO);
                        continue;
                    }else {
                        changequotadesigndetailVO.setReserved1(StringUtils.isNotBlank(reserved1) ? new BigDecimal(reserved1) : null); //预留1
                    }

                    if(!TextUtils.isEmpty(reserved2) && !StringFormatUtil.validateNumber(reserved2)){
                        changequotadesigndetailVO.setErrorMsg("预留2格式不正确！");
                        errorList.add(changequotadesigndetailVO);
                        continue;
                    }else {
                        changequotadesigndetailVO.setReserved2(StringUtils.isNotBlank(reserved2) ? new BigDecimal(reserved2) : null); //预留2
                    }

                    if(!TextUtils.isEmpty(reserved3) && !StringFormatUtil.validateNumber(reserved3)){
                        changequotadesigndetailVO.setErrorMsg("预留3格式不正确！");
                        errorList.add(changequotadesigndetailVO);
                        continue;
                    }else {
                        changequotadesigndetailVO.setReserved3(StringUtils.isNotBlank(reserved3) ? new BigDecimal(reserved3) : null); // 预留3
                    }

                    if(!TextUtils.isEmpty(tax) && !StringFormatUtil.validateNumber(tax)){
                        changequotadesigndetailVO.setErrorMsg("税金格式不正确！");
                        errorList.add(changequotadesigndetailVO);
                        continue;
                    }else {
                        changequotadesigndetailVO.setTax(StringUtils.isNotBlank(tax) ? new BigDecimal(tax) : null); // 税金
                    }

                    if(!TextUtils.isEmpty(estimation) && !StringFormatUtil.validateNumber(estimation)){
                        changequotadesigndetailVO.setErrorMsg("暂估价格式不正确！");
                        errorList.add(changequotadesigndetailVO);
                        continue;
                    }else {
                        changequotadesigndetailVO.setEstimation(StringUtils.isNotBlank(estimation) ? new BigDecimal(estimation) : null); // 暂估价
                    }

                    successList.add(changequotadesigndetailVO);
                }
            }
        }

        //按子目编码排序
        Collections.sort(successList, new Comparator<ChangequotadesigndetailVO>() {
            @Override
            public int compare(ChangequotadesigndetailVO o1, ChangequotadesigndetailVO o2) {
                return o1.getSonItemCode().compareTo(o2.getSonItemCode());
            }
        });

        //构建树
        List<ChangequotadesigndetailVO> resList = createTreeData(successList);

        //统计父级的合计数值
        getChildrenUnitTotalAmount(resList);

        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", resList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());

        ChangequotadesigndetailVO resVo = new ChangequotadesigndetailVO();
        json.put("total", getTotalAmount(resList, resVo));

        return CommonResponse.success(json);
    }

    //子目编码规则定死------分别是2位/4位/6位/6为以上
    private Long setPid(String pcode, Map<String, ChangequotadesigndetailVO> map) {
        if (map.get(pcode) != null) {
            return Long.valueOf(map.get(pcode).getTid());
        } else {
            //父级没有找到，则继续往上找
            if (pcode.length() == 2) {
                //最上级
                return null;
            } else if (pcode.length() == 4) {
                String ppcode = pcode.substring(0, 2);
                return this.setPid(ppcode, map);
            } else if (pcode.length() == 6) {
                String ppcode = pcode.substring(0, 4);
                return this.setPid(ppcode, map);
            } else if (pcode.length() > 6) {
                String ppcode = pcode.substring(0, 6);
                return this.setPid(ppcode, map);
            } else {
                return null;
            }
        }
    }

    /**
     * 构建树
     *
     * @param list
     * @return
     */
    public static List<ChangequotadesigndetailVO> createTreeData(List<ChangequotadesigndetailVO> list) {
        List<ChangequotadesigndetailVO> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();

        //循环list，放入listMap重
        Map<String, ChangequotadesigndetailVO> listMap = new HashMap<>();
        for (ChangequotadesigndetailVO item : list) {
            listMap.put(item.getTid().toString(), item);
        }

        for (int i = 0; i < list.size(); i++) {
            ChangequotadesigndetailVO item = list.get(i);
            String parentId = (item.getTpid() != null) ? item.getTpid().toString() : "";
            ChangequotadesigndetailVO parent = listMap.get(parentId);
            if (parent != null) {
                List<ChangequotadesigndetailVO> child = (List<ChangequotadesigndetailVO>) parent.getChildren();
                if (child != null) {
                    child.add(item);
                } else {
                    List<ChangequotadesigndetailVO> children = new ArrayList<ChangequotadesigndetailVO>();
                    children.add(item);
                    parent.setChildren(children);
                }
            } else {
                rootItems.add(item.getTid());
            }
        }

        for (String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }

    /**
     * 统计父级的合计数值
     * @param vos
     * @return
     */
    private ChangequotadesigndetailVO getChildrenUnitTotalAmount(List<ChangequotadesigndetailVO> vos){
        ChangequotadesigndetailVO detail = new ChangequotadesigndetailVO();
        detail.setShutLabor(new BigDecimal(0));//人工费(综合)
        detail.setShutMaterial(new BigDecimal(0));//材料费(综合)
        detail.setShutMechanical(new BigDecimal(0));//机械费(综合)
        detail.setShutManagement(new BigDecimal(0));//企业管理费(综合)
        detail.setShutProfit(new BigDecimal(0));//利润(综合)
        detail.setShutPrice(new BigDecimal(0));//合价(元)
        detail.setClubInsurance(new BigDecimal(0));//社保
        detail.setHousing(new BigDecimal(0));//住房
        detail.setReserved1(new BigDecimal(0));//预留1
        detail.setReserved2(new BigDecimal(0));//预留2
        detail.setReserved3(new BigDecimal(0));//预留3
        detail.setTax(new BigDecimal(0));//税金
        detail.setEstimation(new BigDecimal(0));//暂估价

        BigDecimal shutLabor = detail.getShutLabor();
        BigDecimal shutMaterial = detail.getShutMaterial();
        BigDecimal shutMechanical = detail.getShutMechanical();
        BigDecimal shutManagement = detail.getShutManagement();
        BigDecimal shutProfit = detail.getShutProfit();
        BigDecimal shutPrice = detail.getShutPrice();
        BigDecimal clubInsurance = detail.getClubInsurance();
        BigDecimal housing = detail.getHousing();
        BigDecimal reserved1 = detail.getReserved1();
        BigDecimal reserved2 = detail.getReserved2();
        BigDecimal reserved3 = detail.getReserved3();
        BigDecimal tax = detail.getTax();
        BigDecimal estimation = detail.getEstimation();

        for(ChangequotadesigndetailVO vo: vos){
            if(vo.getChildren()!=null&&vo.getChildren().size()>0){
                //有孩子节点----清空工程量和综合单价--金额字段
                vo.setEngineering(null);// 工程量
                vo.setLabor(null);// 人工费
                vo.setMaterial(null);
                vo.setMechanical(null);
                vo.setManagement(null);
                vo.setProfit(null);
                vo.setUnitPrice(null);

                //获取孩子节点的总计数据
                ChangequotadesigndetailVO childrenUnitTotalAmount = this.getChildrenUnitTotalAmount(vo.getChildren());
                vo.setShutLabor(childrenUnitTotalAmount.getShutLabor());
                vo.setShutMaterial(childrenUnitTotalAmount.getShutMaterial());
                vo.setShutMechanical(childrenUnitTotalAmount.getShutMechanical());
                vo.setShutManagement(childrenUnitTotalAmount.getShutManagement());
                vo.setShutProfit(childrenUnitTotalAmount.getShutProfit());
                vo.setShutPrice(childrenUnitTotalAmount.getShutPrice());
                vo.setClubInsurance(childrenUnitTotalAmount.getClubInsurance());
                vo.setHousing(childrenUnitTotalAmount.getHousing());
                vo.setReserved1(childrenUnitTotalAmount.getReserved1());
                vo.setReserved2(childrenUnitTotalAmount.getReserved2());
                vo.setReserved3(childrenUnitTotalAmount.getReserved3());
                vo.setTax(childrenUnitTotalAmount.getTax());
                vo.setEstimation(childrenUnitTotalAmount.getEstimation());

                shutLabor = shutLabor.add(childrenUnitTotalAmount.getShutLabor());
                shutMaterial = shutMaterial.add(childrenUnitTotalAmount.getShutMaterial());
                shutMechanical = shutMechanical.add(childrenUnitTotalAmount.getShutMechanical());
                shutManagement = shutManagement.add(childrenUnitTotalAmount.getShutManagement());
                shutProfit = shutProfit.add(childrenUnitTotalAmount.getShutProfit());
                shutPrice = shutPrice.add(childrenUnitTotalAmount.getShutPrice());
                clubInsurance = clubInsurance.add(childrenUnitTotalAmount.getClubInsurance());
                housing = housing.add(childrenUnitTotalAmount.getHousing());
                reserved1 = reserved1.add(childrenUnitTotalAmount.getReserved1());
                reserved2 = reserved2.add(childrenUnitTotalAmount.getReserved2());
                reserved3 = reserved3.add(childrenUnitTotalAmount.getReserved3());
                tax = tax.add(childrenUnitTotalAmount.getTax());
                estimation = estimation.add(childrenUnitTotalAmount.getEstimation());
            }else{
                if(vo.getShutLabor()!=null){
                    shutLabor = shutLabor.add(vo.getShutLabor());
                }

                if(vo.getShutMaterial()!=null){
                    shutMaterial = shutMaterial.add(vo.getShutMaterial());
                }

                if(vo.getShutMechanical()!=null){
                    shutMechanical = shutMechanical.add(vo.getShutMechanical());
                }

                if(vo.getShutManagement()!=null){
                    shutManagement = shutManagement.add(vo.getShutManagement());
                }

                if(vo.getShutProfit()!=null){
                    shutProfit = shutProfit.add(vo.getShutProfit());
                }

                if(vo.getShutPrice()!=null){
                    shutPrice = shutPrice.add(vo.getShutPrice());
                }

                if(vo.getClubInsurance()!=null){
                    clubInsurance = clubInsurance.add(vo.getClubInsurance());
                }

                if(vo.getHousing()!=null){
                    housing = housing.add(vo.getHousing());
                }

                if(vo.getReserved1()!=null){
                    reserved1 = reserved1.add(vo.getReserved1());
                }

                if(vo.getReserved2()!=null){
                    reserved2 = reserved2.add(vo.getReserved2());
                }

                if(vo.getReserved3()!=null){
                    reserved3 = reserved3.add(vo.getReserved3());
                }

                if(vo.getTax()!=null){
                    tax = tax.add(vo.getTax());
                }

                if(vo.getEstimation()!=null){
                    estimation = estimation.add(vo.getEstimation());
                }
            }

            detail.setShutLabor(shutLabor);
            detail.setShutMaterial(shutMaterial);
            detail.setShutMechanical(shutMechanical);
            detail.setShutManagement(shutManagement);
            detail.setShutProfit(shutProfit);
            detail.setShutPrice(shutPrice);
            detail.setClubInsurance(clubInsurance);
            detail.setHousing(housing);
            detail.setReserved1(reserved1);
            detail.setReserved2(reserved2);
            detail.setReserved3(reserved3);
            detail.setTax(tax);
            detail.setEstimation(estimation);
        }
        return detail;
    }

    private ChangequotadesigndetailVO getTotalAmount(List<ChangequotadesigndetailVO> vos, ChangequotadesigndetailVO resVo) {
        BigDecimal costTotal = new BigDecimal(0);
        BigDecimal laborTotal = new BigDecimal(0);
        BigDecimal materialTotal = new BigDecimal(0);
        BigDecimal mechanicalTotal = new BigDecimal(0);
        BigDecimal profitsTotal = new BigDecimal(0);
        BigDecimal managementTotal = new BigDecimal(0);
        BigDecimal feesTotal = new BigDecimal(0);
        BigDecimal taxTotal = new BigDecimal(0);

        for (ChangequotadesigndetailVO vo : vos) {
            if (vo.getShutPrice() != null) {
                costTotal = costTotal.add(vo.getShutPrice());
            }
            if (vo.getShutLabor() != null) {
                laborTotal = laborTotal.add(vo.getShutLabor());
            }
            if (vo.getShutMaterial() != null) {
                materialTotal = materialTotal.add(vo.getShutMaterial());
            }
            if (vo.getShutMechanical() != null) {
                mechanicalTotal = mechanicalTotal.add(vo.getShutMechanical());
            }
            if (vo.getShutProfit() != null) {
                profitsTotal = profitsTotal.add(vo.getShutProfit());
            }
            if (vo.getShutManagement() != null) {
                managementTotal = managementTotal.add(vo.getShutManagement());
            }
            if (vo.getTax() != null) {
                taxTotal = taxTotal.add(vo.getTax());
            }

            //规费合计
            if (vo.getClubInsurance() != null) {
                feesTotal = feesTotal.add(vo.getClubInsurance());
            }
            if (vo.getHousing() != null) {
                feesTotal = feesTotal.add(vo.getHousing());
            }
            if (vo.getReserved1() != null) {
                feesTotal = feesTotal.add(vo.getReserved1());
            }
            if (vo.getReserved2() != null) {
                feesTotal = feesTotal.add(vo.getReserved2());
            }
            if (vo.getReserved3() != null) {
                feesTotal = feesTotal.add(vo.getReserved3());
            }
        }

        resVo.setCostTotal(costTotal);
        resVo.setLaborTotal(laborTotal);
        resVo.setMaterialTotal(materialTotal);
        resVo.setMechanicalTotal(mechanicalTotal);
        resVo.setProfitsTotal(profitsTotal);
        resVo.setManagementTotal(managementTotal);
        resVo.setFeesTotal(feesTotal);
        resVo.setTaxTotal(taxTotal);
        return resVo;
    }

    /**
     * excel导出数据库数据
     *
     * @param response
     * @returnq
     */
    @RequestMapping(value = "/excelExportQuotadesignFromDatabase", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportConsdrawbudgetFromDatabase(@RequestBody ChangequotadesignVO changequotadesignVO, HttpServletResponse response) {
        QueryWrapper<ChangequotadesigndetailEntity> queryWrapper;
        queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("mid", changequotadesignVO.getId());
        queryWrapper.eq("dr", 0);
        queryWrapper.orderByAsc("son_item_code");
        List<ChangequotadesigndetailEntity> list = changequotadesigndetailService.list(queryWrapper);
        List<QuotadesigndetailVO> quotadesigndetailVOList = BeanMapper.mapList(list, QuotadesigndetailVO.class);
        if (quotadesigndetailVOList!= null && quotadesigndetailVOList.size() > 0) {
            for (int i = 0; i < quotadesigndetailVOList.size(); i++) {
                QuotadesigndetailVO quotadesigndetailVO = quotadesigndetailVOList.get(i);
               quotadesigndetailVO.setSort(String.valueOf(i + 1));
            }
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("quotadesigndetail-export.xlsx", beans, response);
    }

    /**
     * excel导出页面数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportQuotadesignFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportConsdrawbudgetFromPage(@RequestBody List<ChangequotadesigndetailVO> list, HttpServletResponse response) {
        List<ChangequotadesigndetailVO> concatList = new ArrayList<>();
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); i++) {
                ChangequotadesigndetailVO changequotadesigndetailVO = list.get(i);
                changequotadesigndetailVO.setSort(String.valueOf(i + 1));
                concatList.add(changequotadesigndetailVO);
            }
        }

        //children拍平
        List<ChangequotadesigndetailVO> allList = handleList(list, concatList);
        //按序号排序
        Collections.sort(allList, new Comparator<ChangequotadesigndetailVO>() {
            @Override
            public int compare(ChangequotadesigndetailVO o1, ChangequotadesigndetailVO o2) {
                return o1.getSonItemCode().compareTo(o2.getSonItemCode());
            }
        });
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", allList);
        ExcelExport.getInstance().export("quotadesigndetail-export.xlsx", beans, response);
    }

    /**
     * 导出页面数据处理children
     *
     * @param list
     */
    private List<ChangequotadesigndetailVO> handleList(List<ChangequotadesigndetailVO> list, List<ChangequotadesigndetailVO> concatList) {
        if (list == null || list.size() == 0) {
            return concatList;
        }

        for (int i = 0; i < list.size(); i++) {
            ChangequotadesigndetailVO changequotadesigndetailVO = list.get(i);
            List<ChangequotadesigndetailVO> children = changequotadesigndetailVO.getChildren();
            if (children != null && children.size() > 0) {
                concatList.addAll(children);
                handleList(children, concatList);
            }
        }

        return concatList;
    }

}
