package com.ejianc.business.change.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bedget.bean.MaterialrequirementsEntity;
import com.ejianc.business.bedget.service.IMaterialrequirementsService;
import com.ejianc.business.change.bean.ChangematerialrequirementsEntity;
import com.ejianc.business.change.mapper.ChangematerialrequirementsMapper;
import com.ejianc.business.change.service.IChangematerialrequirementsService;
import com.ejianc.business.change.vo.ChangematerialrequirementsVO;
import com.ejianc.business.record.bean.RecodematerialrequirementsEntity;
import com.ejianc.business.record.service.IRecodematerialrequirementsService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import java.util.List;
import java.util.stream.Collectors;


/**
 * 物资需求总计划变更
 *
 * @author generator
 */
@Service("changematerialrequirementsService")
public class ChangematerialrequirementsServiceImpl extends BaseServiceImpl<ChangematerialrequirementsMapper, ChangematerialrequirementsEntity> implements IChangematerialrequirementsService {

    @Autowired
    private IMaterialrequirementsService materialrequirementsService;
    @Autowired
    private IRecodematerialrequirementsService recodematerialrequirementsService;

    @Override
    public CommonResponse<ChangematerialrequirementsVO> saveChange(ChangematerialrequirementsVO saveOrUpdateVO) {
        //检验该单据是否存在
        boolean exitBill = false;
        if (saveOrUpdateVO.getId() != null) {
            ChangematerialrequirementsEntity e = this.getById(saveOrUpdateVO);
            if (e != null) {
                exitBill = true;
            }
        }
        ChangematerialrequirementsEntity entity = BeanMapper.map(saveOrUpdateVO, ChangematerialrequirementsEntity.class);
        //检验是否存在未生效的变更单据，若存在，则不能变更
        QueryWrapper<ChangematerialrequirementsEntity> queryWrapper = new QueryWrapper<ChangematerialrequirementsEntity>();
        queryWrapper.eq("original_id", saveOrUpdateVO.getOriginalId());
        queryWrapper.eq("dr", 0);
        queryWrapper.in("bill_state", "[0,4]");
        if (saveOrUpdateVO.getId() != null) {
            queryWrapper.ne("id", saveOrUpdateVO.getId());
        }
        List<ChangematerialrequirementsEntity> exit = this.list(queryWrapper);
        if (exit != null && exit.size() > 0) {
            throw new BusinessException("已存在未完成的变更单据，不能新增新的变更单据");
        }

        //处理子表数据
        //限额设计指标分析子表
        this.saveOrUpdate(entity, false);

        ChangematerialrequirementsVO vo = BeanMapper.map(entity, ChangematerialrequirementsVO.class);
        vo.setMaterialrequirementsdetailEntities(saveOrUpdateVO.getMaterialrequirementsdetailEntities());
        vo.setRecodematerialrequirementsList(saveOrUpdateVO.getRecodematerialrequirementsList());
        if (!exitBill) {
            //查询当前合同信息，将状态改为变更中
            MaterialrequirementsEntity materialrequirementsEntity = materialrequirementsService.selectById(vo.getOriginalId());
            materialrequirementsEntity.setChangeState("2");//状态改为变更中
            materialrequirementsEntity.setChangeId(vo.getId());
            materialrequirementsService.saveOrUpdate(materialrequirementsEntity, false);
        }
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    @Override
    public CommonResponse<String> delete(List<ChangematerialrequirementsVO> vos) {
        for (ChangematerialrequirementsVO vo : vos) {
            ChangematerialrequirementsEntity entity = this.getById(vo.getId());
            MaterialrequirementsEntity materialrequirements = materialrequirementsService.selectById(entity.getOriginalId());
            QueryWrapper<RecodematerialrequirementsEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("dr", 0);
            queryWrapper.eq("original_id", entity.getId());
            List<RecodematerialrequirementsEntity> records = recodematerialrequirementsService.list(queryWrapper);
            if (records != null && records.size() > 0) {
                materialrequirements.setChangeState("3");//状态改为已变更
            } else {
                materialrequirements.setChangeState("1");//状态改为未变更
            }
            materialrequirements.setChangeId(null);
            materialrequirementsService.saveOrUpdate(materialrequirements, false);
        }
        this.removeByIds(vos.stream().map(ChangematerialrequirementsVO::getId).collect(Collectors.toList()), true);

        return CommonResponse.success("删除成功！");
    }
}
