package com.ejianc.business.change.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bedget.bean.QuotasummaryEntity;
import com.ejianc.business.bedget.service.IQuotasummaryService;
import com.ejianc.business.change.bean.ChangequotasummaryEntity;
import com.ejianc.business.change.mapper.ChangequotasummaryMapper;
import com.ejianc.business.change.service.IChangequotasummaryService;
import com.ejianc.business.change.vo.ChangequotasummaryVO;
import com.ejianc.business.change.vo.ChangequotasummarydetaillVO;
import com.ejianc.business.record.bean.RecordquotasummaryEntity;
import com.ejianc.business.record.service.IRecordquotasummaryService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;


/**
 * 限额设计汇总变更
 * 
 * @author generator
 * 
 */
@Service("changequotasummaryService")
public class ChangequotasummaryServiceImpl extends BaseServiceImpl<ChangequotasummaryMapper, ChangequotasummaryEntity> implements IChangequotasummaryService {

    @Autowired
    private IQuotasummaryService quotasummaryService;

    @Autowired
    private IRecordquotasummaryService recordquotasummaryService;

    @Override
    public CommonResponse<ChangequotasummaryVO> saveChange(ChangequotasummaryVO saveOrUpdateVO) {
        //检验该单据是否存在
        boolean exitBill = false;
        if(saveOrUpdateVO.getId()!=null){
            ChangequotasummaryEntity e = this.getById(saveOrUpdateVO);
            if(e!=null){
                exitBill = true;
            }
        }
        ChangequotasummaryEntity entity = BeanMapper.map(saveOrUpdateVO, ChangequotasummaryEntity.class);
        //检验是否存在未生效的变更单据，若存在，则不能变更
        QueryWrapper<ChangequotasummaryEntity> queryWrapper = new QueryWrapper<ChangequotasummaryEntity>();
        queryWrapper.eq("original_id", saveOrUpdateVO.getOriginalId());
        queryWrapper.eq("dr", 0);
        queryWrapper.notIn("bill_state", 1, 3);
        if(saveOrUpdateVO.getId()!=null){
            queryWrapper.ne("id", saveOrUpdateVO.getId());
        }
        List<ChangequotasummaryEntity> exit = this.list(queryWrapper);
        if(exit!=null&&exit.size()>0){
            throw new BusinessException("已存在未完成的变更单据，不能新增新的变更单据");
        }

        //处理子表数据
        //限额设计指标分析子表
        this.saveOrUpdate(entity, false);

        ChangequotasummaryVO vo = BeanMapper.map(entity, ChangequotasummaryVO.class);
        vo.setQuotasummarydetailEntities(saveOrUpdateVO.getQuotasummarydetailEntities());
        vo.setRecordquotasummaryList(saveOrUpdateVO.getRecordquotasummaryList());
        if(!exitBill){
            //查询当前合同信息，将状态改为变更中
            QuotasummaryEntity quotasummaryEntity = quotasummaryService.selectById(vo.getOriginalId());
            quotasummaryEntity.setChangeState("2");//状态改为变更中
            quotasummaryEntity.setChangeId(vo.getId());
            quotasummaryService.saveOrUpdate(quotasummaryEntity, false);
        }

        //构建树形结构
        List<ChangequotasummarydetaillVO> changequotasummarydetailVOList = vo.getQuotasummarydetailEntities();
        List<ChangequotasummarydetaillVO> resQuotasummarydetailVOList = createTreeData(changequotasummarydetailVOList);
        vo.setQuotasummarydetailEntities(resQuotasummarydetailVOList);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    public static List<ChangequotasummarydetaillVO> createTreeData(List<ChangequotasummarydetaillVO> list) {
        List<ChangequotasummarydetaillVO> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();

        //循环list，放入listMap重
        Map<String, ChangequotasummarydetaillVO> listMap = new HashMap<>();
        for(ChangequotasummarydetaillVO item:list) {
            listMap.put(item.getTid().toString(), item);
        }

        for(int i =0; i<list.size(); i++) {
            ChangequotasummarydetaillVO item = list.get(i);
            String parentId = (item.getTpid() != null) ? item.getTpid().toString():"";
            ChangequotasummarydetaillVO parent = listMap.get(parentId);
            if(parent != null) {
                List<ChangequotasummarydetaillVO> child = (List<ChangequotasummarydetaillVO>) parent.getChildren();
                if(child != null) {
                    child.add(item);
                }else{
                    List<ChangequotasummarydetaillVO> children = new ArrayList<ChangequotasummarydetaillVO>();
                    children.add(item);
                    parent.setChildren(children);
                }
            } else {
                rootItems.add(item.getTid());
            }
        }

        for(String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }


    @Override
    public CommonResponse<String> delete(List<ChangequotasummaryVO> vos) {
        for(ChangequotasummaryVO vo : vos){
            ChangequotasummaryEntity entity = this.getById(vo.getId());
            QuotasummaryEntity quotasummaryEntity = quotasummaryService.selectById(entity.getOriginalId());
            QueryWrapper<RecordquotasummaryEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("dr", 0);
            queryWrapper.eq("quotasummary_id", quotasummaryEntity.getId());
            List<RecordquotasummaryEntity> records = recordquotasummaryService.list(queryWrapper);
            if(records!=null&&records.size()>0){
                quotasummaryEntity.setChangeState("3");//状态改为已变更
            }else{
                quotasummaryEntity.setChangeState("1");//状态改为未变更
            }
            quotasummaryEntity.setChangeId(null);
            quotasummaryService.saveOrUpdate(quotasummaryEntity, false);
        }
        this.removeByIds(vos.stream().map(ChangequotasummaryVO::getId).collect(Collectors.toList()),true);

        return CommonResponse.success("删除成功！");
    }
}
