package com.ejianc.business.change.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bedget.bean.*;
import com.ejianc.business.bedget.service.IConsdrawbudgetService;
import com.ejianc.business.bedget.service.IConsdrawbudgetdetailService;
import com.ejianc.business.bedget.service.ISubpackageService;
import com.ejianc.business.bedget.vo.SubpackageVO;
import com.ejianc.business.bedget.vo.SubpackagedetailVO;
import com.ejianc.business.change.bean.ChangedesignestimateEntity;
import com.ejianc.business.change.bean.ChangesubpackageEntity;
import com.ejianc.business.change.bean.ChangesubpackagedetailEntity;
import com.ejianc.business.change.mapper.ChangesubpackageMapper;
import com.ejianc.business.change.service.IChangesubpackageService;
import com.ejianc.business.change.service.IChangesubpackagedetailService;
import com.ejianc.business.change.vo.ChangedesignestimateVO;
import com.ejianc.business.change.vo.ChangedesignestimatedetailVO;
import com.ejianc.business.change.vo.ChangesubpackageVO;
import com.ejianc.business.change.vo.ChangesubpackagedetailVO;
import com.ejianc.business.record.bean.RecorddesignestimateEntity;
import com.ejianc.business.record.bean.RecordsubpackageEntity;
import com.ejianc.business.record.service.IRecordsubpackageService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;


/**
 * 分包施工图预算变更
 *
 * @author generator
 */
@Service("changesubpackageService")
public class ChangesubpackageServiceImpl extends BaseServiceImpl<ChangesubpackageMapper, ChangesubpackageEntity> implements IChangesubpackageService {

    @Autowired
    private ISubpackageService subpackageService;
    @Autowired
    private IRecordsubpackageService recordsubpackageService;
    @Autowired
    private IConsdrawbudgetService consdrawbudgetService;
    @Autowired
    private IConsdrawbudgetdetailService consdrawbudgetdetailService;
    @Autowired
    private IChangesubpackageService changesubpackageService;
    @Autowired
    private IChangesubpackagedetailService changesubpackagedetailService;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public CommonResponse<ChangesubpackageVO> saveChange(ChangesubpackageVO saveOrUpdateVO) {
        //检验该单据是否存在
        boolean exitBill = false;
        if (saveOrUpdateVO.getId() != null) {
            ChangesubpackageEntity e = this.getById(saveOrUpdateVO);
            if (e != null) {
                exitBill = true;
            }
        }
        ChangesubpackageEntity entity = BeanMapper.map(saveOrUpdateVO, ChangesubpackageEntity.class);
        //检验是否存在未生效的变更单据，若存在，则不能变更
        QueryWrapper<ChangesubpackageEntity> queryWrapper = new QueryWrapper<ChangesubpackageEntity>();
        queryWrapper.eq("original_id", saveOrUpdateVO.getOriginalId());
        queryWrapper.eq("dr", 0);
        queryWrapper.in("bill_state", "[0,4]");
        if (saveOrUpdateVO.getId() != null) {
            queryWrapper.ne("id", saveOrUpdateVO.getId());
        }
        List<ChangesubpackageEntity> exit = this.list(queryWrapper);
        if (exit != null && exit.size() > 0) {
            throw new BusinessException("已存在未完成的变更单据，不能新增新的变更单据");
        }

        //查已提交的 除去自身单据的其他同一项目下的单据
        QueryWrapper<ChangesubpackageEntity> masterWrapper = new QueryWrapper<>();
        masterWrapper.eq("dr", 0);
        masterWrapper.in("bill_state", 1, 3);
        masterWrapper.eq("project_id", entity.getProjectId());
        if (entity.getId() != null && entity.getId() != 0) {
            masterWrapper.ne("id", saveOrUpdateVO.getId());
        }
        List<ChangesubpackageEntity> otherEntityList = changesubpackageService.list(masterWrapper);


        QueryWrapper<ConsdrawbudgetEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("dr", 0);
        wrapper.eq("project_id", entity.getProjectId());
        wrapper.in("bill_state", 1, 3);
        List<ConsdrawbudgetEntity> control = consdrawbudgetService.list(wrapper);

        //开启控制
        if (control.get(0).getIsOpenControl() == 1) {
            //其他单据子表的工程量汇总


            //遍历页面拿到的子表
            for (ChangesubpackagedetailEntity entitySubpackagedetailEntity : entity.getSubpackagedetailEntities()) {

                //页面单据子表的删除状态
                String rowState = entitySubpackagedetailEntity.getRowState();
                if (rowState != null && rowState.equals("del")) {
                    continue;
                }

                String masterSection = entitySubpackagedetailEntity.getSection();
                String masterSubtitleCode = entitySubpackagedetailEntity.getSubtitleCode();
                String masterSubtitleName = entitySubpackagedetailEntity.getSubtitleName();

                //施工图预算子表工程量
                //查询是否开启控制 施工图预算
                BigDecimal drawCount = new BigDecimal(0);
                for (ConsdrawbudgetEntity consdrawbudget : control) {
                    QueryWrapper<ConsdrawbudgetdetailEntity> drawDetailWrapper = new QueryWrapper<>();
                    drawDetailWrapper.eq("section",masterSection);
                    drawDetailWrapper.eq("subitem_code",masterSubtitleCode);
                    drawDetailWrapper.eq("subitem_name",masterSubtitleName);
                    drawDetailWrapper.eq("dr",0);
                    drawDetailWrapper.eq("mid",consdrawbudget.getId());
                    List<ConsdrawbudgetdetailEntity> drawDetailList = consdrawbudgetdetailService.list(drawDetailWrapper);
                    for (ConsdrawbudgetdetailEntity consdrawbudgetdetail : drawDetailList) {
                        if(consdrawbudgetdetail.getEngineeQuatity()!=null){
                            drawCount =   drawCount.add(consdrawbudgetdetail.getEngineeQuatity());
                        }
                    }
                }

                entitySubpackagedetailEntity.setSubpackageBudgetTotal(drawCount);
                BigDecimal otherChildCount = new BigDecimal(0);
                //其他单据主表集合
                for (ChangesubpackageEntity subpackageEntity : otherEntityList) {
                    QueryWrapper<ChangesubpackagedetailEntity> otherWrapper = new QueryWrapper<>();
                    otherWrapper.eq("section",masterSection);
                    otherWrapper.eq("subtitle_code",masterSubtitleCode);
                    otherWrapper.eq("subtitle_name",masterSubtitleName);
                    otherWrapper.eq("dr",0);
                    otherWrapper.eq("mid",subpackageEntity.getId());
                    List<ChangesubpackagedetailEntity> otherDetailList = changesubpackagedetailService.list(otherWrapper);
                    for (ChangesubpackagedetailEntity subpackagedetail : otherDetailList) {
                        //其他单据的累计工程量
                        if(subpackagedetail.getSubpackageQuantities()!=null){
                            otherChildCount = otherChildCount.add(subpackagedetail.getSubpackageQuantities());
                        }
                    }
                }

                //本次单据输入的工程量
                BigDecimal masterCount = entitySubpackagedetailEntity.getSubpackageQuantities();

                if(masterCount!= null && drawCount.subtract(otherChildCount).subtract(masterCount).compareTo(BigDecimal.ZERO)==-1){
                    throw new BusinessException("" + masterSection + "," + masterSubtitleCode + "," + masterSubtitleName + "行,本次输入的工程量为" +
                            masterCount + "已超过'分包施工图预算量合计（施工图预算工程量）'");
                }
            }
        }

        //处理子表数据
        this.saveOrUpdate(entity, false);


        ChangesubpackageVO vo = BeanMapper.map(entity, ChangesubpackageVO.class);
        vo.setSubpackagedetailEntities(saveOrUpdateVO.getSubpackagedetailEntities());
        vo.setRecordsubpackageList(saveOrUpdateVO.getRecordsubpackageList());
        if (!exitBill) {
            //查询当前合同信息，将状态改为变更中
            SubpackageEntity subpackageEntity = subpackageService.selectById(vo.getOriginalId());
            subpackageEntity.setChangeState("2");//状态改为变更中
            subpackageEntity.setChangeId(vo.getId());
            subpackageService.saveOrUpdate(subpackageEntity, false);
        }

        //构建树形结构
        List<ChangesubpackagedetailVO> changesubpackagedetailVOList = vo.getSubpackagedetailEntities();
        List<ChangesubpackagedetailVO> resChangedesignestimatedetailVOList = createTree(changesubpackagedetailVOList);
        vo.setSubpackagedetailEntities(resChangedesignestimatedetailVOList);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    @Override
    public CommonResponse<String> delete(List<ChangesubpackageVO> vos) {
        for (ChangesubpackageVO vo : vos) {
            ChangesubpackageEntity entity = this.getById(vo.getId());
            SubpackageEntity subpackageEntity = subpackageService.selectById(entity.getOriginalId());
            QueryWrapper<RecordsubpackageEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("dr", 0);
            queryWrapper.eq("original_id", subpackageEntity.getId());
            List<RecordsubpackageEntity> records = recordsubpackageService.list(queryWrapper);
            if (records != null && records.size() > 0) {
                subpackageEntity.setChangeState("3");//状态改为已变更
            } else {
                subpackageEntity.setChangeState("1");//状态改为未变更
            }
            subpackageEntity.setChangeId(null);
            subpackageService.saveOrUpdate(subpackageEntity, false);
        }
        this.removeByIds(vos.stream().map(ChangesubpackageVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    private List<ChangesubpackagedetailVO> createTree(List<ChangesubpackagedetailVO> list) {
        List<ChangesubpackagedetailVO> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();

        //循环list，放入listMap重
        Map<String, ChangesubpackagedetailVO> listMap = new HashMap<>();
        for (ChangesubpackagedetailVO item : list) {
            listMap.put(item.getTid().toString(), item);
        }

        for (int i = 0; i < list.size(); i++) {
            ChangesubpackagedetailVO item = list.get(i);
            String parentId = (item.getTpid() != null) ? item.getTpid().toString() : "";
            ChangesubpackagedetailVO parent = listMap.get(parentId);
            if (parent != null) {
                List<ChangesubpackagedetailVO> child = (List<ChangesubpackagedetailVO>) parent.getChildren();
                if (child != null) {
                    child.add(item);
                } else {
                    List<ChangesubpackagedetailVO> children = new ArrayList<ChangesubpackagedetailVO>();
                    children.add(item);
                    parent.setChildren(children);
                }
            } else {
                rootItems.add(item.getTid());
            }
        }

        for (String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }

}