/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bedget.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.bedget.bean.DrawEntity;
import com.ejianc.business.bedget.service.IDrawService;
import com.ejianc.business.bedget.vo.DrawVO;
import com.ejianc.business.enums.ChangeStateEnum;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"draw"})
public class DrawController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IDrawService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<DrawVO> saveOrUpdate(@RequestBody DrawVO saveOrUpdateVO) {
        DrawVO vo = this.service.saveOrUpdate(saveOrUpdateVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<DrawVO> queryDetail(Long id) {
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)this.service.queryDetail(id, true)));
    }

    @RequestMapping(value={"/queryReviseDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<DrawVO> queryReviseDetail(Long id) {
        DrawVO changeVO = this.service.queryReviseDetail(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)changeVO));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<DrawVO> vos) {
        for (DrawVO drawVO : vos) {
            DrawEntity drawEntity = (DrawEntity)((Object)this.service.getById(drawVO.getId()));
            if (drawEntity.getLastDrawId() == null) continue;
            DrawEntity revise = (DrawEntity)((Object)this.service.getById(drawEntity.getLastDrawId()));
            revise.setChangeId(null);
            revise.setChangeState(ChangeStateEnum.\u672a\u53d8\u66f4.getCode());
            revise.setLatestFlag(true);
            this.service.saveOrUpdate((Object)revise);
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<DrawVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        if (StringUtils.isNotBlank((CharSequence)authOrgIds)) {
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        } else if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        ComplexParam resultComplexParam = new ComplexParam();
        resultComplexParam.setLogic("and");
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        c1.getParams().put("enableState", new Parameter("eq", (Object)true));
        ComplexParam complex2 = new ComplexParam();
        complex2.setLogic("or");
        ComplexParam c2 = new ComplexParam();
        c2.setLogic("and");
        c2.getParams().put("bill_state", new Parameter("not_in", (Object)"1,3"));
        complex2.getComplexParams().add(c2);
        ComplexParam c3 = new ComplexParam();
        c3.setLogic("and");
        c3.getParams().put("enableState", new Parameter("eq", (Object)false));
        complex2.getComplexParams().add(c3);
        ComplexParam c5 = new ComplexParam();
        c5.setLogic("and");
        c5.getParams().put("drawVersion", new Parameter("eq", (Object)"1"));
        complex2.getComplexParams().add(c5);
        resultComplexParam.getComplexParams().add(c1);
        resultComplexParam.getComplexParams().add(complex2);
        param.getComplexParams().add(resultComplexParam);
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), DrawVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        CommonResponse<IPage<DrawVO>> iPageCommonResponse = this.queryList(param);
        List list = ((IPage)iPageCommonResponse.getData()).getRecords();
        list.forEach(val -> {
            switch (val.getBillState()) {
                case 0: {
                    val.setBillStateName("\u81ea\u7531\u6001");
                    break;
                }
                case 1: {
                    val.setBillStateName("\u5df2\u63d0\u4ea4");
                    break;
                }
                case 2: {
                    val.setBillStateName("\u5ba1\u6279\u4e2d");
                    break;
                }
                case 3: {
                    val.setBillStateName("\u5ba1\u6279\u901a\u8fc7");
                    break;
                }
                case 4: {
                    val.setBillStateName("\u5ba1\u6279\u9a73\u56de");
                    break;
                }
                case 5: {
                    val.setBillStateName("\u5ba1\u6279\u4e2d");
                }
            }
            switch (val.getChangeState()) {
                case 0: {
                    val.setChangeStateName("\u672a\u53d8\u66f4");
                    break;
                }
                case 1: {
                    val.setChangeStateName("\u53d8\u66f4\u4e2d");
                    break;
                }
                case 2: {
                    val.setChangeStateName("\u5df2\u53d8\u66f4");
                }
            }
        });
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("draw-Export.xlsx", beans, response);
    }

    @RequestMapping(value={"/downloadInfo"})
    @ResponseBody
    public void downloadInfo(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"draw-sub-import.xlsx", (String)"\u5206\u90e8\u5206\u9879\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/downloadPrice"})
    @ResponseBody
    public void downloadPrice(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"draw-price-import.xlsx", (String)"\u5355\u4ef7\u63aa\u65bd\u9879\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/downloadTotal"})
    @ResponseBody
    public void downloadTotal(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"draw-total-import.xlsx", (String)"\u603b\u4ef7\u63aa\u65bd\u9879\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/downloadOth"})
    @ResponseBody
    public void downloadOth(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"draw-other-import.xlsx", (String)"\u5176\u4ed6\u9879\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/downloadFee"})
    @ResponseBody
    public void downloadFee(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"draw-fee-import.xlsx", (String)"\u8d39\u7a0e\u6e05\u5355\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImportInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImportInfo(HttpServletRequest request, HttpServletResponse response) {
        return this.service.excelImportInfo(request, response);
    }

    @RequestMapping(value={"/refDrawData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<DrawVO>> refDrawData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), DrawVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

