/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bedget.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.bedget.bean.DrawEntity;
import com.ejianc.business.bedget.bean.DrawFeeEntity;
import com.ejianc.business.bedget.bean.DrawOtherEntity;
import com.ejianc.business.bedget.bean.DrawPriceEntity;
import com.ejianc.business.bedget.bean.DrawSubEntity;
import com.ejianc.business.bedget.bean.DrawTotalEntity;
import com.ejianc.business.bedget.mapper.DrawMapper;
import com.ejianc.business.bedget.service.IDrawFeeService;
import com.ejianc.business.bedget.service.IDrawOtherService;
import com.ejianc.business.bedget.service.IDrawPriceService;
import com.ejianc.business.bedget.service.IDrawService;
import com.ejianc.business.bedget.service.IDrawSubService;
import com.ejianc.business.bedget.service.IDrawTotalService;
import com.ejianc.business.bedget.vo.DrawFeeVO;
import com.ejianc.business.bedget.vo.DrawOtherVO;
import com.ejianc.business.bedget.vo.DrawPriceVO;
import com.ejianc.business.bedget.vo.DrawSubVO;
import com.ejianc.business.bedget.vo.DrawTotalVO;
import com.ejianc.business.bedget.vo.DrawVO;
import com.ejianc.business.bedget.vo.ImportErrorVo;
import com.ejianc.business.enums.ChangeStateEnum;
import com.ejianc.business.pub.tax.TaxCalculateUtil;
import com.ejianc.business.utils.BudgetSortUtil;
import com.ejianc.business.utils.DetailIndexExcelReader;
import com.ejianc.business.utils.UpSumUtil;
import com.ejianc.foundation.share.utils.TreeNodeBUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="drawService")
public class DrawServiceImpl
extends BaseServiceImpl<DrawMapper, DrawEntity>
implements IDrawService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_CODE = "budgetmanager-draw";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IDrawSubService drawSubService;
    @Autowired
    private IDrawFeeService drawFeeService;
    @Autowired
    private IDrawOtherService drawOtherService;
    @Autowired
    private IDrawPriceService drawPriceService;
    @Autowired
    private IDrawTotalService drawTotalService;

    @Override
    public DrawVO saveOrUpdate(DrawVO saveorUpdateVO) {
        List<DrawTotalEntity> totalList;
        List<DrawPriceEntity> priceList;
        List<DrawOtherEntity> otherList;
        List<DrawFeeEntity> feeList;
        Long tenantId = InvocationInfoProxy.getTenantid();
        DrawEntity entity = (DrawEntity)((Object)BeanMapper.map((Object)((Object)saveorUpdateVO), DrawEntity.class));
        if (entity.getDrawVersion() == null) {
            entity.setDrawVersion(1);
        }
        if (saveorUpdateVO.getId() == null || saveorUpdateVO.getId() < 0L) {
            entity.setLatestFlag(true);
            entity.setEnableState(false);
            entity.setChangeState(0);
            if (StringUtils.isEmpty((CharSequence)saveorUpdateVO.getBillCode())) {
                BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)tenantId, (BaseVO)saveorUpdateVO);
                CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
                if (billCode.isSuccess()) {
                    entity.setBillCode((String)billCode.getData());
                } else {
                    throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
            }
            this.clearDetailId(entity);
        }
        super.saveOrUpdate((Object)entity, false);
        List<DrawSubEntity> subList = entity.getSubList();
        if (CollectionUtils.isNotEmpty(subList)) {
            ArrayList<DrawSubEntity> list = new ArrayList<DrawSubEntity>();
            HashSet<String> codeSet = new HashSet<String>();
            HashMap<String, Long> idMap = new HashMap<String, Long>();
            for (DrawSubEntity drawSubEntity : subList) {
                idMap.put(drawSubEntity.getTid(), drawSubEntity.getId());
            }
            for (DrawSubEntity drawSubEntity : subList) {
                if (StringUtils.isNotEmpty((CharSequence)drawSubEntity.getTpid())) {
                    drawSubEntity.setParentId((Long)idMap.get(drawSubEntity.getTpid()));
                }
                if ("del".equals(drawSubEntity.getRowState())) continue;
                list.add(drawSubEntity);
                if (codeSet.contains(drawSubEntity.getCode())) {
                    throw new BusinessException("\u5206\u90e8\u5206\u9879\u6e05\u5355\u4e2d[\u5b50\u76ee\u7f16\u7801]\u91cd\u590d\uff01");
                }
                codeSet.add(drawSubEntity.getCode());
            }
            this.drawSubService.saveOrUpdateBatch(list, list.size(), false);
        }
        if (CollectionUtils.isNotEmpty(feeList = entity.getFeeList())) {
            ArrayList<DrawFeeEntity> list = new ArrayList<DrawFeeEntity>();
            HashSet<String> codeSet = new HashSet<String>();
            HashMap<String, Long> idMap = new HashMap<String, Long>();
            for (DrawFeeEntity drawFeeEntity : feeList) {
                idMap.put(drawFeeEntity.getTid(), drawFeeEntity.getId());
            }
            for (DrawFeeEntity drawFeeEntity : feeList) {
                if (StringUtils.isNotEmpty((CharSequence)drawFeeEntity.getTpid())) {
                    drawFeeEntity.setParentId((Long)idMap.get(drawFeeEntity.getTpid()));
                }
                if ("del".equals(drawFeeEntity.getRowState())) continue;
                list.add(drawFeeEntity);
                if (codeSet.contains(drawFeeEntity.getCode())) {
                    throw new BusinessException("\u89c4\u8d39/\u7a0e\u91d1\u6e05\u5355\u4e2d[\u7f16\u7801]\u91cd\u590d\uff01");
                }
                codeSet.add(drawFeeEntity.getCode());
            }
            this.drawFeeService.saveOrUpdateBatch(list, list.size(), false);
        }
        if (CollectionUtils.isNotEmpty(otherList = entity.getOtherList())) {
            ArrayList<DrawOtherEntity> list = new ArrayList<DrawOtherEntity>();
            HashSet<String> codeSet = new HashSet<String>();
            HashMap<String, Long> hashMap = new HashMap<String, Long>();
            for (DrawOtherEntity drawOtherEntity : otherList) {
                hashMap.put(drawOtherEntity.getTid(), drawOtherEntity.getId());
            }
            for (DrawOtherEntity drawOtherEntity : otherList) {
                if (StringUtils.isNotEmpty((CharSequence)drawOtherEntity.getTpid())) {
                    drawOtherEntity.setParentId((Long)hashMap.get(drawOtherEntity.getTpid()));
                }
                if ("del".equals(drawOtherEntity.getRowState())) continue;
                list.add(drawOtherEntity);
                if (codeSet.contains(drawOtherEntity.getCode())) {
                    throw new BusinessException("\u5176\u4ed6\u9879\u6e05\u5355\u4e2d[\u7f16\u7801]\u91cd\u590d\uff01");
                }
                codeSet.add(drawOtherEntity.getCode());
            }
            this.drawOtherService.saveOrUpdateBatch(list, list.size(), false);
        }
        if (CollectionUtils.isNotEmpty(priceList = entity.getPriceList())) {
            ArrayList<DrawPriceEntity> list = new ArrayList<DrawPriceEntity>();
            HashSet<String> hashSet = new HashSet<String>();
            HashMap<String, Long> hashMap = new HashMap<String, Long>();
            for (DrawPriceEntity cdEntity : priceList) {
                hashMap.put(cdEntity.getTid(), cdEntity.getId());
            }
            for (DrawPriceEntity cdEntity : priceList) {
                if (StringUtils.isNotEmpty((CharSequence)cdEntity.getTpid())) {
                    cdEntity.setParentId((Long)hashMap.get(cdEntity.getTpid()));
                }
                if ("del".equals(cdEntity.getRowState())) continue;
                list.add(cdEntity);
                if (hashSet.contains(cdEntity.getCode())) {
                    throw new BusinessException("\u5355\u4ef7\u63aa\u65bd\u8d39\u6e05\u5355\u4e2d[\u5b50\u76ee\u7f16\u7801]\u91cd\u590d\uff01");
                }
                hashSet.add(cdEntity.getCode());
            }
            this.drawPriceService.saveOrUpdateBatch(list, list.size(), false);
        }
        if (CollectionUtils.isNotEmpty(totalList = entity.getTotalList())) {
            ArrayList<DrawTotalEntity> arrayList = new ArrayList<DrawTotalEntity>();
            HashSet<String> hashSet = new HashSet<String>();
            HashMap<String, Long> hashMap = new HashMap<String, Long>();
            for (DrawTotalEntity cdEntity : totalList) {
                hashMap.put(cdEntity.getTid(), cdEntity.getId());
            }
            for (DrawTotalEntity cdEntity : totalList) {
                if (StringUtils.isNotEmpty((CharSequence)cdEntity.getTpid())) {
                    cdEntity.setParentId((Long)hashMap.get(cdEntity.getTpid()));
                }
                if ("del".equals(cdEntity.getRowState())) continue;
                arrayList.add(cdEntity);
                if (hashSet.contains(cdEntity.getCode())) {
                    throw new BusinessException("\u603b\u4ef7\u63aa\u65bd\u8d39\u6e05\u5355\u4e2d[\u5b50\u76ee\u7f16\u7801]\u91cd\u590d\uff01");
                }
                hashSet.add(cdEntity.getCode());
            }
            this.drawTotalService.saveOrUpdateBatch(arrayList, arrayList.size(), false);
        }
        if (entity.getLastDrawId() != null) {
            LambdaUpdateWrapper lambdaUpdateWrapper = new LambdaUpdateWrapper();
            lambdaUpdateWrapper.eq(BaseEntity::getId, (Object)entity.getLastDrawId());
            lambdaUpdateWrapper.set(DrawEntity::getLatestFlag, (Object)false);
            lambdaUpdateWrapper.set(DrawEntity::getChangeId, (Object)entity.getId());
            lambdaUpdateWrapper.set(DrawEntity::getChangeState, (Object)ChangeStateEnum.\u53d8\u66f4\u4e2d.getCode());
            this.update((Wrapper)lambdaUpdateWrapper);
        }
        return this.queryDetail(entity.getId(), true);
    }

    private void clearDetailId(DrawEntity entity) {
        List<DrawTotalEntity> list;
        List<DrawPriceEntity> list2;
        List<DrawOtherEntity> otherList;
        List<DrawFeeEntity> feeList;
        List<DrawSubEntity> subList = entity.getSubList();
        if (CollectionUtils.isNotEmpty(subList)) {
            ArrayList<DrawSubEntity> list3 = new ArrayList<DrawSubEntity>();
            for (DrawSubEntity drawSubEntity : subList) {
                drawSubEntity.setId(null);
                if ("del".equals(drawSubEntity.getRowState())) continue;
                list3.add(drawSubEntity);
            }
            entity.setSubList(list3);
        }
        if (CollectionUtils.isNotEmpty(feeList = entity.getFeeList())) {
            ArrayList<DrawFeeEntity> list4 = new ArrayList<DrawFeeEntity>();
            for (DrawFeeEntity drawFeeEntity : feeList) {
                drawFeeEntity.setId(null);
                if ("del".equals(drawFeeEntity.getRowState())) continue;
                list4.add(drawFeeEntity);
            }
            entity.setFeeList(list4);
        }
        if (CollectionUtils.isNotEmpty(otherList = entity.getOtherList())) {
            ArrayList<DrawOtherEntity> arrayList = new ArrayList<DrawOtherEntity>();
            for (DrawOtherEntity drawOtherEntity : otherList) {
                drawOtherEntity.setId(null);
                if ("del".equals(drawOtherEntity.getRowState())) continue;
                arrayList.add(drawOtherEntity);
            }
            entity.setOtherList(arrayList);
        }
        if (CollectionUtils.isNotEmpty(list2 = entity.getPriceList())) {
            ArrayList<DrawPriceEntity> arrayList = new ArrayList<DrawPriceEntity>();
            for (DrawPriceEntity cdEntity : list2) {
                cdEntity.setId(null);
                if ("del".equals(cdEntity.getRowState())) continue;
                arrayList.add(cdEntity);
            }
            entity.setPriceList(arrayList);
        }
        if (CollectionUtils.isNotEmpty(list = entity.getTotalList())) {
            ArrayList<DrawTotalEntity> arrayList = new ArrayList<DrawTotalEntity>();
            for (DrawTotalEntity cdEntity : list) {
                cdEntity.setId(null);
                if ("del".equals(cdEntity.getRowState())) continue;
                arrayList.add(cdEntity);
            }
            entity.setTotalList(arrayList);
        }
    }

    @Override
    public DrawVO queryDetail(Long id, boolean hasChildren) {
        List<DrawTotalVO> list;
        List<DrawPriceVO> list2;
        List<DrawOtherVO> list3;
        List<DrawFeeVO> feeList;
        DrawEntity entity = (DrawEntity)((Object)super.selectById((Serializable)id));
        DrawVO vo = (DrawVO)((Object)BeanMapper.map((Object)((Object)entity), DrawVO.class));
        List<DrawSubVO> subList = vo.getSubList();
        if (CollectionUtils.isNotEmpty(subList)) {
            for (DrawSubVO drawSubVO : subList) {
                drawSubVO.setTid(drawSubVO.getId().toString());
                drawSubVO.setTpid(drawSubVO.getParentId() != null && drawSubVO.getParentId() > 0L ? drawSubVO.getParentId().toString() : "");
                drawSubVO.setRowState("edit");
            }
            new BudgetSortUtil<DrawSubVO>().entryListToSort(subList);
            if (hasChildren) {
                vo.setSubList(TreeNodeBUtil.buildTree(subList));
            } else {
                vo.setSubList(subList);
            }
        }
        if (CollectionUtils.isNotEmpty(feeList = vo.getFeeList())) {
            for (DrawFeeVO drawFeeVO : feeList) {
                drawFeeVO.setTid(drawFeeVO.getId().toString());
                drawFeeVO.setTpid(drawFeeVO.getParentId() != null && drawFeeVO.getParentId() > 0L ? drawFeeVO.getParentId().toString() : "");
                drawFeeVO.setRowState("edit");
            }
            new BudgetSortUtil<DrawFeeVO>().entryListToSort(feeList);
            if (hasChildren) {
                vo.setFeeList(TreeNodeBUtil.buildTree(feeList));
            } else {
                vo.setFeeList(feeList);
            }
        }
        if (CollectionUtils.isNotEmpty(list3 = vo.getOtherList())) {
            for (DrawOtherVO drawOtherVO : list3) {
                drawOtherVO.setTid(drawOtherVO.getId().toString());
                drawOtherVO.setTpid(drawOtherVO.getParentId() != null && drawOtherVO.getParentId() > 0L ? drawOtherVO.getParentId().toString() : "");
                drawOtherVO.setRowState("edit");
            }
            new BudgetSortUtil<DrawOtherVO>().entryListToSort(list3);
            if (hasChildren) {
                vo.setOtherList(TreeNodeBUtil.buildTree(list3));
            } else {
                vo.setOtherList(list3);
            }
        }
        if (CollectionUtils.isNotEmpty(list2 = vo.getPriceList())) {
            for (DrawPriceVO drawPriceVO : list2) {
                drawPriceVO.setTid(drawPriceVO.getId().toString());
                drawPriceVO.setTpid(drawPriceVO.getParentId() != null && drawPriceVO.getParentId() > 0L ? drawPriceVO.getParentId().toString() : "");
                drawPriceVO.setRowState("edit");
            }
            new BudgetSortUtil<DrawPriceVO>().entryListToSort(list2);
            if (hasChildren) {
                vo.setPriceList(TreeNodeBUtil.buildTree(list2));
            } else {
                vo.setPriceList(list2);
            }
        }
        if (CollectionUtils.isNotEmpty(list = vo.getTotalList())) {
            for (DrawTotalVO cdVO : list) {
                cdVO.setTid(cdVO.getId().toString());
                cdVO.setTpid(cdVO.getParentId() != null && cdVO.getParentId() > 0L ? cdVO.getParentId().toString() : "");
                cdVO.setRowState("edit");
            }
            new BudgetSortUtil<DrawTotalVO>().entryListToSort(list);
            if (hasChildren) {
                vo.setTotalList(TreeNodeBUtil.buildTree(list));
            } else {
                vo.setTotalList(list);
            }
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(DrawEntity::getProjectId, (Object)entity.getProjectId());
        lambdaQueryWrapper.eq(DrawEntity::getLatestFlag, (Object)false);
        lambdaQueryWrapper.eq(DrawEntity::getEnableState, (Object)false);
        lambdaQueryWrapper.orderByAsc(DrawEntity::getDrawVersion);
        List changeList = this.list((Wrapper)lambdaQueryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)changeList)) {
            vo.setChangeList(BeanMapper.mapList((Iterable)changeList, DrawVO.class));
        }
        return vo;
    }

    @Override
    public DrawVO queryReviseDetail(Long id) {
        List<DrawFeeVO> list;
        List<DrawOtherVO> list2;
        List<DrawTotalVO> totalList;
        List<DrawPriceVO> priceList;
        DrawVO vo = this.queryDetail(id, false);
        vo.setId(null);
        vo.setBillCode(null);
        vo.setBillState(null);
        vo.setCreateTime(null);
        vo.setCreateUserCode(null);
        vo.setUpdateTime(null);
        vo.setUpdateUserCode(null);
        vo.setDrawVersion(vo.getDrawVersion() + 1);
        vo.setBeforeDrawVersion(vo.getDrawVersion());
        vo.setChangeState(ChangeStateEnum.\u672a\u53d8\u66f4.getCode());
        vo.setLastDrawId(id);
        vo.setLatestFlag(true);
        vo.setEnableState(false);
        vo.setBeforeBudgetMny(vo.getBudgetMny());
        vo.setBeforeEstimateMny(vo.getEstimateMny());
        vo.setBeforeFeeMny(vo.getFeeMny());
        vo.setBeforeOtherMny(vo.getOtherMny());
        vo.setBeforePriceMeasureMny(vo.getPriceMeasureMny());
        vo.setBeforeSubMny(vo.getSubMny());
        vo.setBeforeTaxesMny(vo.getTaxesMny());
        vo.setBeforeTotalMeasureMny(vo.getTotalMeasureMny());
        vo.setVersion(null);
        List<DrawSubVO> changeDetailList = vo.getSubList();
        if (CollectionUtils.isNotEmpty(changeDetailList)) {
            HashMap idMap = new HashMap();
            changeDetailList.forEach(changeDetailVO -> {
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setSourceId(changeDetailVO.getId());
                changeDetailVO.setTid(changeDetailVO.getId().toString());
                changeDetailVO.setTpid(changeDetailVO.getParentId() != null && changeDetailVO.getParentId() > 0L ? changeDetailVO.getParentId().toString() : "");
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());
                changeDetailVO.setDrawId(null);
                changeDetailVO.setVersion(null);
                idMap.put(changeDetailVO.getTid(), changeDetailVO.getId());
            });
            for (DrawSubVO drawSubVO : changeDetailList) {
                if (!StringUtils.isNotEmpty((CharSequence)drawSubVO.getTpid())) continue;
                drawSubVO.setParentId((Long)idMap.get(drawSubVO.getTpid()));
            }
            vo.setSubList(TreeNodeBUtil.buildTree(changeDetailList));
        }
        if (CollectionUtils.isNotEmpty(priceList = vo.getPriceList())) {
            HashMap idMap = new HashMap();
            priceList.forEach(changeDetailVO -> {
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setSourceId(changeDetailVO.getId());
                changeDetailVO.setTid(changeDetailVO.getId().toString());
                changeDetailVO.setTpid(changeDetailVO.getParentId() != null && changeDetailVO.getParentId() > 0L ? changeDetailVO.getParentId().toString() : "");
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());
                changeDetailVO.setDrawId(null);
                changeDetailVO.setVersion(null);
                idMap.put(changeDetailVO.getTid(), changeDetailVO.getId());
            });
            for (DrawPriceVO drawPriceVO : priceList) {
                if (!StringUtils.isNotEmpty((CharSequence)drawPriceVO.getTpid())) continue;
                drawPriceVO.setParentId((Long)idMap.get(drawPriceVO.getTpid()));
            }
            vo.setPriceList(TreeNodeBUtil.buildTree(priceList));
        }
        if (CollectionUtils.isNotEmpty(totalList = vo.getTotalList())) {
            HashMap hashMap = new HashMap();
            totalList.forEach(changeDetailVO -> {
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setSourceId(changeDetailVO.getId());
                changeDetailVO.setTid(changeDetailVO.getId().toString());
                changeDetailVO.setTpid(changeDetailVO.getParentId() != null && changeDetailVO.getParentId() > 0L ? changeDetailVO.getParentId().toString() : "");
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());
                changeDetailVO.setDrawId(null);
                changeDetailVO.setVersion(null);
                idMap.put(changeDetailVO.getTid(), changeDetailVO.getId());
            });
            for (DrawTotalVO drawTotalVO : totalList) {
                if (!StringUtils.isNotEmpty((CharSequence)drawTotalVO.getTpid())) continue;
                drawTotalVO.setParentId((Long)hashMap.get(drawTotalVO.getTpid()));
            }
            vo.setTotalList(TreeNodeBUtil.buildTree(totalList));
        }
        if (CollectionUtils.isNotEmpty(list2 = vo.getOtherList())) {
            HashMap hashMap = new HashMap();
            list2.forEach(changeDetailVO -> {
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setSourceId(changeDetailVO.getId());
                changeDetailVO.setTid(changeDetailVO.getId().toString());
                changeDetailVO.setTpid(changeDetailVO.getParentId() != null && changeDetailVO.getParentId() > 0L ? changeDetailVO.getParentId().toString() : "");
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());
                changeDetailVO.setDrawId(null);
                changeDetailVO.setVersion(null);
                idMap.put(changeDetailVO.getTid(), changeDetailVO.getId());
            });
            for (DrawOtherVO cdEntity : list2) {
                if (!StringUtils.isNotEmpty((CharSequence)cdEntity.getTpid())) continue;
                cdEntity.setParentId((Long)hashMap.get(cdEntity.getTpid()));
            }
            vo.setOtherList(TreeNodeBUtil.buildTree(list2));
        }
        if (CollectionUtils.isNotEmpty(list = vo.getFeeList())) {
            HashMap hashMap = new HashMap();
            list.forEach(changeDetailVO -> {
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setSourceId(changeDetailVO.getId());
                changeDetailVO.setTid(changeDetailVO.getId().toString());
                changeDetailVO.setTpid(changeDetailVO.getParentId() != null && changeDetailVO.getParentId() > 0L ? changeDetailVO.getParentId().toString() : "");
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());
                changeDetailVO.setDrawId(null);
                changeDetailVO.setVersion(null);
                idMap.put(changeDetailVO.getTid(), changeDetailVO.getId());
            });
            for (DrawFeeVO cdEntity : list) {
                if (!StringUtils.isNotEmpty((CharSequence)cdEntity.getTpid())) continue;
                cdEntity.setParentId((Long)hashMap.get(cdEntity.getTpid()));
            }
            vo.setFeeList(TreeNodeBUtil.buildTree(list));
        }
        return vo;
    }

    @Override
    public CommonResponse<JSONObject> excelImportInfo(HttpServletRequest request, HttpServletResponse response) {
        String importType;
        switch (importType = request.getParameter("importType")) {
            case "sub": {
                return this.excelImportSub(request);
            }
            case "price": {
                return this.excelImportPrice(request);
            }
            case "total": {
                return this.excelImportTotal(request);
            }
            case "other": {
                return this.excelImportOther(request);
            }
            case "fee": {
                return this.excelImportFee(request);
            }
        }
        return CommonResponse.success();
    }

    private CommonResponse<JSONObject> excelImportFee(HttpServletRequest request) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        JSONObject resp = new JSONObject();
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5\uff01");
        }
        List<List<List<String>>> resList = DetailIndexExcelReader.readExcel(mf);
        List<List<String>> result = resList.get(0);
        if (result.size() > 0 && result.get(0).size() < 8) {
            return CommonResponse.error((String)"[\u8d39\u7a0e\u9879\u6e05\u5355]\u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f\uff01");
        }
        ArrayList<DrawFeeVO> successList = new ArrayList<DrawFeeVO>();
        ArrayList<ImportErrorVo> errorList = new ArrayList<ImportErrorVo>();
        if (result != null && result.size() > 0) {
            ArrayList<String> detailIndexList = new ArrayList<String>();
            HashMap<String, Long> parentMap = new HashMap<String, Long>();
            ArrayList<DrawFeeVO> detailVoList = new ArrayList<DrawFeeVO>();
            boolean importFlag = true;
            for (int i = 0; i < result.size(); ++i) {
                List<String> datas = result.get(i);
                DrawFeeVO vo = new DrawFeeVO();
                boolean flag = false;
                String warnType = "";
                String indexCode = datas.get(0);
                String code = datas.get(0);
                String name = datas.get(1);
                String feature = datas.get(2);
                String computerMny = datas.get(3);
                String taxRate = datas.get(4);
                String mny = datas.get(5);
                String type = datas.get(6);
                String memo = datas.get(7);
                Long id = IdWorker.getId();
                vo.setId(id);
                if (StringUtils.isNotEmpty((CharSequence)indexCode)) {
                    indexCode = indexCode.trim();
                    vo.setIndexCode(indexCode);
                    parentMap.put(indexCode, id);
                    String[] split = this.splitDetailIndex(indexCode);
                    if (split.length > 1) {
                        StringBuffer tpid = new StringBuffer();
                        for (int j = 0; j < split.length - 1; ++j) {
                            tpid.append(split[j]);
                        }
                        vo.setTpid(tpid.toString());
                    }
                    vo.setDetailIndex(String.valueOf(split.length));
                    if (detailIndexList.contains(indexCode)) {
                        warnType = warnType + "[\u7f16\u7801\u91cd\u590d]";
                        flag = true;
                    } else {
                        detailIndexList.add(indexCode);
                    }
                    if (split.length == 4) {
                        vo.setLeafFlag(true);
                    } else {
                        vo.setLeafFlag(false);
                    }
                } else {
                    vo.setIndexCode(null);
                    warnType = warnType + "[\u7f16\u7801\u4e3a\u7a7a]";
                    flag = true;
                }
                if (StringUtils.isEmpty((CharSequence)code)) {
                    vo.setCode(null);
                } else {
                    vo.setCode(code);
                }
                if (StringUtils.isEmpty((CharSequence)name)) {
                    vo.setName(null);
                    warnType = warnType + "[\u540d\u79f0\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    vo.setName(name);
                }
                vo.setFeature(feature);
                if (StringUtils.isEmpty((CharSequence)computerMny)) {
                    vo.setComputerMny(null);
                } else {
                    try {
                        vo.setComputerMny(new BigDecimal(computerMny));
                    }
                    catch (Exception e) {
                        vo.setComputerMny(null);
                        warnType = warnType + "[\u8ba1\u7b97\u57fa\u6570\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)taxRate)) {
                    vo.setTaxRate(null);
                } else {
                    try {
                        vo.setTaxRate(new BigDecimal(taxRate));
                    }
                    catch (Exception e) {
                        vo.setTaxRate(null);
                        warnType = warnType + "[\u8d39\u7387\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)mny)) {
                    vo.setMny(null);
                } else {
                    try {
                        vo.setMny(new BigDecimal(mny));
                    }
                    catch (Exception e) {
                        vo.setMny(null);
                        warnType = warnType + "[\u91d1\u989d\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)type)) {
                    vo.setType(1);
                } else {
                    vo.setType("\u7a0e\u91d1".endsWith(type) ? 2 : 1);
                }
                vo.setMemo(memo);
                vo.setImportFlag(!flag);
                if (importFlag) {
                    importFlag = !flag;
                }
                vo.setWarnType(warnType);
                detailVoList.add(vo);
            }
            for (DrawFeeVO vo : detailVoList) {
                if (vo.getImportFlag().booleanValue()) {
                    if (!importFlag) continue;
                    String indexCode = vo.getIndexCode();
                    Boolean leafFlag = true;
                    for (String code : detailIndexList) {
                        if (!code.startsWith(indexCode) || code.equals(indexCode) || vo.getLeafFlag().booleanValue() || code.length() - indexCode.length() <= 1) continue;
                        leafFlag = false;
                        break;
                    }
                    vo.setLeafFlag(leafFlag);
                    vo.setParentId((Long)parentMap.get(vo.getTpid()));
                    vo.setTid(String.valueOf(vo.getId()));
                    vo.setTpid(null != vo.getParentId() ? String.valueOf(vo.getParentId()) : "");
                    if (!leafFlag.booleanValue()) {
                        vo.setFeature(null);
                        vo.setComputerMny(null);
                        vo.setTaxRate(null);
                        vo.setMny(null);
                    }
                    successList.add(vo);
                    continue;
                }
                ImportErrorVo errorVo = new ImportErrorVo();
                errorVo.setPageName("\u5355\u4ef7\u63aa\u65bd\u9879\u6e05\u5355");
                errorVo.setId(vo.getId());
                errorVo.setIndexCode(vo.getIndexCode());
                errorVo.setCode(vo.getCode());
                errorVo.setName(vo.getName());
                errorVo.setWarnType(vo.getWarnType());
                errorList.add(errorVo);
            }
            if (errorList.size() > 0) {
                resp.put("successList", null);
                resp.put("successNum", (Object)0);
                resp.put("errorNum", (Object)errorList.size());
                if (errorList.size() > 100) {
                    resp.put("errorList", errorList.subList(0, 100));
                } else {
                    resp.put("errorList", errorList);
                }
            } else {
                new TaxCalculateUtil().calculate(successList);
                List subVOS = TreeNodeBUtil.buildTree(successList);
                UpSumUtil drawSubVOUpSumUtil = new UpSumUtil();
                drawSubVOUpSumUtil.creatCode(subVOS, null);
                drawSubVOUpSumUtil.upSum(subVOS, "mny");
                resp.put("feeSuccessList", (Object)subVOS);
                resp.put("errorList", null);
                resp.put("successNum", (Object)subVOS.size());
                resp.put("errorNum", (Object)0);
            }
        }
        return CommonResponse.success((Object)resp);
    }

    private CommonResponse<JSONObject> excelImportOther(HttpServletRequest request) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        JSONObject resp = new JSONObject();
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5\uff01");
        }
        List<List<List<String>>> resList = DetailIndexExcelReader.readExcel(mf);
        List<List<String>> result = resList.get(0);
        if (result.size() > 0 && result.get(0).size() < 6) {
            return CommonResponse.error((String)"[\u5176\u4ed6\u9879\u6e05\u5355]\u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f\uff01");
        }
        ArrayList<DrawOtherVO> successList = new ArrayList<DrawOtherVO>();
        ArrayList<ImportErrorVo> errorList = new ArrayList<ImportErrorVo>();
        if (result != null && result.size() > 0) {
            ArrayList<String> detailIndexList = new ArrayList<String>();
            HashMap<String, Long> parentMap = new HashMap<String, Long>();
            ArrayList<DrawOtherVO> detailVoList = new ArrayList<DrawOtherVO>();
            boolean importFlag = true;
            for (int i = 0; i < result.size(); ++i) {
                List<String> datas = result.get(i);
                DrawOtherVO vo = new DrawOtherVO();
                boolean flag = false;
                String warnType = "";
                String indexCode = datas.get(0);
                String code = datas.get(0);
                String name = datas.get(1);
                String unit = datas.get(2);
                String mny = datas.get(3);
                String estimateFlag = datas.get(4);
                String memo = datas.get(5);
                Long id = IdWorker.getId();
                vo.setId(id);
                if (StringUtils.isNotEmpty((CharSequence)indexCode)) {
                    indexCode = indexCode.trim();
                    vo.setIndexCode(indexCode);
                    parentMap.put(indexCode, id);
                    String[] split = this.splitDetailIndex(indexCode);
                    if (split.length > 1) {
                        StringBuffer tpid = new StringBuffer();
                        for (int j = 0; j < split.length - 1; ++j) {
                            tpid.append(split[j]);
                        }
                        vo.setTpid(tpid.toString());
                    }
                    vo.setDetailIndex(String.valueOf(split.length));
                    if (detailIndexList.contains(indexCode)) {
                        warnType = warnType + "[\u5b50\u76ee\u7f16\u7801\u91cd\u590d]";
                        flag = true;
                    } else {
                        detailIndexList.add(indexCode);
                    }
                    if (split.length == 4) {
                        vo.setLeafFlag(true);
                    } else {
                        vo.setLeafFlag(false);
                    }
                } else {
                    vo.setIndexCode(null);
                    warnType = warnType + "[\u5b50\u76ee\u7f16\u7801\u4e3a\u7a7a]";
                    flag = true;
                }
                if (StringUtils.isEmpty((CharSequence)code)) {
                    flag = true;
                } else {
                    vo.setCode(code);
                }
                if (StringUtils.isEmpty((CharSequence)name)) {
                    vo.setName(null);
                    warnType = warnType + "[\u5b50\u76ee\u540d\u79f0\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    vo.setName(name);
                }
                vo.setUnit(unit);
                if (StringUtils.isEmpty((CharSequence)estimateFlag)) {
                    vo.setEstimateFlag(0);
                } else {
                    vo.setEstimateFlag("\u662f".equals(estimateFlag) ? 1 : 0);
                }
                if (StringUtils.isEmpty((CharSequence)mny)) {
                    vo.setMny(null);
                } else {
                    try {
                        vo.setMny(new BigDecimal(mny));
                    }
                    catch (Exception e) {
                        vo.setMny(null);
                        warnType = warnType + "[\u91d1\u989d(\u9664\u7a0e)\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                vo.setMemo(memo);
                vo.setImportFlag(!flag);
                if (importFlag) {
                    importFlag = !flag;
                }
                vo.setWarnType(warnType);
                detailVoList.add(vo);
            }
            for (DrawOtherVO vo : detailVoList) {
                if (vo.getImportFlag().booleanValue()) {
                    if (!importFlag) continue;
                    String indexCode = vo.getIndexCode();
                    Boolean leafFlag = true;
                    for (String code : detailIndexList) {
                        if (!code.startsWith(indexCode) || code.equals(indexCode) || vo.getLeafFlag().booleanValue() || code.length() - indexCode.length() <= 1) continue;
                        leafFlag = false;
                        break;
                    }
                    vo.setLeafFlag(leafFlag);
                    vo.setParentId((Long)parentMap.get(vo.getTpid()));
                    vo.setTid(String.valueOf(vo.getId()));
                    vo.setTpid(null != vo.getParentId() ? String.valueOf(vo.getParentId()) : "");
                    if (!leafFlag.booleanValue()) {
                        vo.setMny(null);
                    }
                    successList.add(vo);
                    continue;
                }
                ImportErrorVo errorVo = new ImportErrorVo();
                errorVo.setPageName("\u5176\u4ed6\u9879\u6e05\u5355");
                errorVo.setId(vo.getId());
                errorVo.setIndexCode(vo.getIndexCode());
                errorVo.setCode(vo.getCode());
                errorVo.setName(vo.getName());
                errorVo.setWarnType(vo.getWarnType());
                errorList.add(errorVo);
            }
            if (errorList.size() > 0) {
                resp.put("successList", null);
                resp.put("successNum", (Object)0);
                resp.put("errorNum", (Object)errorList.size());
                if (errorList.size() > 100) {
                    resp.put("errorList", errorList.subList(0, 100));
                } else {
                    resp.put("errorList", errorList);
                }
            } else {
                new TaxCalculateUtil().calculate(successList);
                List subVOS = TreeNodeBUtil.buildTree(successList);
                UpSumUtil drawSubVOUpSumUtil = new UpSumUtil();
                drawSubVOUpSumUtil.creatCode(subVOS, null);
                drawSubVOUpSumUtil.upSum(subVOS, "mny");
                resp.put("otherSuccessList", (Object)subVOS);
                resp.put("errorList", null);
                resp.put("successNum", (Object)subVOS.size());
                resp.put("errorNum", (Object)0);
            }
        }
        return CommonResponse.success((Object)resp);
    }

    private CommonResponse<JSONObject> excelImportTotal(HttpServletRequest request) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        JSONObject resp = new JSONObject();
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5\uff01");
        }
        List<List<List<String>>> resList = DetailIndexExcelReader.readExcel(mf);
        List<List<String>> result = resList.get(0);
        if (result.size() > 0 && result.get(0).size() < 6) {
            return CommonResponse.error((String)"[\u603b\u4ef7\u63aa\u65bd\u9879\u6e05\u5355]\u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f\uff01");
        }
        ArrayList<DrawTotalVO> successList = new ArrayList<DrawTotalVO>();
        ArrayList<ImportErrorVo> errorList = new ArrayList<ImportErrorVo>();
        if (result != null && result.size() > 0) {
            ArrayList<String> detailIndexList = new ArrayList<String>();
            HashMap<String, Long> parentMap = new HashMap<String, Long>();
            ArrayList<DrawTotalVO> detailVoList = new ArrayList<DrawTotalVO>();
            boolean importFlag = true;
            for (int i = 0; i < result.size(); ++i) {
                List<String> datas = result.get(i);
                DrawTotalVO vo = new DrawTotalVO();
                boolean flag = false;
                String warnType = "";
                String indexCode = datas.get(0);
                String code = datas.get(0);
                String name = datas.get(1);
                String feature = datas.get(2);
                String rate = datas.get(3);
                String mny = datas.get(4);
                String memo = datas.get(5);
                Long id = IdWorker.getId();
                vo.setId(id);
                if (StringUtils.isNotEmpty((CharSequence)indexCode)) {
                    indexCode = indexCode.trim();
                    vo.setIndexCode(indexCode);
                    parentMap.put(indexCode, id);
                    String[] split = this.splitDetailIndex(indexCode);
                    if (split.length > 1) {
                        StringBuffer tpid = new StringBuffer();
                        for (int j = 0; j < split.length - 1; ++j) {
                            tpid.append(split[j]);
                        }
                        vo.setTpid(tpid.toString());
                    }
                    vo.setDetailIndex(String.valueOf(split.length));
                    if (detailIndexList.contains(indexCode)) {
                        warnType = warnType + "[\u5b50\u76ee\u7f16\u7801\u91cd\u590d]";
                        flag = true;
                    } else {
                        detailIndexList.add(indexCode);
                    }
                    if (split.length == 4) {
                        vo.setLeafFlag(true);
                    } else {
                        vo.setLeafFlag(false);
                    }
                } else {
                    vo.setIndexCode(null);
                    warnType = warnType + "[\u5b50\u76ee\u7f16\u7801\u4e3a\u7a7a]";
                    flag = true;
                }
                if (StringUtils.isEmpty((CharSequence)code)) {
                    vo.setCode(null);
                } else {
                    vo.setCode(code);
                }
                if (StringUtils.isEmpty((CharSequence)name)) {
                    vo.setName(null);
                    warnType = warnType + "[\u5b50\u76ee\u540d\u79f0\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    vo.setName(name);
                }
                vo.setFeature(feature);
                vo.setFeature(feature);
                if (StringUtils.isEmpty((CharSequence)rate)) {
                    vo.setRate(null);
                } else {
                    try {
                        vo.setRate(new BigDecimal(rate));
                    }
                    catch (Exception e) {
                        vo.setRate(null);
                        warnType = warnType + "[\u8d39\u7387\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)mny)) {
                    vo.setMny(null);
                } else {
                    try {
                        vo.setMny(new BigDecimal(mny));
                    }
                    catch (Exception e) {
                        vo.setMny(null);
                        warnType = warnType + "[\u91d1\u989d(\u9664\u7a0e)\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                vo.setMemo(memo);
                vo.setImportFlag(!flag);
                if (importFlag) {
                    importFlag = !flag;
                }
                vo.setWarnType(warnType);
                detailVoList.add(vo);
            }
            for (DrawTotalVO vo : detailVoList) {
                if (vo.getImportFlag().booleanValue()) {
                    if (!importFlag) continue;
                    String indexCode = vo.getIndexCode();
                    Boolean leafFlag = true;
                    for (String code : detailIndexList) {
                        if (!code.startsWith(indexCode) || code.equals(indexCode) || vo.getLeafFlag().booleanValue() || code.length() - indexCode.length() <= 1) continue;
                        leafFlag = false;
                        break;
                    }
                    vo.setLeafFlag(leafFlag);
                    vo.setParentId((Long)parentMap.get(vo.getTpid()));
                    vo.setTid(String.valueOf(vo.getId()));
                    vo.setTpid(null != vo.getParentId() ? String.valueOf(vo.getParentId()) : "");
                    if (!leafFlag.booleanValue()) {
                        vo.setFeature(null);
                        vo.setRate(null);
                        vo.setMny(null);
                    }
                    successList.add(vo);
                    continue;
                }
                ImportErrorVo errorVo = new ImportErrorVo();
                errorVo.setPageName("\u603b\u4ef7\u63aa\u65bd\u9879\u6e05\u5355");
                errorVo.setId(vo.getId());
                errorVo.setIndexCode(vo.getIndexCode());
                errorVo.setCode(vo.getCode());
                errorVo.setName(vo.getName());
                errorVo.setWarnType(vo.getWarnType());
                errorList.add(errorVo);
            }
            if (errorList.size() > 0) {
                resp.put("successList", null);
                resp.put("successNum", (Object)0);
                resp.put("errorNum", (Object)errorList.size());
                if (errorList.size() > 100) {
                    resp.put("errorList", errorList.subList(0, 100));
                } else {
                    resp.put("errorList", errorList);
                }
            } else {
                new TaxCalculateUtil().calculate(successList);
                List subVOS = TreeNodeBUtil.buildTree(successList);
                UpSumUtil drawSubVOUpSumUtil = new UpSumUtil();
                drawSubVOUpSumUtil.creatCode(subVOS, null);
                drawSubVOUpSumUtil.upSum(subVOS, "mny");
                resp.put("totalSuccessList", (Object)subVOS);
                resp.put("errorList", null);
                resp.put("successNum", (Object)subVOS.size());
                resp.put("errorNum", (Object)0);
            }
        }
        return CommonResponse.success((Object)resp);
    }

    private CommonResponse<JSONObject> excelImportPrice(HttpServletRequest request) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        JSONObject resp = new JSONObject();
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5\uff01");
        }
        Integer size = DetailIndexExcelReader.getNumberOfSheets(mf);
        if (size == null || size != 5) {
            return CommonResponse.error((String)"\u6587\u4ef6\u9875\u7b7e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f\uff01");
        }
        List<List<List<String>>> resList = DetailIndexExcelReader.readExcel(mf);
        List<List<String>> result = resList.get(1);
        if (result.size() > 0 && result.get(0).size() < 8) {
            return CommonResponse.error((String)"[\u5355\u4ef7\u63aa\u65bd\u9879\u6e05\u5355]\u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f\uff01");
        }
        ArrayList<DrawPriceVO> successList = new ArrayList<DrawPriceVO>();
        ArrayList<ImportErrorVo> errorList = new ArrayList<ImportErrorVo>();
        if (result != null && result.size() > 0) {
            ArrayList<String> detailIndexList = new ArrayList<String>();
            HashMap<String, Long> parentMap = new HashMap<String, Long>();
            ArrayList<DrawPriceVO> detailVoList = new ArrayList<DrawPriceVO>();
            boolean importFlag = true;
            for (int i = 0; i < result.size(); ++i) {
                List<String> datas = result.get(i);
                DrawPriceVO vo = new DrawPriceVO();
                boolean flag = false;
                String warnType = "";
                String indexCode = datas.get(0);
                String code = datas.get(0);
                String name = datas.get(1);
                String feature = datas.get(2);
                String unit = datas.get(3);
                String num = datas.get(4);
                String price = datas.get(5);
                String mny = datas.get(6);
                String memo = datas.get(7);
                Long id = IdWorker.getId();
                vo.setId(id);
                if (StringUtils.isNotEmpty((CharSequence)indexCode)) {
                    indexCode = indexCode.trim();
                    vo.setIndexCode(indexCode);
                    parentMap.put(indexCode, id);
                    String[] split = this.splitDetailIndex(indexCode);
                    if (split.length > 1) {
                        StringBuffer tpid = new StringBuffer();
                        for (int j = 0; j < split.length - 1; ++j) {
                            tpid.append(split[j]);
                        }
                        vo.setTpid(tpid.toString());
                    }
                    vo.setDetailIndex(String.valueOf(split.length));
                    if (detailIndexList.contains(indexCode)) {
                        warnType = warnType + "[\u5b50\u76ee\u7f16\u7801\u91cd\u590d]";
                        flag = true;
                    } else {
                        detailIndexList.add(indexCode);
                    }
                    if (split.length == 4) {
                        vo.setLeafFlag(true);
                    } else {
                        vo.setLeafFlag(false);
                    }
                } else {
                    vo.setIndexCode(null);
                    warnType = warnType + "[\u5b50\u76ee\u7f16\u7801\u4e3a\u7a7a]";
                    flag = true;
                }
                if (StringUtils.isEmpty((CharSequence)code)) {
                    vo.setCode(null);
                } else {
                    vo.setCode(code);
                }
                if (StringUtils.isEmpty((CharSequence)name)) {
                    vo.setName(null);
                    warnType = warnType + "[\u5b50\u76ee\u540d\u79f0\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    vo.setName(name);
                }
                vo.setFeature(feature);
                vo.setUnit(unit);
                if (StringUtils.isEmpty((CharSequence)num)) {
                    vo.setNum(null);
                } else {
                    try {
                        vo.setNum(new BigDecimal(num));
                    }
                    catch (Exception e) {
                        vo.setNum(null);
                        warnType = warnType + "[\u5de5\u7a0b\u91cf\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)price)) {
                    vo.setPrice(null);
                } else {
                    try {
                        vo.setPrice(new BigDecimal(price));
                    }
                    catch (Exception e) {
                        vo.setPrice(null);
                        warnType = warnType + "[\u7efc\u5408\u5355\u4ef7(\u9664\u7a0e)\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)mny)) {
                    vo.setMny(null);
                } else {
                    try {
                        vo.setMny(new BigDecimal(mny));
                    }
                    catch (Exception e) {
                        vo.setMny(null);
                        warnType = warnType + "[\u5408\u4ef7(\u9664\u7a0e)\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                vo.setMemo(memo);
                vo.setImportFlag(!flag);
                if (importFlag) {
                    importFlag = !flag;
                }
                vo.setWarnType(warnType);
                detailVoList.add(vo);
            }
            for (DrawPriceVO vo : detailVoList) {
                if (vo.getImportFlag().booleanValue()) {
                    if (!importFlag) continue;
                    String indexCode = vo.getIndexCode();
                    Boolean leafFlag = true;
                    for (String code : detailIndexList) {
                        if (!code.startsWith(indexCode) || code.equals(indexCode) || vo.getLeafFlag().booleanValue() || code.length() - indexCode.length() <= 1) continue;
                        leafFlag = false;
                        break;
                    }
                    vo.setLeafFlag(leafFlag);
                    vo.setParentId((Long)parentMap.get(vo.getTpid()));
                    vo.setTid(String.valueOf(vo.getId()));
                    vo.setTpid(null != vo.getParentId() ? String.valueOf(vo.getParentId()) : "");
                    if (!leafFlag.booleanValue()) {
                        vo.setNum(null);
                        vo.setPrice(null);
                        vo.setMny(null);
                    }
                    successList.add(vo);
                    continue;
                }
                ImportErrorVo errorVo = new ImportErrorVo();
                errorVo.setPageName("\u5355\u4ef7\u63aa\u65bd\u9879\u6e05\u5355");
                errorVo.setId(vo.getId());
                errorVo.setIndexCode(vo.getIndexCode());
                errorVo.setCode(vo.getCode());
                errorVo.setName(vo.getName());
                errorVo.setUnit(vo.getUnit());
                errorVo.setWarnType(vo.getWarnType());
                errorList.add(errorVo);
            }
            if (errorList.size() > 0) {
                resp.put("successList", null);
                resp.put("successNum", (Object)0);
                resp.put("errorNum", (Object)errorList.size());
                if (errorList.size() > 100) {
                    resp.put("errorList", errorList.subList(0, 100));
                } else {
                    resp.put("errorList", errorList);
                }
            } else {
                new TaxCalculateUtil().calculate(successList);
                List priceVOS = TreeNodeBUtil.buildTree(successList);
                UpSumUtil drawPriceVOUpSumUtil = new UpSumUtil();
                drawPriceVOUpSumUtil.upSum(priceVOS, "mny");
                drawPriceVOUpSumUtil.creatCode(priceVOS, null);
                resp.put("priceSuccessList", (Object)priceVOS);
                resp.put("errorList", null);
                resp.put("successNum", (Object)priceVOS.size());
                resp.put("errorNum", (Object)0);
            }
        }
        return CommonResponse.success((Object)resp);
    }

    private CommonResponse<JSONObject> excelImportSub(HttpServletRequest request) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        JSONObject resp = new JSONObject();
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5\uff01");
        }
        List<List<List<String>>> resList = DetailIndexExcelReader.readExcel(mf);
        List<List<String>> result = resList.get(0);
        if (result.size() > 0 && result.get(0).size() < 8) {
            return CommonResponse.error((String)"[\u5206\u90e8\u5206\u9879\u6e05\u5355]\u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f\uff01");
        }
        ArrayList<DrawSubVO> successList = new ArrayList<DrawSubVO>();
        ArrayList<ImportErrorVo> errorList = new ArrayList<ImportErrorVo>();
        if (result != null && result.size() > 0) {
            ArrayList<String> detailIndexList = new ArrayList<String>();
            HashMap<String, Long> parentMap = new HashMap<String, Long>();
            ArrayList<DrawSubVO> detailVoList = new ArrayList<DrawSubVO>();
            boolean importFlag = true;
            for (int i = 0; i < result.size(); ++i) {
                List<String> datas = result.get(i);
                DrawSubVO vo = new DrawSubVO();
                boolean flag = false;
                String warnType = "";
                String indexCode = datas.get(0);
                String code = datas.get(0);
                String name = datas.get(1);
                String feature = datas.get(2);
                String unit = datas.get(3);
                String num = datas.get(4);
                String price = datas.get(5);
                String mny = datas.get(6);
                String memo = datas.get(7);
                Long id = IdWorker.getId();
                vo.setId(id);
                if (StringUtils.isNotEmpty((CharSequence)indexCode)) {
                    indexCode = indexCode.trim();
                    vo.setIndexCode(indexCode);
                    parentMap.put(indexCode, id);
                    String[] split = this.splitDetailIndex(indexCode);
                    if (split.length > 1) {
                        StringBuffer tpid = new StringBuffer();
                        for (int j = 0; j < split.length - 1; ++j) {
                            tpid.append(split[j]);
                        }
                        vo.setTpid(tpid.toString());
                    }
                    vo.setDetailIndex(String.valueOf(split.length));
                    if (detailIndexList.contains(indexCode)) {
                        warnType = warnType + "[\u5b50\u76ee\u7f16\u7801\u91cd\u590d]";
                        flag = true;
                    } else {
                        detailIndexList.add(indexCode);
                    }
                    if (split.length == 4) {
                        vo.setLeafFlag(true);
                    } else {
                        vo.setLeafFlag(false);
                    }
                } else {
                    vo.setIndexCode(null);
                    warnType = warnType + "[\u5b50\u76ee\u7f16\u7801\u4e3a\u7a7a]";
                    flag = true;
                }
                if (StringUtils.isEmpty((CharSequence)code)) {
                    vo.setCode(null);
                } else {
                    vo.setCode(code);
                }
                if (StringUtils.isEmpty((CharSequence)name)) {
                    vo.setName(null);
                    warnType = warnType + "[\u5b50\u76ee\u540d\u79f0\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    vo.setName(name);
                }
                vo.setFeature(feature);
                vo.setUnit(unit);
                if (StringUtils.isEmpty((CharSequence)num)) {
                    vo.setNum(null);
                } else {
                    try {
                        vo.setNum(new BigDecimal(num));
                    }
                    catch (Exception e) {
                        vo.setNum(null);
                        warnType = warnType + "[\u5de5\u7a0b\u91cf\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)price)) {
                    vo.setPrice(null);
                } else {
                    try {
                        vo.setPrice(new BigDecimal(price));
                    }
                    catch (Exception e) {
                        vo.setPrice(null);
                        warnType = warnType + "[\u7efc\u5408\u5355\u4ef7(\u9664\u7a0e)\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)mny)) {
                    vo.setMny(null);
                } else {
                    try {
                        vo.setMny(new BigDecimal(mny));
                    }
                    catch (Exception e) {
                        vo.setMny(null);
                        warnType = warnType + "[\u5408\u4ef7(\u9664\u7a0e)\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                vo.setMemo(memo);
                vo.setImportFlag(!flag);
                if (importFlag) {
                    importFlag = !flag;
                }
                vo.setWarnType(warnType);
                detailVoList.add(vo);
            }
            for (DrawSubVO vo : detailVoList) {
                if (vo.getImportFlag().booleanValue()) {
                    if (!importFlag) continue;
                    String indexCode = vo.getIndexCode();
                    Boolean leafFlag = true;
                    for (String code : detailIndexList) {
                        if (!code.startsWith(indexCode) || code.equals(indexCode) || vo.getLeafFlag().booleanValue() || code.length() - indexCode.length() <= 1) continue;
                        leafFlag = false;
                        break;
                    }
                    vo.setLeafFlag(leafFlag);
                    vo.setParentId((Long)parentMap.get(vo.getTpid()));
                    vo.setTid(String.valueOf(vo.getId()));
                    vo.setTpid(null != vo.getParentId() ? String.valueOf(vo.getParentId()) : "");
                    vo.setRowState("add");
                    if (!leafFlag.booleanValue()) {
                        vo.setNum(null);
                        vo.setPrice(null);
                        vo.setMny(null);
                    }
                    successList.add(vo);
                    continue;
                }
                ImportErrorVo errorVo = new ImportErrorVo();
                errorVo.setPageName("\u5206\u90e8\u5206\u9879\u6e05\u5355");
                errorVo.setId(vo.getId());
                errorVo.setIndexCode(vo.getIndexCode());
                errorVo.setCode(vo.getCode());
                errorVo.setName(vo.getName());
                errorVo.setUnit(vo.getUnit());
                errorVo.setWarnType(vo.getWarnType());
                errorList.add(errorVo);
            }
        }
        if (errorList.size() > 0) {
            resp.put("successList", null);
            resp.put("successNum", (Object)0);
            resp.put("errorNum", (Object)errorList.size());
            if (errorList.size() > 100) {
                resp.put("errorList", errorList.subList(0, 100));
            } else {
                resp.put("errorList", errorList);
            }
        } else {
            new TaxCalculateUtil().calculate(successList);
            List subVOS = TreeNodeBUtil.buildTree(successList);
            UpSumUtil drawSubVOUpSumUtil = new UpSumUtil();
            drawSubVOUpSumUtil.creatCode(subVOS, null);
            drawSubVOUpSumUtil.upSum(subVOS, "mny");
            resp.put("subSuccessList", (Object)subVOS);
            resp.put("errorList", null);
            resp.put("successNum", (Object)subVOS.size());
            resp.put("errorNum", (Object)0);
        }
        return CommonResponse.success((Object)resp);
    }

    private String[] splitDetailIndex(String detailIndex) {
        if (StringUtils.isBlank((CharSequence)detailIndex)) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        if (detailIndex.length() < 3) {
            list.add(detailIndex);
        } else if (detailIndex.length() < 5) {
            list.add(detailIndex.substring(0, 2));
            list.add(detailIndex.substring(2));
        } else if (detailIndex.length() < 7) {
            list.add(detailIndex.substring(0, 2));
            list.add(detailIndex.substring(2, 4));
            list.add(detailIndex.substring(4));
        } else {
            list.add(detailIndex.substring(0, 2));
            list.add(detailIndex.substring(2, 4));
            list.add(detailIndex.substring(4, 6));
            list.add(detailIndex.substring(6));
        }
        return list.toArray(new String[0]);
    }
}

