/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bedget.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.bedget.bean.PaymentDetailEntity;
import com.ejianc.business.bedget.bean.PaymentEntity;
import com.ejianc.business.bedget.service.IPaymentService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="payment")
public class PaymentBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPaymentService service;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u63d0\u4ea4\u524d\u56de\u8c03------------------------------------");
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u63d0\u4ea4\u5b8c\u56de\u8c03------------------------------------");
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        this.logger.info("======================================\u6709\u5ba1\u6279\u6d41\u7684\u64a4\u56de\u524d\u56de\u8c03====================================== state:" + state);
        PaymentEntity paymentEntity = (PaymentEntity)((Object)this.service.selectById(billId));
        if (this.queryTop(paymentEntity.getProjectId(), paymentEntity.getCreateTime()).booleanValue()) {
            throw new BusinessException("\u5df2\u6709\u4e0b\u671f\u4ed8\u6b3e\u767b\u8bb0\uff0c\u672c\u671f\u4e0d\u5141\u8bb8\u64a4\u56de\uff01");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        this.logger.info("======================================\u6709\u5ba1\u6279\u6d41\u7684\u64a4\u56de\u540e\u56de\u8c03====================================== state:" + state);
        PaymentEntity paymentEntity = (PaymentEntity)((Object)this.service.selectById(billId));
        for (PaymentDetailEntity paymentDetailEntity : paymentEntity.getPaymentDetailList()) {
            paymentDetailEntity.setPastAdvanceTotal(new BigDecimal("0"));
            paymentDetailEntity.setPastScheduleTotal(new BigDecimal("0"));
        }
        this.service.saveOrUpdate((Object)paymentEntity, false);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u7ec8\u5ba1\u5ba1\u6838\u5b8c\u56de\u8c03------------------------------------");
        PaymentEntity paymentEntity = (PaymentEntity)((Object)this.service.selectById(billId));
        for (PaymentDetailEntity paymentDetailEntity : paymentEntity.getPaymentDetailList()) {
            paymentDetailEntity.setPastAdvanceTotal(ComputeUtil.safeAdd((BigDecimal)paymentDetailEntity.getPastScheduleTotal(), (BigDecimal)paymentDetailEntity.getPaymentAdvanceMoney()));
            paymentDetailEntity.setPastScheduleTotal(ComputeUtil.safeAdd((BigDecimal)paymentDetailEntity.getPastScheduleTotal(), (BigDecimal)paymentDetailEntity.getPaymentScheduleMoney()));
        }
        this.service.saveOrUpdate((Object)paymentEntity, false);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        PaymentEntity paymentEntity = (PaymentEntity)((Object)this.service.selectById(billId));
        if (this.queryTop(paymentEntity.getProjectId(), paymentEntity.getCreateTime()).booleanValue()) {
            throw new BusinessException("\u5df2\u6709\u4e0b\u671f\u4ed8\u6b3e\u767b\u8bb0\uff0c\u672c\u671f\u4e0d\u5141\u8bb8\u64a4\u56de\uff01");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        PaymentEntity paymentEntity = (PaymentEntity)((Object)this.service.selectById(billId));
        for (PaymentDetailEntity paymentDetailEntity : paymentEntity.getPaymentDetailList()) {
            paymentDetailEntity.setPastAdvanceTotal(new BigDecimal("0"));
            paymentDetailEntity.setPastScheduleTotal(new BigDecimal("0"));
        }
        this.service.saveOrUpdate((Object)paymentEntity, false);
        return CommonResponse.success();
    }

    public Boolean queryTop(Long projectId, Date createTime) {
        LambdaQueryWrapper lambdaFlower = Wrappers.lambdaQuery();
        lambdaFlower.eq(PaymentEntity::getProjectId, (Object)projectId);
        lambdaFlower.gt(BaseEntity::getCreateTime, (Object)createTime);
        List paymentEntityList = this.service.list((Wrapper)lambdaFlower);
        if (paymentEntityList.size() > 0) {
            return true;
        }
        return false;
    }
}

