/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bedget.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.ejianc.business.bedget.bean.PaymentEntity;
import com.ejianc.business.bedget.mapper.PaymentMapper;
import com.ejianc.business.bedget.service.IPaymentService;
import com.ejianc.business.bedget.vo.PaymentDetailVO;
import com.ejianc.business.bedget.vo.PaymentVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="paymentService")
public class PaymentServiceImpl
extends BaseServiceImpl<PaymentMapper, PaymentEntity>
implements IPaymentService {
    @Autowired
    private PaymentMapper paymentMapper;

    @Override
    public PaymentVO queryDetailList(Long projectId) {
        List<PaymentDetailVO> queryOutcontractList = this.queryOutcontractList(projectId);
        for (PaymentDetailVO paymentDetailVO : queryOutcontractList) {
            paymentDetailVO.setId(IdWorker.getId());
            if ("\u52b3\u52a1\u5206\u5305".equals(paymentDetailVO.getSubcontractType()) || "\u4e13\u4e1a\u5206\u5305".equals(paymentDetailVO.getSubcontractType())) {
                paymentDetailVO.setIsComplete(this.querySettlementBookList(paymentDetailVO.getProjectId(), paymentDetailVO.getContractId()));
                paymentDetailVO.setTaxCurrentTotal(this.querySubcontractingvolume(paymentDetailVO.getProjectId(), paymentDetailVO.getContractId()));
                paymentDetailVO.setTotalMoneyTax(this.querySettlementBookListAmount(paymentDetailVO.getProjectId(), paymentDetailVO.getContractId()));
            } else if ("\u7269\u8d44\u91c7\u8d2d".equals(paymentDetailVO.getSubcontractType())) {
                paymentDetailVO.setIsComplete(this.queryPurchaseSettlementList(paymentDetailVO.getProjectId(), paymentDetailVO.getContractId()));
                System.out.println(this.queryPurchasesettlement(paymentDetailVO.getProjectId(), paymentDetailVO.getContractId()) + "==============");
                paymentDetailVO.setTaxCurrentTotal(this.queryPurchasesettlement(paymentDetailVO.getProjectId(), paymentDetailVO.getContractId()));
                paymentDetailVO.setTotalMoneyTax(this.queryPurchaseSettlementListAmount(paymentDetailVO.getProjectId(), paymentDetailVO.getContractId()));
            } else if ("\u673a\u68b0\u79df\u8d41".equals(paymentDetailVO.getSubcontractType())) {
                paymentDetailVO.setIsComplete(this.queryMachinerySettlementList(paymentDetailVO.getProjectId(), paymentDetailVO.getContractId()));
                paymentDetailVO.setTaxCurrentTotal(this.queryMechanicallease(paymentDetailVO.getProjectId(), paymentDetailVO.getContractId()));
                paymentDetailVO.setTotalMoneyTax(this.queryMachinerySettlementListAmount(paymentDetailVO.getProjectId(), paymentDetailVO.getContractId()));
            } else if ("\u5468\u8f6c\u6750\u79df\u8d41".equals(paymentDetailVO.getSubcontractType())) {
                paymentDetailVO.setIsComplete(this.queryLeaseSettLementList(paymentDetailVO.getProjectId(), paymentDetailVO.getContractId()));
                paymentDetailVO.setTaxCurrentTotal(this.queryRevolvinglease(paymentDetailVO.getProjectId(), paymentDetailVO.getContractId()));
                paymentDetailVO.setTotalMoneyTax(this.queryLeaseSettLementListAmount(paymentDetailVO.getProjectId(), paymentDetailVO.getContractId()));
            } else if ("\u8bbe\u8ba1\u52d8\u5bdf".equals(paymentDetailVO.getSubcontractType())) {
                paymentDetailVO.setIsComplete(this.queryDesignSettlementList(paymentDetailVO.getProjectId(), paymentDetailVO.getContractId()));
                paymentDetailVO.setTaxCurrentTotal(this.queryDesignsubcontractnode(paymentDetailVO.getProjectId(), paymentDetailVO.getContractId()));
                paymentDetailVO.setTotalMoneyTax(this.queryDesignSettlementListAmount(paymentDetailVO.getProjectId(), paymentDetailVO.getContractId()));
            } else if ("\u54a8\u8be2\u670d\u52a1".equals(paymentDetailVO.getSubcontractType()) || "\u5176\u5b83\u5408\u540c".equals(paymentDetailVO.getSubcontractType())) {
                paymentDetailVO.setIsComplete(this.queryConsultotherfinalList(paymentDetailVO.getProjectId(), paymentDetailVO.getContractId()));
                paymentDetailVO.setTaxCurrentTotal(this.queryConsultother(paymentDetailVO.getProjectId(), paymentDetailVO.getContractId()));
                paymentDetailVO.setTotalMoneyTax(this.queryConsultotherfinalListAmount(paymentDetailVO.getProjectId(), paymentDetailVO.getContractId()));
            }
            paymentDetailVO.setSettlementMoneyTotal(ComputeUtil.safeAdd((BigDecimal)paymentDetailVO.getTaxCurrentTotal(), (BigDecimal)paymentDetailVO.getTotalMoneyTax()));
        }
        List<PaymentDetailVO> paymentDetailVOList = this.queryDetailVOList(projectId);
        if (CollectionUtil.isNotEmpty(paymentDetailVOList)) {
            for (PaymentDetailVO paymentDetailVO : paymentDetailVOList) {
                paymentDetailVO.setId(IdWorker.getId());
                if ("\u52b3\u52a1\u5206\u5305".equals(paymentDetailVO.getSubcontractType()) || "\u4e13\u4e1a\u5206\u5305".equals(paymentDetailVO.getSubcontractType())) {
                    paymentDetailVO.setIsComplete(this.querySettlementBookList(projectId, paymentDetailVO.getContractId()));
                    paymentDetailVO.setTaxCurrentTotal(this.querySubcontractingvolume(projectId, paymentDetailVO.getContractId()));
                    paymentDetailVO.setTotalMoneyTax(this.querySettlementBookListAmount(projectId, paymentDetailVO.getContractId()));
                } else if ("\u7269\u8d44\u91c7\u8d2d".equals(paymentDetailVO.getSubcontractType())) {
                    paymentDetailVO.setIsComplete(this.queryPurchaseSettlementList(projectId, paymentDetailVO.getContractId()));
                    System.out.println(this.queryPurchasesettlement(projectId, paymentDetailVO.getContractId()) + "==============");
                    paymentDetailVO.setTaxCurrentTotal(this.queryPurchasesettlement(projectId, paymentDetailVO.getContractId()));
                    paymentDetailVO.setTotalMoneyTax(this.queryPurchaseSettlementListAmount(projectId, paymentDetailVO.getContractId()));
                } else if ("\u673a\u68b0\u79df\u8d41".equals(paymentDetailVO.getSubcontractType())) {
                    paymentDetailVO.setIsComplete(this.queryMachinerySettlementList(projectId, paymentDetailVO.getContractId()));
                    paymentDetailVO.setTaxCurrentTotal(this.queryMechanicallease(projectId, paymentDetailVO.getContractId()));
                    paymentDetailVO.setTotalMoneyTax(this.queryMachinerySettlementListAmount(projectId, paymentDetailVO.getContractId()));
                } else if ("\u5468\u8f6c\u6750\u79df\u8d41".equals(paymentDetailVO.getSubcontractType())) {
                    paymentDetailVO.setIsComplete(this.queryLeaseSettLementList(projectId, paymentDetailVO.getContractId()));
                    paymentDetailVO.setTaxCurrentTotal(this.queryRevolvinglease(projectId, paymentDetailVO.getContractId()));
                    paymentDetailVO.setTotalMoneyTax(this.queryLeaseSettLementListAmount(projectId, paymentDetailVO.getContractId()));
                } else if ("\u8bbe\u8ba1\u52d8\u5bdf".equals(paymentDetailVO.getSubcontractType())) {
                    paymentDetailVO.setIsComplete(this.queryDesignSettlementList(projectId, paymentDetailVO.getContractId()));
                    paymentDetailVO.setTaxCurrentTotal(this.queryDesignsubcontractnode(projectId, paymentDetailVO.getContractId()));
                    paymentDetailVO.setTotalMoneyTax(this.queryDesignSettlementListAmount(projectId, paymentDetailVO.getContractId()));
                } else if ("\u54a8\u8be2\u670d\u52a1".equals(paymentDetailVO.getSubcontractType()) || "\u5176\u5b83\u5408\u540c".equals(paymentDetailVO.getSubcontractType())) {
                    paymentDetailVO.setIsComplete(this.queryConsultotherfinalList(projectId, paymentDetailVO.getContractId()));
                    paymentDetailVO.setTaxCurrentTotal(this.queryConsultother(projectId, paymentDetailVO.getContractId()));
                    paymentDetailVO.setTotalMoneyTax(this.queryConsultotherfinalListAmount(projectId, paymentDetailVO.getContractId()));
                }
                paymentDetailVO.setSettlementMoneyTotal(ComputeUtil.safeAdd((BigDecimal)paymentDetailVO.getTaxCurrentTotal(), (BigDecimal)paymentDetailVO.getTotalMoneyTax()));
            }
        }
        if (CollectionUtil.isNotEmpty(paymentDetailVOList)) {
            for (PaymentDetailVO paymentDetailVO : paymentDetailVOList) {
                paymentDetailVO.setId(IdWorker.getId());
            }
            Map map = paymentDetailVOList.stream().collect(Collectors.toMap(x -> x.getContractId(), Function.identity(), (k1, k2) -> k2));
            for (PaymentDetailVO vo : queryOutcontractList) {
                Long k = vo.getContractId();
                if (map.containsKey(k)) continue;
                paymentDetailVOList.add(vo);
            }
            BigDecimal paymentCopeWithRatio = new BigDecimal("0");
            BigDecimal paymentAdvanceMoney = new BigDecimal("0");
            BigDecimal havePaidTotal = new BigDecimal("0");
            BigDecimal debtMoneyTotal = new BigDecimal("0");
            for (PaymentDetailVO vo : paymentDetailVOList) {
                vo.setPaymentAdvanceMoney(ComputeUtil.safeAdd((BigDecimal)vo.getPaymentAdvanceMoney(), (BigDecimal)vo.getCurrentAdvanceMoney()));
                vo.setPaymentScheduleMoney(ComputeUtil.safeAdd((BigDecimal)vo.getPaymentScheduleMoney(), (BigDecimal)vo.getCurrentScheduleMoney()));
                vo.setPaymentMoneyTotal(ComputeUtil.safeAdd((BigDecimal)vo.getPaymentAdvanceMoney(), (BigDecimal)vo.getPaymentScheduleMoney()));
                vo.setPaymentCopeWithRatio(ComputeUtil.safeDiv((BigDecimal)vo.getPaymentMoneyTotal(), (BigDecimal)vo.getSettlementMoneyTotal()));
                vo.setDebtAdvanceMoney(ComputeUtil.safeSub((BigDecimal)vo.getAdvanceTotal(), (BigDecimal)vo.getPaymentAdvanceMoney()));
                vo.setDebtScheduleMoney(ComputeUtil.safeSub((BigDecimal)vo.getScheduleTotal(), (BigDecimal)vo.getPaymentScheduleMoney()));
                vo.setDebtMoneyTotal(ComputeUtil.safeAdd((BigDecimal)vo.getDebtAdvanceMoney(), (BigDecimal)vo.getDebtScheduleMoney()));
                paymentCopeWithRatio = ComputeUtil.safeAdd((BigDecimal)paymentCopeWithRatio, (BigDecimal)vo.getPaymentCopeWithRatio());
                paymentAdvanceMoney = ComputeUtil.safeAdd((BigDecimal)paymentAdvanceMoney, (BigDecimal)vo.getPaymentAdvanceMoney());
                havePaidTotal = ComputeUtil.safeAdd((BigDecimal)havePaidTotal, (BigDecimal)vo.getPaymentMoneyTotal());
                debtMoneyTotal = ComputeUtil.safeAdd((BigDecimal)debtMoneyTotal, (BigDecimal)vo.getDebtMoneyTotal());
            }
            PaymentEntity paymentEntity = (PaymentEntity)((Object)this.selectById(paymentDetailVOList.get(0).getPaymentId()));
            paymentEntity.setPaymentRatioTotal(paymentCopeWithRatio);
            paymentEntity.setInAdvancePaymentMoney(paymentAdvanceMoney);
            paymentEntity.setHavePaidTotal(havePaidTotal);
            paymentEntity.setDebtMoneyTotal(debtMoneyTotal);
            PaymentVO paymentVO = (PaymentVO)((Object)BeanMapper.map((Object)((Object)paymentEntity), PaymentVO.class));
            paymentVO.setPaymentDetailList(paymentDetailVOList);
            return paymentVO;
        }
        PaymentVO paymentVO = new PaymentVO();
        paymentVO.setPaymentDetailList(queryOutcontractList);
        return paymentVO;
    }

    @Override
    public List<PaymentDetailVO> queryOutcontractList(Long projectId) {
        return this.paymentMapper.queryOutcontractList(projectId);
    }

    @Override
    public String querySettlementBookList(Long projectId, Long contractId) {
        List<PaymentDetailVO> paymentDetailVOS = this.paymentMapper.querySettlementBookList(projectId, contractId);
        if (CollectionUtil.isNotEmpty(paymentDetailVOS)) {
            return "\u662f";
        }
        return "\u5426";
    }

    @Override
    public String queryPurchaseSettlementList(Long projectId, Long contractId) {
        List<PaymentDetailVO> paymentDetailVOS = this.paymentMapper.queryPurchaseSettlementList(projectId, contractId);
        if (CollectionUtil.isNotEmpty(paymentDetailVOS)) {
            return "\u662f";
        }
        return "\u5426";
    }

    @Override
    public String queryLeaseSettLementList(Long projectId, Long contractId) {
        List<PaymentDetailVO> paymentDetailVOS = this.paymentMapper.queryLeaseSettLementList(projectId, contractId);
        if (CollectionUtil.isNotEmpty(paymentDetailVOS)) {
            return "\u662f";
        }
        return "\u5426";
    }

    @Override
    public String queryMachinerySettlementList(Long projectId, Long contractId) {
        List<PaymentDetailVO> paymentDetailVOS = this.paymentMapper.queryMachinerySettlementList(projectId, contractId);
        if (CollectionUtil.isNotEmpty(paymentDetailVOS)) {
            return "\u662f";
        }
        return "\u5426";
    }

    @Override
    public String queryDesignSettlementList(Long projectId, Long contractId) {
        List<PaymentDetailVO> paymentDetailVOS = this.paymentMapper.queryDesignSettlementList(projectId, contractId);
        if (CollectionUtil.isNotEmpty(paymentDetailVOS)) {
            return "\u662f";
        }
        return "\u5426";
    }

    @Override
    public String queryConsultotherfinalList(Long projectId, Long contractId) {
        List<PaymentDetailVO> paymentDetailVOS = this.paymentMapper.queryConsultotherfinalList(projectId, contractId);
        if (CollectionUtil.isNotEmpty(paymentDetailVOS)) {
            return "\u662f";
        }
        return "\u5426";
    }

    @Override
    public BigDecimal querySubcontractingvolume(Long projectId, Long contractId) {
        List<PaymentDetailVO> paymentDetailVOS = this.paymentMapper.querySubcontractingvolume(projectId, contractId);
        if (CollectionUtil.isNotEmpty(paymentDetailVOS)) {
            return paymentDetailVOS.get(0).getTotalMoneyTax();
        }
        return new BigDecimal("0");
    }

    @Override
    public BigDecimal queryPurchasesettlement(Long projectId, Long contractId) {
        List<PaymentDetailVO> paymentDetailVOS = this.paymentMapper.queryPurchasesettlement(projectId, contractId);
        if (CollectionUtil.isNotEmpty(paymentDetailVOS)) {
            return paymentDetailVOS.get(0).getTotalMoneyTax();
        }
        return new BigDecimal("0");
    }

    @Override
    public BigDecimal queryRevolvinglease(Long projectId, Long contractId) {
        List<PaymentDetailVO> paymentDetailVOS = this.paymentMapper.queryRevolvinglease(projectId, contractId);
        if (CollectionUtil.isNotEmpty(paymentDetailVOS)) {
            return paymentDetailVOS.get(0).getTotalMoneyTax();
        }
        return new BigDecimal("0");
    }

    @Override
    public BigDecimal queryMechanicallease(Long projectId, Long contractId) {
        List<PaymentDetailVO> paymentDetailVOS = this.paymentMapper.queryMechanicallease(projectId, contractId);
        if (CollectionUtil.isNotEmpty(paymentDetailVOS)) {
            return paymentDetailVOS.get(0).getTotalMoneyTax();
        }
        return new BigDecimal("0");
    }

    @Override
    public BigDecimal queryDesignsubcontractnode(Long projectId, Long contractId) {
        List<PaymentDetailVO> paymentDetailVOS = this.paymentMapper.queryDesignsubcontractnode(projectId, contractId);
        if (CollectionUtil.isNotEmpty(paymentDetailVOS)) {
            return paymentDetailVOS.get(0).getTotalMoneyTax();
        }
        return new BigDecimal("0");
    }

    @Override
    public BigDecimal queryConsultother(Long projectId, Long contractId) {
        List<PaymentDetailVO> paymentDetailVOS = this.paymentMapper.queryConsultother(projectId, contractId);
        if (CollectionUtil.isNotEmpty(paymentDetailVOS)) {
            return paymentDetailVOS.get(0).getTotalMoneyTax();
        }
        return new BigDecimal("0");
    }

    @Override
    public BigDecimal querySettlementBookListAmount(Long projectId, Long contractId) {
        List<PaymentDetailVO> paymentDetailVOS = this.paymentMapper.querySettlementBookListAmount(projectId, contractId);
        if (CollectionUtil.isNotEmpty(paymentDetailVOS)) {
            return paymentDetailVOS.get(0).getTotalMoneyTax();
        }
        return new BigDecimal("0");
    }

    @Override
    public BigDecimal queryPurchaseSettlementListAmount(Long projectId, Long contractId) {
        List<PaymentDetailVO> paymentDetailVOS = this.paymentMapper.queryPurchaseSettlementListAmount(projectId, contractId);
        if (CollectionUtil.isNotEmpty(paymentDetailVOS)) {
            return paymentDetailVOS.get(0).getTotalMoneyTax();
        }
        return new BigDecimal("0");
    }

    @Override
    public BigDecimal queryLeaseSettLementListAmount(Long projectId, Long contractId) {
        List<PaymentDetailVO> paymentDetailVOS = this.paymentMapper.queryLeaseSettLementListAmount(projectId, contractId);
        if (CollectionUtil.isNotEmpty(paymentDetailVOS)) {
            return paymentDetailVOS.get(0).getTotalMoneyTax();
        }
        return new BigDecimal("0");
    }

    @Override
    public BigDecimal queryMachinerySettlementListAmount(Long projectId, Long contractId) {
        List<PaymentDetailVO> paymentDetailVOS = this.paymentMapper.queryMachinerySettlementListAmount(projectId, contractId);
        if (CollectionUtil.isNotEmpty(paymentDetailVOS)) {
            return paymentDetailVOS.get(0).getTotalMoneyTax();
        }
        return new BigDecimal("0");
    }

    @Override
    public BigDecimal queryDesignSettlementListAmount(Long projectId, Long contractId) {
        List<PaymentDetailVO> paymentDetailVOS = this.paymentMapper.queryDesignSettlementListAmount(projectId, contractId);
        if (CollectionUtil.isNotEmpty(paymentDetailVOS)) {
            return paymentDetailVOS.get(0).getTotalMoneyTax();
        }
        return new BigDecimal("0");
    }

    @Override
    public BigDecimal queryConsultotherfinalListAmount(Long projectId, Long contractId) {
        List<PaymentDetailVO> paymentDetailVOS = this.paymentMapper.queryConsultotherfinalListAmount(projectId, contractId);
        if (CollectionUtil.isNotEmpty(paymentDetailVOS)) {
            return paymentDetailVOS.get(0).getTotalMoneyTax();
        }
        return new BigDecimal("0");
    }

    @Override
    public List<PaymentDetailVO> queryDetailVOList(Long projectId) {
        return this.paymentMapper.queryDetailVOList(projectId);
    }

    @Override
    public List<PaymentDetailVO> queryDetailListParams(Long paymentId, String searchText) {
        return this.paymentMapper.queryDetailListParams(paymentId, searchText);
    }
}

