/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.record.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.record.bean.RecordconsdrawbudgetEntity;
import com.ejianc.business.record.service.IRecordconsdrawbudgetService;
import com.ejianc.business.record.vo.RecordconsdrawbudgetVO;
import com.ejianc.business.record.vo.RecordconsdrawbudgetdetailVO;
import com.ejianc.business.utils.BigDecimalUtils;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"recordconsdrawbudget"})
public class RecordconsdrawbudgetController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "budgetmanager-recordconsdrawbudget";
    @Autowired
    private IRecordconsdrawbudgetService service;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<RecordconsdrawbudgetVO> saveOrUpdate(@RequestBody RecordconsdrawbudgetVO saveorUpdateVO) {
        RecordconsdrawbudgetEntity entity = (RecordconsdrawbudgetEntity)((Object)BeanMapper.map((Object)((Object)saveorUpdateVO), RecordconsdrawbudgetEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        BigDecimal total = BigDecimalUtils.ofNullable(entity.getFeesTotal()).add(BigDecimalUtils.ofNullable(entity.getTaxTotal())).add(BigDecimalUtils.ofNullable(entity.getProvisionalEstimateTotal()));
        entity.setTotal(total);
        this.service.saveOrUpdate((Object)entity, false);
        RecordconsdrawbudgetVO vo = (RecordconsdrawbudgetVO)((Object)BeanMapper.map((Object)((Object)entity), RecordconsdrawbudgetVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<RecordconsdrawbudgetVO> queryDetail(Long id) {
        RecordconsdrawbudgetEntity entity = (RecordconsdrawbudgetEntity)((Object)this.service.selectById(id));
        RecordconsdrawbudgetVO vo = (RecordconsdrawbudgetVO)((Object)BeanMapper.map((Object)((Object)entity), RecordconsdrawbudgetVO.class));
        List<RecordconsdrawbudgetdetailVO> consdrawbudgetdetailEntities = vo.getConsdrawbudgetdetailEntities();
        vo.setConsdrawbudgetdetailEntities(this.handleChildren(consdrawbudgetdetailEntities));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<RecordconsdrawbudgetVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<RecordconsdrawbudgetVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), RecordconsdrawbudgetVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Recordconsdrawbudget-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refRecordconsdrawbudgetData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<RecordconsdrawbudgetVO>> refRecordconsdrawbudgetData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), RecordconsdrawbudgetVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private List<RecordconsdrawbudgetdetailVO> handleChildren(List<RecordconsdrawbudgetdetailVO> voList) {
        Collections.sort(voList, new Comparator<RecordconsdrawbudgetdetailVO>(){

            @Override
            public int compare(RecordconsdrawbudgetdetailVO o1, RecordconsdrawbudgetdetailVO o2) {
                return (o1.getSubitemCode() + o1.getSection()).compareTo(o2.getSubitemCode() + o2.getSection());
            }
        });
        voList = RecordconsdrawbudgetController.createTreeData(voList);
        return voList;
    }

    public static List<RecordconsdrawbudgetdetailVO> createTreeData(List<RecordconsdrawbudgetdetailVO> list) {
        ArrayList<RecordconsdrawbudgetdetailVO> resp = new ArrayList<RecordconsdrawbudgetdetailVO>();
        ArrayList<String> rootItems = new ArrayList<String>();
        HashMap<String, RecordconsdrawbudgetdetailVO> listMap = new HashMap<String, RecordconsdrawbudgetdetailVO>();
        for (RecordconsdrawbudgetdetailVO item : list) {
            listMap.put(item.getTid().toString(), item);
        }
        for (int i = 0; i < list.size(); ++i) {
            RecordconsdrawbudgetdetailVO item;
            item = list.get(i);
            String parentId = item.getTpid() != null ? item.getTpid().toString() : "";
            RecordconsdrawbudgetdetailVO parent = (RecordconsdrawbudgetdetailVO)((Object)listMap.get(parentId));
            if (parent != null) {
                List<RecordconsdrawbudgetdetailVO> child = parent.getChildren();
                if (child != null) {
                    child.add(item);
                    continue;
                }
                ArrayList<RecordconsdrawbudgetdetailVO> children = new ArrayList<RecordconsdrawbudgetdetailVO>();
                children.add(item);
                parent.setChildren(children);
                continue;
            }
            rootItems.add(item.getTid());
        }
        for (String rootId : rootItems) {
            resp.add((RecordconsdrawbudgetdetailVO)((Object)listMap.get(rootId)));
        }
        return resp;
    }
}

