/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.utils;

import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ComputeUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class UpSumUtil<T> {
    public List<T> treeToList(List<T> list) {
        ArrayList<T> result = new ArrayList<T>();
        for (Object t : list) {
            result.add(t);
            List<T> children = this.getChilerenValue(t, "children");
            if (children == null || children.size() <= 0) continue;
            List<T> tes = this.treeToList(children);
            result.addAll(tes);
        }
        if (result.size() > 0) {
            for (Object t : result) {
                this.setChilerenValue(t, "children", null);
            }
        }
        return result;
    }

    public List<T> upSum(List<T> list, String ... columns) {
        for (T t : list) {
            List<T> children = this.getChilerenValue(t, "children");
            if (children == null || children.size() <= 0) continue;
            List<T> c = this.upSum(children, columns);
            this.sumColumns(t, c, columns);
        }
        return list;
    }

    private void sumColumns(T t, List<T> children, String ... columns) {
        for (String column : columns) {
            BigDecimal sum = BigDecimal.ZERO;
            for (T c : children) {
                BigDecimal bigDecimalValue = this.getBigDecimalValue(c, column);
                sum = ComputeUtil.safeAdd((BigDecimal)sum, (BigDecimal)bigDecimalValue);
            }
            this.setValue(t, column, sum);
        }
        this.setChilerenValue(t, "children", children);
    }

    private List<T> getChilerenValue(T t, String code) {
        Class<?> mainClass = t.getClass();
        try {
            Method m = mainClass.getDeclaredMethod("get" + code.substring(0, 1).toUpperCase() + code.substring(1), null);
            try {
                return (List)m.invoke(t, (Object[])null);
            }
            catch (IllegalAccessException e) {
                throw new BusinessException("\u7c7b\u3010" + mainClass + "\u3011\u7684\u5b57\u6bb5\u3010" + code + "\u3011\u7684get\u65b9\u6cd5\u9700\u8981\u8bbe\u7f6e\u6210public\u5c5e\u6027\uff01");
            }
            catch (InvocationTargetException e) {
                throw new BusinessException("\u7c7b\u3010" + mainClass + "\u3011\u7684\u5b57\u6bb5\u3010" + code + "\u3011\u7684get\u65b9\u6cd5\u8c03\u7528\u5931\u8d25\uff01");
            }
        }
        catch (NoSuchMethodException e) {
            throw new BusinessException("\u7c7b\u3010" + mainClass + "\u3011\u7684\u5b57\u6bb5\u3010" + code + "\u3011\u672a\u8bbe\u7f6eget\u65b9\u6cd5\uff01");
        }
    }

    private BigDecimal getBigDecimalValue(T t, String code) {
        Class<?> mainClass = t.getClass();
        try {
            Method m = mainClass.getDeclaredMethod("get" + code.substring(0, 1).toUpperCase() + code.substring(1), null);
            try {
                return (BigDecimal)m.invoke(t, (Object[])null);
            }
            catch (IllegalAccessException e) {
                throw new BusinessException("\u7c7b\u3010" + mainClass + "\u3011\u7684\u5b57\u6bb5\u3010" + code + "\u3011\u7684get\u65b9\u6cd5\u9700\u8981\u8bbe\u7f6e\u6210public\u5c5e\u6027\uff01");
            }
            catch (InvocationTargetException e) {
                throw new BusinessException("\u7c7b\u3010" + mainClass + "\u3011\u7684\u5b57\u6bb5\u3010" + code + "\u3011\u7684get\u65b9\u6cd5\u8c03\u7528\u5931\u8d25\uff01");
            }
        }
        catch (NoSuchMethodException e) {
            throw new BusinessException("\u7c7b\u3010" + mainClass + "\u3011\u7684\u5b57\u6bb5\u3010" + code + "\u3011\u672a\u8bbe\u7f6eget\u65b9\u6cd5\uff01");
        }
    }

    private String getValue(T t, String code) {
        Class<?> mainClass = t.getClass();
        try {
            Method m = mainClass.getDeclaredMethod("get" + code.substring(0, 1).toUpperCase() + code.substring(1), null);
            try {
                return (String)m.invoke(t, (Object[])null);
            }
            catch (IllegalAccessException e) {
                throw new BusinessException("\u7c7b\u3010" + mainClass + "\u3011\u7684\u5b57\u6bb5\u3010" + code + "\u3011\u7684get\u65b9\u6cd5\u9700\u8981\u8bbe\u7f6e\u6210public\u5c5e\u6027\uff01");
            }
            catch (InvocationTargetException e) {
                throw new BusinessException("\u7c7b\u3010" + mainClass + "\u3011\u7684\u5b57\u6bb5\u3010" + code + "\u3011\u7684get\u65b9\u6cd5\u8c03\u7528\u5931\u8d25\uff01");
            }
        }
        catch (NoSuchMethodException e) {
            throw new BusinessException("\u7c7b\u3010" + mainClass + "\u3011\u7684\u5b57\u6bb5\u3010" + code + "\u3011\u672a\u8bbe\u7f6eget\u65b9\u6cd5\uff01");
        }
    }

    private void setValue(T t, String code, String value) {
        Class<?> mainClass = t.getClass();
        try {
            Method subPid = mainClass.getDeclaredMethod("set" + code.substring(0, 1).toUpperCase() + code.substring(1), String.class);
            try {
                subPid.invoke(t, value);
            }
            catch (IllegalAccessException e) {
                throw new BusinessException("\u7c7b\u3010" + mainClass + "\u3011\u7684\u5b57\u6bb5\u3010" + code + "\u3011\u7684set\u65b9\u6cd5\u9700\u8981\u8bbe\u7f6e\u6210public\u5c5e\u6027\uff01");
            }
            catch (InvocationTargetException e) {
                throw new BusinessException("\u7c7b\u3010" + mainClass + "\u3011\u7684\u5b57\u6bb5\u3010" + code + "\u3011\u7684set\u65b9\u6cd5\u8c03\u7528\u5931\u8d25\uff01");
            }
        }
        catch (NoSuchMethodException e) {
            throw new BusinessException("\u7c7b\u3010" + mainClass + "\u3011\u7684\u5b57\u6bb5\u3010" + code + "\u3011\u672a\u8bbe\u7f6eset\u65b9\u6cd5\uff01");
        }
    }

    private void setValue(T t, String code, BigDecimal value) {
        Class<?> mainClass = t.getClass();
        try {
            Method subPid = mainClass.getDeclaredMethod("set" + code.substring(0, 1).toUpperCase() + code.substring(1), BigDecimal.class);
            try {
                subPid.invoke(t, value);
            }
            catch (IllegalAccessException e) {
                throw new BusinessException("\u7c7b\u3010" + mainClass + "\u3011\u7684\u5b57\u6bb5\u3010" + code + "\u3011\u7684set\u65b9\u6cd5\u9700\u8981\u8bbe\u7f6e\u6210public\u5c5e\u6027\uff01");
            }
            catch (InvocationTargetException e) {
                throw new BusinessException("\u7c7b\u3010" + mainClass + "\u3011\u7684\u5b57\u6bb5\u3010" + code + "\u3011\u7684set\u65b9\u6cd5\u8c03\u7528\u5931\u8d25\uff01");
            }
        }
        catch (NoSuchMethodException e) {
            throw new BusinessException("\u7c7b\u3010" + mainClass + "\u3011\u7684\u5b57\u6bb5\u3010" + code + "\u3011\u672a\u8bbe\u7f6eset\u65b9\u6cd5\uff01");
        }
    }

    private void setChilerenValue(T t, String code, List<T> value) {
        Class<?> mainClass = t.getClass();
        try {
            Method subPid = mainClass.getDeclaredMethod("set" + code.substring(0, 1).toUpperCase() + code.substring(1), List.class);
            try {
                subPid.invoke(t, value);
            }
            catch (IllegalAccessException e) {
                throw new BusinessException("\u7c7b\u3010" + mainClass + "\u3011\u7684\u5b57\u6bb5\u3010" + code + "\u3011\u7684set\u65b9\u6cd5\u9700\u8981\u8bbe\u7f6e\u6210public\u5c5e\u6027\uff01");
            }
            catch (InvocationTargetException e) {
                throw new BusinessException("\u7c7b\u3010" + mainClass + "\u3011\u7684\u5b57\u6bb5\u3010" + code + "\u3011\u7684set\u65b9\u6cd5\u8c03\u7528\u5931\u8d25\uff01");
            }
        }
        catch (NoSuchMethodException e) {
            throw new BusinessException("\u7c7b\u3010" + mainClass + "\u3011\u7684\u5b57\u6bb5\u3010" + code + "\u3011\u672a\u8bbe\u7f6eset\u65b9\u6cd5\uff01");
        }
    }

    public List<T> creatCode(List<T> list, String serialNumber) {
        for (int i = 0; i < list.size(); ++i) {
            T ypd = list.get(i);
            String value = this.getValue(ypd, "serialNumber");
            if (null == value) {
                if (StringUtils.isNotEmpty((CharSequence)serialNumber)) {
                    this.setValue(ypd, "serialNumber", serialNumber + "." + (i + 1));
                } else {
                    this.setValue(ypd, "serialNumber", String.valueOf(i + 1));
                }
            }
            value = this.getValue(ypd, "serialNumber");
            List<T> children = this.getChilerenValue(ypd, "children");
            if (children == null) continue;
            List<T> child = this.creatCode(children, value);
            this.setChilerenValue(ypd, "children", child);
        }
        return list;
    }
}

