/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bedget.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.bedget.bean.PaymentEntity;
import com.ejianc.business.bedget.service.IPaymentDetailService;
import com.ejianc.business.bedget.service.IPaymentService;
import com.ejianc.business.bedget.vo.PaymentDetailVO;
import com.ejianc.business.bedget.vo.PaymentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"payment"})
public class PaymentController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "FKDJ";
    @Autowired
    private IPaymentService service;
    @Autowired
    private IPaymentDetailService paymentDetailService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PaymentVO> saveOrUpdate(@RequestBody PaymentVO saveOrUpdateVO) {
        List paymentEntityList;
        List paymentEntities;
        PaymentEntity entity = (PaymentEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), PaymentEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(PaymentEntity::getProjectId, (Object)entity.getProjectId());
        queryWrapper.ne(PaymentEntity::getBillState, (Object)1);
        queryWrapper.ne(PaymentEntity::getBillState, (Object)3);
        if (entity.getId() != null) {
            queryWrapper.ne(BaseEntity::getId, (Object)entity.getId());
        }
        if (CollectionUtils.isNotEmpty((Collection)(paymentEntities = this.service.list((Wrapper)queryWrapper)))) {
            throw new BusinessException("\u8be5\u9879\u76ee\u6709\u672a\u5ba1\u6279\u901a\u8fc7\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u505a\u4e0b\u4e00\u671f\uff01");
        }
        LambdaQueryWrapper queryWrapper2 = new LambdaQueryWrapper();
        queryWrapper2.eq(PaymentEntity::getProjectId, (Object)entity.getProjectId());
        queryWrapper2.gt(PaymentEntity::getRegisterDate, (Object)entity.getRegisterDate());
        if (entity.getId() != null) {
            queryWrapper.ne(BaseEntity::getId, (Object)entity.getId());
        }
        if (CollectionUtils.isNotEmpty((Collection)(paymentEntityList = this.service.list((Wrapper)queryWrapper2)))) {
            throw new BusinessException("\u5df2\u6709\u4e0a\u671f\uff0c\u4e0d\u5141\u8bb8\u505a\u5f80\u671f\u6570\u636e\uff01");
        }
        this.service.saveOrUpdate((Object)entity, false);
        PaymentVO vo = (PaymentVO)((Object)BeanMapper.map((Object)((Object)entity), PaymentVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PaymentVO> queryDetail(Long id) {
        PaymentEntity entity = (PaymentEntity)((Object)this.service.selectById(id));
        PaymentVO vo = (PaymentVO)((Object)BeanMapper.map((Object)((Object)entity), PaymentVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetailList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PaymentVO> queryDetailList(Long projectId) {
        PaymentVO paymentVOS = this.service.queryDetailList(projectId);
        return CommonResponse.success((String)"\u83b7\u53d6\u6570\u636e\u6210\u529f\uff01", (Object)((Object)paymentVOS));
    }

    @RequestMapping(value={"/storematerialList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<PaymentDetailVO>> storematerialList(@RequestBody QueryParam params) {
        if (params.getParams().get("paymentId") == null || ((Parameter)params.getParams().get("paymentId")).getValue() == null) {
            throw new BusinessException("\u4e3b\u952eid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long paymentId = Long.parseLong(((Parameter)params.getParams().get("paymentId")).getValue().toString());
        String searchText = null;
        if (params.getParams().get("searchText") != null && ((Parameter)params.getParams().get("searchText")).getValue() != null) {
            searchText = ((Parameter)params.getParams().get("searchText")).getValue().toString();
        }
        List<PaymentDetailVO> paymentDetailVOList = this.service.queryDetailListParams(paymentId, searchText);
        Page page = new Page();
        page = new Page(page.getCurrent(), (long)params.getPageSize(), (long)paymentDetailVOList.size());
        page.setRecords(paymentDetailVOList);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PaymentVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (PaymentVO paymentVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<PaymentVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PaymentVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        List list = this.service.queryList(param);
        for (PaymentEntity paymentEntity : list) {
            String billStateStr = paymentEntity.getBillState().toString();
            if (billStateStr == null) continue;
            if ("0".equals(billStateStr)) {
                billStateStr = "\u81ea\u7531\u6001";
            } else if ("1".equals(billStateStr)) {
                billStateStr = "\u5df2\u63d0\u4ea4";
            } else if ("2".equals(billStateStr) || "5".equals(billStateStr)) {
                billStateStr = "\u5ba1\u6279\u4e2d";
            } else if ("3".equals(billStateStr)) {
                billStateStr = "\u5ba1\u6279\u901a\u8fc7";
            } else if ("4".equals(billStateStr)) {
                billStateStr = "\u9a73\u56de";
            }
            paymentEntity.setBillStateName(billStateStr);
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Payment-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refPaymentData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<PaymentVO>> refPaymentData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PaymentVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExportDetailDatabase"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportMaterialWarehousingFromDatabase(@RequestBody PaymentVO paymentVO, HttpServletResponse response) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"payment_id", (Object)paymentVO.getId());
        queryWrapper.eq((Object)"dr", (Object)0);
        List list = this.paymentDetailService.list((Wrapper)queryWrapper);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("DetailDatabase-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/excelExportDetailPage"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportMaterialWarehousingFromPage(@RequestBody List<PaymentDetailVO> paymentDetailVOList, HttpServletResponse response) {
        HashMap<String, List<PaymentDetailVO>> beans = new HashMap<String, List<PaymentDetailVO>>();
        beans.put("records", paymentDetailVOList);
        ExcelExport.getInstance().export("DetailDatabase-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/downloadModel"})
    @ResponseBody
    public void downloadModel(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"paymentdetail-import.xlsx", (String)"\u4ed8\u6b3e\u660e\u7ec6\u6a21\u677f");
    }

    @RequestMapping(value={"/detailImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> detailImport(HttpServletRequest request, HttpServletResponse response, Long projectId, String pcList) throws ParseException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        List list = JSON.parseArray((String)pcList, PaymentDetailVO.class);
        Object o = this.service.detailImport(request, response, projectId, list);
        return CommonResponse.success((Object)o);
    }
}

