/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bedget.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.bedget.bean.PaymentEntity;
import com.ejianc.business.bedget.mapper.PaymentMapper;
import com.ejianc.business.bedget.service.IPaymentService;
import com.ejianc.business.bedget.vo.PaymentDetailVO;
import com.ejianc.business.bedget.vo.PaymentVO;
import com.ejianc.business.utils.BigDecimalUtils;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.util.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="paymentService")
public class PaymentServiceImpl
extends BaseServiceImpl<PaymentMapper, PaymentEntity>
implements IPaymentService {
    @Autowired
    private PaymentMapper paymentMapper;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public PaymentVO queryDetailList(Long projectId) {
        List<PaymentDetailVO> queryOutcontractList = this.queryOutcontractList(projectId);
        for (PaymentDetailVO paymentDetailVO : queryOutcontractList) {
            paymentDetailVO.setId(IdWorker.getId());
            if ("\u52b3\u52a1\u5206\u5305".equals(paymentDetailVO.getSubcontractType()) || "\u4e13\u4e1a\u5206\u5305".equals(paymentDetailVO.getSubcontractType())) {
                paymentDetailVO.setIsComplete(this.querySettlementBookList(paymentDetailVO.getProjectId(), paymentDetailVO.getContractId()));
                paymentDetailVO.setTaxCurrentTotal(this.querySubcontractingvolume(paymentDetailVO.getProjectId(), paymentDetailVO.getContractId()));
                paymentDetailVO.setTotalMoneyTax(this.querySettlementBookListAmount(paymentDetailVO.getProjectId(), paymentDetailVO.getContractId()));
            } else if ("\u7269\u8d44\u91c7\u8d2d".equals(paymentDetailVO.getSubcontractType())) {
                paymentDetailVO.setIsComplete(this.queryPurchaseSettlementList(paymentDetailVO.getProjectId(), paymentDetailVO.getContractId()));
                paymentDetailVO.setTaxCurrentTotal(this.queryPurchasesettlement(paymentDetailVO.getProjectId(), paymentDetailVO.getContractId()));
                paymentDetailVO.setTotalMoneyTax(this.queryPurchaseSettlementListAmount(paymentDetailVO.getProjectId(), paymentDetailVO.getContractId()));
            } else if ("\u673a\u68b0\u79df\u8d41".equals(paymentDetailVO.getSubcontractType())) {
                paymentDetailVO.setIsComplete(this.queryMachinerySettlementList(paymentDetailVO.getProjectId(), paymentDetailVO.getContractId()));
                paymentDetailVO.setTaxCurrentTotal(this.queryMechanicallease(paymentDetailVO.getProjectId(), paymentDetailVO.getContractId()));
                paymentDetailVO.setTotalMoneyTax(BigDecimal.ZERO);
            } else if ("\u5468\u8f6c\u6750\u79df\u8d41".equals(paymentDetailVO.getSubcontractType())) {
                paymentDetailVO.setIsComplete(this.queryLeaseSettLementList(paymentDetailVO.getProjectId(), paymentDetailVO.getContractId()));
                paymentDetailVO.setTaxCurrentTotal(this.queryRevolvinglease(paymentDetailVO.getProjectId(), paymentDetailVO.getContractId()));
                paymentDetailVO.setTotalMoneyTax(BigDecimal.ZERO);
            } else if ("\u8bbe\u8ba1\u52d8\u5bdf".equals(paymentDetailVO.getSubcontractType())) {
                paymentDetailVO.setIsComplete(this.queryDesignSettlementList(paymentDetailVO.getProjectId(), paymentDetailVO.getContractId()));
                paymentDetailVO.setTaxCurrentTotal(this.queryDesignsubcontractnode(paymentDetailVO.getProjectId(), paymentDetailVO.getContractId()));
                paymentDetailVO.setTotalMoneyTax(this.queryDesignSettlementListAmount(paymentDetailVO.getProjectId(), paymentDetailVO.getContractId()));
            } else if ("\u54a8\u8be2\u670d\u52a1".equals(paymentDetailVO.getSubcontractType()) || "\u5176\u5b83\u5408\u540c".equals(paymentDetailVO.getSubcontractType())) {
                paymentDetailVO.setIsComplete(this.queryConsultotherfinalList(paymentDetailVO.getProjectId(), paymentDetailVO.getContractId()));
                paymentDetailVO.setTaxCurrentTotal(this.queryConsultother(paymentDetailVO.getProjectId(), paymentDetailVO.getContractId()));
                paymentDetailVO.setTotalMoneyTax(this.queryConsultotherfinalListAmount(paymentDetailVO.getProjectId(), paymentDetailVO.getContractId()));
            }
            paymentDetailVO.setSettlementMoneyTotal(ComputeUtil.safeAdd((BigDecimal)paymentDetailVO.getTaxCurrentTotal(), (BigDecimal)paymentDetailVO.getTotalMoneyTax()));
        }
        List<PaymentDetailVO> paymentDetailVOList = this.queryDetailVOList(projectId);
        if (CollectionUtil.isNotEmpty(paymentDetailVOList)) {
            for (PaymentDetailVO paymentDetailVO : paymentDetailVOList) {
                paymentDetailVO.setId(IdWorker.getId());
                if ("\u52b3\u52a1\u5206\u5305".equals(paymentDetailVO.getSubcontractType()) || "\u4e13\u4e1a\u5206\u5305".equals(paymentDetailVO.getSubcontractType())) {
                    paymentDetailVO.setIsComplete(this.querySettlementBookList(projectId, paymentDetailVO.getContractId()));
                    paymentDetailVO.setTaxCurrentTotal(this.querySubcontractingvolume(projectId, paymentDetailVO.getContractId()));
                    paymentDetailVO.setTotalMoneyTax(this.querySettlementBookListAmount(projectId, paymentDetailVO.getContractId()));
                } else if ("\u7269\u8d44\u91c7\u8d2d".equals(paymentDetailVO.getSubcontractType())) {
                    paymentDetailVO.setIsComplete(this.queryPurchaseSettlementList(projectId, paymentDetailVO.getContractId()));
                    paymentDetailVO.setTaxCurrentTotal(this.queryPurchasesettlement(projectId, paymentDetailVO.getContractId()));
                    paymentDetailVO.setTotalMoneyTax(this.queryPurchaseSettlementListAmount(projectId, paymentDetailVO.getContractId()));
                } else if ("\u673a\u68b0\u79df\u8d41".equals(paymentDetailVO.getSubcontractType())) {
                    paymentDetailVO.setIsComplete(this.queryMachinerySettlementList(projectId, paymentDetailVO.getContractId()));
                    paymentDetailVO.setTaxCurrentTotal(this.queryMechanicallease(projectId, paymentDetailVO.getContractId()));
                    paymentDetailVO.setTotalMoneyTax(BigDecimal.ZERO);
                } else if ("\u5468\u8f6c\u6750\u79df\u8d41".equals(paymentDetailVO.getSubcontractType())) {
                    paymentDetailVO.setIsComplete(this.queryLeaseSettLementList(projectId, paymentDetailVO.getContractId()));
                    paymentDetailVO.setTaxCurrentTotal(this.queryRevolvinglease(projectId, paymentDetailVO.getContractId()));
                    paymentDetailVO.setTotalMoneyTax(BigDecimal.ZERO);
                } else if ("\u8bbe\u8ba1\u52d8\u5bdf".equals(paymentDetailVO.getSubcontractType())) {
                    paymentDetailVO.setIsComplete(this.queryDesignSettlementList(projectId, paymentDetailVO.getContractId()));
                    paymentDetailVO.setTaxCurrentTotal(this.queryDesignsubcontractnode(projectId, paymentDetailVO.getContractId()));
                    paymentDetailVO.setTotalMoneyTax(this.queryDesignSettlementListAmount(projectId, paymentDetailVO.getContractId()));
                } else if ("\u54a8\u8be2\u670d\u52a1".equals(paymentDetailVO.getSubcontractType()) || "\u5176\u5b83\u5408\u540c".equals(paymentDetailVO.getSubcontractType())) {
                    paymentDetailVO.setIsComplete(this.queryConsultotherfinalList(projectId, paymentDetailVO.getContractId()));
                    paymentDetailVO.setTaxCurrentTotal(this.queryConsultother(projectId, paymentDetailVO.getContractId()));
                    paymentDetailVO.setTotalMoneyTax(this.queryConsultotherfinalListAmount(projectId, paymentDetailVO.getContractId()));
                }
                paymentDetailVO.setSettlementMoneyTotal(ComputeUtil.safeAdd((BigDecimal)paymentDetailVO.getTaxCurrentTotal(), (BigDecimal)paymentDetailVO.getTotalMoneyTax()));
            }
        }
        if (CollectionUtil.isNotEmpty(paymentDetailVOList)) {
            for (PaymentDetailVO paymentDetailVO : paymentDetailVOList) {
                paymentDetailVO.setId(IdWorker.getId());
            }
            Map map = paymentDetailVOList.stream().collect(Collectors.toMap(x -> x.getContractId(), Function.identity(), (k1, k2) -> k2));
            for (PaymentDetailVO vo : queryOutcontractList) {
                Long k = vo.getContractId();
                if (map.containsKey(k)) continue;
                paymentDetailVOList.add(vo);
            }
            BigDecimal paymentCopeWithRatio = new BigDecimal("0");
            BigDecimal paymentAdvanceMoney = new BigDecimal("0");
            BigDecimal havePaidTotal = new BigDecimal("0");
            BigDecimal debtMoneyTotal = new BigDecimal("0");
            for (PaymentDetailVO vo : paymentDetailVOList) {
                vo.setPaymentAdvanceMoney(ComputeUtil.safeAdd((BigDecimal)vo.getPaymentAdvanceMoney(), (BigDecimal)vo.getCurrentAdvanceMoney()));
                vo.setPaymentScheduleMoney(ComputeUtil.safeAdd((BigDecimal)vo.getPaymentScheduleMoney(), (BigDecimal)vo.getCurrentScheduleMoney()));
                vo.setPaymentMoneyTotal(ComputeUtil.safeAdd((BigDecimal)vo.getPaymentAdvanceMoney(), (BigDecimal)vo.getPaymentScheduleMoney()));
                vo.setPaymentCopeWithRatio(ComputeUtil.safeDiv((BigDecimal)vo.getPaymentMoneyTotal(), (BigDecimal)vo.getSettlementMoneyTotal()));
                vo.setDebtAdvanceMoney(ComputeUtil.safeSub((BigDecimal)vo.getAdvanceTotal(), (BigDecimal)vo.getPaymentAdvanceMoney()));
                vo.setDebtScheduleMoney(ComputeUtil.safeSub((BigDecimal)vo.getScheduleTotal(), (BigDecimal)vo.getPaymentScheduleMoney()));
                vo.setDebtMoneyTotal(ComputeUtil.safeAdd((BigDecimal)vo.getDebtAdvanceMoney(), (BigDecimal)vo.getDebtScheduleMoney()));
                paymentCopeWithRatio = ComputeUtil.safeAdd((BigDecimal)paymentCopeWithRatio, (BigDecimal)vo.getPaymentCopeWithRatio());
                paymentAdvanceMoney = ComputeUtil.safeAdd((BigDecimal)paymentAdvanceMoney, (BigDecimal)vo.getPaymentAdvanceMoney());
                havePaidTotal = ComputeUtil.safeAdd((BigDecimal)havePaidTotal, (BigDecimal)vo.getPaymentMoneyTotal());
                debtMoneyTotal = ComputeUtil.safeAdd((BigDecimal)debtMoneyTotal, (BigDecimal)vo.getDebtMoneyTotal());
            }
            PaymentEntity paymentEntity = (PaymentEntity)((Object)this.selectById(paymentDetailVOList.get(0).getPaymentId()));
            paymentEntity.setPaymentRatioTotal(paymentCopeWithRatio);
            paymentEntity.setInAdvancePaymentMoney(paymentAdvanceMoney);
            paymentEntity.setHavePaidTotal(havePaidTotal);
            paymentEntity.setDebtMoneyTotal(debtMoneyTotal);
            PaymentVO paymentVO = (PaymentVO)((Object)BeanMapper.map((Object)((Object)paymentEntity), PaymentVO.class));
            paymentVO.setPaymentDetailList(this.orderByList(paymentDetailVOList));
            return paymentVO;
        }
        PaymentVO paymentVO = new PaymentVO();
        paymentVO.setPaymentDetailList(this.orderByList(queryOutcontractList));
        return paymentVO;
    }

    @Override
    public List<PaymentDetailVO> queryOutcontractList(Long projectId) {
        return this.paymentMapper.queryOutcontractList(projectId);
    }

    @Override
    public String querySettlementBookList(Long projectId, Long contractId) {
        List<PaymentDetailVO> paymentDetailVOS = this.paymentMapper.querySettlementBookList(projectId, contractId);
        if (CollectionUtil.isNotEmpty(paymentDetailVOS)) {
            return "\u662f";
        }
        return "\u5426";
    }

    @Override
    public String queryPurchaseSettlementList(Long projectId, Long contractId) {
        List<PaymentDetailVO> paymentDetailVOS = this.paymentMapper.queryPurchaseSettlementList(projectId, contractId);
        if (CollectionUtil.isNotEmpty(paymentDetailVOS)) {
            return "\u662f";
        }
        return "\u5426";
    }

    @Override
    public String queryLeaseSettLementList(Long projectId, Long contractId) {
        List<PaymentDetailVO> paymentDetailVOS = this.paymentMapper.queryLeaseSettLementList(projectId, contractId);
        if (CollectionUtil.isNotEmpty(paymentDetailVOS)) {
            return "\u662f";
        }
        return "\u5426";
    }

    @Override
    public String queryMachinerySettlementList(Long projectId, Long contractId) {
        List<PaymentDetailVO> paymentDetailVOS = this.paymentMapper.queryMachinerySettlementList(projectId, contractId);
        if (CollectionUtil.isNotEmpty(paymentDetailVOS)) {
            return "\u662f";
        }
        return "\u5426";
    }

    @Override
    public String queryDesignSettlementList(Long projectId, Long contractId) {
        List<PaymentDetailVO> paymentDetailVOS = this.paymentMapper.queryDesignSettlementList(projectId, contractId);
        if (CollectionUtil.isNotEmpty(paymentDetailVOS)) {
            return "\u662f";
        }
        return "\u5426";
    }

    @Override
    public String queryConsultotherfinalList(Long projectId, Long contractId) {
        List<PaymentDetailVO> paymentDetailVOS = this.paymentMapper.queryConsultotherfinalList(projectId, contractId);
        if (CollectionUtil.isNotEmpty(paymentDetailVOS)) {
            return "\u662f";
        }
        return "\u5426";
    }

    @Override
    public BigDecimal querySubcontractingvolume(Long projectId, Long contractId) {
        List<PaymentDetailVO> paymentDetailVOS = this.paymentMapper.querySubcontractingvolume(projectId, contractId);
        if (CollectionUtil.isNotEmpty(paymentDetailVOS)) {
            return paymentDetailVOS.get(0).getTotalMoneyTax();
        }
        return new BigDecimal("0");
    }

    @Override
    public BigDecimal queryPurchasesettlement(Long projectId, Long contractId) {
        List<PaymentDetailVO> paymentDetailVOS = this.paymentMapper.queryPurchasesettlement(projectId, contractId);
        if (CollectionUtil.isNotEmpty(paymentDetailVOS)) {
            return paymentDetailVOS.get(0).getTotalMoneyTax();
        }
        return new BigDecimal("0");
    }

    @Override
    public BigDecimal queryRevolvinglease(Long projectId, Long contractId) {
        List<PaymentDetailVO> paymentDetailVOS = this.paymentMapper.queryRevolvinglease(projectId, contractId);
        if (CollectionUtil.isNotEmpty(paymentDetailVOS)) {
            return paymentDetailVOS.get(0).getTotalMoneyTax();
        }
        return new BigDecimal("0");
    }

    @Override
    public BigDecimal queryMechanicallease(Long projectId, Long contractId) {
        List<PaymentDetailVO> paymentDetailVOS = this.paymentMapper.queryMechanicallease(projectId, contractId);
        if (CollectionUtil.isNotEmpty(paymentDetailVOS)) {
            return paymentDetailVOS.get(0).getTotalMoneyTax();
        }
        return new BigDecimal("0");
    }

    @Override
    public BigDecimal queryDesignsubcontractnode(Long projectId, Long contractId) {
        List<PaymentDetailVO> paymentDetailVOS = this.paymentMapper.queryDesignsubcontractnode(projectId, contractId);
        if (CollectionUtil.isNotEmpty(paymentDetailVOS)) {
            return paymentDetailVOS.get(0).getTotalMoneyTax();
        }
        return new BigDecimal("0");
    }

    @Override
    public BigDecimal queryConsultother(Long projectId, Long contractId) {
        List<PaymentDetailVO> paymentDetailVOS = this.paymentMapper.queryConsultother(projectId, contractId);
        if (CollectionUtil.isNotEmpty(paymentDetailVOS)) {
            return paymentDetailVOS.get(0).getTotalMoneyTax();
        }
        return new BigDecimal("0");
    }

    @Override
    public BigDecimal querySettlementBookListAmount(Long projectId, Long contractId) {
        List<PaymentDetailVO> paymentDetailVOS = this.paymentMapper.querySettlementBookListAmount(projectId, contractId);
        if (CollectionUtil.isNotEmpty(paymentDetailVOS)) {
            return paymentDetailVOS.get(0).getTotalMoneyTax();
        }
        return new BigDecimal("0");
    }

    @Override
    public BigDecimal queryPurchaseSettlementListAmount(Long projectId, Long contractId) {
        List<PaymentDetailVO> paymentDetailVOS = this.paymentMapper.queryPurchaseSettlementListAmount(projectId, contractId);
        if (CollectionUtil.isNotEmpty(paymentDetailVOS)) {
            return paymentDetailVOS.get(0).getTotalMoneyTax();
        }
        return new BigDecimal("0");
    }

    @Override
    public BigDecimal queryLeaseSettLementListAmount(Long projectId, Long contractId) {
        List<PaymentDetailVO> paymentDetailVOS = this.paymentMapper.queryLeaseSettLementListAmount(projectId, contractId);
        if (CollectionUtil.isNotEmpty(paymentDetailVOS)) {
            return paymentDetailVOS.get(0).getTotalMoneyTax();
        }
        return new BigDecimal("0");
    }

    @Override
    public BigDecimal queryMachinerySettlementListAmount(Long projectId, Long contractId) {
        List<PaymentDetailVO> paymentDetailVOS = this.paymentMapper.queryMachinerySettlementListAmount(projectId, contractId);
        if (CollectionUtil.isNotEmpty(paymentDetailVOS)) {
            return paymentDetailVOS.get(0).getTotalMoneyTax();
        }
        return new BigDecimal("0");
    }

    @Override
    public BigDecimal queryDesignSettlementListAmount(Long projectId, Long contractId) {
        List<PaymentDetailVO> paymentDetailVOS = this.paymentMapper.queryDesignSettlementListAmount(projectId, contractId);
        if (CollectionUtil.isNotEmpty(paymentDetailVOS)) {
            return paymentDetailVOS.get(0).getTotalMoneyTax();
        }
        return new BigDecimal("0");
    }

    @Override
    public BigDecimal queryConsultotherfinalListAmount(Long projectId, Long contractId) {
        List<PaymentDetailVO> paymentDetailVOS = this.paymentMapper.queryConsultotherfinalListAmount(projectId, contractId);
        if (CollectionUtil.isNotEmpty(paymentDetailVOS)) {
            return paymentDetailVOS.get(0).getTotalMoneyTax();
        }
        return new BigDecimal("0");
    }

    @Override
    public List<PaymentDetailVO> queryDetailVOList(Long projectId) {
        return this.paymentMapper.queryDetailVOList(projectId);
    }

    @Override
    public List<PaymentDetailVO> queryDetailListParams(Long paymentId, String searchText) {
        return this.paymentMapper.queryDetailListParams(paymentId, searchText);
    }

    @Override
    public Object detailImport(HttpServletRequest request, HttpServletResponse response, Long projectId, List<PaymentDetailVO> pcList) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<PaymentDetailVO> success = new ArrayList<PaymentDetailVO>();
        ArrayList<PaymentDetailVO> errorList = new ArrayList<PaymentDetailVO>();
        HashMap map = new HashMap();
        ArrayList costNewList = new ArrayList();
        ArrayList costList = new ArrayList();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            for (int i = 2; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                StringBuilder errorsMsgBuilder = new StringBuilder();
                String contractCode = (String)datas.get(0);
                String contractName = (String)datas.get(1);
                String supplierName = (String)datas.get(2);
                String subcontractType = (String)datas.get(3);
                String contractAmountTax = (String)datas.get(4);
                String isComplete = (String)datas.get(5);
                String settlementMoneyTotal = (String)datas.get(6);
                String copeWithRatioTotal = (String)datas.get(7);
                this.logger.info("111111111111111" + copeWithRatioTotal);
                String advanceTotal = (String)datas.get(8);
                String scheduleTotal = (String)datas.get(9);
                String accountsPayableTotal = (String)datas.get(10);
                String currentAdvanceMoney = (String)datas.get(11);
                String currentScheduleMoney = (String)datas.get(12);
                String currentSalaryMoney = (String)datas.get(13);
                PaymentDetailVO paymentDetailVO = new PaymentDetailVO();
                paymentDetailVO.setContractCode(StringUtils.isNotBlank((CharSequence)contractCode) ? contractCode : null);
                paymentDetailVO.setContractName(StringUtils.isNotBlank((CharSequence)contractName) ? contractName : null);
                paymentDetailVO.setSupplierName(StringUtils.isNotBlank((CharSequence)supplierName) ? supplierName : null);
                paymentDetailVO.setSubcontractType(StringUtils.isNotBlank((CharSequence)subcontractType) ? subcontractType : null);
                paymentDetailVO.setCopeWithRatioTotal(new BigDecimal(StringUtils.isNotBlank((CharSequence)copeWithRatioTotal) ? copeWithRatioTotal : "0.00"));
                paymentDetailVO.setAdvanceTotal(new BigDecimal(StringUtils.isNotBlank((CharSequence)advanceTotal) ? advanceTotal : "0.00"));
                paymentDetailVO.setScheduleTotal(new BigDecimal(StringUtils.isNotBlank((CharSequence)scheduleTotal) ? scheduleTotal : "0.00"));
                paymentDetailVO.setCurrentAdvanceMoney(new BigDecimal(StringUtils.isNotBlank((CharSequence)currentAdvanceMoney) ? currentAdvanceMoney : "0.00"));
                paymentDetailVO.setCurrentScheduleMoney(new BigDecimal(StringUtils.isNotBlank((CharSequence)currentScheduleMoney) ? currentScheduleMoney : "0.00"));
                paymentDetailVO.setCurrentSalaryMoney(new BigDecimal(StringUtils.isNotBlank((CharSequence)currentSalaryMoney) ? currentSalaryMoney : "0.00"));
                if (contractCode == null || TextUtils.isEmpty((CharSequence)contractCode)) {
                    paymentDetailVO.setErrorMsg("\u5408\u540c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorsMsgBuilder.append("\u5408\u540c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (contractName == null || TextUtils.isEmpty((CharSequence)contractName)) {
                    paymentDetailVO.setErrorMsg("\u5408\u540c\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorsMsgBuilder.append("\u5408\u540c\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (errorsMsgBuilder.length() > 0) {
                    errorList.add(paymentDetailVO);
                    continue;
                }
                success.add(paymentDetailVO);
            }
            HashMap<String, PaymentDetailVO> costMap = new HashMap<String, PaymentDetailVO>();
            for (PaymentDetailVO vo : success) {
                this.logger.info("successkey" + vo.getContractCode());
                costMap.put(vo.getContractCode(), vo);
            }
            if (CollectionUtils.isNotEmpty(pcList)) {
                for (PaymentDetailVO paymentDetailVO : pcList) {
                    paymentDetailVO.setId(IdWorker.getId());
                    String key = paymentDetailVO.getContractCode();
                    this.logger.info("key" + key);
                    if (!costMap.containsKey(key)) continue;
                    PaymentDetailVO paymentDetailVOExcel = (PaymentDetailVO)((Object)costMap.get(key));
                    paymentDetailVO.setCopeWithRatioTotal(paymentDetailVOExcel.getCopeWithRatioTotal());
                    paymentDetailVO.setAdvanceTotal(paymentDetailVOExcel.getAdvanceTotal());
                    paymentDetailVO.setScheduleTotal(paymentDetailVOExcel.getScheduleTotal());
                    paymentDetailVO.setCurrentAdvanceMoney(paymentDetailVOExcel.getCurrentAdvanceMoney());
                    paymentDetailVO.setCurrentScheduleMoney(paymentDetailVOExcel.getCurrentScheduleMoney());
                    paymentDetailVO.setCurrentSalaryMoney(paymentDetailVOExcel.getCurrentSalaryMoney());
                    paymentDetailVO.setAccountsPayableTotal(BigDecimalUtils.add(paymentDetailVO.getAdvanceTotal(), paymentDetailVO.getScheduleTotal()));
                    paymentDetailVO.setCurrentMoneyTotal(BigDecimalUtils.add(paymentDetailVO.getCurrentAdvanceMoney(), paymentDetailVO.getCurrentScheduleMoney()));
                    paymentDetailVO.setPaymentAdvanceMoney(BigDecimalUtils.add(paymentDetailVO.getPastAdvanceTotal(), paymentDetailVO.getCurrentAdvanceMoney()));
                    paymentDetailVO.setPaymentScheduleMoney(BigDecimalUtils.add(paymentDetailVO.getPastScheduleTotal(), paymentDetailVO.getCurrentScheduleMoney()));
                    paymentDetailVO.setPaymentMoneyTotal(BigDecimalUtils.add(paymentDetailVO.getPaymentAdvanceMoney(), paymentDetailVO.getPaymentScheduleMoney()));
                    paymentDetailVO.setDebtAdvanceMoney(ComputeUtil.safeSub((BigDecimal)paymentDetailVO.getAdvanceTotal(), (BigDecimal)paymentDetailVO.getPaymentAdvanceMoney()));
                    paymentDetailVO.setDebtScheduleMoney(ComputeUtil.safeSub((BigDecimal)paymentDetailVO.getScheduleTotal(), (BigDecimal)paymentDetailVO.getPaymentScheduleMoney()));
                    paymentDetailVO.setDebtMoneyTotal(ComputeUtil.safeAdd((BigDecimal)paymentDetailVO.getDebtAdvanceMoney(), (BigDecimal)paymentDetailVO.getDebtScheduleMoney()));
                    if (BigDecimalUtils.ofNullable(paymentDetailVO.getCurrentSalaryMoney()).compareTo(paymentDetailVO.getCurrentScheduleMoney()) == 1) {
                        paymentDetailVO.setCurrentSalaryMoney(BigDecimal.ZERO);
                        paymentDetailVO.setPaymentSalaryMoney(paymentDetailVO.getPastSalaryTotal());
                        continue;
                    }
                    paymentDetailVO.setPaymentSalaryMoney(ComputeUtil.safeAdd((BigDecimal)paymentDetailVO.getPastSalaryTotal(), (BigDecimal)paymentDetailVO.getCurrentSalaryMoney()));
                }
            }
        }
        JSONObject json = new JSONObject();
        Integer size = pcList.size();
        json.put("successNum", (Object)size);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        json.put("successList", pcList);
        json.put("total", pcList);
        return json;
    }

    public List<PaymentDetailVO> orderByList(List<PaymentDetailVO> paymentDetailVOList) {
        ArrayList<PaymentDetailVO> laowu = new ArrayList<PaymentDetailVO>();
        ArrayList<PaymentDetailVO> zhuanye = new ArrayList<PaymentDetailVO>();
        ArrayList<PaymentDetailVO> wzcg = new ArrayList<PaymentDetailVO>();
        ArrayList<PaymentDetailVO> jxzl = new ArrayList<PaymentDetailVO>();
        ArrayList<PaymentDetailVO> zzczl = new ArrayList<PaymentDetailVO>();
        ArrayList<PaymentDetailVO> sjkc = new ArrayList<PaymentDetailVO>();
        ArrayList<PaymentDetailVO> zxfw = new ArrayList<PaymentDetailVO>();
        ArrayList<PaymentDetailVO> qtht = new ArrayList<PaymentDetailVO>();
        ArrayList<PaymentDetailVO> paymentDetailVOS = new ArrayList<PaymentDetailVO>();
        if (CollectionUtil.isNotEmpty(paymentDetailVOList)) {
            for (PaymentDetailVO paymentDetailVO : paymentDetailVOList) {
                if ("\u52b3\u52a1\u5206\u5305".equals(paymentDetailVO.getSubcontractType())) {
                    laowu.add(paymentDetailVO);
                }
                if ("\u4e13\u4e1a\u5206\u5305".equals(paymentDetailVO.getSubcontractType())) {
                    zhuanye.add(paymentDetailVO);
                }
                if ("\u7269\u8d44\u91c7\u8d2d".equals(paymentDetailVO.getSubcontractType())) {
                    wzcg.add(paymentDetailVO);
                }
                if ("\u673a\u68b0\u79df\u8d41".equals(paymentDetailVO.getSubcontractType())) {
                    jxzl.add(paymentDetailVO);
                }
                if ("\u5468\u8f6c\u6750\u79df\u8d41".equals(paymentDetailVO.getSubcontractType())) {
                    zzczl.add(paymentDetailVO);
                }
                if ("\u8bbe\u8ba1\u52d8\u5bdf".equals(paymentDetailVO.getSubcontractType())) {
                    sjkc.add(paymentDetailVO);
                }
                if ("\u54a8\u8be2\u670d\u52a1".equals(paymentDetailVO.getSubcontractType())) {
                    zxfw.add(paymentDetailVO);
                }
                if (!"\u5176\u5b83\u5408\u540c".equals(paymentDetailVO.getSubcontractType())) continue;
                qtht.add(paymentDetailVO);
            }
            if (CollectionUtil.isNotEmpty(laowu)) {
                paymentDetailVOS.addAll(laowu);
            }
            if (CollectionUtil.isNotEmpty(zhuanye)) {
                paymentDetailVOS.addAll(zhuanye);
            }
            if (CollectionUtil.isNotEmpty(wzcg)) {
                paymentDetailVOS.addAll(wzcg);
            }
            if (CollectionUtil.isNotEmpty(jxzl)) {
                paymentDetailVOS.addAll(jxzl);
            }
            if (CollectionUtil.isNotEmpty(zzczl)) {
                paymentDetailVOS.addAll(zzczl);
            }
            if (CollectionUtil.isNotEmpty(sjkc)) {
                paymentDetailVOS.addAll(sjkc);
            }
            if (CollectionUtil.isNotEmpty(zxfw)) {
                paymentDetailVOS.addAll(zxfw);
            }
            if (CollectionUtil.isNotEmpty(qtht)) {
                paymentDetailVOS.addAll(qtht);
            }
            return paymentDetailVOS;
        }
        return paymentDetailVOList;
    }
}

