/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.change.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.bedget.bean.QuotadesignEntity;
import com.ejianc.business.bedget.bean.QuotadesigndetailEntity;
import com.ejianc.business.bedget.service.IQuotadesignService;
import com.ejianc.business.change.bean.ChangequotadesignEntity;
import com.ejianc.business.change.service.IChangequotadesignService;
import com.ejianc.business.change.vo.ChangequotadesignVO;
import com.ejianc.business.change.vo.ChangequotadesigndetailVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.util.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"changequotadesign"})
public class ChangequotadesignController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "change-budgetmanage-quotadesign";
    @Autowired
    private IChangequotadesignService service;
    @Autowired
    private IQuotadesignService quotadesignService;

    @GetMapping(value={"queryDetailByOriginalId"})
    @ResponseBody
    public CommonResponse<ChangequotadesignVO> queryDetailByOriginalId(@RequestParam(value="originalId") Long originalId) {
        QuotadesignEntity quotadesignVO = (QuotadesignEntity)((Object)this.quotadesignService.selectById(originalId));
        ChangequotadesignVO changeVO = (ChangequotadesignVO)((Object)BeanMapper.map((Object)((Object)quotadesignVO), ChangequotadesignVO.class));
        Long id = IdWorker.getId();
        changeVO.setOriginalId(originalId);
        changeVO.setBillState(null);
        changeVO.setCreateTime(null);
        changeVO.setCreateUserCode(null);
        changeVO.setTenantId(null);
        changeVO.setUpdateTime(null);
        changeVO.setUpdateUserCode(null);
        changeVO.setId(id);
        List<QuotadesigndetailEntity> quotadesigndetailList = quotadesignVO.getQuotadesigndetailEntities();
        if (quotadesigndetailList != null && quotadesigndetailList.size() > 0) {
            ArrayList<ChangequotadesigndetailVO> changequotadesigndetailVos = new ArrayList<ChangequotadesigndetailVO>();
            for (QuotadesigndetailEntity entity : quotadesigndetailList) {
                ChangequotadesigndetailVO vo = (ChangequotadesigndetailVO)((Object)BeanMapper.map((Object)((Object)entity), ChangequotadesigndetailVO.class));
                vo.setMid(id);
                vo.setOriginalId(entity.getId());
                vo.setCreateTime(null);
                vo.setCreateUserCode(null);
                vo.setTenantId(null);
                vo.setUpdateTime(null);
                vo.setUpdateUserCode(null);
                vo.setRowState("edit");
                vo.setId(IdWorker.getId());
                changequotadesigndetailVos.add(vo);
            }
            List<ChangequotadesigndetailVO> resChangequotadesigndetailVOList = ChangequotadesignController.createTreeData(changequotadesigndetailVos);
            changeVO.setQuotadesigndetailEntities(resChangequotadesigndetailVOList);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6210\u529f\uff01", (Object)((Object)changeVO));
    }

    @RequestMapping(value={"/saveChange"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ChangequotadesignVO> saveOrUpdate(@RequestBody ChangequotadesignVO saveOrUpdateVO) {
        return this.service.saveChange(saveOrUpdateVO);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ChangequotadesignVO> queryDetail(Long id) {
        ChangequotadesignEntity entity = (ChangequotadesignEntity)((Object)this.service.selectById(id));
        ChangequotadesignVO vo = (ChangequotadesignVO)((Object)BeanMapper.map((Object)((Object)entity), ChangequotadesignVO.class));
        List<ChangequotadesigndetailVO> quotadesigndetailVO = vo.getQuotadesigndetailEntities();
        List<ChangequotadesigndetailVO> resQuotadesigndetailVO = ChangequotadesignController.createTreeData(quotadesigndetailVO);
        vo.setQuotadesigndetailEntities(resQuotadesigndetailVO);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ChangequotadesignVO> vos) {
        return this.service.delete(vos);
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ChangequotadesignVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ChangequotadesignVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Changequotadesign-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refChangequotadesignData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ChangequotadesignVO>> refChangequotadesignData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ChangequotadesignVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/refreshData"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> refreshData(@RequestBody List<ChangequotadesigndetailVO> list, HttpServletResponse response) {
        JSONObject json = new JSONObject();
        HashMap<String, ChangequotadesigndetailVO> map = new HashMap<String, ChangequotadesigndetailVO>();
        ChangequotadesigndetailVO add = list.get(list.size() - 1);
        add.setId(IdWorker.getId());
        add.setTid(String.valueOf(IdWorker.getId()));
        add.setRowState("edit");
        add.setInnercode(add.getSonItemCode());
        for (ChangequotadesigndetailVO vo : list) {
            map.put(vo.getInnercode(), vo);
            if (add.getId().equals(vo.getId()) || !add.getInnercode().equals(vo.getInnercode())) continue;
            throw new BusinessException("\u5b50\u76ee\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u586b\u5199");
        }
        for (ChangequotadesigndetailVO vo : list) {
            String innercode = vo.getInnercode();
            Long pid = null;
            if (innercode.length() != 2) {
                String pcode;
                if (innercode.length() == 4) {
                    pcode = innercode.substring(0, 2);
                    pid = this.setPid(pcode, map);
                } else if (innercode.length() == 6) {
                    pcode = innercode.substring(0, 4);
                    pid = this.setPid(pcode, map);
                } else if (innercode.length() > 6) {
                    pcode = innercode.substring(0, 6);
                    pid = this.setPid(pcode, map);
                }
            }
            if (pid != null) {
                vo.setTpid(pid.toString());
                continue;
            }
            vo.setTpid("");
        }
        list = this.clearPData(add, list);
        Collections.sort(list, new Comparator<ChangequotadesigndetailVO>(){

            @Override
            public int compare(ChangequotadesigndetailVO o1, ChangequotadesigndetailVO o2) {
                return o1.getSonItemCode().compareTo(o2.getSonItemCode());
            }
        });
        List<ChangequotadesigndetailVO> result = ChangequotadesignController.createTreeData(list);
        json.put("dataSource", result);
        return CommonResponse.success((Object)json);
    }

    private List<ChangequotadesigndetailVO> clearPData(ChangequotadesigndetailVO handleVO, List<ChangequotadesigndetailVO> list) {
        if (list == null || list.size() == 0) {
            return null;
        }
        String pid = handleVO.getTpid();
        if (pid == null || TextUtils.isEmpty((CharSequence)pid)) {
            return list;
        }
        for (int i = 0; i < list.size(); ++i) {
            ChangequotadesigndetailVO vo = list.get(i);
            if (!pid.equals(vo.getTid())) continue;
            vo.setEngineering(null);
            vo.setLabor(null);
            vo.setMaterial(null);
            vo.setMechanical(null);
            vo.setManagement(null);
            vo.setProfit(null);
            vo.setUnitPrice(null);
            if (vo.getTpid() == null || TextUtils.isEmpty((CharSequence)vo.getTpid())) break;
            this.clearPData(vo, list);
            break;
        }
        return list;
    }

    private Long setPid(String pcode, Map<String, ChangequotadesigndetailVO> map) {
        if (map.get(pcode) != null) {
            return Long.valueOf(map.get(pcode).getTid());
        }
        if (pcode.length() == 2) {
            return null;
        }
        if (pcode.length() == 4) {
            String ppcode = pcode.substring(0, 2);
            return this.setPid(ppcode, map);
        }
        if (pcode.length() == 6) {
            String ppcode = pcode.substring(0, 4);
            return this.setPid(ppcode, map);
        }
        if (pcode.length() > 6) {
            String ppcode = pcode.substring(0, 6);
            return this.setPid(ppcode, map);
        }
        return null;
    }

    public static List<ChangequotadesigndetailVO> createTreeData(List<ChangequotadesigndetailVO> list) {
        ArrayList<ChangequotadesigndetailVO> resp = new ArrayList<ChangequotadesigndetailVO>();
        ArrayList<String> rootItems = new ArrayList<String>();
        HashMap<String, ChangequotadesigndetailVO> listMap = new HashMap<String, ChangequotadesigndetailVO>();
        for (ChangequotadesigndetailVO item : list) {
            listMap.put(item.getTid().toString(), item);
        }
        for (int i = 0; i < list.size(); ++i) {
            ChangequotadesigndetailVO item;
            item = list.get(i);
            String parentId = item.getTpid() != null ? item.getTpid().toString() : "";
            ChangequotadesigndetailVO parent = (ChangequotadesigndetailVO)((Object)listMap.get(parentId));
            if (parent != null) {
                List<ChangequotadesigndetailVO> child = parent.getChildren();
                if (child != null) {
                    child.add(item);
                    continue;
                }
                ArrayList<ChangequotadesigndetailVO> children = new ArrayList<ChangequotadesigndetailVO>();
                children.add(item);
                parent.setChildren(children);
                continue;
            }
            rootItems.add(item.getTid());
        }
        for (String rootId : rootItems) {
            resp.add((ChangequotadesigndetailVO)((Object)listMap.get(rootId)));
        }
        return resp;
    }
}

