package com.ejianc.business.bedget.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 付款登记子表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_budgetmanage_payment_detail")
public class PaymentDetailEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="payment_id")
    private Long paymentId; // 主表主键
    @TableField(value="contract_id")
    private Long contractId; // 合同主键
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="contract_code")
    private String contractCode; // 合同编号
    @TableField(value="supplier_id")
    private Long supplierId; // 分包分供id
    @TableField(value="supplier_name")
    private String supplierName; // 分包分供名称
    @TableField(value="subcontract_type")
    private String subcontractType; // 分包类型
    @TableField(value="contract_amount_tax")
    private BigDecimal contractAmountTax; // 合同额（含税）
    @TableField(value="is_complete")
    private String isComplete; // 是否完工结算 是/否
    @TableField(value="settlement_money_total")
    private BigDecimal settlementMoneyTotal; // 累计结算金额（含税）
    @TableField(value="cope_with_ratio_total")
    private BigDecimal copeWithRatioTotal; // 应付比例%
    @TableField(value="advance_total")
    private BigDecimal advanceTotal; // 累计应付金额  预付账款
    @TableField(value="schedule_total")
    private BigDecimal scheduleTotal; // 累计应付金额  进度账款
    @TableField(value="past_advance_total")
    private BigDecimal pastAdvanceTotal;//往期 累计应付金额 预付账款
    @TableField(value="past_schedule_total")
    private BigDecimal pastScheduleTotal;//往期 累计应付金额 进度账款
    @TableField(value="past_salary_total")
    private BigDecimal pastSalaryTotal;//往期 累计农民工工资金额
    @TableField(value="accounts_payable_total")
    private BigDecimal accountsPayableTotal; // 累计应付金额合计
    @TableField(value="current_advance_money")
    private BigDecimal currentAdvanceMoney; // 本期实付金额 预付款金额
    @TableField(value="current_schedule_money")
    private BigDecimal currentScheduleMoney; // 本期实付金额 进度款
    @TableField(value="current_money_total")
    private BigDecimal currentMoneyTotal; // 本期实付金额合计
    @TableField(value="payment_advance_money")
    private BigDecimal paymentAdvanceMoney; // 累计付款金额（含本期) 预付账款
    @TableField(value="payment_schedule_money")
    private BigDecimal paymentScheduleMoney; // 累计付款金额（含本期) 进度账款
    @TableField(value="payment_money_total")
    private BigDecimal paymentMoneyTotal; // 累计付款金额（含本期）合计
    @TableField(value="payment_cope_with_ratio")
    private BigDecimal paymentCopeWithRatio; // 累计付款金额（含本期)  累计支付比例%
    @TableField(value="debt_advance_money")
    private BigDecimal debtAdvanceMoney; // 累计欠款金额 预付账款
    @TableField(value="debt_schedule_money")
    private BigDecimal debtScheduleMoney; // 累计欠款金额 进度账款
    @TableField(value="debt_money_total")
    private BigDecimal debtMoneyTotal; // 累计欠款金额 合计

    @TableField(value="current_salary_money")
    private BigDecimal currentSalaryMoney; // 其中农名工工资(本期实付金额)
    @TableField(value="payment_salary_money")
    private BigDecimal paymentSalaryMoney; // 其中农名工工资(累计付款金额（含本期）)

    public BigDecimal getPastSalaryTotal() {
        return pastSalaryTotal;
    }

    public void setPastSalaryTotal(BigDecimal pastSalaryTotal) {
        this.pastSalaryTotal = pastSalaryTotal;
    }



    public BigDecimal getCurrentSalaryMoney() {
        return currentSalaryMoney;
    }

    public void setCurrentSalaryMoney(BigDecimal currentSalaryMoney) {
        this.currentSalaryMoney = currentSalaryMoney;
    }

    public BigDecimal getPaymentSalaryMoney() {
        return paymentSalaryMoney;
    }

    public void setPaymentSalaryMoney(BigDecimal paymentSalaryMoney) {
        this.paymentSalaryMoney = paymentSalaryMoney;
    }

    public Long getPaymentId() {
        return paymentId;
    }

    public void setPaymentId(Long paymentId) {
        this.paymentId = paymentId;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public String getSubcontractType() {
        return subcontractType;
    }

    public void setSubcontractType(String subcontractType) {
        this.subcontractType = subcontractType;
    }
    public BigDecimal getContractAmountTax() {
        return contractAmountTax;
    }

    public void setContractAmountTax(BigDecimal contractAmountTax) {
        this.contractAmountTax = contractAmountTax;
    }
    public String getIsComplete() {
        return isComplete;
    }

    public void setIsComplete(String isComplete) {
        this.isComplete = isComplete;
    }
    public BigDecimal getSettlementMoneyTotal() {
        return settlementMoneyTotal;
    }

    public void setSettlementMoneyTotal(BigDecimal settlementMoneyTotal) {
        this.settlementMoneyTotal = settlementMoneyTotal;
    }
    public BigDecimal getCopeWithRatioTotal() {
        return copeWithRatioTotal;
    }

    public void setCopeWithRatioTotal(BigDecimal copeWithRatioTotal) {
        this.copeWithRatioTotal = copeWithRatioTotal;
    }
    public BigDecimal getAdvanceTotal() {
        return advanceTotal;
    }

    public void setAdvanceTotal(BigDecimal advanceTotal) {
        this.advanceTotal = advanceTotal;
    }
    public BigDecimal getScheduleTotal() {
        return scheduleTotal;
    }

    public void setScheduleTotal(BigDecimal scheduleTotal) {
        this.scheduleTotal = scheduleTotal;
    }

    public BigDecimal getPastAdvanceTotal() {
        return pastAdvanceTotal;
    }

    public void setPastAdvanceTotal(BigDecimal pastAdvanceTotal) {
        this.pastAdvanceTotal = pastAdvanceTotal;
    }

    public BigDecimal getPastScheduleTotal() {
        return pastScheduleTotal;
    }

    public void setPastScheduleTotal(BigDecimal pastScheduleTotal) {
        this.pastScheduleTotal = pastScheduleTotal;
    }

    public BigDecimal getAccountsPayableTotal() {
        return accountsPayableTotal;
    }

    public void setAccountsPayableTotal(BigDecimal accountsPayableTotal) {
        this.accountsPayableTotal = accountsPayableTotal;
    }
    public BigDecimal getCurrentAdvanceMoney() {
        return currentAdvanceMoney;
    }

    public void setCurrentAdvanceMoney(BigDecimal currentAdvanceMoney) {
        this.currentAdvanceMoney = currentAdvanceMoney;
    }

    public BigDecimal getCurrentScheduleMoney() {
        return currentScheduleMoney;
    }

    public void setCurrentScheduleMoney(BigDecimal currentScheduleMoney) {
        this.currentScheduleMoney = currentScheduleMoney;
    }

    public BigDecimal getCurrentMoneyTotal() {
        return currentMoneyTotal;
    }

    public void setCurrentMoneyTotal(BigDecimal currentMoneyTotal) {
        this.currentMoneyTotal = currentMoneyTotal;
    }

    public BigDecimal getPaymentAdvanceMoney() {
        return paymentAdvanceMoney;
    }

    public void setPaymentAdvanceMoney(BigDecimal paymentAdvanceMoney) {
        this.paymentAdvanceMoney = paymentAdvanceMoney;
    }

    public BigDecimal getPaymentScheduleMoney() {
        return paymentScheduleMoney;
    }

    public void setPaymentScheduleMoney(BigDecimal paymentScheduleMoney) {
        this.paymentScheduleMoney = paymentScheduleMoney;
    }

    public BigDecimal getPaymentMoneyTotal() {
        return paymentMoneyTotal;
    }

    public void setPaymentMoneyTotal(BigDecimal paymentMoneyTotal) {
        this.paymentMoneyTotal = paymentMoneyTotal;
    }

    public BigDecimal getPaymentCopeWithRatio() {
        return paymentCopeWithRatio;
    }

    public void setPaymentCopeWithRatio(BigDecimal paymentCopeWithRatio) {
        this.paymentCopeWithRatio = paymentCopeWithRatio;
    }

    public BigDecimal getDebtAdvanceMoney() {
        return debtAdvanceMoney;
    }

    public void setDebtAdvanceMoney(BigDecimal debtAdvanceMoney) {
        this.debtAdvanceMoney = debtAdvanceMoney;
    }

    public BigDecimal getDebtScheduleMoney() {
        return debtScheduleMoney;
    }

    public void setDebtScheduleMoney(BigDecimal debtScheduleMoney) {
        this.debtScheduleMoney = debtScheduleMoney;
    }

    public BigDecimal getDebtMoneyTotal() {
        return debtMoneyTotal;
    }

    public void setDebtMoneyTotal(BigDecimal debtMoneyTotal) {
        this.debtMoneyTotal = debtMoneyTotal;
    }
}
