package com.ejianc.business.bedget.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.bedget.bean.*;
import com.ejianc.business.bedget.service.*;
import com.ejianc.business.bedget.vo.ContrastanalysisVO;
import com.ejianc.business.bedget.vo.ContrastanalysisdetailVO;
import com.ejianc.business.record.bean.RecordContrastanalysistEntity;
import com.ejianc.business.record.service.IRecordContrastanalysistService;
import com.ejianc.business.record.vo.RecordContrastanalysistVO;
import com.ejianc.business.utils.DateUtils;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.utils.TreeNodeBUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.units.qual.A;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 对比分析表
 *
 * @author generator
 */
@Controller
@RequestMapping("contrastanalysis")
public class ContrastanalysisController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "budgetmanager-contrastanalysis";//此处需要根据实际修改

    @Autowired
    private IContrastanalysisService service;
    @Autowired
    private IQuotasummaryService quotasummaryService;
    @Autowired
    private IContrastanalysisdetailsService contrastanalysisdetailsService;
    @Autowired
    private IDesignestimateService designestimateService;
    @Autowired
    private IConsdrawbudgettotalService consdrawbudgettotalService;
    @Autowired
    private IQuotasummarydetailService quotasummarydetailService;
    @Autowired
    private IDesignestimatedetailService designestimatedetailService;
    @Autowired
    private IConsdrawbudgettotaldetailService consdrawbudgettotaldetailService;
    @Autowired
    private IRecordContrastanalysistService recordContrastanalysistService;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IEstimatesummaryService estimatesummaryService;
    @Autowired
    private IEstimatesummarydetailService estimatesummarydetailService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ContrastanalysisVO> saveOrUpdate(@RequestBody ContrastanalysisVO saveorUpdateVO) {
        //1.校验（一个项目只能有一个对比分析表）
        //创建条件构造器
        QueryWrapper<ContrastanalysisEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("project_id", saveorUpdateVO.getProjectId());
        queryWrapper.eq("dr", "0");
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() != 0) {
            queryWrapper.ne("id", saveorUpdateVO.getId());
        }
        List<ContrastanalysisEntity> pro = service.list(queryWrapper);
        if (pro != null && pro.size() > 0) {
            throw new BusinessException("一个项目只能有一个对比分析表");
        }

        ContrastanalysisEntity entity = BeanMapper.map(saveorUpdateVO, ContrastanalysisEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setChangeState("1");//未变更
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        service.saveOrUpdate(entity, false);
        ContrastanalysisVO vo = BeanMapper.map(entity, ContrastanalysisVO.class);
        vo.setContrastanalysisdetailEntities(createTreeData(vo.getContrastanalysisdetailEntities()));
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ContrastanalysisVO> queryDetail(Long id) {
        ContrastanalysisEntity entity = service.selectById(id);
        ContrastanalysisVO vo = BeanMapper.map(entity, ContrastanalysisVO.class);

        vo.setContrastanalysisdetailEntities(createTreeData(vo.getContrastanalysisdetailEntities()));

        //当前单据变更过则显示变更记录
        if (!"1".equals(vo.getChangeState())) {
            QueryWrapper<RecordContrastanalysistEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("dr", 0);
            queryWrapper.eq("contrastanalysis_id", vo.getId());
            List<RecordContrastanalysistEntity> records = recordContrastanalysistService.list(queryWrapper);
            if (records != null && records.size() > 0) {
                vo.setRecordContrastanalysistList(BeanMapper.mapList(records, RecordContrastanalysistVO.class));
            }
        }
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ContrastanalysisVO> vos) {
        service.removeByIds(vos.stream().map(ContrastanalysisVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ContrastanalysisVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("bill_code");
        fuzzyFields.add("project_name");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<ContrastanalysisEntity> page = service.queryPage(param, false);
        IPage<ContrastanalysisVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ContrastanalysisVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("bill_code");
        fuzzyFields.add("project_name");
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        List<ContrastanalysisEntity> list = service.queryList(param);
        //todo:字段翻译等等
        List<ContrastanalysisVO> contrastanalysisVOList = BeanMapper.mapList(list, ContrastanalysisVO.class);
        for (int i = 0; i < contrastanalysisVOList.size(); i++) {
            ContrastanalysisVO contrastanalysisVO = contrastanalysisVOList.get(i);
            contrastanalysisVO.setSort(Long.parseLong(String.valueOf(i + 1)));
            if (contrastanalysisVO.getCreateTime() != null) {
                contrastanalysisVO.setCreateTimeShow(DateUtils.dateSimple2(contrastanalysisVO.getCreateTime()));
            }
            String billStateStr = contrastanalysisVO.getBillState().toString();
            String changeState = contrastanalysisVO.getChangeState();
            if (billStateStr != null) {
                if ("0".equals(billStateStr)) {//自由态
                    billStateStr = "自由态";
                } else if ("1".equals(billStateStr)) {//已提交
                    billStateStr = "已提交";
                } else if ("2".equals(billStateStr) || "5".equals(billStateStr)) {//审批中
                    billStateStr = "审批中";
                } else if ("3".equals(billStateStr)) {//审批通过
                    billStateStr = "审批通过";
                } else if ("4".equals(billStateStr)) {//驳回
                    billStateStr = "驳回";
                }

                contrastanalysisVO.setBillStateStr(billStateStr);
            }

            if (changeState != null) {
                if ("1".equals(changeState)) {//1:未变更
                    changeState = "未变更";
                } else if ("2".equals(changeState)) {//2:变更中
                    changeState = "变更中";
                } else if ("3".equals(changeState)) {//3:已变更
                    changeState = "已变更";
                }

                contrastanalysisVO.setChangeState(changeState);
            }
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", contrastanalysisVOList);
        ExcelExport.getInstance().export("Contrastanalysis-export.xlsx", beans, response);
    }

    /**
     * @param
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refContrastanalysisData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ContrastanalysisVO>> refContrastanalysisData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                             String condition,
                                                                             String searchObject,
                                                                             String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ContrastanalysisEntity> page = service.queryPage(param, false);
        IPage<ContrastanalysisVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ContrastanalysisVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * @param projectId
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetailList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ContrastanalysisVO> queryDetailList(Long id, Long projectId) {
        //校验项目唯一性
        QueryWrapper<ContrastanalysisEntity> queryWrapperProject = new QueryWrapper<>();
        queryWrapperProject.eq("project_id", projectId);
        queryWrapperProject.eq("dr", 0);
        if(id != null && id != 0){
            queryWrapperProject.ne("id", id);
        }
        List<ContrastanalysisEntity> entityList = service.list(queryWrapperProject);
        if(entityList != null && entityList.size() > 0){
            throw new BusinessException("该项目已经创建一个对比分析表，不允许重复创建！");
        }
        List<EstimatesummaryEntity> estimatesummaryEntities = estimatesummaryService.list(new QueryWrapper<EstimatesummaryEntity>().eq("project_id", projectId).in("bill_state", 1,3));
        if (!CollectionUtils.isNotEmpty(estimatesummaryEntities)) {
            throw new BusinessException("请先填写设计概算汇总！");
        }
        List<Long> ids = estimatesummaryEntities.stream().map(EstimatesummaryEntity::getId).collect(Collectors.toList());
        List<EstimatesummarydetailEntity> estimatesummarydetailEntities = estimatesummarydetailService.list(new QueryWrapper<EstimatesummarydetailEntity>().in("mid", ids));
        ContrastanalysisVO contrastanalysisVO = new ContrastanalysisVO();
        List<ContrastanalysisdetailVO> contrastanalysisdetailVO = new ArrayList<>();
        for (EstimatesummarydetailEntity entity : estimatesummarydetailEntities) {
            ContrastanalysisdetailVO vo = new ContrastanalysisdetailVO();
            vo.setId(entity.getId());
            vo.setSort(entity.getSort());
            vo.setCode(entity.getInventoryCode());
            vo.setName(entity.getEngineeringName());
            vo.setTid(entity.getTid());
            vo.setTpid(entity.getTpid());
            contrastanalysisdetailVO.add(vo);
        }
        contrastanalysisVO.setContrastanalysisdetailEntities(createTreeData(contrastanalysisdetailVO));
        return CommonResponse.success("查询参照数据成功！", contrastanalysisVO);
    }

    public static List<ContrastanalysisdetailVO> createTreeData(List<ContrastanalysisdetailVO> list) {
        List<ContrastanalysisdetailVO> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();

        //循环list，放入listMap重
        Map<String, ContrastanalysisdetailVO> listMap = new HashMap<>();
        for (ContrastanalysisdetailVO item : list) {
            listMap.put(item.getTid().toString(), item);
        }

        for (int i = 0; i < list.size(); i++) {
            ContrastanalysisdetailVO item = list.get(i);
            String parentId = (item.getTpid() != null) ? item.getTpid().toString() : "";
            ContrastanalysisdetailVO parent = listMap.get(parentId);
            if (parent != null) {
                List<ContrastanalysisdetailVO> child = (List<ContrastanalysisdetailVO>) parent.getChildren();
                if (child != null) {
                    child.add(item);
                } else {
                    List<ContrastanalysisdetailVO> children = new ArrayList<ContrastanalysisdetailVO>();
                    children.add(item);
                    parent.setChildren(children);
                }
            } else {
                rootItems.add(item.getTid());
            }
        }

        for (String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }
}
