package com.ejianc.business.bedget.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.bedget.bean.DesignestimateEntity;
import com.ejianc.business.bedget.service.IDesignestimateService;
import com.ejianc.business.bedget.vo.DesignestimateVO;
import com.ejianc.business.bedget.vo.DesignestimatedetailVO;
import com.ejianc.business.record.bean.RecorddesignestimateEntity;
import com.ejianc.business.record.service.IRecorddesignestimateService;
import com.ejianc.business.record.vo.RecorddesignestimateVO;
import com.ejianc.business.utils.DateUtils;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.util.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 设计概算
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("designestimate")
public class DesignestimateController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private SessionManager sessionManager;

    private static final String BILL_CODE = "budgetmanage-designestimate";//此处需要根据实际修改

    @Autowired
    private IDesignestimateService service;


    @Autowired
    private IRecorddesignestimateService  recorddesignestimateService;
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<DesignestimateVO> saveOrUpdate(@RequestBody DesignestimateVO saveorUpdateVO) {
    	DesignestimateEntity entity = BeanMapper.map(saveorUpdateVO, DesignestimateEntity.class);

        QueryWrapper<DesignestimateEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("project_id", entity.getProjectId());
        queryWrapper.eq("dr", "0");
        if(saveorUpdateVO.getId() != null && saveorUpdateVO.getId() != 0){
            queryWrapper.ne("id", saveorUpdateVO.getId());
        }
        List<DesignestimateEntity> pro = service.list(queryWrapper);
        if(pro.size() > 0){
            throw new BusinessException("该项目已经创建一个设计概算，不允许重复创建!");
        }

    	if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setChangeState("1");//未变更
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	DesignestimateVO vo = BeanMapper.map(entity, DesignestimateVO.class);

        //构建树形结构
        List<DesignestimatedetailVO> designestimatedetailVOList = vo.getDesignestimatedetailEntities();
        List<DesignestimatedetailVO> resDesignestimatedetailVOList = createTreeData(designestimatedetailVOList);
        vo.setDesignestimatedetailEntities(resDesignestimatedetailVOList);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询该项目是否已有限额设计指标分析单据
     * @param id
     * @param projectId
     */
    @RequestMapping(value = "/queryProject", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> queryProject(Long id, Long projectId) {
        QueryWrapper<DesignestimateEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("dr", 0);
        queryWrapper.eq("project_id", projectId);
        if(id != null && id != 0){
            queryWrapper.ne("id", id);
        }
        List<DesignestimateEntity> entityList = service.list(queryWrapper);

        if(entityList != null && entityList.size() > 0){
            return CommonResponse.success("该项目已经创建一个设计概算，请选择其他项目!", "0");
        }

        return CommonResponse.success("查询成功！", "1");
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<DesignestimateVO> queryDetail(Long id) {
    	DesignestimateEntity entity = service.selectById(id);
    	DesignestimateVO vo = BeanMapper.map(entity, DesignestimateVO.class);

        //构建树形结构
        List<DesignestimatedetailVO> designestimatedetailVOList = vo.getDesignestimatedetailEntities();
        //按子目编码排序
        Collections.sort(designestimatedetailVOList, new Comparator<DesignestimatedetailVO>() {
            @Override
            public int compare(DesignestimatedetailVO o1, DesignestimatedetailVO o2) {
                return o1.getSonItemCode().compareTo(o2.getSonItemCode());
            }
        });
        List<DesignestimatedetailVO> resDesignestimatedetailVOList = createTreeData(designestimatedetailVOList);
        vo.setDesignestimatedetailEntities(resDesignestimatedetailVOList);
        
        //当前单据变更过则显示变更记录
        if(!"1".equals(vo.getChangeState())){
            QueryWrapper<RecorddesignestimateEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("dr", 0);
            queryWrapper.eq("designestimate_id", vo.getId());
            List<RecorddesignestimateEntity> records = recorddesignestimateService.list(queryWrapper);
            if(records!=null&&records.size()>0){
                vo.setRecorddesignestimateList(BeanMapper.mapList(records, RecorddesignestimateVO.class));
            }
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<DesignestimateVO> vos) {
        service.removeByIds(vos.stream().map(DesignestimateVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<DesignestimateVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("bill_code");
        fuzzyFields.add("project_name");
        /** 租户隔离 */
        //param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        IPage<DesignestimateEntity> page = service.queryPage(param,false);
        IPage<DesignestimateVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), DesignestimateVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }



    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("bill_code");
        fuzzyFields.add("project_name");

        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        List<DesignestimateEntity> list = service.queryList(param);
        //todo:字段翻译等等
        List<DesignestimateVO> designestimateVOList = BeanMapper.mapList(list, DesignestimateVO.class);
        for (int i = 0; i < designestimateVOList.size(); i++) {
            DesignestimateVO designestimateVO = designestimateVOList.get(i);
            designestimateVO.setSort(Long.parseLong(String.valueOf(i+1)));
            if (designestimateVO.getCreateTime()!=null){
                designestimateVO.setCreateTimeShow(DateUtils.dateSimple2(designestimateVO.getCreateTime()));
            }
            String billStateStr = designestimateVO.getBillState().toString();
            String changeState = designestimateVO.getChangeState();
            if (billStateStr != null){
                if("0".equals(billStateStr)){//自由态
                    billStateStr = "自由态";
                }else if("1".equals(billStateStr)){//已提交
                    billStateStr = "已提交";
                }else if("2".equals(billStateStr) || "5".equals(billStateStr)){//审批中
                    billStateStr = "审批中";
                }else if("3".equals(billStateStr)){//审批通过
                    billStateStr = "审批通过";
                }else if("4".equals(billStateStr)){//驳回
                    billStateStr = "驳回";
                }

                designestimateVO.setBillStateStr(billStateStr);
            }

            if (changeState != null){
                if("1".equals(changeState)){//1:未变更
                    changeState = "未变更";
                }else if("2".equals(changeState)){//2:变更中
                    changeState = "变更中";
                }else if("3".equals(changeState)){//3:已变更
                    changeState = "已变更";
                }

                designestimateVO.setChangeState(changeState);
            }
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", designestimateVOList);
        ExcelExport.getInstance().export("Designestimate-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refDesignestimateData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<DesignestimateVO>> refDesignestimateData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        //param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<DesignestimateEntity> page = service.queryPage(param,false);
        IPage<DesignestimateVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), DesignestimateVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    public static List<DesignestimatedetailVO> createTreeData(List<DesignestimatedetailVO> list) {
        List<DesignestimatedetailVO> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();

        //循环list，放入listMap重
        Map<String, DesignestimatedetailVO> listMap = new HashMap<>();
        for(DesignestimatedetailVO item:list) {
            listMap.put(item.getTid().toString(), item);
        }

        for(int i =0; i<list.size(); i++) {
            DesignestimatedetailVO item = list.get(i);
            String parentId = (item.getTpid() != null) ? item.getTpid().toString():"";
            DesignestimatedetailVO parent = listMap.get(parentId);
            if(parent != null) {
                List<DesignestimatedetailVO> child = (List<DesignestimatedetailVO>) parent.getChildren();
                if(child != null) {
                    child.add(item);
                }else{
                    List<DesignestimatedetailVO> children = new ArrayList<DesignestimatedetailVO>();
                    children.add(item);
                    parent.setChildren(children);
                }
            } else {
                rootItems.add(item.getTid());
            }
        }

        for(String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }

    @RequestMapping(value = "/refreshData", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> refreshData(@RequestBody List<DesignestimatedetailVO> list, HttpServletResponse response) {
        JSONObject json = new JSONObject();
        Map<String,DesignestimatedetailVO> map = new HashMap<>();
        DesignestimatedetailVO add = list.get(list.size() - 1);
        add.setId(IdWorker.getId());
        add.setTid(String.valueOf(IdWorker.getId()));
        add.setRowState("edit");
        add.setInnercode(add.getSonItemCode());
//        if("01".equals(add.getSonItemCode())&&add.getSonItemName().contains("装饰")){
//            add.setInnercode("a1");
//        }
        //判断是否是装饰工程的子节点编码
//        if(add.getSonItemCode().length()>=4){
//            //0111、0112、0113、0114、0115这五个节点都是装饰工程下的
//            String code = add.getSonItemCode().substring(0,4);
//            if("0111".equals(code)||"0112".equals(code)||"0113".equals(code)||"0114".equals(code)||"0115".equals(code)){
////	    		若是的话，将内码改为a1xx
//                add.setInnercode("a1"+add.getSonItemCode().substring(2,add.getSonItemCode().length()));
//            }
//        }
        for(DesignestimatedetailVO vo : list){
            map.put(vo.getInnercode(), vo);
            if(!add.getId().equals(vo.getId()) && add.getInnercode().equals(vo.getInnercode())){
                throw new BusinessException("子目编码已存在，请重新填写");
            }
        }
        //设置父级id
        for(DesignestimatedetailVO vo : list){
            String innercode = vo.getInnercode();
            Long pid = null;
            if(innercode.length()==2){
                //最上级
            }else if(innercode.length()==4){
                String pcode = innercode.substring(0, 2);
                //有父节点
                pid = this.setPid(pcode, map);

            }else if(innercode.length()==6){
                String pcode = innercode.substring(0, 4);
                //有父节点
                pid = this.setPid(pcode, map);
            }
//            else if(innercode.length()>6){
//                String pcode = innercode.substring(0, 6);
//                //有父节点
//                pid = this.setPid(pcode, map);
//            }

            if(pid != null){
                vo.setTpid(pid.toString());
            }else {
                vo.setTpid("");
            }
        }

        //清空父级部分数据
        list = clearPData(add, list);

        //按子目编码排序
        Collections.sort(list, new Comparator<DesignestimatedetailVO>() {
            @Override
            public int compare(DesignestimatedetailVO o1, DesignestimatedetailVO o2) {
                return o1.getSonItemCode().compareTo(o2.getSonItemCode());
            }
        });
        //构建树
        List<DesignestimatedetailVO> result = createTreeData(list);

        json.put("dataSource", result);
        return CommonResponse.success(json);
    }

    private List<DesignestimatedetailVO> clearPData(DesignestimatedetailVO handleVO, List<DesignestimatedetailVO> list) {
        if(list == null || list.size() == 0){
            return null;
        }

        String pid = handleVO.getTpid();
        if(pid == null || TextUtils.isEmpty(pid)){
            return list;
        }

        for (int i = 0; i < list.size(); i++) {
            DesignestimatedetailVO vo = list.get(i);
            if(pid.equals(vo.getTid())){
                //清空父级不汇总字段
                vo.setCostPercent(null);
                vo.setProjectScale(null);
                vo.setUnitCost(null);

                if(vo.getTpid() != null && !TextUtils.isEmpty(vo.getTpid())){
                    clearPData(vo, list);
                    break;
                }
            }
        }

        return list;
    }

    //子目编码规则定死------分别是2位/4位/6位/6为以上
    private Long setPid(String pcode,Map<String,DesignestimatedetailVO> map){
        if(map.get(pcode)!=null){
            return Long.valueOf(map.get(pcode).getTid());
        }else{
            //父级没有找到，则继续往上找
            if(pcode.length()==2){
                //最上级
                return null;
            }else if(pcode.length()==4){
                String ppcode = pcode.substring(0, 2);
                return this.setPid(ppcode, map);
            }else if(pcode.length()==6){
                String ppcode = pcode.substring(0, 4);
                return this.setPid(ppcode, map);
            }else if(pcode.length()>6){
                String ppcode = pcode.substring(0, 6);
                return this.setPid(ppcode, map);
            }else{
                return null;
            }
        }
    }
}
