package com.ejianc.business.bedget.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.bedget.bean.DrawEntity;
import com.ejianc.business.bedget.service.IDrawService;
import com.ejianc.business.bedget.vo.DrawVO;
import com.ejianc.business.enums.ChangeStateEnum;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 施工图预算书
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("draw")
public class DrawController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IDrawService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<DrawVO> saveOrUpdate(@RequestBody DrawVO saveOrUpdateVO) {
    	DrawVO vo = service.saveOrUpdate(saveOrUpdateVO);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<DrawVO> queryDetail(Long id) {
        return CommonResponse.success("查询详情数据成功！", service.queryDetail(id, true));
    }

    /**
     * @Description queryReviseDetail 查询修订详情
     * @param id
     */
    @RequestMapping(value = "/queryReviseDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<DrawVO> queryReviseDetail(Long id) {
        DrawVO changeVO = service.queryReviseDetail(id);
        return CommonResponse.success("查询详情数据成功！", changeVO);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<DrawVO> vos) {
        for(DrawVO drawVO : vos){
            DrawEntity drawEntity = service.getById(drawVO.getId());
            if (drawEntity.getLastDrawId() != null) {
                DrawEntity revise = service.getById(drawEntity.getLastDrawId());
                revise.setChangeId(null);
                revise.setChangeState(ChangeStateEnum.未变更.getCode());
                revise.setLatestFlag(true);
                service.saveOrUpdate(revise);
            }
        }
        service.removeByIds(vos.stream().map(DrawVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<DrawVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        //* 数据隔离 本下 没有组织orgId的删除下面代码-------------开始
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
                param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
            } else {
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                        InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
        }

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */

        /*  1>【是否生效】为是的 + 第一版本没审批通过的（审批中的+自由态）单据；
            2> 如果生效的目标成本当前存在修订中的单据（未审批通过的），在操作列显示变更按钮跳转到对应单据。（【是否最新版本】=否  【是否生效】=是）
            3>【是否最新版本】=是  【是否生效】=是 时，操作列显示 修订 按钮，点击跳转到单据修订页面*/
        //复合条件
        ComplexParam resultComplexParam = new ComplexParam();
        resultComplexParam.setLogic("and");

        //生效
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        c1.getParams().put("enableState", new Parameter(QueryParam.EQ, true));//生效

        ComplexParam complex2 = new ComplexParam();
        complex2.setLogic("or");
        //不生效
        ComplexParam c2 = new ComplexParam();
        c2.setLogic("and");
        c2.getParams().put("bill_state", new Parameter(QueryParam.NOT_IN, "1,3"));//非已提交和已通过
        complex2.getComplexParams().add(c2);
        ComplexParam c3 = new ComplexParam();
        c3.setLogic("and");
        c3.getParams().put("enableState", new Parameter(QueryParam.EQ, false));//不生效
        complex2.getComplexParams().add(c3);
        ComplexParam c5 = new ComplexParam();
        c5.setLogic("and");
        c5.getParams().put("drawVersion", new Parameter(QueryParam.EQ, "1"));//第一版本
        complex2.getComplexParams().add(c5);

        resultComplexParam.getComplexParams().add(c1);
        resultComplexParam.getComplexParams().add(complex2);
        param.getComplexParams().add(resultComplexParam);
        param.getOrderMap().put("org_status_order", QueryParam.ASC);
        param.getOrderMap().put("project_create_time", QueryParam.ASC);

        IPage<DrawEntity> page = service.queryPage(param,false);
        IPage<DrawVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), DrawVO.class));
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        param.setPageIndex(1);
        param.setPageSize(-1);
        CommonResponse<IPage<DrawVO>> iPageCommonResponse = queryList(param);
        List<DrawVO> list = iPageCommonResponse.getData().getRecords();
        list.forEach(val ->{
            switch (val.getBillState()){
                case 0: val.setBillStateName("自由态");break;
                case 1: val.setBillStateName("已提交");break;
                case 2: val.setBillStateName("审批中");break;
                case 3: val.setBillStateName("审批通过");break;
                case 4: val.setBillStateName("审批驳回");break;
                case 5: val.setBillStateName("审批中");break;
            }
            switch (val.getChangeState()){
                case 0: val.setChangeStateName("未变更");break;
                case 1: val.setChangeStateName("变更中");break;
                case 2: val.setChangeStateName("已变更");break;
            }
        });
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("draw-Export.xlsx", beans, response);
    }

    /**
     * 导入模板下载(清单模式)
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadInfo")
    @ResponseBody
    public void downloadInfo(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "draw-sub-import.xlsx", "分部分项导入模板");
    }

    /**
     * 导入模板下载(清单模式)
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadPrice")
    @ResponseBody
    public void downloadPrice(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "draw-price-import.xlsx", "单价措施项导入模板");
    }

    /**
     * 导入模板下载(清单模式)
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadTotal")
    @ResponseBody
    public void downloadTotal(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "draw-total-import.xlsx", "总价措施项导入模板");
    }

    /**
     * 导入模板下载(清单模式)
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadOth")
    @ResponseBody
    public void downloadOth(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "draw-other-import.xlsx", "其他项导入模板");
    }

    /**
     * 导入模板下载(清单模式)
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadFee")
    @ResponseBody
    public void downloadFee(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "draw-fee-import.xlsx", "费税清单导入模板");
    }

    /**
     * excel导入(清单模式)
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImportInfo", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImportInfo(HttpServletRequest request, HttpServletResponse response) {
        return service.excelImportInfo(request,response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refDrawData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<DrawVO>> refDrawData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<DrawEntity> page = service.queryPage(param,false);
        IPage<DrawVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), DrawVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
