package com.ejianc.business.bedget.controller;

import java.io.Serializable;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.bedget.bean.PaymentDetailEntity;
import com.ejianc.business.bedget.service.IPaymentDetailService;
import com.ejianc.business.bedget.vo.PaymentDetailVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.bedget.bean.PaymentEntity;
import com.ejianc.business.bedget.service.IPaymentService;
import com.ejianc.business.bedget.vo.PaymentVO;

/**
 * 付款登记
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("payment")
public class PaymentController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "FKDJ";//此处需要根据实际修改

    @Autowired
    private IPaymentService service;

    @Autowired
    private IPaymentDetailService paymentDetailService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PaymentVO> saveOrUpdate(@RequestBody PaymentVO saveOrUpdateVO) {
    	PaymentEntity entity = BeanMapper.map(saveOrUpdateVO, PaymentEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        LambdaQueryWrapper<PaymentEntity> queryWrapper = new LambdaQueryWrapper<PaymentEntity>();
        queryWrapper.eq(PaymentEntity::getProjectId,entity.getProjectId());
        queryWrapper.ne(PaymentEntity::getBillState, 1);
        queryWrapper.ne(PaymentEntity::getBillState, 3);
        if (entity.getId()!=null){
            queryWrapper.ne(PaymentEntity::getId, entity.getId());
        }
        List<PaymentEntity> paymentEntities = service.list(queryWrapper);
        if(CollectionUtils.isNotEmpty(paymentEntities)) {
            throw new BusinessException("该项目有未审批通过单据，不允许做下一期！");
        }

        LambdaQueryWrapper<PaymentEntity> queryWrapper2 = new LambdaQueryWrapper<PaymentEntity>();
        queryWrapper2.eq(PaymentEntity::getProjectId,entity.getProjectId());
        queryWrapper2.gt(PaymentEntity::getRegisterDate,entity.getRegisterDate());
        if (entity.getId()!=null){
            queryWrapper.ne(PaymentEntity::getId, entity.getId());
        }
        List<PaymentEntity> paymentEntityList = service.list(queryWrapper2);
        if(CollectionUtils.isNotEmpty(paymentEntityList)) {
            throw new BusinessException("已有上期，不允许做往期数据！");
        }

    	service.saveOrUpdate(entity, false);
    	PaymentVO vo = BeanMapper.map(entity, PaymentVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PaymentVO> queryDetail(Long id) {
    	PaymentEntity entity = service.selectById(id);
    	PaymentVO vo = BeanMapper.map(entity, PaymentVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description queryDetail 查询表体
     * @param projectId
     */
    @RequestMapping(value = "/queryDetailList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PaymentVO> queryDetailList(Long projectId) {
        PaymentVO paymentVOS = service.queryDetailList(projectId);
        return CommonResponse.success("获取数据成功！",paymentVOS);
    }

    @RequestMapping(value = "/storematerialList", method = RequestMethod.POST)
    @ResponseBody
    public  CommonResponse<IPage<PaymentDetailVO>> storematerialList(@RequestBody QueryParam params) {

        if (params.getParams().get("paymentId") == null || params.getParams().get("paymentId").getValue() == null) {
            throw new BusinessException("主键id不能为空");
        }
        Long paymentId = Long.parseLong(params.getParams().get("paymentId").getValue().toString());
        String searchText = null;
        if (params.getParams().get("searchText") != null  && params.getParams().get("searchText").getValue() != null) {
            searchText = params.getParams().get("searchText").getValue().toString();
        }
        List<PaymentDetailVO> paymentDetailVOList = service.queryDetailListParams(paymentId,searchText);
        IPage<PaymentDetailVO> page = new Page<>();
        page = new Page<>(page.getCurrent(), params.getPageSize(),paymentDetailVOList.size());
        page.setRecords(paymentDetailVOList);
        return CommonResponse.success("查询列表数据成功！",page);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PaymentVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (PaymentVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(PaymentVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PaymentVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<PaymentEntity> page = service.queryPage(param,false);
        IPage<PaymentVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), PaymentVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        List<PaymentEntity> list = service.queryList(param);
        for(PaymentEntity paymentEntity : list){
            String billStateStr = paymentEntity.getBillState().toString();
            if (billStateStr != null){
                if("0".equals(billStateStr)){//自由态
                    billStateStr = "自由态";
                }else if("1".equals(billStateStr)){//已提交
                    billStateStr = "已提交";
                }else if("2".equals(billStateStr) || "5".equals(billStateStr)){//审批中
                    billStateStr = "审批中";
                }else if("3".equals(billStateStr)){//审批通过
                    billStateStr = "审批通过";
                }else if("4".equals(billStateStr)){//驳回
                    billStateStr = "驳回";
                }
                paymentEntity.setBillStateName(billStateStr);
            }
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Payment-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refPaymentData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<PaymentVO>> refPaymentData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<PaymentEntity> page = service.queryPage(param,false);
        IPage<PaymentVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PaymentVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * excel导出数据库数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportDetailDatabase", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportMaterialWarehousingFromDatabase(@RequestBody PaymentVO paymentVO, HttpServletResponse response) {
        QueryWrapper<PaymentDetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("payment_id", paymentVO.getId());
        queryWrapper.eq("dr", 0);
        List<PaymentDetailEntity> list = paymentDetailService.list(queryWrapper);
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("DetailDatabase-export.xlsx", beans, response);
    }


    /**
     * excel导出页面数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportDetailPage", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportMaterialWarehousingFromPage(@RequestBody List<PaymentDetailVO> paymentDetailVOList, HttpServletResponse response) {
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", paymentDetailVOList);
        ExcelExport.getInstance().export("DetailDatabase-export.xlsx", beans, response);
    }

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadModel")
    @ResponseBody
    public void downloadModel(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "paymentdetail-import.xlsx", "付款明细模板");
    }

    /**
     * 付款明细导入接口
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/detailImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> detailImport(HttpServletRequest request, HttpServletResponse response,Long projectId,String pcList) throws ParseException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        List<PaymentDetailVO> list = JSON.parseArray(pcList, PaymentDetailVO.class);
        Object o = service.detailImport(request,response,projectId,list);
        return CommonResponse.success(o);
    }

}
