package com.ejianc.business.bedget.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.bedget.bean.ConsdrawbudgetEntity;
import com.ejianc.business.bedget.bean.ConsdrawbudgetdetailEntity;
import com.ejianc.business.bedget.bean.SubpackageEntity;
import com.ejianc.business.bedget.bean.SubpackagedetailEntity;
import com.ejianc.business.bedget.service.IConsdrawbudgetService;
import com.ejianc.business.bedget.service.IConsdrawbudgetdetailService;
import com.ejianc.business.bedget.service.ISubpackageService;
import com.ejianc.business.bedget.service.ISubpackagedetailService;
import com.ejianc.business.bedget.vo.SubpackageVO;
import com.ejianc.business.bedget.vo.SubpackagedetailVO;
import com.ejianc.business.record.bean.RecordsubpackageEntity;
import com.ejianc.business.record.service.IRecordsubpackageService;
import com.ejianc.business.record.vo.RecordsubpackageVO;
import com.ejianc.business.utils.DateUtils;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 分包施工图预算
 *
 * @author generator
 */
@Controller
@RequestMapping("subpackage")
public class SubpackageController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private SessionManager sessionManager;

    private static final String BILL_CODE = "budgetmanager-subpackage";//此处需要根据实际修改

    @Autowired
    private ISubpackageService service;
    @Autowired
    private IRecordsubpackageService recordsubpackageService;
    @Autowired
    private ISubpackagedetailService subpackagedetailService;

    @Autowired
    private IConsdrawbudgetService consdrawbudgetService;
    @Autowired
    private IConsdrawbudgetdetailService consdrawbudgetdetailService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SubpackageVO> saveOrUpdate(@RequestBody SubpackageVO saveorUpdateVO) {

        SubpackageEntity entity = BeanMapper.map(saveorUpdateVO, SubpackageEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setChangeState("1");//未变更
                //entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }




        //查已提交的 除去自身单据的其他同一项目下的单据
        QueryWrapper<SubpackageEntity> masterWrapper = new QueryWrapper<>();
        masterWrapper.eq("dr", 0);
        masterWrapper.in("bill_state", 1, 3);
        masterWrapper.eq("project_id", entity.getProjectId());
        if (entity.getId() != null && entity.getId() != 0) {
            masterWrapper.ne("id", entity.getId());
        }
        List<SubpackageEntity> otherEntityList = service.list(masterWrapper);


        QueryWrapper<ConsdrawbudgetEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("dr", 0);
        wrapper.eq("project_id", entity.getProjectId());
        wrapper.in("bill_state", 1, 3);
        List<ConsdrawbudgetEntity> control = consdrawbudgetService.list(wrapper);

        //查询施工图预算的是否开启控制   分包施工图预算和施工图预算的控制状态保持一致
        if(CollectionUtil.isEmpty(control)){
            entity.setIsEnable(Long.valueOf(0));
        }else{
            entity.setIsEnable(Long.valueOf(control.get(0).getIsOpenControl()));
        }
        //开启控制
        if (control.get(0).getIsOpenControl() == 1) {
            //其他单据子表的工程量汇总


            //遍历页面拿到的子表
            for (SubpackagedetailEntity entitySubpackagedetailEntity : entity.getSubpackagedetailEntities()) {

                //页面单据子表的删除状态
                String rowState = entitySubpackagedetailEntity.getRowState();
                if (rowState != null && rowState.equals("del")) {
                    continue;
                }

                String masterSection = entitySubpackagedetailEntity.getSection();
                String masterSubtitleCode = entitySubpackagedetailEntity.getSubtitleCode();
                String masterSubtitleName = entitySubpackagedetailEntity.getSubtitleName();

                //施工图预算子表工程量
                //查询是否开启控制 施工图预算
                BigDecimal drawCount = new BigDecimal(0);
                for (ConsdrawbudgetEntity consdrawbudget : control) {
                    QueryWrapper<ConsdrawbudgetdetailEntity> drawDetailWrapper = new QueryWrapper<>();
                    drawDetailWrapper.eq("section",masterSection);
                    drawDetailWrapper.eq("subitem_code",masterSubtitleCode);
                    drawDetailWrapper.eq("subitem_name",masterSubtitleName);
                    drawDetailWrapper.eq("dr",0);
                    drawDetailWrapper.eq("mid",consdrawbudget.getId());
                    List<ConsdrawbudgetdetailEntity> drawDetailList = consdrawbudgetdetailService.list(drawDetailWrapper);
                    for (ConsdrawbudgetdetailEntity consdrawbudgetdetail : drawDetailList) {
                        if(consdrawbudgetdetail.getEngineeQuatity()!=null){
                            drawCount =   drawCount.add(consdrawbudgetdetail.getEngineeQuatity());
                        }
                    }
                }

                entitySubpackagedetailEntity.setSubpackageBudgetTotal(drawCount);
                BigDecimal otherChildCount = new BigDecimal(0);
                //其他单据主表集合
                for (SubpackageEntity subpackageEntity : otherEntityList) {
                    QueryWrapper<SubpackagedetailEntity> otherWrapper = new QueryWrapper<>();
                    otherWrapper.eq("section",masterSection);
                    otherWrapper.eq("subtitle_code",masterSubtitleCode);
                    otherWrapper.eq("subtitle_name",masterSubtitleName);
                    otherWrapper.eq("dr",0);
                    otherWrapper.eq("mid",subpackageEntity.getId());
                    List<SubpackagedetailEntity> otherDetailList = subpackagedetailService.list(otherWrapper);
                    for (SubpackagedetailEntity subpackagedetail : otherDetailList) {
                        //其他单据的累计工程量
                        if(subpackagedetail.getSubpackageQuantities()!=null){
                            otherChildCount = otherChildCount.add(subpackagedetail.getSubpackageQuantities());
                        }
                    }
                }

                //本次单据输入的工程量
                BigDecimal masterCount = entitySubpackagedetailEntity.getSubpackageQuantities();

                if(masterCount!= null && drawCount.subtract(otherChildCount).subtract(masterCount).compareTo(BigDecimal.ZERO)==-1){
                    throw new BusinessException("" + masterSection + "," + masterSubtitleCode + "," + masterSubtitleName + "行,本次输入的工程量为" +
                            masterCount + "已超过'分包施工图预算量合计（施工图预算工程量）'");
                }
            }
            }
        entity.setChangeState("1");
        for (SubpackagedetailEntity subpackagedetailEntity : entity.getSubpackagedetailEntities()) {
            logger.info(subpackagedetailEntity.getTpid());
            if (entity.getId() == null && subpackagedetailEntity.getTpid() == "") {
                // 施工图预算合价（除税）
                entity.setConDrawBudgetExcludingTax(ComputeUtil.safeAdd(entity.getConDrawBudgetExcludingTax(), subpackagedetailEntity.getArtificialTotal(),
                        subpackagedetailEntity.getMaterialsTotal(), subpackagedetailEntity.getMechanicalTotal(),
                        subpackagedetailEntity.getEnterpriseManageTotal(), subpackagedetailEntity.getProfitsTotal(),
                        subpackagedetailEntity.getFeesTotal()));
                // 施工图预算合价（含税）
                entity.setConDrawBudgetIncludingTax(ComputeUtil.safeAdd(entity.getConDrawBudgetIncludingTax(), subpackagedetailEntity.getArtificialTotal(),
                        subpackagedetailEntity.getMaterialsTotal(), subpackagedetailEntity.getMechanicalTotal(),
                        subpackagedetailEntity.getEnterpriseManageTotal(), subpackagedetailEntity.getProfitsTotal(),
                        subpackagedetailEntity.getFeesTotal(), subpackagedetailEntity.getTaxTotal()));
            }
        }
        service.saveOrUpdate(entity, false);

        SubpackageVO vo = BeanMapper.map(entity, SubpackageVO.class);
        vo.setSubpackagedetailEntities(createTreeData(vo.getSubpackagedetailEntities()));
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SubpackageVO> queryDetail(Long id) {
        SubpackageEntity entity = service.selectById(id);
        SubpackageVO vo = BeanMapper.map(entity, SubpackageVO.class);

        //当前单据变更过则显示变更记录
        if (!"1".equals(vo.getChangeState())) {
            QueryWrapper<RecordsubpackageEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("dr", 0);
            queryWrapper.eq("original_id", vo.getId());
            List<RecordsubpackageEntity> records = recordsubpackageService.list(queryWrapper);
            if (records != null && records.size() > 0) {
                vo.setRecordsubpackageList(BeanMapper.mapList(records, RecordsubpackageVO.class));
            }
        }
        vo.setSubpackagedetailEntities(createTreeData(vo.getSubpackagedetailEntities()));
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SubpackageVO> vos) {
        service.removeByIds(vos.stream().map(SubpackageVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SubpackageVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("bill_code");
        fuzzyFields.add("project_name");
        fuzzyFields.add("subcontract_unit_name");
        /** 租户隔离 */
        //param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
/** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        IPage<SubpackageEntity> page = service.queryPage(param, false);
        IPage<SubpackageVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SubpackageVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }




    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }



    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("bill_code");
        fuzzyFields.add("project_name");
        fuzzyFields.add("subcontract_unit_name");
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        List<SubpackageEntity> list = service.queryList(param);
        //todo:字段翻译等等
        List<SubpackageVO> subpackageVOList = BeanMapper.mapList(list, SubpackageVO.class);
        for (int i = 0; i < subpackageVOList.size(); i++) {
            SubpackageVO subpackageVO = subpackageVOList.get(i);
            subpackageVO.setSort(String.valueOf(i + 1));
            if (subpackageVO.getCreateTime() != null) {
                subpackageVO.setCreateTimeShow(DateUtils.dateSimple2(subpackageVO.getCreateTime()));
            }

            String billStateStr = subpackageVO.getBillState().toString();
            String changeState = subpackageVO.getChangeState();
            if (billStateStr != null) {
                if ("0".equals(billStateStr)) {//自由态
                    billStateStr = "自由态";
                } else if ("1".equals(billStateStr)) {//已提交
                    billStateStr = "已提交";
                } else if ("2".equals(billStateStr) || "5".equals(billStateStr)) {//审批中
                    billStateStr = "审批中";
                } else if ("3".equals(billStateStr)) {//审批通过
                    billStateStr = "审批通过";
                } else if ("4".equals(billStateStr)) {//驳回
                    billStateStr = "驳回";
                }

                subpackageVO.setBillStateStr(billStateStr);
            }

            if (changeState != null) {
                if ("1".equals(changeState)) {//1:未变更
                    changeState = "未变更";
                } else if ("2".equals(changeState)) {//2:变更中
                    changeState = "变更中";
                } else if ("3".equals(changeState)) {//3:已变更
                    changeState = "已变更";
                }

                subpackageVO.setChangeState(changeState);
            }
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", subpackageVOList);
        ExcelExport.getInstance().export("Subpackage-export.xlsx", beans, response);
    }

    /**
     * @param id
     * @param projectId
     * @Description queryDetail 查询该项目是否已有限额设计指标分析单据
     */
    @RequestMapping(value = "/queryProject", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ConsdrawbudgetEntity> queryProject(Long projectId, Long id) {

        QueryWrapper<ConsdrawbudgetEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("dr", 0);
        wrapper.in("bill_state", 1, 3);
        wrapper.eq("project_id", projectId);
        ConsdrawbudgetEntity consdrawbudget = consdrawbudgetService.getOne(wrapper);
        if (consdrawbudget == null) {
            throw new BusinessException("该项目不存在施工图预算");
        } else {
            QueryWrapper<SubpackageEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("dr", 0);
            queryWrapper.eq("project_id", projectId);
            queryWrapper.eq("bill_state", 0);
            if (id != null && id != 0) {
                queryWrapper.ne("id", id);
            }
            List<SubpackageEntity> entityList = service.list(queryWrapper);
            if (entityList != null && entityList.size() > 0) {
                throw new BusinessException("该项目下已存在自由态的单据，请重新选择");
            }
        }
        return CommonResponse.success(consdrawbudget);
    }


    @RequestMapping(value = "/volidateProject", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ConsdrawbudgetEntity> volidateProject(Long projectId, Long contract, Long id) {
        QueryWrapper<SubpackageEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("dr", 0);
        queryWrapper.eq("project_id", projectId);
        if(id != null && id != 0){
            queryWrapper.ne("id", id);
        }
        List<SubpackageEntity> entity = service.list(queryWrapper);
        for (SubpackageEntity e : entity) {
            if (e.getContract().equals(contract)) {
                throw new BusinessException("该项目下已存在所选合同的单据，请重新选择");
            }
        }
        queryWrapper.eq("bill_state", 0);
        List<SubpackageEntity> entityList = service.list(queryWrapper);
        if (id != null) {
            if (entityList.size() > 1 && CollectionUtil.isNotEmpty(entityList)) {
                throw new BusinessException("该项目下已存在自由态的单据，请重新选择");
            }
        } else {
            if (CollectionUtil.isNotEmpty(entityList)) {
                throw new BusinessException("该项目下已存在自由态的单据，请重新选择");
            }
        }

        return CommonResponse.success();
    }

    /**
     * @param
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refSubpackageData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SubpackageVO>> refSubpackageData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                 String condition,
                                                                 String searchObject,
                                                                 String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        //param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<SubpackageEntity> page = service.queryPage(param, false);
        IPage<SubpackageVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SubpackageVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    public static List<SubpackagedetailVO> createTreeData(List<SubpackagedetailVO> list) {
        List<SubpackagedetailVO> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();

        //循环list，放入listMap重
        Map<String, SubpackagedetailVO> listMap = new HashMap<>();
        for (SubpackagedetailVO item : list) {
            listMap.put(item.getTid().toString(), item);
        }

        for (int i = 0; i < list.size(); i++) {
            SubpackagedetailVO item = list.get(i);
            String parentId = (item.getTpid() != null) ? item.getTpid().toString() : "";
            SubpackagedetailVO parent = listMap.get(parentId);
            if (parent != null) {
                List<SubpackagedetailVO> child = (List<SubpackagedetailVO>) parent.getChildren();
                if (child != null) {
                    child.add(item);
                } else {
                    List<SubpackagedetailVO> children = new ArrayList<SubpackagedetailVO>();
                    children.add(item);
                    parent.setChildren(children);
                }
            } else {
                rootItems.add(item.getTid());
            }
        }

        for (String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }
}
