package com.ejianc.business.bedget.controller.api;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bedget.bean.ConsdrawbudgetEntity;
import com.ejianc.business.bedget.bean.ConsdrawbudgetdetailEntity;
import com.ejianc.business.bedget.service.IConsdrawbudgetService;
import com.ejianc.business.bedget.service.IConsdrawbudgetdetailService;
import com.ejianc.foundation.budgetmanage.vo.ConsdrawbudgetVO;
import com.ejianc.foundation.budgetmanage.vo.ConsdrawbudgetdetailVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;
import java.util.List;

/**
 * 施工图预算
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("api/consdrawbudget")
public class ConsdrawbudgetApiController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IConsdrawbudgetService service;
    @Autowired
    private IConsdrawbudgetdetailService detailService;

    /**
     * @Description 根据合同id查询详情
     * @param
     * @Return void
     */
    @RequestMapping(value = "/queryByProjectId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ConsdrawbudgetVO> queryByProjectId(@RequestParam(value = "projectId") Long projectId) {
        QueryWrapper<ConsdrawbudgetEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("project_id", projectId);
        queryWrapper.in("bill_state", 1, 3);
        queryWrapper.eq("dr", 0);
        List<ConsdrawbudgetEntity> list = service.list(queryWrapper);
        ConsdrawbudgetVO result = new ConsdrawbudgetVO();
        if(list != null && list.size() > 0){
            result = BeanMapper.map(list.get(0), ConsdrawbudgetVO.class);

            //查询单据子表
            QueryWrapper<ConsdrawbudgetdetailEntity> queryWrapperDetailList = new QueryWrapper<>();
            queryWrapperDetailList.eq("mid", result.getId());
            queryWrapperDetailList.eq("dr", "0");
            List<ConsdrawbudgetdetailEntity> detailList = detailService.list(queryWrapperDetailList);

            List<ConsdrawbudgetdetailVO> resDetailList = BeanMapper.mapList(detailList, ConsdrawbudgetdetailVO.class);
            result.setConsdrawbudgetdetailEntities(resDetailList);
        }
        return CommonResponse.success("查询数据成功！",result);
    }
}
