package com.ejianc.business.bedget.excel;

import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bedget.bean.ConsdrawbudgetEntity;
import com.ejianc.business.bedget.bean.ConsdrawbudgetdetailEntity;
import com.ejianc.business.bedget.bean.ConsdrawbudgettotaldetailEntity;
import com.ejianc.business.bedget.controller.ConsdrawbudgettotalController;
import com.ejianc.business.bedget.service.IConsdrawbudgetService;
import com.ejianc.business.bedget.service.IConsdrawbudgetdetailService;
import com.ejianc.business.bedget.service.IConsdrawbudgettotaldetailService;
import com.ejianc.business.bedget.vo.*;
import com.ejianc.business.change.vo.ChangeconsdrawbudgettotalVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.util.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 施工图预算汇总清单导入导出
 */
@Controller
@RequestMapping("consdrawtotalExport")
public class ExeclConsdrawbudgettotalController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IConsdrawbudgettotaldetailService consdrawbudgettotaldetailService;

    @Autowired
    private IConsdrawbudgetService consdrawbudgetService;
    @Autowired
    private IConsdrawbudgetdetailService consdrawbudgetdetailService;

    /**
     * 导入模板下载
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadConsdrawtotal")
    @ResponseBody
    public void downloadConsdrawtotal(HttpServletRequest request, HttpServletResponse response){
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "consdrawbudgettotaldetail-import.xlsx", "施工图预算汇总清单模板");
    }

    /**
     * excel导入
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelImportConsdrawtotal", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportConsdrawtotal(HttpServletRequest request, HttpServletResponse response, String projectId) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<ConsdrawbudgettotaldetailVO> successList = new ArrayList<>();
        List<ConsdrawbudgettotaldetailVO> errorList = new ArrayList<>();
        Map<String, ConsdrawbudgettotaldetailVO> map = new HashMap<>();
        DateFormat sdf=new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if(isFailed) {
            return CommonResponse.error("文件格式不合法");
        }else{
            List<List<String>> result = ExcelReader.readExcel(mf);
            if(result != null && result.size() > 0) {
                //抓取施工图预算数据
                List<ConsdrawbudgettotaldetailVO> grabVos = getGrabDetails(projectId);
                List<ConsdrawbudgettotaldetailVO> concatList = new ArrayList<>();
                if (grabVos != null && grabVos.size() > 0) {
                    for (int i = 0; i < grabVos.size(); i++) {
                        ConsdrawbudgettotaldetailVO consdrawbudgetdetailVO = grabVos.get(i);
                        concatList.add(consdrawbudgetdetailVO);
                    }
                }
                grabVos = handleList(grabVos, concatList);//拍平
                Map<String, ConsdrawbudgettotaldetailVO> grabMap = new HashMap<>();

                for (int i = 0; i < grabVos.size(); i++) {
                    ConsdrawbudgettotaldetailVO grabVo = grabVos.get(i);
                    String subitemCode = grabVo.getSubitemCode();
                    String section = grabVo.getSection();
                    String projectUnitName = grabVo.getProjectUnitName();
                    String key = subitemCode + section + projectUnitName;
                    grabMap.put(key, grabVo);
                }

                //读取excel
                for(int i=2;i<result.size();i++) {
                    List<String> datas = result.get(i);
                    StringBuilder errorsMsgBuilder = new StringBuilder();

                    String subitemCode = datas.get(0);
                    String section = datas.get(1);
                    String projectUnitName = datas.get(2);
                    String projectCost = datas.get(3);
                    String unitLaborCost = datas.get(4);
                    String unitMaterialCost = datas.get(5);
                    String unitMachineryCost = datas.get(6);
                    String unitBusinessManagerCost = datas.get(7);
                    String unitProfit = datas.get(8);
                    String itemsSubTotal = datas.get(9);
                    String garbageConsumption = datas.get(10);
                    String unilateralMeasuresCost = datas.get(11);
                    String otherItems = datas.get(12);
                    String fees = datas.get(13);
                    String tax = datas.get(14);
                    String costPercent = datas.get(15);
                    String projectScale = datas.get(16);
                    String unitCost = datas.get(17);

                    ConsdrawbudgettotaldetailVO consdrawbudgettotaldetailVO = new ConsdrawbudgettotaldetailVO();
                    consdrawbudgettotaldetailVO.setId(IdWorker.getId());//id
                    consdrawbudgettotaldetailVO.setTid(String.valueOf(IdWorker.getId()));//tid

                    //必填项校验
                    if (subitemCode == null || TextUtils.isEmpty(subitemCode)) {
                        consdrawbudgettotaldetailVO.setErrorMsg("编码不能为空！");
                        errorsMsgBuilder.append("编码不能为空！");
                    }

                    if (section == null || TextUtils.isEmpty(section)) {
                        consdrawbudgettotaldetailVO.setErrorMsg("区段不能为空！");
                        errorsMsgBuilder.append("区段不能为空！");
                    }else {
                        consdrawbudgettotaldetailVO.setSection(section);
                    }

                    if (projectUnitName == null || TextUtils.isEmpty(projectUnitName)) {
                        consdrawbudgettotaldetailVO.setErrorMsg("单位工程名称不能为空！");
                        errorsMsgBuilder.append("单位工程名称不能为空！");
                    }else {
                        consdrawbudgettotaldetailVO.setProjectUnitName(projectUnitName);
                    }
                    if (garbageConsumption == null || TextUtils.isEmpty(garbageConsumption)) {
                        consdrawbudgettotaldetailVO.setErrorMsg("其中：施工垃圾场外晕和消纳费不能为空！");
                        errorsMsgBuilder.append("其中：施工垃圾场外晕和消纳费不能为空！");
                    }
                    if (unilateralMeasuresCost == null || TextUtils.isEmpty(unilateralMeasuresCost)) {
                        consdrawbudgettotaldetailVO.setErrorMsg("单方措施项目合计不能为空！");
                        errorsMsgBuilder.append("单方措施项目合计不能为空！");
                    }
                    if (otherItems == null || TextUtils.isEmpty(otherItems)) {
                        consdrawbudgettotaldetailVO.setErrorMsg("其他项目不能为空！");
                        errorsMsgBuilder.append("其他项目不能为空！");
                    }
                    if (projectScale == null || TextUtils.isEmpty(projectScale)) {
                        consdrawbudgettotaldetailVO.setErrorMsg("工程规模（m²或m）不能为空！");
                        errorsMsgBuilder.append("工程规模（m²或m）不能为空！");
                    }

                    //格式校验
//                    if(!TextUtils.isEmpty(projectCost) && !NumberUtil.isNumber(projectCost)){
//                        consdrawbudgettotaldetailVO.setErrorMsg("项目造价格式不正确！");
//                        errorsMsgBuilder.append("项目造价格式不正确！");
//                    }else {
//                        consdrawbudgettotaldetailVO.setProjectCost(StringUtils.isNotBlank(projectCost) ? new BigDecimal(projectCost) : null);
//                    }
//
//                    if(!TextUtils.isEmpty(unitLaborCost) && !NumberUtil.isNumber(unitLaborCost)){
//                        consdrawbudgettotaldetailVO.setErrorMsg("人工费格式不正确！");
//                        errorsMsgBuilder.append("人工费格式不正确！");
//                    }else {
//                        consdrawbudgettotaldetailVO.setUnitLaborCost(StringUtils.isNotBlank(unitLaborCost) ? new BigDecimal(unitLaborCost) : null); // 人工费(单价)
//                    }
//
//                    if(!TextUtils.isEmpty(unitMaterialCost) && !NumberUtil.isNumber(unitMaterialCost)){
//                        consdrawbudgettotaldetailVO.setErrorMsg("材料费格式不正确！");
//                        errorsMsgBuilder.append("材料费格式不正确！");
//                    }else {
//                        consdrawbudgettotaldetailVO.setUnitMaterialCost(StringUtils.isNotBlank(unitMaterialCost) ? new BigDecimal(unitMaterialCost) : null); // 材料费(单价)
//                    }

//                    if(!TextUtils.isEmpty(unitMachineryCost) && !NumberUtil.isNumber(unitMachineryCost)){
//                        consdrawbudgettotaldetailVO.setErrorMsg("机械费格式不正确！");
//                        errorsMsgBuilder.append("机械费格式不正确！");
//                    }else {
//                        consdrawbudgettotaldetailVO.setUnitMachineryCost(StringUtils.isNotBlank(unitMachineryCost) ? new BigDecimal(unitMachineryCost) : null); // 机械费(单价)
//                    }
//
//                    if(!TextUtils.isEmpty(unitBusinessManagerCost) && !NumberUtil.isNumber(unitBusinessManagerCost)){
//                        consdrawbudgettotaldetailVO.setErrorMsg("企业管理费格式不正确！");
//                        errorsMsgBuilder.append("企业管理费格式不正确！");
//                    }else {
//                        consdrawbudgettotaldetailVO.setUnitBusinessManagerCost(StringUtils.isNotBlank(unitBusinessManagerCost) ? new BigDecimal(unitBusinessManagerCost) : null); // 企业管理费(单价)
//                    }
//
//                    if(!TextUtils.isEmpty(unitProfit) && !NumberUtil.isNumber(unitProfit)){
//                        consdrawbudgettotaldetailVO.setErrorMsg("利润格式不正确！");
//                        errorsMsgBuilder.append("利润格式不正确！");
//                    }else {
//                        consdrawbudgettotaldetailVO.setUnitProfit(StringUtils.isNotBlank(unitProfit) ? new BigDecimal(unitProfit) : null); // 利润(单价)
//                    }
//
//                    if(!TextUtils.isEmpty(itemsSubTotal) && !NumberUtil.isNumber(itemsSubTotal)){
//                        consdrawbudgettotaldetailVO.setErrorMsg("分部分项合计格式不正确！");
//                        errorsMsgBuilder.append("分部分项合计格式不正确！");
//                    }else {
//                        consdrawbudgettotaldetailVO.setItemsSubTotal(StringUtils.isNotBlank(itemsSubTotal) ? new BigDecimal(itemsSubTotal) : null); // 分部分项合计
//                    }

                    if(!TextUtils.isEmpty(garbageConsumption) && !NumberUtil.isNumber(garbageConsumption)){
                        consdrawbudgettotaldetailVO.setErrorMsg("其中：施工垃圾场外晕和消纳费格式不正确！");
                        errorsMsgBuilder.append("其中：施工垃圾场外晕和消纳费格式不正确！");
                    }else {
                        consdrawbudgettotaldetailVO.setGarbageConsumption(StringUtils.isNotBlank(garbageConsumption) ? new BigDecimal(garbageConsumption) : null); //
                    }

                    if(!TextUtils.isEmpty(unilateralMeasuresCost) && !NumberUtil.isNumber(unilateralMeasuresCost)){
                        consdrawbudgettotaldetailVO.setErrorMsg("单方措施项目合计格式不正确！");
                        errorsMsgBuilder.append("单方措施项目合计格式不正确！");
                    }else {
                        consdrawbudgettotaldetailVO.setUnilateralMeasuresCost(StringUtils.isNotBlank(unilateralMeasuresCost) ? new BigDecimal(unilateralMeasuresCost) : null); // 材料费(综合)
                    }

                    if(!TextUtils.isEmpty(otherItems) && !NumberUtil.isNumber(otherItems)){
                        consdrawbudgettotaldetailVO.setErrorMsg("其他项目格式不正确！");
                        errorsMsgBuilder.append("其他项目格式不正确！");
                    }else {
                        consdrawbudgettotaldetailVO.setOtherItems(StringUtils.isNotBlank(otherItems) ? new BigDecimal(otherItems) : null); // 其他项目
                    }

//                    if(!TextUtils.isEmpty(fees) && !NumberUtil.isNumber(fees)){
//                        consdrawbudgettotaldetailVO.setErrorMsg("规费格式不正确！");
//                        errorsMsgBuilder.append("规费格式不正确！");
//                    }else {
//                        consdrawbudgettotaldetailVO.setFees(StringUtils.isNotBlank(fees) ? new BigDecimal(fees) : null); // 规费
//                    }
//
//                    if(!TextUtils.isEmpty(tax) && !NumberUtil.isNumber(tax)){
//                        consdrawbudgettotaldetailVO.setErrorMsg("税金格式不正确！");
//                        errorsMsgBuilder.append("税金格式不正确！");
//                    }else {
//                        consdrawbudgettotaldetailVO.setTax(StringUtils.isNotBlank(tax) ? new BigDecimal(tax) : null); // 税金
//                    }

                    if(!TextUtils.isEmpty(costPercent) && !NumberUtil.isNumber(costPercent)){
                        consdrawbudgettotaldetailVO.setErrorMsg("占造价比例（%）（仅包括分部分项和单价措施）格式不正确！");
                        errorsMsgBuilder.append("占造价比例（%）（仅包括分部分项和单价措施）格式不正确！");
                    }else {
                        consdrawbudgettotaldetailVO.setCostPercent(StringUtils.isNotBlank(costPercent) ? new BigDecimal(costPercent) : null); // 占造价比例（%）（仅包括分部分项和单价措施）
                    }

                    if(!TextUtils.isEmpty(projectScale) && !NumberUtil.isNumber(projectScale)){
                        consdrawbudgettotaldetailVO.setErrorMsg("工程规模格式不正确！");
                        errorsMsgBuilder.append("工程规模格式不正确！");
                    }else {
                        consdrawbudgettotaldetailVO.setProjectScale(StringUtils.isNotBlank(projectScale) ? new BigDecimal(projectScale) : null); //
                    }

                    if(!TextUtils.isEmpty(unitCost) && !NumberUtil.isNumber(costPercent)){
                        consdrawbudgettotaldetailVO.setErrorMsg("单位造价格式不正确！");
                        errorsMsgBuilder.append("单位造价格式不正确！");
                    }else {
                        consdrawbudgettotaldetailVO.setUnitCost(StringUtils.isNotBlank(unitCost) ? new BigDecimal(unitCost) : null); //
                    }

                    if(subitemCode != null){
                        consdrawbudgettotaldetailVO.setInnercode(subitemCode + "_" + section);//编码、区段、确定唯一性
//                        if ("01".equals(subitemCode) && projectUnitName != null && projectUnitName.contains("装饰")) {
//                            consdrawbudgettotaldetailVO.setInnercode("a1" + "_" + consdrawbudgettotaldetailVO.getSection());
//                        }
                        //判断是否是装饰工程的子节点编码
//                        if (subitemCode.length() >= 4) {
//                            //0111、0112、0113、0114、0115这五个节点都是装饰工程下的
//                            String code = subitemCode.substring(0, 4);
//                            if ("0111".equals(code) || "0112".equals(code) || "0113".equals(code) || "0114".equals(code) || "0115".equals(code)) {
//                                //若是的话，将内码改为a1xx
//                                consdrawbudgettotaldetailVO.setInnercode("a1" + subitemCode.substring(2, subitemCode.length()) + "_" + section);
//                            }
//                        }
                        //1、校验编码是否符合规则--2、4、6、9、9以上
                        if (subitemCode == null || !(subitemCode.length() == 2 || subitemCode.length() == 4 || subitemCode.length() == 6 || subitemCode.length() >= 9)) {
                            consdrawbudgettotaldetailVO.setErrorMsg("编码必须符合：2位、4位、6位、9位或9位以上中任意一规则");
                            errorsMsgBuilder.append("编码必须符合：2位、4位、6位、9位或9位以上中任意一规则！");
                        }
                        consdrawbudgettotaldetailVO.setSubitemCode(subitemCode);

                        //校验是否在施工图预算中存在
                        String currentKey = subitemCode + section + projectUnitName;
                        if(grabMap.get(currentKey) == null){
                            consdrawbudgettotaldetailVO.setErrorMsg("子目编码，区段，子目名称，在施工图预算未查询到！");
                            errorsMsgBuilder.append("子目编码，区段，子目名称，在施工图预算未查询到！");
                        }else {
                            ConsdrawbudgettotaldetailVO grabVo = grabMap.get(currentKey);
                            BigDecimal grabProjectCost = grabVo.getProjectCost();//项目造价（公式自动计算，不校验）
                            BigDecimal grabUnitLaborCost = grabVo.getUnitLaborCost();//人工费
                            BigDecimal grabUnitMaterialCost = grabVo.getUnitMaterialCost();//材料费
                            BigDecimal grabUnitMachineryCost = grabVo.getUnitMachineryCost();//机械费
                            BigDecimal grabUnitBusinessManagerCost = grabVo.getUnitBusinessManagerCost();//企业管理费
                            BigDecimal grabUnitProfit = grabVo.getUnitProfit();//利润
                            BigDecimal grabItemsSubTotal = grabVo.getItemsSubTotal();//分部分项合计
                            BigDecimal grabFees = grabVo.getFees();//规费
                            BigDecimal grabTax = grabVo.getTax();//税金

                            //抓取的数据，以系统为准
                            consdrawbudgettotaldetailVO.setUnitLaborCost(grabUnitLaborCost);
                            consdrawbudgettotaldetailVO.setUnitMaterialCost(grabUnitMaterialCost);
                            consdrawbudgettotaldetailVO.setUnitMachineryCost(grabUnitMachineryCost);
                            consdrawbudgettotaldetailVO.setUnitBusinessManagerCost(grabUnitBusinessManagerCost);
                            consdrawbudgettotaldetailVO.setUnitProfit(grabUnitProfit);
                            consdrawbudgettotaldetailVO.setItemsSubTotal(grabItemsSubTotal);
                            consdrawbudgettotaldetailVO.setFees(grabFees);
                            consdrawbudgettotaldetailVO.setTax(grabTax);
                            //对比项目造价
//                            if((grabProjectCost == null && projectCost != null && !TextUtils.isEmpty(projectCost)) ||
//                                    (grabProjectCost != null && (!NumberUtil.isNumber(projectCost) || grabProjectCost.compareTo(new BigDecimal(projectCost)) != 0))){
//                                consdrawbudgettotaldetailVO.setErrorMsg("项目造价与系统带出数据不符！");
//                                errorsMsgBuilder.append("项目造价与系统带出数据不符！");
//                            }
//                            if(grabProjectCost == null) {
//                                if(projectCost != null && !TextUtils.isEmpty(projectCost)){
//
//                                }
//                            }else {
//                                if(!NumberUtil.isNumber(projectCost) || grabProjectCost.compareTo(new BigDecimal(projectCost)) != 0){
//
//                                }
//                            }

                            //对比人工费
//                            if((grabUnitLaborCost == null && unitLaborCost != null && !TextUtils.isEmpty(unitLaborCost)) ||
//                                    (grabUnitLaborCost != null && (!NumberUtil.isNumber(unitLaborCost) || grabUnitLaborCost.compareTo(new BigDecimal(unitLaborCost)) != 0))){
//                                consdrawbudgettotaldetailVO.setErrorMsg("人工费与系统带出数据不符！");
//                                errorsMsgBuilder.append("人工费与系统带出数据不符！");
//                            }
//
//                            //对比材料费
//                            if((grabUnitMaterialCost == null && unitMaterialCost != null && !TextUtils.isEmpty(unitMaterialCost)) ||
//                                    (grabUnitMaterialCost != null && (!NumberUtil.isNumber(unitMaterialCost) || grabUnitMaterialCost.compareTo(new BigDecimal(unitMaterialCost)) != 0))){
//                                consdrawbudgettotaldetailVO.setErrorMsg("材料费与系统带出数据不符！");
//                                errorsMsgBuilder.append("材料费与系统带出数据不符！");
//                            }
//
//                            //对比机械费
//                            if((grabUnitMachineryCost == null && unitMachineryCost != null && !TextUtils.isEmpty(unitMachineryCost)) ||
//                                    (grabUnitMachineryCost != null && (!NumberUtil.isNumber(unitMachineryCost) || grabUnitMachineryCost.compareTo(new BigDecimal(unitMachineryCost)) != 0))){
//                                consdrawbudgettotaldetailVO.setErrorMsg("机械费与系统带出数据不符！");
//                                errorsMsgBuilder.append("机械费与系统带出数据不符！");
//                            }
//
//                            //对比企业管理费
//                            if((grabUnitBusinessManagerCost == null && unitBusinessManagerCost != null && !TextUtils.isEmpty(unitBusinessManagerCost)) ||
//                                    (grabUnitBusinessManagerCost != null && (!NumberUtil.isNumber(unitBusinessManagerCost) || grabUnitBusinessManagerCost.compareTo(new BigDecimal(unitBusinessManagerCost)) != 0))){
//                                consdrawbudgettotaldetailVO.setErrorMsg("企业管理费与系统带出数据不符！");
//                                errorsMsgBuilder.append("企业管理费与系统带出数据不符！");
//                            }
//
//                            //对比利润
//                            if((grabUnitProfit == null && unitProfit != null && !TextUtils.isEmpty(unitProfit)) ||
//                                    (grabUnitProfit != null && (!NumberUtil.isNumber(unitProfit) || grabUnitProfit.compareTo(new BigDecimal(unitProfit)) != 0))){
//                                consdrawbudgettotaldetailVO.setErrorMsg("利润与系统带出数据不符！");
//                                errorsMsgBuilder.append("利润与系统带出数据不符！");
//                            }
//
//                            //对比分部分项合计
//                            if((grabItemsSubTotal == null && itemsSubTotal != null && !TextUtils.isEmpty(itemsSubTotal)) ||
//                                    (grabItemsSubTotal != null && (!NumberUtil.isNumber(itemsSubTotal) || grabItemsSubTotal.compareTo(new BigDecimal(itemsSubTotal)) != 0))){
//                                consdrawbudgettotaldetailVO.setErrorMsg("分部分项合计与系统带出数据不符！");
//                                errorsMsgBuilder.append("分部分项合计与系统带出数据不符！");
//                            }
//
//                            //对比规费
//                            if((grabFees == null && fees != null && !TextUtils.isEmpty(fees)) ||
//                                    (grabFees != null && (!NumberUtil.isNumber(fees) || grabFees.compareTo(new BigDecimal(fees)) != 0))){
//                                consdrawbudgettotaldetailVO.setErrorMsg("规费与系统带出数据不符！");
//                                errorsMsgBuilder.append("规费与系统带出数据不符！");
//                            }
//
//                            //对比税金
//                            if((grabTax == null && tax != null && !TextUtils.isEmpty(tax)) ||
//                                    (grabTax != null && (!NumberUtil.isNumber(tax) || grabTax.compareTo(new BigDecimal(tax)) != 0))){
//                                consdrawbudgettotaldetailVO.setErrorMsg("税金与系统带出数据不符！");
//                                errorsMsgBuilder.append("税金与系统带出数据不符！");
//                            }
                        }

                        //重复性校验（必须在校验是否在施工图预算中存在之后）
                        ConsdrawbudgettotaldetailVO mapVO = map.get(consdrawbudgettotaldetailVO.getInnercode());
                        if(mapVO == null){
                            map.put(consdrawbudgettotaldetailVO.getInnercode(), consdrawbudgettotaldetailVO);
                        }else {
                            consdrawbudgettotaldetailVO.setErrorMsg("编码已存在！");
                            errorsMsgBuilder.append("编码已存在！");
                        }
                        consdrawbudgettotaldetailVO.setSubitemCode(subitemCode);

                        //设置父级id
                        String innercode = consdrawbudgettotaldetailVO.getInnercode();
                        String[] innercodeSubArr = innercode.split("_");
                        String innercodeSub = "";
                        String sectionSuf = "";
                        if (innercodeSubArr.length > 1) {
                            innercodeSub = innercodeSubArr[0];
                            sectionSuf = "_" + innercodeSubArr[1];
                        }

                        Long pid = null;
                        if (innercodeSub.length() == 2) {
                            //最上级
                        } else if (innercodeSub.length() == 4) {
                            String pcode = innercodeSub.substring(0, 2) + sectionSuf;
                            //有父节点
                            pid = this.setPid(pcode, map);
                        } else if (innercodeSub.length() == 6) {
                            String pcode = innercodeSub.substring(0, 4) + sectionSuf;
                            //有父节点
                            pid = this.setPid(pcode, map);
                        } else if (innercodeSub.length() > 6) {
                            String pcode = innercodeSub.substring(0, 6) + sectionSuf;
                            //有父节点
                            pid = this.setPid(pcode, map);
                        }

                        if (pid != null) {
                            consdrawbudgettotaldetailVO.setTpid(pid.toString());
                        } else {
                            consdrawbudgettotaldetailVO.setTpid("");
                        }
                    }

                    if(errorsMsgBuilder.length() > 0){
                        errorList.add(consdrawbudgettotaldetailVO);
                    }else {
                        successList.add(consdrawbudgettotaldetailVO);
                    }
                }
            }
        }

        //构建树
        List<ConsdrawbudgettotaldetailVO> resList = createTreeData(successList);

        //统计父级的合计数值
        getChildrenUnitTotalAmount(resList);
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", resList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());

//        ConsdrawbudgettotalVO resVo = new ConsdrawbudgettotalVO();
//        json.put("total", getTotalAmount(resList, resVo));

        return CommonResponse.success(json);
    }

    private List<ConsdrawbudgettotaldetailVO> getGrabDetails(String projectId) {
        List<ConsdrawbudgettotaldetailVO> detailList = new ArrayList<>();
        //根据项目id查询限施工图预算表id
        QueryWrapper<ConsdrawbudgetEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("project_id", projectId);
        queryWrapper.eq("dr", 0);
        queryWrapper.in("bill_state", 1, 3);//审批通过的
        ConsdrawbudgetEntity entity = consdrawbudgetService.getOne(queryWrapper);
        if (entity == null) {
            throw new BusinessException("您选择的项目没有施工图预算,请选择别的项目!");
        }

        ConsdrawbudgettotalVO consdrawbudgettotalVO = BeanMapper.map(entity, ConsdrawbudgettotalVO.class);
        //根据主表id和tpid为空 查询子表第一层数据
        QueryWrapper<ConsdrawbudgetdetailEntity> queryWrapper1 = new QueryWrapper<>();
        queryWrapper1.eq("mid", entity.getId());
        queryWrapper1.eq("dr", 0);
        queryWrapper1.eq("tpid", "");
        List<ConsdrawbudgetdetailEntity> list = consdrawbudgetdetailService.list(queryWrapper1);
        if (list == null) {
            throw new BusinessException("您选择的项目没有清单,请选择别的项目!");
        }

        for (ConsdrawbudgetdetailEntity consdrawbudgetdetailEntity : list) {
            //循环将第一层数据的值赋值给清单
            ConsdrawbudgettotaldetailVO consdrawbudgettotaldetailVO = new ConsdrawbudgettotaldetailVO();
            consdrawbudgettotaldetailVO.setId(IdWorker.getId());
            consdrawbudgettotaldetailVO.setSubitemCode(consdrawbudgetdetailEntity.getSubitemCode());
            consdrawbudgettotaldetailVO.setSection(consdrawbudgetdetailEntity.getSection());
            consdrawbudgettotaldetailVO.setProjectUnitName(consdrawbudgetdetailEntity.getSubitemName());
            consdrawbudgettotaldetailVO.setUnitLaborCost(consdrawbudgetdetailEntity.getTotalLaborCost());
            consdrawbudgettotaldetailVO.setUnitMaterialCost(consdrawbudgetdetailEntity.getTotalMaterialCost());
            consdrawbudgettotaldetailVO.setUnitMachineryCost(consdrawbudgetdetailEntity.getTotalMachineryCost());
            consdrawbudgettotaldetailVO.setUnitBusinessManagerCost(consdrawbudgetdetailEntity.getTotalBusinessManagerCost());
            consdrawbudgettotaldetailVO.setUnitProfit(consdrawbudgetdetailEntity.getTotalProfit());
            consdrawbudgettotaldetailVO.setItemsSubTotal(consdrawbudgetdetailEntity.getSumTotalPrice());
            BigDecimal fees = new BigDecimal(0);
            BigDecimal socialSecurity = consdrawbudgetdetailEntity.getSocialSecurity();
            BigDecimal housing = consdrawbudgetdetailEntity.getHousing();
            BigDecimal reserved1 = consdrawbudgetdetailEntity.getReserved1();
            BigDecimal reserved2 = consdrawbudgetdetailEntity.getReserved2();
            BigDecimal reserved3 = consdrawbudgetdetailEntity.getReserved3();
            if (socialSecurity != null) {
                fees = fees.add(socialSecurity);
            }
            if (housing != null) {
                fees = fees.add(housing);
            }
            if (reserved1 != null) {
                fees = fees.add(reserved1);
            }
            if (reserved2 != null) {
                fees = fees.add(reserved2);
            }
            if (reserved3 != null) {
                fees = fees.add(reserved3);
            }
            consdrawbudgettotaldetailVO.setFees(fees);
            consdrawbudgettotaldetailVO.setTax(consdrawbudgetdetailEntity.getTax());
            consdrawbudgettotaldetailVO.setTid(consdrawbudgetdetailEntity.getTid());
            consdrawbudgettotaldetailVO.setTpid(consdrawbudgetdetailEntity.getTpid());
            //根据主表id和第一层数据的父id查询第二层数据
            QueryWrapper<ConsdrawbudgetdetailEntity> queryWrapper2 = new QueryWrapper<>();
            queryWrapper2.eq("mid", entity.getId());
            queryWrapper2.eq("dr", 0);
            queryWrapper2.eq("tpid", consdrawbudgetdetailEntity.getTid());
            List<ConsdrawbudgetdetailEntity> list1 = consdrawbudgetdetailService.list(queryWrapper2);
            if (list1 != null) {
                List<ConsdrawbudgettotaldetailVO> consdrawbudgettotaldetailVOs = new ArrayList<>();
                for (ConsdrawbudgetdetailEntity consdrawbudgetdetailEntity1 : list1) {
                    ConsdrawbudgettotaldetailVO consdrawbudgettotaldetailVO1 = new ConsdrawbudgettotaldetailVO();
                    consdrawbudgettotaldetailVO1.setId(IdWorker.getId());
                    consdrawbudgettotaldetailVO1.setSubitemCode(consdrawbudgetdetailEntity1.getSubitemCode());
                    consdrawbudgettotaldetailVO1.setSection(consdrawbudgetdetailEntity1.getSection());
                    consdrawbudgettotaldetailVO1.setProjectUnitName(consdrawbudgetdetailEntity1.getSubitemName());
                    consdrawbudgettotaldetailVO1.setUnitLaborCost(consdrawbudgetdetailEntity1.getTotalLaborCost());
                    consdrawbudgettotaldetailVO1.setUnitMaterialCost(consdrawbudgetdetailEntity1.getTotalMaterialCost());
                    consdrawbudgettotaldetailVO1.setUnitMachineryCost(consdrawbudgetdetailEntity1.getTotalMachineryCost());
                    consdrawbudgettotaldetailVO1.setUnitBusinessManagerCost(consdrawbudgetdetailEntity1.getTotalBusinessManagerCost());
                    consdrawbudgettotaldetailVO1.setUnitProfit(consdrawbudgetdetailEntity1.getTotalProfit());
                    consdrawbudgettotaldetailVO1.setItemsSubTotal(consdrawbudgetdetailEntity1.getSumTotalPrice());
                    BigDecimal fees1 = new BigDecimal(0);
                    BigDecimal socialSecurity1 = consdrawbudgetdetailEntity1.getSocialSecurity();
                    BigDecimal housing1 = consdrawbudgetdetailEntity1.getHousing();
                    BigDecimal reserved11 = consdrawbudgetdetailEntity1.getReserved1();
                    BigDecimal reserved21 = consdrawbudgetdetailEntity1.getReserved2();
                    BigDecimal reserved31 = consdrawbudgetdetailEntity1.getReserved3();
                    if (socialSecurity1 != null) {
                        fees1 = fees1.add(socialSecurity1);
                    }
                    if (housing1 != null) {
                        fees1 = fees1.add(housing1);
                    }
                    if (reserved11 != null) {
                        fees1 = fees1.add(reserved11);
                    }
                    if (reserved21 != null) {
                        fees1 = fees1.add(reserved21);
                    }
                    if (reserved31 != null) {
                        fees1 = fees1.add(reserved31);
                    }
                    consdrawbudgettotaldetailVO1.setFees(fees1);
                    consdrawbudgettotaldetailVO1.setTax(consdrawbudgetdetailEntity1.getTax());
                    consdrawbudgettotaldetailVO1.setTid(consdrawbudgetdetailEntity1.getTid());
                    consdrawbudgettotaldetailVO1.setTpid(consdrawbudgetdetailEntity1.getTpid());
                    consdrawbudgettotaldetailVOs.add(consdrawbudgettotaldetailVO1);
                    //将第二层数据添加到第一层数据下
                    consdrawbudgettotaldetailVO.setChildren(consdrawbudgettotaldetailVOs);
                }
            }
            detailList.add(consdrawbudgettotaldetailVO);
        }

        return detailList;
    }

    //子目编码规则定死------分别是2位/4位/6位/6为以上
    private Long setPid(String pcode, Map<String, ConsdrawbudgettotaldetailVO> map) {
        if (map.get(pcode) != null) {
            return Long.valueOf(map.get(pcode).getTid());
        } else {
            //父级没有找到，则继续往上找
            String[] pcodeSubArr = pcode.split("_");
            String pcodeSub = "";
            String sectionSuf = "";//"_" + 区段
            if (pcodeSubArr.length > 1) {
                pcodeSub = pcodeSubArr[0];
                sectionSuf = "_" + pcodeSubArr[1];
            }
            if (pcodeSub.length() == 2) {
                //最上级
                return null;
            } else if (pcodeSub.length() == 4) {
                String ppcode = pcodeSub.substring(0, 2);
                return this.setPid(ppcode + sectionSuf, map);
            } else if (pcodeSub.length() == 6) {
                String ppcode = pcode.substring(0, 4);
                return this.setPid(ppcode + sectionSuf, map);
            } else if (pcodeSub.length() > 6) {
                String ppcode = pcode.substring(0, 6);
                return this.setPid(ppcode + sectionSuf, map);
            } else {
                return null;
            }
        }
    }

    /**
     * 构建树
     *
     * @param list
     * @return
     */
    public static List<ConsdrawbudgettotaldetailVO> createTreeData(List<ConsdrawbudgettotaldetailVO> list) {
        List<ConsdrawbudgettotaldetailVO> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();

        //循环list，放入listMap重
        Map<String, ConsdrawbudgettotaldetailVO> listMap = new HashMap<>();
        for (ConsdrawbudgettotaldetailVO item : list) {
            listMap.put(item.getTid().toString(), item);
        }

        for (int i = 0; i < list.size(); i++) {
            ConsdrawbudgettotaldetailVO item = list.get(i);
            String parentId = (item.getTpid() != null) ? item.getTpid().toString() : "";
            ConsdrawbudgettotaldetailVO parent = listMap.get(parentId);
            if (parent != null) {
                List<ConsdrawbudgettotaldetailVO> child = (List<ConsdrawbudgettotaldetailVO>) parent.getChildren();
                if (child != null) {
                    child.add(item);
                } else {
                    List<ConsdrawbudgettotaldetailVO> children = new ArrayList<ConsdrawbudgettotaldetailVO>();
                    children.add(item);
                    parent.setChildren(children);
                }
            } else {
                rootItems.add(item.getTid());
            }
        }

        for (String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }

    private ConsdrawbudgettotalVO getTotalAmount(List<ConsdrawbudgettotaldetailVO> vos, ConsdrawbudgettotalVO resVo) {
        BigDecimal costTotal = new BigDecimal(0);
        BigDecimal itemsSubTotal = new BigDecimal(0);
        BigDecimal measureItemsTotal = new BigDecimal(0);
        BigDecimal otherItemsTotal = new BigDecimal(0);
        BigDecimal feesTotal = new BigDecimal(0);
        BigDecimal taxTotal = new BigDecimal(0);

        for (ConsdrawbudgettotaldetailVO vo : vos) {
            if (vo.getProjectCost() != null) {
                costTotal = costTotal.add(vo.getProjectCost());
            }
            if (vo.getItemsSubTotal() != null) {
                itemsSubTotal = itemsSubTotal.add(vo.getItemsSubTotal());
            }
            if (vo.getGarbageConsumption() != null) {
                measureItemsTotal = measureItemsTotal.add(vo.getGarbageConsumption());
            }
            if (vo.getUnilateralMeasuresCost() != null) {
                measureItemsTotal = measureItemsTotal.add(vo.getUnilateralMeasuresCost());
            }
            if (vo.getOtherItems() != null) {
                otherItemsTotal = otherItemsTotal.add(vo.getOtherItems());
            }

            if (vo.getTax() != null) {
                taxTotal = taxTotal.add(vo.getTax());
            }

            //规费合计
            if (vo.getFees() != null) {
                feesTotal = feesTotal.add(vo.getFees());
            }
        }

        resVo.setCostTotal(costTotal);
        resVo.setItemsSubTotal(itemsSubTotal);
        resVo.setMeasureItemsTotal(measureItemsTotal);
        resVo.setOtherItemsTotal(otherItemsTotal);
        resVo.setFeesTotal(feesTotal);
        resVo.setTaxTotal(taxTotal);
        return resVo;
    }


    /**
     * 统计父级的合计数值
     * @param vos
     * @return
     */
    private ConsdrawbudgettotaldetailVO getChildrenUnitTotalAmount(List<ConsdrawbudgettotaldetailVO> vos){
        ConsdrawbudgettotaldetailVO detail = new ConsdrawbudgettotaldetailVO();
        detail.setGarbageConsumption(new BigDecimal(0));
        detail.setUnilateralMeasuresCost(new BigDecimal(0));
        detail.setOtherItems(new BigDecimal(0));
        detail.setProjectScale(new BigDecimal(0));
        BigDecimal garbageConsumption = detail.getGarbageConsumption();//施工垃圾场外运输和消纳费
        BigDecimal unilateralMeasuresCost = detail.getUnilateralMeasuresCost();//单方措施项目合计
        BigDecimal otherItems = detail.getOtherItems();//其他项目
        BigDecimal projectScale = detail.getProjectScale();//工程规模

        for(ConsdrawbudgettotaldetailVO vo: vos){
            if(vo.getChildren()!=null&&vo.getChildren().size()>0){
                //有孩子节点----清空工程量和综合单价--金额字段
                //获取孩子节点的总计数据
                ConsdrawbudgettotaldetailVO childrenUnitTotalAmount = this.getChildrenUnitTotalAmount(vo.getChildren());
                vo.setGarbageConsumption(childrenUnitTotalAmount.getGarbageConsumption());
                vo.setUnilateralMeasuresCost(childrenUnitTotalAmount.getUnilateralMeasuresCost());
                vo.setOtherItems(childrenUnitTotalAmount.getOtherItems());
                vo.setProjectScale(childrenUnitTotalAmount.getProjectScale());

                garbageConsumption = garbageConsumption.add(childrenUnitTotalAmount.getGarbageConsumption());
                unilateralMeasuresCost = unilateralMeasuresCost.add(childrenUnitTotalAmount.getUnilateralMeasuresCost());
                otherItems = otherItems.add(childrenUnitTotalAmount.getOtherItems());
                projectScale = projectScale.add(childrenUnitTotalAmount.getProjectScale());
            }else{
                if(vo.getGarbageConsumption()!=null){
                    garbageConsumption = garbageConsumption.add(vo.getGarbageConsumption());
                }

                if(vo.getUnilateralMeasuresCost()!=null){
                    unilateralMeasuresCost = unilateralMeasuresCost.add(vo.getUnilateralMeasuresCost());
                }

                if(vo.getOtherItems()!=null){
                    otherItems = otherItems.add(vo.getOtherItems());
                }

                if(vo.getProjectScale()!=null){
                    projectScale = projectScale.add(vo.getProjectScale());
                }
            }

            detail.setGarbageConsumption(garbageConsumption);
            detail.setUnilateralMeasuresCost(unilateralMeasuresCost);
            detail.setOtherItems(otherItems);
            detail.setProjectScale(projectScale);
        }
        return detail;
    }

    /**
     * excel导出数据库数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportConsdrawtotalFromDatabase", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportConsdrawtotalFromDatabase(@RequestBody ConsdrawbudgettotalVO consdrawbudgettotalVO, HttpServletResponse response) {
        QueryWrapper<ConsdrawbudgettotaldetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("mid", consdrawbudgettotalVO.getId());
        queryWrapper.eq("dr", 0);
        queryWrapper.orderByAsc("subitem_code");
        queryWrapper.orderByAsc("section");
        List<ConsdrawbudgettotaldetailEntity> list = consdrawbudgettotaldetailService.list(queryWrapper);

        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("consdrawbudgettotaldetail-export.xlsx", beans, response);
    }

    /**
     * excel导出页面数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportConsdrawtotalFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportConsdrawtotalFromPage(@RequestBody List<ConsdrawbudgettotaldetailVO> list, HttpServletResponse response) {
        List<ConsdrawbudgettotaldetailVO> concatList = new ArrayList<>();
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); i++) {
                ConsdrawbudgettotaldetailVO consdrawbudgetdetailVO = list.get(i);
                concatList.add(consdrawbudgetdetailVO);
            }
        }

        //children拍平
        List<ConsdrawbudgettotaldetailVO> allList = handleList(list, concatList);
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", allList);
        ExcelExport.getInstance().export("consdrawbudgettotaldetail-export.xlsx", beans, response);
    }

    /**
     * 导出页面数据处理children
     *
     * @param list
     */
    private List<ConsdrawbudgettotaldetailVO> handleList(List<ConsdrawbudgettotaldetailVO> list, List<ConsdrawbudgettotaldetailVO> concatList) {
        if (list == null || list.size() == 0) {
            return concatList;
        }

        for (int i = 0; i < list.size(); i++) {
            ConsdrawbudgettotaldetailVO consdrawbudgettotaldetailVO = list.get(i);
            List<ConsdrawbudgettotaldetailVO> children = consdrawbudgettotaldetailVO.getChildren();
            if (children != null && children.size() > 0) {
                concatList.addAll(children);
                handleList(children, concatList);
            }
        }

        return concatList;
    }
}
