package com.ejianc.business.bedget.mapper;

import com.ejianc.business.bedget.bean.PaymentEntity;
import com.ejianc.business.bedget.vo.PaymentDetailVO;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Mapper;

import java.util.List;

/**
 * 付款登记
 * 
 * @author generator
 * 
 */
@Mapper
public interface PaymentMapper extends BaseCrudMapper<PaymentEntity> {

    List<PaymentDetailVO> queryOutcontractList(Long projectId);

    //查询所有劳务分包，专业分包是否做过最终结算
    List<PaymentDetailVO> querySettlementBookList(Long projectId,Long contractId);

    //查询所有物资采购结算单
    List<PaymentDetailVO> queryPurchaseSettlementList(Long projectId,Long contractId);

    //查询周转租赁结算
    List<PaymentDetailVO> queryLeaseSettLementList(Long projectId,Long contractId);

    //查询机械设备结算
    List<PaymentDetailVO> queryMachinerySettlementList(Long projectId,Long contractId);

    //查询设计类结算单
    List<PaymentDetailVO> queryDesignSettlementList(Long projectId,Long contractId);

    //查询咨询及其他类合同最终结算单
    List<PaymentDetailVO> queryConsultotherfinalList(Long projectId,Long contractId);

    //查询分包合同，同一个项目合同，中间计量本期合计金额
    List<PaymentDetailVO> querySubcontractingvolume(Long projectId,Long contractId);

    //查询月度物资采购结算单，同一个项目合同，中间计量本期合计金额
    List<PaymentDetailVO> queryPurchasesettlement(Long projectId,Long contractId);

    //查询周转租赁费结算单，同一个项目合同，中间计量本期合计金额
    List<PaymentDetailVO> queryRevolvinglease(Long projectId,Long contractId);

    //查询机械设备租赁单，同一个项目合同，中间计量本期合计金额
    List<PaymentDetailVO> queryMechanicallease(Long projectId,Long contractId);

    //查询设计结算，同一个项目合同，中间计量本期合计金额
    List<PaymentDetailVO> queryDesignsubcontractnode(Long projectId,Long contractId);

    //查询咨询及其他，同一个项目合同，中间计量本期合计金额
    List<PaymentDetailVO> queryConsultother(Long projectId,Long contractId);




    //查询所有劳务分包，专业分包是否做过最终结算金额
    List<PaymentDetailVO> querySettlementBookListAmount(Long projectId,Long contractId);

    //查询所有物资采购结算单金额
    List<PaymentDetailVO> queryPurchaseSettlementListAmount(Long projectId,Long contractId);

    //查询周转租赁结算金额
    List<PaymentDetailVO> queryLeaseSettLementListAmount(Long projectId,Long contractId);

    //查询机械设备结算金额
    List<PaymentDetailVO> queryMachinerySettlementListAmount(Long projectId,Long contractId);

    //查询设计类结算单金额
    List<PaymentDetailVO> queryDesignSettlementListAmount(Long projectId,Long contractId);

    //查询咨询及其他类合同最终结算单金额
    List<PaymentDetailVO> queryConsultotherfinalListAmount(Long projectId,Long contractId);

    //查询上期数据
    List<PaymentDetailVO> queryDetailVOList(Long projectId);

    //模糊查询子表信息
    List<PaymentDetailVO>  queryDetailListParams(Long paymentId,String searchText);

}
