package com.ejianc.business.bedget.service;

import com.ejianc.business.bedget.vo.PaymentDetailVO;
import com.ejianc.business.bedget.vo.PaymentVO;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.bedget.bean.PaymentEntity;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.List;

/**
 * 付款登记
 * 
 * @author generator
 * 
 */
public interface IPaymentService extends IBaseService<PaymentEntity> {
    //查询子表信息
    PaymentVO queryDetailList(Long projectId);

    //查询所有合同
    List<PaymentDetailVO> queryOutcontractList(Long projectId);

    //查询劳务分包，专业分包是否做过最终结算
    String querySettlementBookList(Long projectId,Long contractId);

    //查询所有物资采购结算单
    String queryPurchaseSettlementList(Long projectId,Long contractId);

    //查询周转租赁结算
    String queryLeaseSettLementList(Long projectId,Long contractId);

    //查询机械设备结算
    String queryMachinerySettlementList(Long projectId,Long contractId);

    //查询设计类结算单
    String queryDesignSettlementList(Long projectId,Long contractId);

    //查询咨询及其他类合同最终结算单
    String queryConsultotherfinalList(Long projectId,Long contractId);


    //查询分包合同，同一个项目合同，中间计量本期合计金额
    BigDecimal querySubcontractingvolume(Long projectId, Long contractId);

    //查询月度物资采购结算单，同一个项目合同，中间计量本期合计金额
    BigDecimal queryPurchasesettlement(Long projectId,Long contractId);

    //查询周转租赁费结算单，同一个项目合同，中间计量本期合计金额
    BigDecimal queryRevolvinglease(Long projectId,Long contractId);

    //查询机械设备租赁单，同一个项目合同，中间计量本期合计金额
    BigDecimal queryMechanicallease(Long projectId,Long contractId);

    //查询设计结算，同一个项目合同，中间计量本期合计金额
    BigDecimal queryDesignsubcontractnode(Long projectId,Long contractId);

    //查询咨询及其他，同一个项目合同，中间计量本期合计金额
    BigDecimal queryConsultother(Long projectId,Long contractId);


    //查询劳务分包，专业分包是否做过最终结算金额
    BigDecimal querySettlementBookListAmount(Long projectId,Long contractId);

    //查询所有物资采购结算单金额
    BigDecimal queryPurchaseSettlementListAmount(Long projectId,Long contractId);

    //查询周转租赁结算金额
    BigDecimal queryLeaseSettLementListAmount(Long projectId,Long contractId);

    //查询机械设备结算金额
    BigDecimal queryMachinerySettlementListAmount(Long projectId,Long contractId);

    //查询设计类结算单金额
    BigDecimal queryDesignSettlementListAmount(Long projectId,Long contractId);

    //查询咨询及其他类合同最终结算单金额
    BigDecimal queryConsultotherfinalListAmount(Long projectId,Long contractId);

    //查询上期数据
    List<PaymentDetailVO> queryDetailVOList(Long projectId);

    //模糊查询子表信息
    List<PaymentDetailVO>  queryDetailListParams(Long paymentId,String searchText);

    Object detailImport(HttpServletRequest request, HttpServletResponse response, Long projectId, List<PaymentDetailVO> pcList);
}
