package com.ejianc.business.bedget.service.impl;

import com.ejianc.business.bedget.bean.DrawEntity;
import com.ejianc.business.bedget.service.IDrawService;
import com.ejianc.business.enums.ChangeStateEnum;
import com.ejianc.framework.core.exception.BusinessException;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Date;

@Service("draw")
public class DrawBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;

    @Autowired
    private IDrawService drawService;

	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		updateEnableAndWriteBack(billId, true);
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		DrawEntity drawEntity = drawService.selectById(billId);
		logger.info("state---------------有审批流的撤回前回调-------------------"+state);
		if (drawEntity.getLastDrawId() == null) {
			if (BooleanUtils.isFalse(drawEntity.getLatestFlag()) || (1 != drawEntity.getDrawVersion() && BooleanUtils.isFalse(drawEntity.getEnableState()))) {
				throw new BusinessException("非最新生效版本，不能撤回！");
			}
		}else{
			throw new BusinessException("施工图预算书变更不允许撤回！");
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		updateEnableAndWriteBack(billId, false);
		return CommonResponse.success();
	}

	private void updateEnableAndWriteBack(Long billId, Boolean isPass){
		DrawEntity drawEntity = drawService.getById(billId);
		drawEntity.setEnableState(isPass);
		drawEntity.setEnabledTime(isPass ? new Date() : null);
		drawService.saveOrUpdate(drawEntity);
		//弃审,存在前版本，单据是否生效为是
		if(drawEntity.getLastDrawId()!=null){
			DrawEntity revise = drawService.getById(drawEntity.getLastDrawId());
			revise.setChangeState(isPass ? ChangeStateEnum.已变更.getCode() : ChangeStateEnum.变更中.getCode());
			revise.setEnableState(!isPass);
			drawService.saveOrUpdate(revise);
		}
	}

}
