package com.ejianc.business.bedget.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.bedget.bean.*;
import com.ejianc.business.bedget.mapper.DrawMapper;
import com.ejianc.business.bedget.service.*;
import com.ejianc.business.bedget.vo.*;
import com.ejianc.business.enums.ChangeStateEnum;
import com.ejianc.business.pub.tax.TaxCalculateUtil;
import com.ejianc.business.utils.BudgetSortUtil;
import com.ejianc.business.utils.DetailIndexExcelReader;
import com.ejianc.business.utils.UpSumUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IZjkjProjectApi;
import com.ejianc.foundation.share.utils.TreeNodeBUtil;
import com.ejianc.foundation.share.vo.ProjectVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.*;

/**
 * 施工图预算书
 *
 * @author generator
 *
 */
@Service("drawService")
public class DrawServiceImpl extends BaseServiceImpl<DrawMapper, DrawEntity> implements IDrawService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String BILL_CODE = "budgetmanager-draw";

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IDrawSubService drawSubService;
    @Autowired
    private IDrawFeeService drawFeeService;
    @Autowired
    private IDrawOtherService drawOtherService;
    @Autowired
    private IDrawPriceService drawPriceService;
    @Autowired
    private IDrawTotalService drawTotalService;

    @Autowired
    private IZjkjProjectApi zjkjProjectApi;
    @Autowired
    private IOrgApi iOrgApi;

    @Override
    public DrawVO saveOrUpdate(DrawVO saveorUpdateVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        //补全二级组织信息
        CommonResponse<OrgVO> orgVo = iOrgApi.detailById(saveorUpdateVO.getOrgId());//此处是项目部id 1286211352287834113
        if (orgVo.isSuccess() && null != orgVo.getData()) {
            String innerCode = orgVo.getData().getInnerCode();
            String[] strs = innerCode.split("\\|");
            CommonResponse<OrgVO> orgVos = iOrgApi.detailById(Long.parseLong(strs[1]));
            if (orgVos.isSuccess() && null != orgVos.getData()) {
                //二级组织信息
                saveorUpdateVO.setOrgStatusOrder(orgVos.getData().getSequence() == null ? 1000: orgVos.getData().getSequence());
            }
        }

//获取项目创建时间
        CommonResponse<ProjectVO> projectVOCommonResponse = zjkjProjectApi.queryDetailById(saveorUpdateVO.getProjectId());
        if(!projectVOCommonResponse.isSuccess()){
            throw new BusinessException("获取项目信息失败");
        }
        ProjectVO projectVO = projectVOCommonResponse.getData();
        saveorUpdateVO.setProjectCreateTime(projectVO.getCreateTime());

        DrawEntity entity = BeanMapper.map(saveorUpdateVO, DrawEntity.class);
        //新增默认版本为1(修订的存在版本号)
        if(entity.getDrawVersion()==null){
            entity.setDrawVersion(1);
        }
        if (saveorUpdateVO.getId() == null || saveorUpdateVO.getId() < 0) { //新增
            entity.setLatestFlag(true);//新增时默认最新版本
            entity.setEnableState(false);//新增时默认不生效
            entity.setChangeState(0);
            if (StringUtils.isEmpty(saveorUpdateVO.getBillCode())) {
                BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, tenantId, saveorUpdateVO);
                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                if (billCode.isSuccess()) {
                    entity.setBillCode(billCode.getData());
                } else {
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
            }
            clearDetailId(entity);
        }
        super.saveOrUpdate(entity, false);

        List<DrawSubEntity> subList = entity.getSubList();
        if(CollectionUtils.isNotEmpty(subList)){
            List<DrawSubEntity> list = new ArrayList<>();
            Set<String> codeSet = new HashSet<>();
            Map<String, Long> idMap = new HashMap<>();
            for(DrawSubEntity cdEntity : subList){
                idMap.put(cdEntity.getTid(),cdEntity.getId());
            }
            for(DrawSubEntity cdEntity : subList){
                if(StringUtils.isNotEmpty(cdEntity.getTpid())){
                    cdEntity.setParentId(idMap.get(cdEntity.getTpid()));
                }
                if (!"del".equals(cdEntity.getRowState())) {
                    list.add(cdEntity);
                    if (codeSet.contains(cdEntity.getCode())) {
                        throw  new BusinessException("分部分项清单中[子目编码]重复！");
                    }else{
                        codeSet.add(cdEntity.getCode());
                    }
                }
            }
            drawSubService.saveOrUpdateBatch(list, list.size(), false);
        }

        List<DrawFeeEntity> feeList = entity.getFeeList();
        if(CollectionUtils.isNotEmpty(feeList)){
            List<DrawFeeEntity> list = new ArrayList<>();
            Set<String> codeSet = new HashSet<>();
            Map<String, Long> idMap = new HashMap<>();
            for(DrawFeeEntity cdEntity : feeList){
                idMap.put(cdEntity.getTid(),cdEntity.getId());
            }
            for(DrawFeeEntity cdEntity : feeList){
                if(StringUtils.isNotEmpty(cdEntity.getTpid())){
                    cdEntity.setParentId(idMap.get(cdEntity.getTpid()));
                }
                if (!"del".equals(cdEntity.getRowState())) {
                    list.add(cdEntity);
                    if (codeSet.contains(cdEntity.getCode())) {
                        throw  new BusinessException("规费/税金清单中[编码]重复！");
                    }else{
                        codeSet.add(cdEntity.getCode());
                    }
                }
            }
            drawFeeService.saveOrUpdateBatch(list, list.size(), false);
        }

        List<DrawOtherEntity> otherList = entity.getOtherList();
        if(CollectionUtils.isNotEmpty(otherList)){
            List<DrawOtherEntity> list = new ArrayList<>();
            Set<String> codeSet = new HashSet<>();
            Map<String, Long> idMap = new HashMap<>();
            for(DrawOtherEntity cdEntity : otherList){
                idMap.put(cdEntity.getTid(),cdEntity.getId());
            }
            for(DrawOtherEntity cdEntity : otherList){
                if(StringUtils.isNotEmpty(cdEntity.getTpid())){
                    cdEntity.setParentId(idMap.get(cdEntity.getTpid()));
                }
                if (!"del".equals(cdEntity.getRowState())) {
                    list.add(cdEntity);
                    if (codeSet.contains(cdEntity.getCode())) {
                        throw  new BusinessException("其他项清单中[编码]重复！");
                    }else{
                        codeSet.add(cdEntity.getCode());
                    }
                }
            }
            drawOtherService.saveOrUpdateBatch(list, list.size(), false);
        }

        List<DrawPriceEntity> priceList = entity.getPriceList();
        if(CollectionUtils.isNotEmpty(priceList)){
            List<DrawPriceEntity> list = new ArrayList<>();
            Set<String> codeSet = new HashSet<>();
            Map<String, Long> idMap = new HashMap<>();
            for(DrawPriceEntity cdEntity : priceList){
                idMap.put(cdEntity.getTid(),cdEntity.getId());
            }
            for(DrawPriceEntity cdEntity : priceList){
                if(StringUtils.isNotEmpty(cdEntity.getTpid())){
                    cdEntity.setParentId(idMap.get(cdEntity.getTpid()));
                }
                if (!"del".equals(cdEntity.getRowState())) {
                    list.add(cdEntity);
                    if (codeSet.contains(cdEntity.getCode())) {
                        throw  new BusinessException("单价措施费清单中[子目编码]重复！");
                    }else{
                        codeSet.add(cdEntity.getCode());
                    }
                }
            }
            drawPriceService.saveOrUpdateBatch(list, list.size(), false);
        }

        List<DrawTotalEntity> totalList = entity.getTotalList();
        if(CollectionUtils.isNotEmpty(totalList)){
            List<DrawTotalEntity> list = new ArrayList<>();
            Set<String> codeSet = new HashSet<>();
            Map<String, Long> idMap = new HashMap<>();
            for(DrawTotalEntity cdEntity : totalList){
                idMap.put(cdEntity.getTid(),cdEntity.getId());
            }
            for(DrawTotalEntity cdEntity : totalList){
                if(StringUtils.isNotEmpty(cdEntity.getTpid())){
                    cdEntity.setParentId(idMap.get(cdEntity.getTpid()));
                }
                if (!"del".equals(cdEntity.getRowState())) {
                    list.add(cdEntity);
                    if (codeSet.contains(cdEntity.getCode())) {
                        throw  new BusinessException("总价措施费清单中[子目编码]重复！");
                    }else{
                        codeSet.add(cdEntity.getCode());
                    }
                }
            }
            drawTotalService.saveOrUpdateBatch(list, list.size(), false);
        }

        //变更单保存
        if (entity.getLastDrawId() != null) {
            LambdaUpdateWrapper<DrawEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.eq(DrawEntity::getId, entity.getLastDrawId());
            updateWrapper.set(DrawEntity::getLatestFlag, false);
            updateWrapper.set(DrawEntity::getChangeId, entity.getId());
            updateWrapper.set(DrawEntity::getChangeState, ChangeStateEnum.变更中.getCode());
            update(updateWrapper);
        }

        return queryDetail(entity.getId(), true);
    }

    private void clearDetailId(DrawEntity entity) {
        List<DrawSubEntity> subList = entity.getSubList();
        if(CollectionUtils.isNotEmpty(subList)){
            List<DrawSubEntity> list = new ArrayList<>();
            for(DrawSubEntity cdEntity : subList){
                cdEntity.setId(null);
                if (!"del".equals(cdEntity.getRowState())) {
                    list.add(cdEntity);
                }
            }
            entity.setSubList(list);
        }

        List<DrawFeeEntity> feeList = entity.getFeeList();
        if(CollectionUtils.isNotEmpty(feeList)){
            List<DrawFeeEntity> list = new ArrayList<>();
            for(DrawFeeEntity cdEntity : feeList){
                cdEntity.setId(null);
                if (!"del".equals(cdEntity.getRowState())) {
                    list.add(cdEntity);
                }
            }
            entity.setFeeList(list);
        }

        List<DrawOtherEntity> otherList = entity.getOtherList();
        if(CollectionUtils.isNotEmpty(otherList)){
            List<DrawOtherEntity> list = new ArrayList<>();
            for(DrawOtherEntity cdEntity : otherList){
                cdEntity.setId(null);
                if (!"del".equals(cdEntity.getRowState())) {
                    list.add(cdEntity);
                }
            }
            entity.setOtherList(list);
        }

        List<DrawPriceEntity> priceList = entity.getPriceList();
        if(CollectionUtils.isNotEmpty(priceList)){
            List<DrawPriceEntity> list = new ArrayList<>();
            for(DrawPriceEntity cdEntity : priceList){
                cdEntity.setId(null);
                if (!"del".equals(cdEntity.getRowState())) {
                    list.add(cdEntity);
                }
            }
            entity.setPriceList(list);
        }

        List<DrawTotalEntity> totalList = entity.getTotalList();
        if(CollectionUtils.isNotEmpty(totalList)){
            List<DrawTotalEntity> list = new ArrayList<>();
            for(DrawTotalEntity cdEntity : totalList){
                cdEntity.setId(null);
                if (!"del".equals(cdEntity.getRowState())) {
                    list.add(cdEntity);
                }
            }
            entity.setTotalList(list);
        }
    }

    @Override
    public DrawVO queryDetail(Long id, boolean hasChildren) {
        DrawEntity entity = super.selectById(id);
        DrawVO vo = BeanMapper.map(entity, DrawVO.class);
        List<DrawSubVO> subList = vo.getSubList();
        if(CollectionUtils.isNotEmpty(subList)) {
            for(DrawSubVO cdVO : subList){
                cdVO.setTid(cdVO.getId().toString());
                cdVO.setTpid(cdVO.getParentId() != null && cdVO.getParentId() > 0 ? cdVO.getParentId().toString() : "");
                cdVO.setRowState("edit");
            }
            new BudgetSortUtil<DrawSubVO>().entryListToSort(subList);
            if(hasChildren){
                vo.setSubList(TreeNodeBUtil.buildTree(subList));
            }else{
                vo.setSubList(subList);
            }
        }

        List<DrawFeeVO> feeList = vo.getFeeList();
        if(CollectionUtils.isNotEmpty(feeList)) {
            for(DrawFeeVO cdVO : feeList){
                cdVO.setTid(cdVO.getId().toString());
                cdVO.setTpid(cdVO.getParentId() != null && cdVO.getParentId() > 0 ? cdVO.getParentId().toString() : "");
                cdVO.setRowState("edit");
            }
            new BudgetSortUtil<DrawFeeVO>().entryListToSort(feeList);
            if(hasChildren){
                vo.setFeeList(TreeNodeBUtil.buildTree(feeList));
            }else{
                vo.setFeeList(feeList);
            }
        }

        List<DrawOtherVO> otherList = vo.getOtherList();
        if(CollectionUtils.isNotEmpty(otherList)) {
            for(DrawOtherVO cdVO : otherList){
                cdVO.setTid(cdVO.getId().toString());
                cdVO.setTpid(cdVO.getParentId() != null && cdVO.getParentId() > 0 ? cdVO.getParentId().toString() : "");
                cdVO.setRowState("edit");
            }
            new BudgetSortUtil<DrawOtherVO>().entryListToSort(otherList);
            if(hasChildren){
                vo.setOtherList(TreeNodeBUtil.buildTree(otherList));
            }else{
                vo.setOtherList(otherList);
            }
        }

        List<DrawPriceVO> priceList = vo.getPriceList();
        if(CollectionUtils.isNotEmpty(priceList)) {
            for(DrawPriceVO cdVO : priceList){
                cdVO.setTid(cdVO.getId().toString());
                cdVO.setTpid(cdVO.getParentId() != null && cdVO.getParentId() > 0 ? cdVO.getParentId().toString() : "");
                cdVO.setRowState("edit");
            }
            new BudgetSortUtil<DrawPriceVO>().entryListToSort(priceList);
            if(hasChildren){
                vo.setPriceList(TreeNodeBUtil.buildTree(priceList));
            }else{
                vo.setPriceList(priceList);
            }
        }

        List<DrawTotalVO> totalList = vo.getTotalList();
        if(CollectionUtils.isNotEmpty(totalList)) {
            for(DrawTotalVO cdVO : totalList){
                cdVO.setTid(cdVO.getId().toString());
                cdVO.setTpid(cdVO.getParentId() != null && cdVO.getParentId() > 0 ? cdVO.getParentId().toString() : "");
                cdVO.setRowState("edit");
            }
            new BudgetSortUtil<DrawTotalVO>().entryListToSort(totalList);
            if(hasChildren){
                vo.setTotalList(TreeNodeBUtil.buildTree(totalList));
            }else{
                vo.setTotalList(totalList);
            }
        }

        LambdaQueryWrapper<DrawEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(DrawEntity::getProjectId, entity.getProjectId());
        queryWrapper.eq(DrawEntity::getLatestFlag, false);
        queryWrapper.eq(DrawEntity::getEnableState, false);
        queryWrapper.orderByAsc(DrawEntity::getDrawVersion);
        List<DrawEntity> changeList = list(queryWrapper);
        if (CollectionUtils.isNotEmpty(changeList)) {
            vo.setChangeList(BeanMapper.mapList(changeList, DrawVO.class));
        }
        return vo;
    }

    @Override
    public DrawVO queryReviseDetail(Long id) {
        DrawVO vo = queryDetail(id, false);
        vo.setId(null);
        vo.setBillCode(null);
        vo.setBillState(null);
        vo.setCreateTime(null);
        vo.setCreateUserCode(null);
        vo.setUpdateTime(null);
        vo.setUpdateUserCode(null);
        vo.setDrawVersion(vo.getDrawVersion() + 1);
        vo.setBeforeDrawVersion(vo.getDrawVersion());
        vo.setChangeState(ChangeStateEnum.未变更.getCode());
        vo.setLastDrawId(id);
        vo.setLatestFlag(true);
        vo.setEnableState(false);
        vo.setBeforeBudgetMny(vo.getBudgetMny());
        vo.setBeforeEstimateMny(vo.getEstimateMny());
        vo.setBeforeFeeMny(vo.getFeeMny());
        vo.setBeforeOtherMny(vo.getOtherMny());
        vo.setBeforePriceMeasureMny(vo.getPriceMeasureMny());
        vo.setBeforeSubMny(vo.getSubMny());
        vo.setBeforeTaxesMny(vo.getTaxesMny());
        vo.setBeforeTotalMeasureMny(vo.getTotalMeasureMny());
        vo.setVersion(null);

        List<DrawSubVO> changeDetailList = vo.getSubList();
        if(CollectionUtils.isNotEmpty(changeDetailList)){
            Map<String,Long> idMap=new HashMap<>();
            changeDetailList.forEach(changeDetailVO ->{
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setSourceId(changeDetailVO.getId());
                changeDetailVO.setTid(changeDetailVO.getId().toString());
                changeDetailVO.setTpid(changeDetailVO.getParentId()!= null&&changeDetailVO.getParentId()>0?changeDetailVO.getParentId().toString():"");
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());
                changeDetailVO.setDrawId(null);
                changeDetailVO.setVersion(null);
                idMap.put(changeDetailVO.getTid(),changeDetailVO.getId());
            });
            for(DrawSubVO cdEntity : changeDetailList){
                if(StringUtils.isNotEmpty(cdEntity.getTpid())){
                    cdEntity.setParentId(idMap.get(cdEntity.getTpid()));
                }
            }
            vo.setSubList(TreeNodeBUtil.buildTree(changeDetailList));
        }

        List<DrawPriceVO> priceList = vo.getPriceList();
        if(CollectionUtils.isNotEmpty(priceList)){
            Map<String,Long> idMap=new HashMap<>();
            priceList.forEach(changeDetailVO ->{
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setSourceId(changeDetailVO.getId());
                changeDetailVO.setTid(changeDetailVO.getId().toString());
                changeDetailVO.setTpid(changeDetailVO.getParentId()!= null&&changeDetailVO.getParentId()>0?changeDetailVO.getParentId().toString():"");
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());
                changeDetailVO.setDrawId(null);
                changeDetailVO.setVersion(null);
                idMap.put(changeDetailVO.getTid(),changeDetailVO.getId());
            });
            for(DrawPriceVO cdEntity : priceList){
                if(StringUtils.isNotEmpty(cdEntity.getTpid())){
                    cdEntity.setParentId(idMap.get(cdEntity.getTpid()));
                }
            }
            vo.setPriceList(TreeNodeBUtil.buildTree(priceList));
        }

        List<DrawTotalVO> totalList = vo.getTotalList();
        if(CollectionUtils.isNotEmpty(totalList)){
            Map<String,Long> idMap=new HashMap<>();
            totalList.forEach(changeDetailVO ->{
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setSourceId(changeDetailVO.getId());
                changeDetailVO.setTid(changeDetailVO.getId().toString());
                changeDetailVO.setTpid(changeDetailVO.getParentId()!= null&&changeDetailVO.getParentId()>0?changeDetailVO.getParentId().toString():"");
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());
                changeDetailVO.setDrawId(null);
                changeDetailVO.setVersion(null);
                idMap.put(changeDetailVO.getTid(),changeDetailVO.getId());
            });
            for(DrawTotalVO cdEntity : totalList){
                if(StringUtils.isNotEmpty(cdEntity.getTpid())){
                    cdEntity.setParentId(idMap.get(cdEntity.getTpid()));
                }
            }
            vo.setTotalList(TreeNodeBUtil.buildTree(totalList));
        }

        List<DrawOtherVO> otherList = vo.getOtherList();
        if(CollectionUtils.isNotEmpty(otherList)){
            Map<String,Long> idMap=new HashMap<>();
            otherList.forEach(changeDetailVO ->{
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setSourceId(changeDetailVO.getId());
                changeDetailVO.setTid(changeDetailVO.getId().toString());
                changeDetailVO.setTpid(changeDetailVO.getParentId()!= null&&changeDetailVO.getParentId()>0?changeDetailVO.getParentId().toString():"");
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());
                changeDetailVO.setDrawId(null);
                changeDetailVO.setVersion(null);
                idMap.put(changeDetailVO.getTid(),changeDetailVO.getId());
            });
            for(DrawOtherVO cdEntity : otherList){
                if(StringUtils.isNotEmpty(cdEntity.getTpid())){
                    cdEntity.setParentId(idMap.get(cdEntity.getTpid()));
                }
            }
            vo.setOtherList(TreeNodeBUtil.buildTree(otherList));
        }

        List<DrawFeeVO> feeList = vo.getFeeList();
        if(CollectionUtils.isNotEmpty(feeList)){
            Map<String,Long> idMap=new HashMap<>();
            feeList.forEach(changeDetailVO ->{
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setSourceId(changeDetailVO.getId());
                changeDetailVO.setTid(changeDetailVO.getId().toString());
                changeDetailVO.setTpid(changeDetailVO.getParentId()!= null&&changeDetailVO.getParentId()>0?changeDetailVO.getParentId().toString():"");
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(IdWorker.getId());
                changeDetailVO.setDrawId(null);
                changeDetailVO.setVersion(null);
                idMap.put(changeDetailVO.getTid(),changeDetailVO.getId());
            });
            for(DrawFeeVO cdEntity : feeList){
                if(StringUtils.isNotEmpty(cdEntity.getTpid())){
                    cdEntity.setParentId(idMap.get(cdEntity.getTpid()));
                }
            }
            vo.setFeeList(TreeNodeBUtil.buildTree(feeList));
        }
        return vo;
    }

    @Override
    public CommonResponse<JSONObject> excelImportInfo(HttpServletRequest request, HttpServletResponse response) {
        String importType = request.getParameter("importType");
        switch (importType) {
            case "sub":
                return excelImportSub(request);
            case "price":
                return excelImportPrice(request);
            case "total":
                return excelImportTotal(request);
            case "other":
                return excelImportOther(request);
            case "fee":
                return excelImportFee(request);
                default:
                    return CommonResponse.success();
        }
    }


    private CommonResponse<JSONObject> excelImportFee(HttpServletRequest request) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }

        JSONObject resp = new JSONObject();
        if (isFailed) {
            return CommonResponse.error("文件格式不合法！");
        } else {
            List<List<List<String>>> resList = DetailIndexExcelReader.readExcel(mf);
            List<List<String>> result = resList.get(0);
            if (result.size() > 0 && result.get(0).size() < 8) {
                return CommonResponse.error("[费税项清单]数据不完整，请下载最新模板！");
            }
            List<DrawFeeVO> successList = new ArrayList<>();
            List<ImportErrorVo> errorList = new ArrayList<>();
            if (result != null && result.size() > 0) {
                List<String> detailIndexList = new ArrayList<>();// 树形编码不能重复
                Map<String, Long> parentMap = new HashMap<>();
                List<DrawFeeVO> detailVoList = new ArrayList<>();
                boolean importFlag = true;
                for (int i = 0; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    DrawFeeVO vo = new DrawFeeVO();
                    boolean flag = false;
                    String warnType = "";

                    String indexCode = datas.get(0);
                    String code = datas.get(0);
                    String name = datas.get(1);
                    String feature = datas.get(2);
                    String computerMny = datas.get(3);
                    String taxRate = datas.get(4);
                    String mny = datas.get(5);
                    String type = datas.get(6);
                    String memo = datas.get(7);

                    Long id = IdWorker.getId();
                    vo.setId(id);

                    if (StringUtils.isNotEmpty(indexCode)) {//序号不为空
                        indexCode = indexCode.trim();// 去除导入时树形编码空格
                        vo.setIndexCode(indexCode);
                        parentMap.put(indexCode, id);
                        String[] split = splitDetailIndex(indexCode);
                        if (split.length > 1) {
                            StringBuffer tpid = new StringBuffer();
                            for (int j = 0; j < split.length - 1; j++) {
                                tpid.append(split[j]);
                            }
                            vo.setTpid(tpid.toString());
                        }
                        vo.setDetailIndex(String.valueOf(split.length));
                        if (detailIndexList.contains(indexCode)) {
                            warnType = warnType + "[编码重复]";
                            flag = true;
                        } else {
                            detailIndexList.add(indexCode);
                        }
                        if (split.length == 4) {
                            vo.setLeafFlag(true);
                        } else {
                            vo.setLeafFlag(false);
                        }
                    } else {
                        vo.setIndexCode(null);
                        warnType = warnType + "[编码为空]";
                        flag = true;
                    }

                    if (StringUtils.isEmpty(code)) {// 编码为空
                        vo.setCode(null);
                    } else {
                        vo.setCode(code);
                    }

                    if (StringUtils.isEmpty(name)) {//名称为空
                        vo.setName(null);
                        warnType = warnType + "[名称为空]";
                        flag = true;
                    } else {
                        vo.setName(name);
                    }
                    vo.setFeature(feature);

                    if (StringUtils.isEmpty(computerMny)) {
                        vo.setComputerMny(null);
                    } else {
                        try {
                            vo.setComputerMny(new BigDecimal(computerMny));
                        } catch (Exception e) {
                            vo.setComputerMny(null);
                            warnType = warnType + "[计算基数只能为数字或小数]";
                            flag = true;
                        }
                    }
                    if (StringUtils.isEmpty(taxRate)) {
                        vo.setTaxRate(null);
                    } else {
                        try {
                            vo.setTaxRate(new BigDecimal(taxRate));
                        } catch (Exception e) {
                            vo.setTaxRate(null);
                            warnType = warnType + "[费率只能为数字或小数]";
                            flag = true;
                        }
                    }
                    if (StringUtils.isEmpty(mny)) {
                        vo.setMny(null);
                    } else {
                        try {
                            vo.setMny(new BigDecimal(mny));
                        } catch (Exception e) {
                            vo.setMny(null);
                            warnType = warnType + "[金额只能为数字或小数]";
                            flag = true;
                        }
                    }
                    if (StringUtils.isEmpty(type)) {// 编码为空
                        vo.setType(1);
                    } else {
                        vo.setType("税金".endsWith(type) ? 2 : 1);
                    }
                    vo.setMemo(memo);
                    vo.setImportFlag(!flag);// true=可以导入，false=不可导入
                    if (importFlag) {// 如果能导入
                        importFlag = !flag;
                    }
                    vo.setWarnType(warnType);
                    detailVoList.add(vo);
                }
                for (DrawFeeVO vo : detailVoList) {
                    if (vo.getImportFlag()) {
                        if (importFlag) {
                            String indexCode = vo.getIndexCode();
                            Boolean leafFlag = true;
                            for (String code : detailIndexList) {
                                if (code.startsWith(indexCode) && !code.equals(indexCode) && !vo.getLeafFlag()) {
                                    if (code.length() - indexCode.length() > 1) {
                                        leafFlag = false;
                                        break;
                                    }
                                }
                            }
                            vo.setLeafFlag(leafFlag);
                            vo.setParentId(parentMap.get(vo.getTpid()));
                            vo.setTid(String.valueOf(vo.getId()));
                            vo.setTpid(null != vo.getParentId() ? String.valueOf(vo.getParentId()) : "");
                            if (!leafFlag) {
                                vo.setFeature(null);
                                vo.setComputerMny(null);
                                vo.setTaxRate(null);
                                vo.setMny(null);
                            }
                            successList.add(vo);
                        }
                    } else {
                        ImportErrorVo errorVo = new ImportErrorVo();
                        errorVo.setPageName("费税项清单");
                        errorVo.setId(vo.getId());
                        errorVo.setIndexCode(vo.getIndexCode());
                        errorVo.setCode(vo.getCode());
                        errorVo.setName(vo.getName());
                        errorVo.setWarnType(vo.getWarnType());
                        errorList.add(errorVo);
                    }
                }
                if (errorList.size() > 0) {
                    resp.put("successList", null);
                    resp.put("successNum", 0);
                    resp.put("errorNum", errorList.size());
                    if (errorList.size() > 100) {
                        resp.put("errorList", errorList.subList(0, 100));
                    } else {
                        resp.put("errorList", errorList);
                    }
                }else{
                    // 价税分离
                    new TaxCalculateUtil<DrawFeeVO>().calculate(successList);
//                // list转树
                    List<DrawFeeVO> subVOS = TreeNodeBUtil.buildTree(successList);
                    UpSumUtil<DrawFeeVO> drawSubVOUpSumUtil = new UpSumUtil<>();
                    drawSubVOUpSumUtil.creatCode(subVOS, null);
                    // 向上汇总金额
                    drawSubVOUpSumUtil.upSum(subVOS, "mny");

                    resp.put("feeSuccessList", subVOS);
                    resp.put("errorList", null);
                    resp.put("successNum", subVOS.size());
                    resp.put("errorNum", 0);
                }
            }
        }
        return CommonResponse.success(resp);
    }

    private CommonResponse<JSONObject> excelImportOther(HttpServletRequest request) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }

        JSONObject resp = new JSONObject();
        if (isFailed) {
            return CommonResponse.error("文件格式不合法！");
        } else {
            List<List<List<String>>> resList = DetailIndexExcelReader.readExcel(mf);
            List<List<String>> result = resList.get(0);
            if (result.size() > 0 && result.get(0).size() < 6) {
                return CommonResponse.error("[其他项清单]数据不完整，请下载最新模板！");
            }
            List<DrawOtherVO> successList = new ArrayList<>();
            List<ImportErrorVo> errorList = new ArrayList<>();
            if (result != null && result.size() > 0) {
                List<String> detailIndexList = new ArrayList<>();// 树形编码不能重复
                Map<String, Long> parentMap = new HashMap<>();
                List<DrawOtherVO> detailVoList = new ArrayList<>();
                boolean importFlag = true;
                for (int i = 0; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    DrawOtherVO vo = new DrawOtherVO();
                    boolean flag = false;
                    String warnType = "";

                    String indexCode = datas.get(0);
                    String code = datas.get(0);
                    String name = datas.get(1);
                    String unit = datas.get(2);
                    String mny = datas.get(3);
                    String estimateFlag = datas.get(4);
                    String memo = datas.get(5);

                    Long id = IdWorker.getId();
                    vo.setId(id);

                    if (StringUtils.isNotEmpty(indexCode)) {//序号不为空
                        indexCode = indexCode.trim();// 去除导入时树形编码空格
                        vo.setIndexCode(indexCode);
                        parentMap.put(indexCode, id);
                        String[] split = splitDetailIndex(indexCode);
                        if (split.length > 1) {
                            StringBuffer tpid = new StringBuffer();
                            for (int j = 0; j < split.length - 1; j++) {
                                tpid.append(split[j]);
                            }
                            vo.setTpid(tpid.toString());
                        }
                        vo.setDetailIndex(String.valueOf(split.length));
                        if (detailIndexList.contains(indexCode)) {
                            warnType = warnType + "[子目编码重复]";
                            flag = true;
                        } else {
                            detailIndexList.add(indexCode);
                        }
                        if (split.length == 4) {
                            vo.setLeafFlag(true);
                        } else {
                            vo.setLeafFlag(false);
                        }
                    } else {
                        vo.setIndexCode(null);
                        warnType = warnType + "[子目编码为空]";
                        flag = true;
                    }

                    if (StringUtils.isEmpty(code)) {// 编码为空
                        flag = true;
                    } else {
                        vo.setCode(code);
                    }

                    if (StringUtils.isEmpty(name)) {//名称为空
                        vo.setName(null);
                        warnType = warnType + "[子目名称为空]";
                        flag = true;
                    } else {
                        vo.setName(name);
                    }
                    vo.setUnit(unit);

                    if (StringUtils.isEmpty(estimateFlag)) {
                        vo.setEstimateFlag(0);
                    } else {
                        vo.setEstimateFlag("是".equals(estimateFlag) ? 1 : 0);
                    }
                    if (StringUtils.isEmpty(mny)) {
                        vo.setMny(null);
                    } else {
                        try {
                            vo.setMny(new BigDecimal(mny));
                        } catch (Exception e) {
                            vo.setMny(null);
                            warnType = warnType + "[金额(除税)只能为数字或小数]";
                            flag = true;
                        }
                    }
                    vo.setMemo(memo);
                    vo.setImportFlag(!flag);// true=可以导入，false=不可导入
                    if (importFlag) {// 如果能导入
                        importFlag = !flag;
                    }
                    vo.setWarnType(warnType);
                    detailVoList.add(vo);
                }
                for (DrawOtherVO vo : detailVoList) {
                    if (vo.getImportFlag()) {
                        if (importFlag) {
                            String indexCode = vo.getIndexCode();
                            Boolean leafFlag = true;
                            for (String code : detailIndexList) {
                                if (code.startsWith(indexCode) && !code.equals(indexCode) && !vo.getLeafFlag()) {
                                    if (code.length() - indexCode.length() > 1) {
                                        leafFlag = false;
                                        break;
                                    }
                                }
                            }
                            vo.setLeafFlag(leafFlag);
                            vo.setParentId(parentMap.get(vo.getTpid()));
                            vo.setTid(String.valueOf(vo.getId()));
                            vo.setTpid(null != vo.getParentId() ? String.valueOf(vo.getParentId()) : "");
                            if (!leafFlag) {
                                vo.setMny(null);
                            }
                            successList.add(vo);
                        }
                    } else {
                        ImportErrorVo errorVo = new ImportErrorVo();
                        errorVo.setPageName("其他项清单");
                        errorVo.setId(vo.getId());
                        errorVo.setIndexCode(vo.getIndexCode());
                        errorVo.setCode(vo.getCode());
                        errorVo.setName(vo.getName());
                        errorVo.setWarnType(vo.getWarnType());
                        errorList.add(errorVo);
                    }
                }
                if (errorList.size() > 0) {
                    resp.put("successList", null);
                    resp.put("successNum", 0);
                    resp.put("errorNum", errorList.size());
                    if (errorList.size() > 100) {
                        resp.put("errorList", errorList.subList(0, 100));
                    } else {
                        resp.put("errorList", errorList);
                    }
                }else{
                    // 价税分离
                    new TaxCalculateUtil<DrawOtherVO>().calculate(successList);
//                // list转树
                    List<DrawOtherVO> subVOS = TreeNodeBUtil.buildTree(successList);
                    UpSumUtil<DrawOtherVO> drawSubVOUpSumUtil = new UpSumUtil<>();
                    drawSubVOUpSumUtil.creatCode(subVOS, null);
                    // 向上汇总金额
                    drawSubVOUpSumUtil.upSum(subVOS, "mny");

                    resp.put("otherSuccessList", subVOS);
                    resp.put("errorList", null);
                    resp.put("successNum", subVOS.size());
                    resp.put("errorNum", 0);
                }
            }
        }
        return  CommonResponse.success(resp);
    }

    private CommonResponse<JSONObject> excelImportTotal(HttpServletRequest request) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }

        JSONObject resp = new JSONObject();
        if (isFailed) {
            return CommonResponse.error("文件格式不合法！");
        } else {
            List<List<List<String>>> resList = DetailIndexExcelReader.readExcel(mf);
            List<List<String>> result = resList.get(0);
            if (result.size() > 0 && result.get(0).size() < 6) {
                return CommonResponse.error("[总价措施项清单]数据不完整，请下载最新模板！");
            }
            List<DrawTotalVO> successList = new ArrayList<>();
            List<ImportErrorVo> errorList = new ArrayList<>();
            if (result != null && result.size() > 0) {
                List<String> detailIndexList = new ArrayList<>();// 树形编码不能重复
                Map<String, Long> parentMap = new HashMap<>();
                List<DrawTotalVO> detailVoList = new ArrayList<>();
                boolean importFlag = true;
                for (int i = 0; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    DrawTotalVO vo = new DrawTotalVO();
                    boolean flag = false;
                    String warnType = "";

                    String indexCode = datas.get(0);
                    String code = datas.get(0);
                    String name = datas.get(1);
                    String feature = datas.get(2);
                    String rate = datas.get(3);
                    String mny = datas.get(4);
                    String memo = datas.get(5);

                    Long id = IdWorker.getId();
                    vo.setId(id);

                    if (StringUtils.isNotEmpty(indexCode)) {//序号不为空
                        indexCode = indexCode.trim();// 去除导入时树形编码空格
                        vo.setIndexCode(indexCode);
                        parentMap.put(indexCode, id);
                        String[] split = splitDetailIndex(indexCode);
                        if (split.length > 1) {
                            StringBuffer tpid = new StringBuffer();
                            for (int j = 0; j < split.length - 1; j++) {
                                tpid.append(split[j]);
                            }
                            vo.setTpid(tpid.toString());
                        }
                        vo.setDetailIndex(String.valueOf(split.length));
                        if (detailIndexList.contains(indexCode)) {
                            warnType = warnType + "[子目编码重复]";
                            flag = true;
                        } else {
                            detailIndexList.add(indexCode);
                        }
                        if (split.length == 4) {
                            vo.setLeafFlag(true);
                        } else {
                            vo.setLeafFlag(false);
                        }
                    } else {
                        vo.setIndexCode(null);
                        warnType = warnType + "[子目编码为空]";
                        flag = true;
                    }

                    if (StringUtils.isEmpty(code)) {// 编码为空
                        vo.setCode(null);
                    } else {
                        vo.setCode(code);
                    }

                    if (StringUtils.isEmpty(name)) {//名称为空
                        vo.setName(null);
                        warnType = warnType + "[子目名称为空]";
                        flag = true;
                    } else {
                        vo.setName(name);
                    }
                    vo.setFeature(feature);
                    vo.setFeature(feature);//计量单位

                    if (StringUtils.isEmpty(rate)) {
                        vo.setRate(null);
                    } else {
                        try {
                            vo.setRate(new BigDecimal(rate));
                        } catch (Exception e) {
                            vo.setRate(null);
                            warnType = warnType + "[费率只能为数字或小数]";
                            flag = true;
                        }
                    }
                    if (StringUtils.isEmpty(mny)) {
                        vo.setMny(null);
                    } else {
                        try {
                            vo.setMny(new BigDecimal(mny));
                        } catch (Exception e) {
                            vo.setMny(null);
                            warnType = warnType + "[金额(除税)只能为数字或小数]";
                            flag = true;
                        }
                    }
                    vo.setMemo(memo);
                    vo.setImportFlag(!flag);// true=可以导入，false=不可导入
                    if (importFlag) {// 如果能导入
                        importFlag = !flag;
                    }
                    vo.setWarnType(warnType);
                    detailVoList.add(vo);
                }
                for (DrawTotalVO vo : detailVoList) {
                    if (vo.getImportFlag()) {
                        if (importFlag) {
                            String indexCode = vo.getIndexCode();
                            Boolean leafFlag = true;
                            for (String code : detailIndexList) {
                                if (code.startsWith(indexCode) && !code.equals(indexCode) && !vo.getLeafFlag()) {
                                    if (code.length() - indexCode.length() > 1) {
                                        leafFlag = false;
                                        break;
                                    }
                                }
                            }
                            vo.setLeafFlag(leafFlag);
                            vo.setParentId(parentMap.get(vo.getTpid()));
                            vo.setTid(String.valueOf(vo.getId()));
                            vo.setTpid(null != vo.getParentId() ? String.valueOf(vo.getParentId()) : "");
                            if (!leafFlag) {
                                vo.setFeature(null);
                                vo.setRate(null);
                                vo.setMny(null);
                            }
                            successList.add(vo);
                        }
                    } else {
                        ImportErrorVo errorVo = new ImportErrorVo();
                        errorVo.setPageName("总价措施项清单");
                        errorVo.setId(vo.getId());
                        errorVo.setIndexCode(vo.getIndexCode());
                        errorVo.setCode(vo.getCode());
                        errorVo.setName(vo.getName());
                        errorVo.setWarnType(vo.getWarnType());
                        errorList.add(errorVo);
                    }
                }
                if (errorList.size() > 0) {
                    resp.put("successList", null);
                    resp.put("successNum", 0);
                    resp.put("errorNum", errorList.size());
                    if (errorList.size() > 100) {
                        resp.put("errorList", errorList.subList(0, 100));
                    } else {
                        resp.put("errorList", errorList);
                    }
                }else{
                    // 价税分离
                    new TaxCalculateUtil<DrawTotalVO>().calculate(successList);
//                // list转树
                    List<DrawTotalVO> subVOS = TreeNodeBUtil.buildTree(successList);
                    UpSumUtil<DrawTotalVO> drawSubVOUpSumUtil = new UpSumUtil<>();
                    drawSubVOUpSumUtil.creatCode(subVOS, null);
                    // 向上汇总金额
                    drawSubVOUpSumUtil.upSum(subVOS, "mny");

                    resp.put("totalSuccessList", subVOS);
                    resp.put("errorList", null);
                    resp.put("successNum", subVOS.size());
                    resp.put("errorNum", 0);
                }
            }
        }
        return CommonResponse.success(resp);
    }

    private CommonResponse<JSONObject> excelImportPrice(HttpServletRequest request) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }

        JSONObject resp = new JSONObject();
        if (isFailed) {
            return CommonResponse.error("文件格式不合法！");
        } else {
            List<List<List<String>>> resList = DetailIndexExcelReader.readExcel(mf);
            List<List<String>> result = resList.get(0);
            if (result.size() > 0 && result.get(0).size() < 8) {
                return CommonResponse.error("[单价措施项清单]数据不完整，请下载最新模板！");
            }
            List<DrawPriceVO> successList = new ArrayList<>();
            List<ImportErrorVo> errorList = new ArrayList<>();
            if (result != null && result.size() > 0) {
                List<String> detailIndexList = new ArrayList<>();// 树形编码不能重复
                Map<String, Long> parentMap = new HashMap<>();
                List<DrawPriceVO> detailVoList = new ArrayList<>();
                boolean importFlag = true;
                for (int i = 0; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    DrawPriceVO vo = new DrawPriceVO();
                    boolean flag = false;
                    String warnType = "";

                    String indexCode = datas.get(0);
                    String code = datas.get(0);
                    String name = datas.get(1);
                    String feature = datas.get(2);
                    String unit = datas.get(3);
                    String num = datas.get(4);
                    String price = datas.get(5);
                    String mny = datas.get(6);
                    String memo = datas.get(7);

                    Long id = IdWorker.getId();
                    vo.setId(id);

                    if (StringUtils.isNotEmpty(indexCode)) {//序号不为空
                        indexCode = indexCode.trim();// 去除导入时树形编码空格
                        vo.setIndexCode(indexCode);
                        parentMap.put(indexCode, id);
                        String[] split = splitDetailIndex(indexCode);
                        if (split.length > 1) {
                            StringBuffer tpid = new StringBuffer();
                            for (int j = 0; j < split.length - 1; j++) {
                                tpid.append(split[j]);
                            }
                            vo.setTpid(tpid.toString());
                        }
                        vo.setDetailIndex(String.valueOf(split.length));
                        if (detailIndexList.contains(indexCode)) {
                            warnType = warnType + "[子目编码重复]";
                            flag = true;
                        } else {
                            detailIndexList.add(indexCode);
                        }
                        if (split.length == 4) {
                            vo.setLeafFlag(true);
                        } else {
                            vo.setLeafFlag(false);
                        }
                    } else {
                        vo.setIndexCode(null);
                        warnType = warnType + "[子目编码为空]";
                        flag = true;
                    }

                    if (StringUtils.isEmpty(code)) {// 编码为空
                        vo.setCode(null);
                    } else {
                        vo.setCode(code);
                    }

                    if (StringUtils.isEmpty(name)) {//名称为空
                        vo.setName(null);
                        warnType = warnType + "[子目名称为空]";
                        flag = true;
                    } else {
                        vo.setName(name);
                    }
                    vo.setFeature(feature);
                    vo.setUnit(unit);//计量单位

                    if (StringUtils.isEmpty(num)) {
                        vo.setNum(null);
                    } else {
                        try {
                            vo.setNum(new BigDecimal(num));
                        } catch (Exception e) {
                            vo.setNum(null);
                            warnType = warnType + "[工程量只能为数字或小数]";
                            flag = true;
                        }
                    }
                    if (StringUtils.isEmpty(price)) {
                        vo.setPrice(null);
                    } else {
                        try {
                            vo.setPrice(new BigDecimal(price));
                        } catch (Exception e) {
                            vo.setPrice(null);
                            warnType = warnType + "[综合单价(除税)只能为数字或小数]";
                            flag = true;
                        }
                    }
                    if (StringUtils.isEmpty(mny)) {
                        vo.setMny(null);
                    } else {
                        try {
                            vo.setMny(new BigDecimal(mny));
                        } catch (Exception e) {
                            vo.setMny(null);
                            warnType = warnType + "[合价(除税)只能为数字或小数]";
                            flag = true;
                        }
                    }
                    vo.setMemo(memo);
                    vo.setImportFlag(!flag);// true=可以导入，false=不可导入
                    if (importFlag) {// 如果能导入
                        importFlag = !flag;
                    }
                    vo.setWarnType(warnType);
                    detailVoList.add(vo);
                }
                for (DrawPriceVO vo : detailVoList) {
                    if (vo.getImportFlag()) {
                        if (importFlag) {
                            String indexCode = vo.getIndexCode();
                            Boolean leafFlag = true;
                            for (String code : detailIndexList) {
                                if (code.startsWith(indexCode) && !code.equals(indexCode) && !vo.getLeafFlag()) {
                                    if (code.length() - indexCode.length() > 1) {
                                        leafFlag = false;
                                        break;
                                    }
                                }
                            }
                            vo.setLeafFlag(leafFlag);
                            vo.setParentId(parentMap.get(vo.getTpid()));
                            vo.setTid(String.valueOf(vo.getId()));
                            vo.setTpid(null != vo.getParentId() ? String.valueOf(vo.getParentId()) : "");
                            if (!leafFlag) {
                                vo.setNum(null);
                                vo.setPrice(null);
                                vo.setMny(null);
                            }
                            successList.add(vo);
                        }
                    } else {
                        ImportErrorVo errorVo = new ImportErrorVo();
                        errorVo.setPageName("单价措施项清单");
                        errorVo.setId(vo.getId());
                        errorVo.setIndexCode(vo.getIndexCode());
                        errorVo.setCode(vo.getCode());
                        errorVo.setName(vo.getName());
                        errorVo.setUnit(vo.getUnit());
                        errorVo.setWarnType(vo.getWarnType());
                        errorList.add(errorVo);
                    }
                }
                if (errorList.size() > 0) {
                    resp.put("successList", null);
                    resp.put("successNum", 0);
                    resp.put("errorNum", errorList.size());
                    if (errorList.size() > 100) {
                        resp.put("errorList", errorList.subList(0, 100));
                    } else {
                        resp.put("errorList", errorList);
                    }
                }else{
                    // 价税分离
                    new TaxCalculateUtil<DrawPriceVO>().calculate(successList);
                    // list转树
                    List<DrawPriceVO> priceVOS = TreeNodeBUtil.buildTree(successList);
                    UpSumUtil<DrawPriceVO> drawPriceVOUpSumUtil = new UpSumUtil<>();
                    // 向上汇总金额
                    drawPriceVOUpSumUtil.upSum(priceVOS, "mny");
                    drawPriceVOUpSumUtil.creatCode(priceVOS, null);

                    resp.put("priceSuccessList", priceVOS);
                    resp.put("errorList", null);
                    resp.put("successNum", priceVOS.size());
                    resp.put("errorNum", 0);
                }
            }
        }
        return CommonResponse.success(resp);
    }

    private CommonResponse<JSONObject> excelImportSub(HttpServletRequest request) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }

        JSONObject resp = new JSONObject();
        if (isFailed) {
            return CommonResponse.error("文件格式不合法！");
        } else {
            List<List<List<String>>> resList = DetailIndexExcelReader.readExcel(mf);
            List<List<String>> result = resList.get(0);
            if (result.size() > 0 && result.get(0).size() < 8) {
                return CommonResponse.error("[分部分项清单]数据不完整，请下载最新模板！");
            }

            List<DrawSubVO> successList = new ArrayList<>();
            List<ImportErrorVo> errorList = new ArrayList<>();
            if (result != null && result.size() > 0) {
                List<String> detailIndexList = new ArrayList<>();// 树形编码不能重复
                Map<String, Long> parentMap = new HashMap<>();
                List<DrawSubVO> detailVoList = new ArrayList<>();
                boolean importFlag = true;
                for (int i = 0; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    DrawSubVO vo = new DrawSubVO();
                    boolean flag = false;
                    String warnType = "";

                    String indexCode = datas.get(0);
                    String code = datas.get(0);
                    String name = datas.get(1);
                    String feature = datas.get(2);
                    String unit = datas.get(3);
                    String num = datas.get(4);
                    String price = datas.get(5);
                    String mny = datas.get(6);
                    String memo = datas.get(7);

                    Long id = IdWorker.getId();
                    vo.setId(id);

                    if (StringUtils.isNotEmpty(indexCode)) {//序号不为空
                        indexCode = indexCode.trim();// 去除导入时树形编码空格
                        vo.setIndexCode(indexCode);
                        parentMap.put(indexCode, id);
                        String[] split = splitDetailIndex(indexCode);
                        if (split.length > 1) {
                            StringBuffer tpid = new StringBuffer();
                            for (int j = 0; j < split.length - 1; j++) {
                                tpid.append(split[j]);
                            }
                            vo.setTpid(tpid.toString());
                        }
                        vo.setDetailIndex(String.valueOf(split.length));
                        if (detailIndexList.contains(indexCode)) {
                            warnType = warnType + "[子目编码重复]";
                            flag = true;
                        } else {
                            detailIndexList.add(indexCode);
                        }
                        if (split.length == 4) {
                            vo.setLeafFlag(true);
                        } else {
                            vo.setLeafFlag(false);
                        }
                    } else {
                        vo.setIndexCode(null);
                        warnType = warnType + "[子目编码为空]";
                        flag = true;
                    }

                    if (StringUtils.isEmpty(code)) {// 编码为空
                        vo.setCode(null);
                    } else {
                        vo.setCode(code);
                    }

                    if (StringUtils.isEmpty(name)) {//名称为空
                        vo.setName(null);
                        warnType = warnType + "[子目名称为空]";
                        flag = true;
                    } else {
                        vo.setName(name);
                    }
                    vo.setFeature(feature);
                    vo.setUnit(unit);//计量单位

                    if (StringUtils.isEmpty(num)) {
                        vo.setNum(null);
                    } else {
                        try {
                            vo.setNum(new BigDecimal(num));
                        } catch (Exception e) {
                            vo.setNum(null);
                            warnType = warnType + "[工程量只能为数字或小数]";
                            flag = true;
                        }
                    }
                    if (StringUtils.isEmpty(price)) {
                        vo.setPrice(null);
                    } else {
                        try {
                            vo.setPrice(new BigDecimal(price));
                        } catch (Exception e) {
                            vo.setPrice(null);
                            warnType = warnType + "[综合单价(除税)只能为数字或小数]";
                            flag = true;
                        }
                    }
                    if (StringUtils.isEmpty(mny)) {
                        vo.setMny(null);
                    } else {
                        try {
                            vo.setMny(new BigDecimal(mny));
                        } catch (Exception e) {
                            vo.setMny(null);
                            warnType = warnType + "[合价(除税)只能为数字或小数]";
                            flag = true;
                        }
                    }
                    vo.setMemo(memo);
                    vo.setImportFlag(!flag);// true=可以导入，false=不可导入
                    if (importFlag) {// 如果能导入
                        importFlag = !flag;
                    }
                    vo.setWarnType(warnType);
                    detailVoList.add(vo);
                }

                for (DrawSubVO vo : detailVoList) {
                    if (vo.getImportFlag()) {
                        if (importFlag) {
                            String indexCode = vo.getIndexCode();
                            Boolean leafFlag = true;
                            for (String code : detailIndexList) {
                                if (code.startsWith(indexCode) && !code.equals(indexCode) && !vo.getLeafFlag()) {
                                    if (code.length() - indexCode.length() > 1) {
                                        leafFlag = false;
                                        break;
                                    }
                                }
                            }
                            vo.setLeafFlag(leafFlag);
                            vo.setParentId(parentMap.get(vo.getTpid()));
                            vo.setTid(String.valueOf(vo.getId()));
                            vo.setTpid(null != vo.getParentId() ? String.valueOf(vo.getParentId()) : "");
                            vo.setRowState("add");
                            if (!leafFlag) {
                                vo.setNum(null);
                                vo.setPrice(null);
                                vo.setMny(null);
                            }
                            successList.add(vo);
                        }
                    } else {
                        ImportErrorVo errorVo = new ImportErrorVo();
                        errorVo.setPageName("分部分项清单");
                        errorVo.setId(vo.getId());
                        errorVo.setIndexCode(vo.getIndexCode());
                        errorVo.setCode(vo.getCode());
                        errorVo.setName(vo.getName());
                        errorVo.setUnit(vo.getUnit());
                        errorVo.setWarnType(vo.getWarnType());
                        errorList.add(errorVo);
                    }
                }
            }

            if (errorList.size() > 0) {
                resp.put("successList", null);
                resp.put("successNum", 0);
                resp.put("errorNum", errorList.size());
                if (errorList.size() > 100) {
                    resp.put("errorList", errorList.subList(0, 100));
                } else {
                    resp.put("errorList", errorList);
                }
            }else{
                // 价税分离
                new TaxCalculateUtil<DrawSubVO>().calculate(successList);
//                // list转树
                List<DrawSubVO> subVOS = TreeNodeBUtil.buildTree(successList);
                UpSumUtil<DrawSubVO> drawSubVOUpSumUtil = new UpSumUtil<>();
                drawSubVOUpSumUtil.creatCode(subVOS, null);
                // 向上汇总金额
                drawSubVOUpSumUtil.upSum(subVOS, "mny");

                resp.put("subSuccessList", subVOS);
                resp.put("errorList", null);
                resp.put("successNum", subVOS.size());
                resp.put("errorNum", 0);
            }

        }
        return CommonResponse.success(resp);
    }

    private String[] splitDetailIndex(String detailIndex) {
        if (StringUtils.isBlank(detailIndex)) {
            return null;
        }
        List<String> list = new ArrayList<>();
        if (detailIndex.length() < 3) {
            list.add(detailIndex);
        } else if (detailIndex.length() < 5) {
            list.add(detailIndex.substring(0, 2));
            list.add(detailIndex.substring(2));
        } else if (detailIndex.length() < 7) {
            list.add(detailIndex.substring(0, 2));
            list.add(detailIndex.substring(2, 4));
            list.add(detailIndex.substring(4));
        } else {
            list.add(detailIndex.substring(0, 2));
            list.add(detailIndex.substring(2, 4));
            list.add(detailIndex.substring(4, 6));
            list.add(detailIndex.substring(6));
        }
        return list.toArray(new String[0]);
    }

}
